import _extends from "@babel/runtime/helpers/esm/extends";
import moment from 'moment';
import momentTZ from 'moment-timezone';
import createDescribe from '@mui/monorepo/test/utils/createDescribe';
import { buildFieldInteractions, createPickerRenderer } from 'test/utils/pickers-utils';
const ADAPTERS = ['dayjs', 'date-fns', 'luxon', 'moment'];
function innerDescribeAdapters(title, FieldComponent, testRunner) {
  ADAPTERS.forEach(adapterName => {
    // TODO: Set locale moment before the 1st test run
    if (adapterName === 'moment') {
      moment.locale('en');
    }
    describe(`${title} - adapter: ${adapterName}`, () => {
      const pickerRendererResponse = createPickerRenderer({
        adapterName,
        clock: 'fake',
        clockConfig: new Date(2022, 5, 15),
        instance: adapterName === 'moment' ? momentTZ : undefined
      });
      const fieldInteractions = buildFieldInteractions({
        clock: pickerRendererResponse.clock,
        render: pickerRendererResponse.render,
        Component: FieldComponent
      });
      testRunner(_extends({}, pickerRendererResponse, fieldInteractions));
    });
  });
}
export const describeAdapters = createDescribe('Adapter specific tests', innerDescribeAdapters);