import * as React from "react";
import { AuthEmission, FirebaseAuthProviderProps, FirebaseAuthProviderState, RenderableChildren } from "./types";
export declare class FirebaseAuthProvider extends React.PureComponent<FirebaseAuthProviderProps, FirebaseAuthProviderState> {
    stopListeningToAuth?: () => void;
    listenToAuth: () => void;
    state: {
        isSignedIn: boolean;
        providerId: null;
        user: null;
        firebase: {};
    };
    constructor(props: FirebaseAuthProviderProps);
    componentDidMount(): void;
    componentWillUnmount(): void;
    render(): JSX.Element;
}
export declare const FirebaseAuthConsumer: React.StatelessComponent<{
    children: RenderableChildren;
}>;
export declare const IfFirebaseAuthed: React.StatelessComponent<{
    children: RenderableChildren;
}>;
export declare type FilterAuthFunction = (authState: AuthEmission) => boolean;
export declare const IfFirebaseAuthedAnd: React.StatelessComponent<{
    filter: FilterAuthFunction;
    children: RenderableChildren;
}>;
export declare const IfFirebaseAuthedOr: React.StatelessComponent<{
    children: RenderableChildren;
    filter: FilterAuthFunction;
}>;
export declare const IfFirebaseUnAuthed: React.StatelessComponent<{
    children: RenderableChildren;
}>;
export declare const WithFirebase: ({ children }: {
    children: (authState: AuthEmission) => any;
}) => JSX.Element;
