import { createContext, createElement, PureComponent } from 'react';
import { renderAndAddProps } from 'render-and-add-props';
import get from 'lodash/get';

/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var initializeFirebaseApp = function (_a) {
    var firebase = _a.firebase, authDomain = _a.authDomain, databaseURL = _a.databaseURL, projectId = _a.projectId, storageBucket = _a.storageBucket, messagingSenderId = _a.messagingSenderId, apiKey = _a.apiKey, appId = _a.appId, measurementId = _a.measurementId;
    try {
        firebase.initializeApp({
            apiKey: apiKey,
            authDomain: authDomain,
            databaseURL: databaseURL,
            projectId: projectId,
            storageBucket: storageBucket,
            messagingSenderId: messagingSenderId,
            appId: appId,
            measurementId: measurementId
        });
    }
    catch (err) {
        if (err.code !== "app/duplicate-app") {
            throw err;
        }
    }
};

var firebaseAuthProviderDefaultProps = {
    isSignedIn: false,
    providerId: null,
    user: null,
    firebase: {}
};
var _a = createContext(firebaseAuthProviderDefaultProps), FirebaseAuthContextProvider = _a.Provider, FirebaseAuthContextConsumer = _a.Consumer;
var FirebaseAuthProvider = (function (_super) {
    __extends(FirebaseAuthProvider, _super);
    function FirebaseAuthProvider(props) {
        var _this = _super.call(this, props) || this;
        _this.listenToAuth = function () {
            var firebase = _this.props.firebase;
            _this.stopListeningToAuth = firebase
                .app()
                .auth()
                .onAuthStateChanged(function (user) {
                var authEmission = null;
                if (user === null) {
                    authEmission = {
                        isSignedIn: false,
                        providerId: "none",
                        user: user,
                        firebase: firebase
                    };
                }
                else if (user.isAnonymous === true) {
                    authEmission = {
                        isSignedIn: true,
                        providerId: "anonymous",
                        user: user,
                        firebase: firebase
                    };
                }
                else if (user.providerData && user.providerData[0]) {
                    authEmission = {
                        isSignedIn: true,
                        providerId: get(user, "providerData.0.providerId", "unknown"),
                        user: user,
                        firebase: firebase
                    };
                }
                if (authEmission !== null) {
                    _this.setState(function () { return authEmission; });
                }
                else {
                    console.error("Something unexpected happened with ", user);
                }
            });
        };
        _this.state = {
            isSignedIn: false,
            providerId: null,
            user: null,
            firebase: {}
        };
        if (props.apiKey) {
            initializeFirebaseApp(Object.assign({}, props));
        }
        return _this;
    }
    FirebaseAuthProvider.prototype.componentDidMount = function () {
        this.listenToAuth();
    };
    FirebaseAuthProvider.prototype.componentWillUnmount = function () {
        this.stopListeningToAuth && this.stopListeningToAuth();
    };
    FirebaseAuthProvider.prototype.render = function () {
        var children = this.props.children;
        return (createElement(FirebaseAuthContextProvider, { value: this.state }, renderAndAddProps(children, {})));
    };
    return FirebaseAuthProvider;
}(PureComponent));
var FirebaseAuthConsumer = function (_a) {
    var children = _a.children;
    return (createElement(FirebaseAuthContextConsumer, null, function (authState) { return renderAndAddProps(children, authState); }));
};
var IfFirebaseAuthed = function (_a) {
    var children = _a.children;
    return (createElement(FirebaseAuthContextConsumer, null, function (authState) {
        return authState.isSignedIn === true
            ? renderAndAddProps(children, authState)
            : null;
    }));
};
var IfFirebaseAuthedAnd = function (_a) {
    var children = _a.children, filter = _a.filter;
    return (createElement(FirebaseAuthContextConsumer, null, function (authState) {
        return authState.isSignedIn === true
            ? filter(authState)
                ? renderAndAddProps(children, authState)
                : null
            : null;
    }));
};
var IfFirebaseAuthedOr = function (_a) {
    var children = _a.children, filter = _a.filter;
    return (createElement(FirebaseAuthContextConsumer, null, function (authState) {
        return authState.isSignedIn === true || filter(authState)
            ? renderAndAddProps(children, authState)
            : null;
    }));
};
var IfFirebaseUnAuthed = function (_a) {
    var children = _a.children;
    return (createElement(FirebaseAuthContextConsumer, null, function (authState) {
        return authState.isSignedIn === false
            ? renderAndAddProps(children, authState)
            : null;
    }));
};
var WithFirebase = function (_a) {
    var children = _a.children;
    return createElement(FirebaseAuthContextConsumer, null, children);
};

export { FirebaseAuthProvider, FirebaseAuthConsumer, IfFirebaseAuthed, IfFirebaseAuthedAnd, IfFirebaseAuthedOr, IfFirebaseUnAuthed, WithFirebase };
