// Type definitions for non-npm package Google Maps JavaScript API 3.53
// Project: https://developers.google.com/maps/
// Definitions by: Alex Muramoto <https://github.com/amuramoto>
//                 Angela Yu <https://github.com/wangela>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped

// To report an issue with these types, please open a support ticket at:
// https://issuetracker.google.com/savedsearches/558438

// Google Maps JS API Version: 3.53
// tslint:disable:enforce-name-casing
// tslint:disable:no-any
// tslint:disable:interface-over-type-literal
// tslint:disable:array-type
// tslint:disable:no-empty-interface
// tslint:disable:no-unnecessary-class
// tslint:disable:strict-export-declare-modifiers

// Generated by an automated process. DO NOT EDIT!

declare namespace google.maps {
  /**
   * Animations that can be played on a marker. Use the {@link
   * google.maps.Marker.setAnimation} method on Marker or the {@link
   * google.maps.MarkerOptions.animation} option to play an animation.
   *
   * Access by calling `const {Animation} = await
   * google.maps.importLibrary("marker")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum Animation {
    /**
     * Marker bounces until animation is stopped by calling {@link
     * google.maps.Marker.setAnimation} with <code>null</code>.
     */
    BOUNCE = 0.0,
    /**
     * Marker drops from the top of the map to its final location. Animation
     * will cease once the marker comes to rest and {@link
     * google.maps.Marker.getAnimation} will return <code>null</code>. This type
     * of animation is usually specified during creation of the marker.
     */
    DROP = 1.0,
  }
  /**
   * A layer showing bike lanes and paths.
   *
   * Access by calling `const {BicyclingLayer} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class BicyclingLayer extends google.maps.MVCObject {
    /**
     * Returns the map on which this layer is displayed.
     */
    getMap(): google.maps.Map|null;
    /**
     * Renders the layer on the specified map. If map is set to
     * <code>null</code>, the layer will be removed.
     */
    setMap(map: google.maps.Map|null): void;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * Used for setting the map&#39;s camera options.
   */
  export interface CameraOptions {
    center?: google.maps.LatLngLiteral|google.maps.LatLng;
    heading?: number;
    tilt?: number;
    zoom?: number;
  }
  /**
   * Used for retrieving camera parameters, such as that of the GL camera used
   * for the {@link google.maps.WebGLOverlayView}.
   */
  export interface CameraParams extends google.maps.CameraOptions {
    center: google.maps.LatLng;
    heading: number;
    tilt: number;
    zoom: number;
  }
  /**
   * A circle on the Earth&#39;s surface; also known as a &quot;spherical
   * cap&quot;.
   *
   * Access by calling `const {Circle} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Circle extends google.maps.MVCObject {
    /**
     * A circle on the Earth&#39;s surface; also known as a &quot;spherical
     * cap&quot;.
     *
     * Access by calling `const {Circle} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(circleOrCircleOptions?: google.maps.Circle|null|
                google.maps.CircleLiteral|google.maps.CircleOptions);
    /**
     * Gets the <code>LatLngBounds</code> of this Circle.
     */
    getBounds(): google.maps.LatLngBounds|null;
    /**
     * Returns the center of this circle.
     */
    getCenter(): google.maps.LatLng|null;
    /**
     * Returns whether this circle can be dragged by the user.
     */
    getDraggable(): boolean;
    /**
     * Returns whether this circle can be edited by the user.
     */
    getEditable(): boolean;
    /**
     * Returns the map on which this circle is displayed.
     */
    getMap(): google.maps.Map|null;
    /**
     * Returns the radius of this circle (in meters).
     */
    getRadius(): number;
    /**
     * Returns whether this circle is visible on the map.
     */
    getVisible(): boolean;
    /**
     * Sets the center of this circle.
     */
    setCenter(center: google.maps.LatLng|null|google.maps.LatLngLiteral): void;
    /**
     * If set to <code>true</code>, the user can drag this circle over the map.
     */
    setDraggable(draggable: boolean): void;
    /**
     * If set to <code>true</code>, the user can edit this circle by dragging
     * the control points shown at the center and around the circumference of
     * the circle.
     */
    setEditable(editable: boolean): void;
    /**
     * Renders the circle on the specified map. If map is set to
     * <code>null</code>, the circle will be removed.
     */
    setMap(map: google.maps.Map|null): void;
    setOptions(options: google.maps.CircleOptions|null): void;
    /**
     * Sets the radius of this circle (in meters).
     */
    setRadius(radius: number): void;
    /**
     * Hides this circle if set to <code>false</code>.
     */
    setVisible(visible: boolean): void;
  }
  /**
   * Object literal which represents a circle.
   */
  export interface CircleLiteral extends google.maps.CircleOptions {
    /**
     * The center of the Circle.
     */
    center: google.maps.LatLng|google.maps.LatLngLiteral;
    /**
     * The radius in meters on the Earth&#39;s surface.
     */
    radius: number;
  }
  /**
   * CircleOptions object used to define the properties that can be set on a
   * Circle.
   */
  export interface CircleOptions {
    /**
     * The center of the Circle.
     */
    center?: null|google.maps.LatLng|google.maps.LatLngLiteral;
    /**
     * Indicates whether this <code>Circle</code> handles mouse events.
     * @defaultValue <code>true</code>
     */
    clickable?: null|boolean;
    /**
     * If set to <code>true</code>, the user can drag this circle over the map.
     * @defaultValue <code>false</code>
     */
    draggable?: null|boolean;
    /**
     * If set to <code>true</code>, the user can edit this circle by dragging
     * the control points shown at the center and around the circumference of
     * the circle.
     * @defaultValue <code>false</code>
     */
    editable?: null|boolean;
    /**
     * The fill color. All CSS3 colors are supported except for extended named
     * colors.
     */
    fillColor?: null|string;
    /**
     * The fill opacity between 0.0 and 1.0.
     */
    fillOpacity?: null|number;
    /**
     * Map on which to display the Circle.
     */
    map?: null|google.maps.Map;
    /**
     * The radius in meters on the Earth&#39;s surface.
     */
    radius?: null|number;
    /**
     * The stroke color. All CSS3 colors are supported except for extended named
     * colors.
     */
    strokeColor?: null|string;
    /**
     * The stroke opacity between 0.0 and 1.0.
     */
    strokeOpacity?: null|number;
    /**
     * The stroke position.
     * @defaultValue {@link google.maps.StrokePosition.CENTER}
     */
    strokePosition?: null|google.maps.StrokePosition;
    /**
     * The stroke width in pixels.
     */
    strokeWeight?: null|number;
    /**
     * Whether this circle is visible on the map.
     * @defaultValue <code>true</code>
     */
    visible?: null|boolean;
    /**
     * The zIndex compared to other polys.
     */
    zIndex?: null|number;
  }
  /**
   * Access by calling `const {CollisionBehavior} = await
   * google.maps.importLibrary("marker")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum CollisionBehavior {
    /**
     * Display the marker only if it does not overlap with other markers. If two
     * markers of this type would overlap, the one with the higher zIndex is
     * shown. If they have the same zIndex, the one with the lower vertical
     * screen position is shown.
     */
    OPTIONAL_AND_HIDES_LOWER_PRIORITY = 'OPTIONAL_AND_HIDES_LOWER_PRIORITY',
    /**
     * Always display the marker regardless of collision. This is the default
     * behavior.
     */
    REQUIRED = 'REQUIRED',
    /**
     * Always display the marker regardless of collision, and hide any
     * OPTIONAL_AND_HIDES_LOWER_PRIORITY markers or labels that would overlap
     * with the marker.
     */
    REQUIRED_AND_HIDES_OPTIONAL = 'REQUIRED_AND_HIDES_OPTIONAL',
  }
  /**
   * Identifiers used to specify the placement of controls on the map. Controls
   * are positioned relative to other controls in the same layout position.
   * Controls that are added first are positioned closer to the edge of the map.
   * <code> <br>&nbsp;&nbsp;+----------------+
   * <br>&nbsp;&nbsp;+&nbsp;TL&nbsp;&nbsp;&nbsp;&nbsp;TC&nbsp;&nbsp;&nbsp;&nbsp;TR
   * +
   * <br>&nbsp;&nbsp;+&nbsp;LT&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;RT
   * +
   * <br>&nbsp;&nbsp;+&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;+
   * <br>&nbsp;&nbsp;+&nbsp;LC&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;RC
   * +
   * <br>&nbsp;&nbsp;+&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;+
   * <br>&nbsp;&nbsp;+&nbsp;LB&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;RB
   * +
   * <br>&nbsp;&nbsp;+&nbsp;BL&nbsp;&nbsp;&nbsp;&nbsp;BC&nbsp;&nbsp;&nbsp;&nbsp;BR
   * + <br>&nbsp;&nbsp;+----------------+ <br></code> Elements in the top or
   * bottom row flow towards the middle of the row. Elements in the left or
   * right column flow towards the middle of the column.
   *
   * Access by calling `const {ControlPosition} = await
   * google.maps.importLibrary("core")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum ControlPosition {
    /**
     * Elements are positioned in the center of the bottom row.
     */
    BOTTOM_CENTER = 0.0,
    /**
     * Elements are positioned in the bottom left and flow towards the middle.
     * Elements are positioned to the right of the Google logo.
     */
    BOTTOM_LEFT = 1.0,
    /**
     * Elements are positioned in the bottom right and flow towards the middle.
     * Elements are positioned to the left of the copyrights.
     */
    BOTTOM_RIGHT = 2.0,
    /**
     * Elements are positioned on the left, above bottom-left elements, and flow
     * upwards.
     */
    LEFT_BOTTOM = 3.0,
    /**
     * Elements are positioned in the center of the left side.
     */
    LEFT_CENTER = 4.0,
    /**
     * Elements are positioned on the left, below top-left elements, and flow
     * downwards.
     */
    LEFT_TOP = 5.0,
    /**
     * Elements are positioned on the right, above bottom-right elements, and
     * flow upwards.
     */
    RIGHT_BOTTOM = 6.0,
    /**
     * Elements are positioned in the center of the right side.
     */
    RIGHT_CENTER = 7.0,
    /**
     * Elements are positioned on the right, below top-right elements, and flow
     * downwards.
     */
    RIGHT_TOP = 8.0,
    /**
     * Elements are positioned in the center of the top row.
     */
    TOP_CENTER = 9.0,
    /**
     * Elements are positioned in the top left and flow towards the middle.
     */
    TOP_LEFT = 10.0,
    /**
     * Elements are positioned in the top right and flow towards the middle.
     */
    TOP_RIGHT = 11.0,
  }
  /**
   * This interface provides convenience methods for generating matrices to use
   * for rendering WebGL scenes on top of the Google base map. <br><br>Note: A
   * reference to this object should <b>not</b> be held outside of the scope of
   * the encapsulating {@link google.maps.WebGLOverlayView.onDraw} call.
   */
  export interface CoordinateTransformer {
    fromLatLngAltitude(
        latLngAltitude: google.maps.LatLngAltitude|
        google.maps.LatLngAltitudeLiteral,
        rotations?: Float32Array, scale?: Float32Array): Float64Array;
    getCameraParams(): google.maps.CameraParams;
  }
  export interface CoreLibrary {
    ControlPosition: typeof google.maps.ControlPosition;
    event: typeof google.maps.event;
    LatLng: typeof google.maps.LatLng;
    LatLngAltitude: typeof google.maps.LatLngAltitude;
    LatLngBounds: typeof google.maps.LatLngBounds;
    MapsNetworkError: typeof google.maps.MapsNetworkError;
    MapsNetworkErrorEndpoint: typeof google.maps.MapsNetworkErrorEndpoint;
    MapsRequestError: typeof google.maps.MapsRequestError;
    MapsServerError: typeof google.maps.MapsServerError;
    MVCArray: typeof google.maps.MVCArray;
    MVCObject: typeof google.maps.MVCObject;
    Point: typeof google.maps.Point;
    Settings: typeof google.maps.Settings;
    Size: typeof google.maps.Size;
    SymbolPath: typeof google.maps.SymbolPath;
    UnitSystem: typeof google.maps.UnitSystem;
  }
  /**
   * A layer for displaying geospatial data. Points, line-strings and polygons
   * can be displayed. <p> Every <code>Map</code> has a <code>Data</code> object
   * by default, so most of the time there is no need to construct one. For
   * example: <pre> var myMap = new google.maps.Map(...);<br>
   * myMap.data.addGeoJson(...);<br> myMap.data.setStyle(...); </pre> The
   * <code>Data</code> object is a collection of <a
   * href="#Data.Feature"><code>Features</code></a>.
   *
   * Access by calling `const {Data} = await google.maps.importLibrary("maps")`.
   * See https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Data extends google.maps.MVCObject {
    /**
     * A layer for displaying geospatial data. Points, line-strings and polygons
     * can be displayed. <p> Every <code>Map</code> has a <code>Data</code>
     * object by default, so most of the time there is no need to construct one.
     * For example: <pre> var myMap = new google.maps.Map(...);<br>
     * myMap.data.addGeoJson(...);<br> myMap.data.setStyle(...); </pre> The
     * <code>Data</code> object is a collection of <a
     * href="#Data.Feature"><code>Features</code></a>.
     *
     * Access by calling `const {Data} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(options?: google.maps.Data.DataOptions|null);
    /**
     * Adds a feature to the collection, and returns the added feature. <p> If
     * the feature has an ID, it will replace any existing feature in the
     * collection with the same ID. If no feature is given, a new feature will
     * be created with null geometry and no properties. If
     * <code>FeatureOptions</code> are given, a new feature will be created with
     * the specified properties. <p> Note that the IDs <code>1234</code> and
     * <code>'1234'</code> are equivalent. Adding a feature with ID
     * <code>1234</code> will replace a feature with ID <code>'1234'</code>, and
     * vice versa.
     */
    add(feature?: google.maps.Data.Feature|null|
        google.maps.Data.FeatureOptions): google.maps.Data.Feature;
    /**
     * Adds GeoJSON features to the collection. Give this method a parsed JSON.
     * The imported features are returned. Throws an exception if the GeoJSON
     * could not be imported.
     */
    addGeoJson(geoJson: object, options?: google.maps.Data.GeoJsonOptions|null):
        google.maps.Data.Feature[];
    /**
     * Checks whether the given feature is in the collection.
     */
    contains(feature: google.maps.Data.Feature): boolean;
    /**
     * Repeatedly invokes the given function, passing a feature in the
     * collection to the function on each invocation. The order of iteration
     * through the features is undefined.
     */
    forEach(callback: (a: google.maps.Data.Feature) => void): void;
    /**
     * Returns the position of the drawing controls on the map.
     */
    getControlPosition(): google.maps.ControlPosition;
    /**
     * Returns which drawing modes are available for the user to select, in the
     * order they are displayed. This does not include the <code>null</code>
     * drawing mode, which is added by default. Possible drawing modes are
     * <code>"Point"</code>, <code>"LineString"</code> or
     * <code>"Polygon"</code>.
     */
    getControls(): string[]|null;
    /**
     * Returns the current drawing mode of the given Data layer. A drawing mode
     * of <code>null</code> means that the user can interact with the map as
     * normal, and clicks do not draw anything. Possible drawing modes are
     * <code>null</code>, <code>"Point"</code>, <code>"LineString"</code> or
     * <code>"Polygon"</code>.
     */
    getDrawingMode(): string|null;
    /**
     * Returns the feature with the given ID, if it exists in the collection.
     * Otherwise returns <code>undefined</code>. <p> Note that the IDs
     * <code>1234</code> and <code>'1234'</code> are equivalent. Either can be
     * used to look up the same feature.
     */
    getFeatureById(id: number|string): google.maps.Data.Feature|undefined;
    /**
     * Returns the map on which the features are displayed.
     */
    getMap(): google.maps.Map|null;
    /**
     * Gets the style for all features in the collection.
     */
    getStyle(): (google.maps.Data.StylingFunction)|google.maps.Data.StyleOptions
        |null;
    /**
     * Loads GeoJSON from a URL, and adds the features to the collection. <p>
     * NOTE: The GeoJSON is fetched using XHR, and may not work cross-domain. If
     * you have issues, we recommend you fetch the GeoJSON using your choice of
     * AJAX library, and then call <code>addGeoJson()</code>.
     */
    loadGeoJson(
        url: string, options?: google.maps.Data.GeoJsonOptions|null,
        callback?: (a: google.maps.Data.Feature[]) => void): void;
    /**
     * Changes the style of a feature. These changes are applied on top of the
     * style specified by <code>setStyle()</code>. Style properties set to
     * <code>null</code> revert to the value specified via
     * <code>setStyle()</code>.
     */
    overrideStyle(
        feature: google.maps.Data.Feature,
        style: google.maps.Data.StyleOptions): void;
    /**
     * Removes a feature from the collection.
     */
    remove(feature: google.maps.Data.Feature): void;
    /**
     * Removes the effect of previous <code>overrideStyle()</code> calls. The
     * style of the given feature reverts to the style specified by
     * <code>setStyle()</code>. <p>If no feature is given, all features have
     * their style reverted.</p>
     */
    revertStyle(feature?: google.maps.Data.Feature|null): void;
    /**
     * Sets the position of the drawing controls on the map.
     */
    setControlPosition(controlPosition: google.maps.ControlPosition): void;
    /**
     * Sets which drawing modes are available for the user to select, in the
     * order they are displayed. This should not include the <code>null</code>
     * drawing mode, which is added by default. If <code>null</code>, drawing
     * controls are disabled and not displayed. Possible drawing modes are
     * <code>"Point"</code>, <code>"LineString"</code> or
     * <code>"Polygon"</code>.
     */
    setControls(controls: string[]|null): void;
    /**
     * Sets the current drawing mode of the given Data layer. A drawing mode of
     * <code>null</code> means that the user can interact with the map as
     * normal, and clicks do not draw anything. Possible drawing modes are
     * <code>null</code>, <code>"Point"</code>, <code>"LineString"</code> or
     * <code>"Polygon"</code>.
     */
    setDrawingMode(drawingMode: string|null): void;
    /**
     * Renders the features on the specified map. If map is set to
     * <code>null</code>, the features will be removed from the map.
     */
    setMap(map: google.maps.Map|null): void;
    /**
     * Sets the style for all features in the collection. Styles specified on a
     * per-feature basis via <code>overrideStyle()</code> continue to apply.
     * <p>Pass either an object with the desired style options, or a function
     * that computes the style for each feature. The function will be called
     * every time a feature&#39;s properties are updated.
     */
    setStyle(style: (google.maps.Data.StylingFunction)|
             google.maps.Data.StyleOptions|null): void;
    /**
     * Exports the features in the collection to a GeoJSON object.
     */
    toGeoJson(callback: (a: object) => void): void;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * An interface representing a feature from a Dataset. The
   * <code>featureType</code> of a <code>DatasetFeature</code> will always be
   * <code>FeatureType.DATASET</code>.
   */
  export interface DatasetFeature extends google.maps.Feature {
    /**
     * Key-value mapping of the feature&#39;s attributes.
     */
    datasetAttributes: {[key: string]: string};
    /**
     * Dataset id of the dataset that this feature belongs to.
     */
    datasetId: string;
  }
  /**
   * A single geocoded waypoint.
   */
  export interface DirectionsGeocodedWaypoint {
    /**
     * Whether the geocoder did not return an exact match for the original
     * waypoint, though it was able to match part of the requested address.
     */
    partial_match?: boolean;
    /**
     * The place ID associated with the waypoint. Place IDs uniquely identify a
     * place in the Google Places database and on Google Maps. Learn more about
     * <a
     * href="https://developers.google.com/maps/documentation/places/web-service/place-id">Place
     * IDs</a> in the Places API developer guide.
     */
    place_id?: string;
    /**
     * An array of strings denoting the type of the returned geocoded element.
     * For a list of possible strings, refer to the <a href=
     * "https://developers.google.com/maps/documentation/javascript/geocoding#GeocodingAddressTypes">
     * Address Component Types</a> section of the Developer&#39;s Guide.
     */
    types?: string[];
  }
  /**
   * A single leg consisting of a set of steps in a <code><a
   * href="#DirectionsResult">DirectionsResult</a></code>. Some fields in the
   * leg may not be returned for all requests. Note that though this result is
   * &quot;JSON-like,&quot; it is not strictly JSON, as it directly and
   * indirectly includes <code>LatLng</code> objects.
   */
  export interface DirectionsLeg {
    /**
     * An estimated arrival time for this leg. Only applicable for TRANSIT
     * requests.
     */
    arrival_time?: google.maps.Time;
    /**
     * An estimated departure time for this leg. Only applicable for TRANSIT
     * requests.
     */
    departure_time?: google.maps.Time;
    /**
     * The total distance covered by this leg. This property may be undefined as
     * the distance may be unknown.
     */
    distance?: google.maps.Distance;
    /**
     * The total duration of this leg. This property may be
     * <code>undefined</code> as the duration may be unknown.
     */
    duration?: google.maps.Duration;
    /**
     * The total duration of this leg, taking into account the traffic
     * conditions indicated by the <code>trafficModel</code> property. This
     * property may be <code>undefined</code> as the duration may be unknown.
     */
    duration_in_traffic?: google.maps.Duration;
    /**
     * The address of the destination of this leg. This content is meant to be
     * read as-is. Do not programmatically parse the formatted address.
     */
    end_address: string;
    /**
     * The <code>DirectionsService</code> calculates directions between
     * locations by using the nearest transportation option (usually a road) at
     * the start and end locations. <code>end_location</code> indicates the
     * actual geocoded destination, which may be different than the
     * <code>end_location</code> of the last step if, for example, the road is
     * not near the destination of this leg.
     */
    end_location: google.maps.LatLng;
    /**
     * The address of the origin of this leg. This content is meant to be read
     * as-is. Do not programmatically parse the formatted address.
     */
    start_address: string;
    /**
     * The <code>DirectionsService</code> calculates directions between
     * locations by using the nearest transportation option (usually a road) at
     * the start and end locations. <code>start_location</code> indicates the
     * actual geocoded origin, which may be different than the
     * <code>start_location</code> of the first step if, for example, the road
     * is not near the origin of this leg.
     */
    start_location: google.maps.LatLng;
    /**
     * An array of <code>DirectionsStep</code>s, each of which contains
     * information about the individual steps in this leg.
     */
    steps: google.maps.DirectionsStep[];
    /**
     * Information about traffic speed along the leg.
     * @deprecated This array will always be empty.
     */
    traffic_speed_entry: any[];
    /**
     * An array of non-stopover waypoints along this leg, which were specified
     * in the original request. <p> <strong>Deprecated in alternative
     * routes</strong>. Version 3.27 will be the last version of the API that
     * adds extra <code>via_waypoints</code> in alternative routes. <p> When
     * using the Directions Service to implement draggable directions, it is
     * recommended to disable dragging of alternative routes. Only the main
     * route should be draggable. Users can drag the main route until it matches
     * an alternative route.
     */
    via_waypoints: google.maps.LatLng[];
  }
  /**
   * An object containing a <code>points</code> property to describe the
   * polyline of a {@link google.maps.DirectionsStep}.
   */
  export interface DirectionsPolyline {
    /**
     * An <a
     * href="https://developers.google.com/maps/documentation/utilities/polylinealgorithm">encoded
     * polyline</a>.
     */
    points: string;
  }
  /**
   * Renders directions obtained from the <code><a
   * href="#DirectionsService">DirectionsService</a></code>.
   *
   * Access by calling `const {DirectionsRenderer} = await
   * google.maps.importLibrary("routes")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class DirectionsRenderer extends google.maps.MVCObject {
    /**
     * Renders directions obtained from the <code><a
     * href="#DirectionsService">DirectionsService</a></code>.
     *
     * Access by calling `const {DirectionsRenderer} = await
     * google.maps.importLibrary("routes")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(opts?: google.maps.DirectionsRendererOptions|null);
    /**
     * Returns the renderer&#39;s current set of directions.
     */
    getDirections(): google.maps.DirectionsResult|null;
    /**
     * Returns the map on which the <code>DirectionsResult</code> is rendered.
     */
    getMap(): google.maps.Map|null;
    /**
     * Returns the panel <code>&lt;div&gt;</code> in which the
     * <code>DirectionsResult</code> is rendered.
     */
    getPanel(): HTMLElement|null;
    /**
     * Returns the current (zero-based) route index in use by this
     * <code>DirectionsRenderer</code> object.
     */
    getRouteIndex(): number;
    /**
     * Set the renderer to use the result from the
     * <code>DirectionsService</code>. Setting a valid set of directions in this
     * manner will display the directions on the renderer&#39;s designated map
     * and panel.
     */
    setDirections(directions: google.maps.DirectionsResult|null): void;
    /**
     * This method specifies the map on which directions will be rendered. Pass
     * <code>null</code> to remove the directions from the map.
     */
    setMap(map: google.maps.Map|null): void;
    /**
     * Change the options settings of this <code>DirectionsRenderer</code> after
     * initialization.
     */
    setOptions(options: google.maps.DirectionsRendererOptions|null): void;
    /**
     * This method renders the directions in a <code>&lt;div&gt;</code>. Pass
     * <code>null</code> to remove the content from the panel.
     */
    setPanel(panel: HTMLElement|null): void;
    /**
     * Set the (zero-based) index of the route in the
     * <code>DirectionsResult</code> object to render. By default, the first
     * route in the array will be rendered.
     */
    setRouteIndex(routeIndex: number): void;
  }
  /**
   * This object defines the properties that can be set on a
   * <code>DirectionsRenderer</code> object.
   */
  export interface DirectionsRendererOptions {
    /**
     * The directions to display on the map and/or in a <code>&lt;div&gt;</code>
     * panel, retrieved as a <code>DirectionsResult</code> object from
     * <code>DirectionsService</code>.
     */
    directions?: google.maps.DirectionsResult|null;
    /**
     * If <code>true</code>, allows the user to drag and modify the paths of
     * routes rendered by this <code>DirectionsRenderer</code>.
     */
    draggable?: boolean|null;
    /**
     * This property indicates whether the renderer should provide a
     * user-selectable list of routes shown in the directions panel.
     * @defaultValue <code>false</code>
     */
    hideRouteList?: boolean|null;
    /**
     * The <code>InfoWindow</code> in which to render text information when a
     * marker is clicked. Existing info window content will be overwritten and
     * its position moved. If no info window is specified, the
     * <code>DirectionsRenderer</code> will create and use its own info window.
     * This property will be ignored if <code>suppressInfoWindows</code> is set
     * to <code>true</code>.
     */
    infoWindow?: google.maps.InfoWindow|null;
    /**
     * Map on which to display the directions.
     */
    map?: google.maps.Map|null;
    /**
     * Options for the markers. All markers rendered by the
     * <code>DirectionsRenderer</code> will use these options.
     */
    markerOptions?: google.maps.MarkerOptions|null;
    /**
     * The <code>&lt;div&gt;</code> in which to display the directions steps.
     */
    panel?: HTMLElement|null;
    /**
     * Options for the polylines. All polylines rendered by the
     * <code>DirectionsRenderer</code> will use these options.
     */
    polylineOptions?: google.maps.PolylineOptions|null;
    /**
     * If this option is set to <code>true</code> or the map&#39;s center and
     * zoom were never set, the input map is centered and zoomed to the bounding
     * box of this set of directions.
     * @defaultValue <code>false</code>
     */
    preserveViewport?: boolean|null;
    /**
     * The index of the route within the <code>DirectionsResult</code> object.
     * The default value is 0.
     */
    routeIndex?: number|null;
    /**
     * Suppress the rendering of the <code>BicyclingLayer</code> when bicycling
     * directions are requested.
     */
    suppressBicyclingLayer?: boolean|null;
    /**
     * Suppress the rendering of info windows.
     */
    suppressInfoWindows?: boolean|null;
    /**
     * Suppress the rendering of markers.
     */
    suppressMarkers?: boolean|null;
    /**
     * Suppress the rendering of polylines.
     */
    suppressPolylines?: boolean|null;
  }
  /**
   * A directions query to be sent to the <code><a
   * href="#DirectionsService">DirectionsService</a></code>.
   */
  export interface DirectionsRequest {
    /**
     * If <code>true</code>, instructs the Directions service to avoid ferries
     * where possible. Optional.
     */
    avoidFerries?: boolean;
    /**
     * If <code>true</code>, instructs the Directions service to avoid highways
     * where possible. Optional.
     */
    avoidHighways?: boolean;
    /**
     * If <code>true</code>, instructs the Directions service to avoid toll
     * roads where possible. Optional.
     */
    avoidTolls?: boolean;
    /**
     * Location of destination. This can be specified as either a string to be
     * geocoded, or a <code>LatLng</code>, or a <code>Place</code>. Required.
     */
    destination: string|google.maps.LatLng|google.maps.Place|
        google.maps.LatLngLiteral;
    /**
     * Settings that apply only to requests where <code>travelMode</code> is
     * <code>DRIVING</code>. This object will have no effect for other travel
     * modes.
     */
    drivingOptions?: google.maps.DrivingOptions;
    /**
     * A language identifier for the language in which results should be
     * returned, when possible. See the <a
     * href="https://developers.google.com/maps/faq#languagesupport">list of
     * supported languages</a>.
     */
    language?: string|null;
    /**
     * If set to <code>true</code>, the <code>DirectionsService</code> will
     * attempt to re-order the supplied intermediate waypoints to minimize
     * overall cost of the route. If waypoints are optimized, inspect
     * <code>DirectionsRoute.waypoint_order</code> in the response to determine
     * the new ordering.
     */
    optimizeWaypoints?: boolean;
    /**
     * Location of origin. This can be specified as either a string to be
     * geocoded, or a <code>LatLng</code>, or a <code>Place</code>. Required.
     */
    origin: string|google.maps.LatLng|google.maps.Place|
        google.maps.LatLngLiteral;
    /**
     * Whether or not route alternatives should be provided. Optional.
     */
    provideRouteAlternatives?: boolean;
    /**
     * Region code used as a bias for geocoding requests. The region code
     * accepts a <a
     * href="https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains">ccTLD
     * (&quot;top-level domain&quot;)</a> two-character value. Most ccTLD codes
     * are identical to ISO 3166-1 codes, with some notable exceptions. For
     * example, the United Kingdom&#39;s ccTLD is &quot;uk&quot;
     * (<code>.co.uk</code>) while its ISO 3166-1 code is &quot;gb&quot;
     * (technically for the entity of &quot;The United Kingdom of Great Britain
     * and Northern Ireland&quot;).
     */
    region?: string|null;
    /**
     * Settings that apply only to requests where <code>travelMode</code> is
     * TRANSIT. This object will have no effect for other travel modes.
     */
    transitOptions?: google.maps.TransitOptions;
    /**
     * Type of routing requested. Required.
     */
    travelMode: google.maps.TravelMode;
    /**
     * Preferred unit system to use when displaying distance.
     * @defaultValue The unit system used in the country of origin.
     */
    unitSystem?: google.maps.UnitSystem;
    /**
     * Array of intermediate waypoints. Directions are calculated from the
     * origin to the destination by way of each waypoint in this array. See the
     * <a
     * href="https://developers.google.com/maps/documentation/javascript/directions#UsageLimits">
     * developer&#39;s guide</a> for the maximum number of waypoints allowed.
     * Waypoints are not supported for transit directions. Optional.
     */
    waypoints?: google.maps.DirectionsWaypoint[];
  }
  /**
   * The directions response retrieved from the directions server. You can
   * render these using a {@link google.maps.DirectionsRenderer} or parse this
   * object and render it yourself. You must display the warnings and copyrights
   * as noted in the <a
   * href="https://cloud.google.com/maps-platform/terms">Google Maps Platform
   * Terms of Service</a>. Note that though this result is
   * &quot;JSON-like,&quot; it is not strictly JSON, as it indirectly includes
   * <code>LatLng</code> objects.
   */
  export interface DirectionsResult {
    /**
     * Contains an array of available travel modes. This field is returned when
     * a request specifies a travel mode and gets no results. The array contains
     * the available travel modes in the countries of the given set of
     * waypoints. This field is not returned if one or more of the waypoints are
     * &#39;via waypoints&#39;.
     */
    available_travel_modes?: google.maps.TravelMode[];
    /**
     * An array of <code>DirectionsGeocodedWaypoint</code>s, each of which
     * contains information about the geocoding of origin, destination and
     * waypoints.
     */
    geocoded_waypoints?: google.maps.DirectionsGeocodedWaypoint[];
    /**
     * An array of <code>DirectionsRoute</code>s, each of which contains
     * information about the legs and steps of which it is composed. There will
     * only be one route unless the <code>DirectionsRequest</code> was made with
     * <code>provideRouteAlternatives</code> set to <code>true</code>.
     */
    routes: google.maps.DirectionsRoute[];
  }
  /**
   * A single route containing a set of legs in a <code><a
   * href="#DirectionsResult">DirectionsResult</a></code>. Note that though this
   * object is &quot;JSON-like,&quot; it is not strictly JSON, as it directly
   * and indirectly includes <code>LatLng</code> objects.
   */
  export interface DirectionsRoute {
    /**
     * The bounds for this route.
     */
    bounds: google.maps.LatLngBounds;
    /**
     * Copyrights text to be displayed for this route.
     */
    copyrights: string;
    /**
     * The total fare for the whole transit trip. Only applicable to transit
     * requests.
     */
    fare?: google.maps.TransitFare;
    /**
     * An array of <code>DirectionsLeg</code>s, each of which contains
     * information about the steps of which it is composed. There will be one
     * leg for each stopover waypoint or destination specified. So a route with
     * no stopover waypoints will contain one <code>DirectionsLeg</code> and a
     * route with one stopover waypoint will contain two.
     */
    legs: google.maps.DirectionsLeg[];
    /**
     * An array of <code>LatLng</code>s representing the entire course of this
     * route. The path is simplified in order to make it suitable in contexts
     * where a small number of vertices is required (such as Static Maps API
     * URLs).
     */
    overview_path: google.maps.LatLng[];
    /**
     * An <a
     * href="https://developers.google.com/maps/documentation/utilities/polylinealgorithm">encoded
     * polyline representation</a> of the route in overview_path. This polyline
     * is an approximate (smoothed) path of the resulting directions.
     */
    overview_polyline: string;
    /**
     * Contains a short textual description for the route, suitable for naming
     * and disambiguating the route from alternatives.
     */
    summary: string;
    /**
     * Warnings to be displayed when showing these directions.
     */
    warnings: string[];
    /**
     * If <code>optimizeWaypoints</code> was set to <code>true</code>, this
     * field will contain the re-ordered permutation of the input waypoints. For
     * example, if the input was:<br> &nbsp;&nbsp;Origin: Los Angeles<br>
     * &nbsp;&nbsp;Waypoints: Dallas, Bangor, Phoenix<br>
     * &nbsp;&nbsp;Destination: New York<br> and the optimized output was
     * ordered as follows:<br> &nbsp;&nbsp;Origin: Los Angeles<br>
     * &nbsp;&nbsp;Waypoints: Phoenix, Dallas, Bangor<br>
     * &nbsp;&nbsp;Destination: New York<br> then this field will be an
     * <code>Array</code> containing the values [2, 0, 1]. Note that the
     * numbering of waypoints is zero-based.<br> If any of the input waypoints
     * has <code>stopover</code> set to <code>false</code>, this field will be
     * empty, since route optimization is not available for such queries.
     */
    waypoint_order: number[];
  }
  /**
   * A service for computing directions between two or more places.
   *
   * Access by calling `const {DirectionsService} = await
   * google.maps.importLibrary("routes")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class DirectionsService {
    /**
     * Issue a directions search request.
     */
    route(
        request: google.maps.DirectionsRequest,
        callback?:
            (a: google.maps.DirectionsResult|null,
             b: google.maps.DirectionsStatus) => void):
        Promise<google.maps.DirectionsResult>;
  }
  /**
   * The status returned by the <code>DirectionsService</code> on the completion
   * of a call to <code>route()</code>. Specify these by value, or by using the
   * constant&#39;s name. For example, <code>'OK'</code> or
   * <code>google.maps.DirectionsStatus.OK</code>.
   *
   * Access by calling `const {DirectionsStatus} = await
   * google.maps.importLibrary("routes")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum DirectionsStatus {
    /**
     * The <code>DirectionsRequest</code> provided was invalid.
     */
    INVALID_REQUEST = 'INVALID_REQUEST',
    /**
     * Too many <code>DirectionsWaypoint</code>s were provided in the
     * <code>DirectionsRequest</code>. See the <a
     * href="https://developers.google.com/maps/documentation/javascript/directions#UsageLimits">
     * developer&#39;s guide</a> for the maximum number of waypoints allowed.
     */
    MAX_WAYPOINTS_EXCEEDED = 'MAX_WAYPOINTS_EXCEEDED',
    /**
     * At least one of the origin, destination, or waypoints could not be
     * geocoded.
     */
    NOT_FOUND = 'NOT_FOUND',
    /**
     * The response contains a valid <code>DirectionsResult</code>.
     */
    OK = 'OK',
    /**
     * The webpage has gone over the requests limit in too short a period of
     * time.
     */
    OVER_QUERY_LIMIT = 'OVER_QUERY_LIMIT',
    /**
     * The webpage is not allowed to use the directions service.
     */
    REQUEST_DENIED = 'REQUEST_DENIED',
    /**
     * A directions request could not be processed due to a server error. The
     * request may succeed if you try again.
     */
    UNKNOWN_ERROR = 'UNKNOWN_ERROR',
    /**
     * No route could be found between the origin and destination.
     */
    ZERO_RESULTS = 'ZERO_RESULTS',
  }
  /**
   * A single <code>DirectionsStep</code> in a <code>DirectionsResult</code>.
   * Some fields may be <code>undefined</code>. Note that though this object is
   * &quot;JSON-like,&quot; it is not strictly JSON, as it directly includes
   * <code>LatLng</code> objects.
   */
  export interface DirectionsStep {
    /**
     * The distance covered by this step. This property may be
     * <code>undefined</code> as the distance may be unknown.
     */
    distance?: google.maps.Distance;
    /**
     * The typical time required to perform this step in seconds and in text
     * form. This property may be <code>undefined</code> as the duration may be
     * unknown.
     */
    duration?: google.maps.Duration;
    /**
     * An <a
     * href="https://developers.google.com/maps/documentation/utilities/polylinealgorithm">encoded
     * polyline representation</a> of the step. This is an approximate
     * (smoothed) path of the step.
     */
    encoded_lat_lngs: string;
    /**
     * The ending location of this step.
     */
    end_location: google.maps.LatLng;
    /**
     * The ending location of this step.
     * @deprecated Please use {@link google.maps.DirectionsStep.end_location}.
     */
    end_point: google.maps.LatLng;
    /**
     * Instructions for this step.
     */
    instructions: string;
    /**
     * A sequence of <code>LatLng</code>s describing the course of this step.
     * This is an approximate (smoothed) path of the step.
     * @deprecated Please use {@link google.maps.DirectionsStep.path}.
     */
    lat_lngs: google.maps.LatLng[];
    /**
     * Contains the action to take for the current step (<code>turn-left</code>,
     * <code>merge</code>, <code>straight</code>, etc.). Values are subject to
     * change, and new values may be introduced without prior notice.
     */
    maneuver: string;
    /**
     * A sequence of <code>LatLng</code>s describing the course of this step.
     * This is an approximate (smoothed) path of the step.
     */
    path: google.maps.LatLng[];
    /**
     * Contains an object with a single property, &#39;points&#39;, that holds
     * an <a
     * href="https://developers.google.com/maps/documentation/utilities/polylinealgorithm">encoded
     * polyline</a> representation of the step. This polyline is an approximate
     * (smoothed) path of the step.
     * @deprecated Please use {@link
     *     google.maps.DirectionsStep.encoded_lat_lngs}.
     */
    polyline?: google.maps.DirectionsPolyline;
    /**
     * The starting location of this step.
     */
    start_location: google.maps.LatLng;
    /**
     * The starting location of this step.
     * @deprecated Please use {@link google.maps.DirectionsStep.start_location}.
     */
    start_point: google.maps.LatLng;
    /**
     * Sub-steps of this step. Specified for non-transit sections of transit
     * routes.
     */
    steps?: google.maps.DirectionsStep[];
    /**
     * Transit-specific details about this step. This property will be undefined
     * unless the travel mode of this step is <code>TRANSIT</code>.
     */
    transit?: google.maps.TransitDetails;
    /**
     * Details pertaining to this step if the travel mode is
     * <code>TRANSIT</code>.
     */
    transit_details?: google.maps.TransitDetails;
    /**
     * The mode of travel used in this step.
     */
    travel_mode: google.maps.TravelMode;
  }
  export enum DirectionsTravelMode {}
  export enum DirectionsUnitSystem {}
  /**
   * A <code>DirectionsWaypoint</code> represents a location between origin and
   * destination through which the trip should be routed.
   */
  export interface DirectionsWaypoint {
    /**
     * Waypoint location. Can be an address string, a <code>LatLng</code>, or a
     * <code>Place</code>. Optional.
     */
    location?: string|google.maps.LatLng|google.maps.LatLngLiteral|
        google.maps.Place;
    /**
     * If <code>true</code>, indicates that this waypoint is a stop between the
     * origin and destination. This has the effect of splitting the route into
     * two legs. If <code>false</code>, indicates that the route should be
     * biased to go through this waypoint, but not split into two legs. This is
     * useful if you want to create a route in response to the user dragging
     * waypoints on a map.
     * @defaultValue <code>true</code>
     */
    stopover?: boolean;
  }
  /**
   * A representation of distance as a numeric value and a display string.
   */
  export interface Distance {
    /**
     * A string representation of the distance value, using the
     * <code>UnitSystem</code> specified in the request.
     */
    text: string;
    /**
     * The distance in meters.
     */
    value: number;
  }
  /**
   * The element-level status about a particular origin-destination pairing
   * returned by the <code>DistanceMatrixService</code> upon completion of a
   * distance matrix request. These values are specified as strings, for
   * example, <code>'OK'</code>.
   *
   * Access by calling `const {DistanceMatrixElementStatus} = await
   * google.maps.importLibrary("routes")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum DistanceMatrixElementStatus {
    /**
     * The origin and/or destination of this pairing could not be geocoded.
     */
    NOT_FOUND = 'NOT_FOUND',
    /**
     * The response contains a valid result.
     */
    OK = 'OK',
    /**
     * No route could be found between the origin and destination.
     */
    ZERO_RESULTS = 'ZERO_RESULTS',
  }
  /**
   * A distance matrix query sent by the <code>DistanceMatrixService</code>
   * containing arrays of origin and destination locations, and various options
   * for computing metrics.
   */
  export interface DistanceMatrixRequest {
    /**
     * If <code>true</code>, instructs the Distance Matrix service to avoid
     * ferries where possible. Optional.
     */
    avoidFerries?: boolean;
    /**
     * If <code>true</code>, instructs the Distance Matrix service to avoid
     * highways where possible. Optional.
     */
    avoidHighways?: boolean;
    /**
     * If <code>true</code>, instructs the Distance Matrix service to avoid toll
     * roads where possible. Optional.
     */
    avoidTolls?: boolean;
    /**
     * An array containing destination address strings, or <code>LatLng</code>,
     * or <code>Place</code> objects, to which to calculate distance and time.
     * Required.
     */
    destinations: (string|google.maps.LatLng|google.maps.LatLngLiteral|
                   google.maps.Place)[];
    /**
     * Settings that apply only to requests where <code>travelMode</code> is
     * <code>DRIVING</code>. This object will have no effect for other travel
     * modes.
     */
    drivingOptions?: google.maps.DrivingOptions;
    /**
     * A language identifier for the language in which results should be
     * returned, when possible. See the <a
     * href="https://developers.google.com/maps/faq#languagesupport">list of
     * supported languages</a>.
     */
    language?: null|string;
    /**
     * An array containing origin address strings, or <code>LatLng</code>, or
     * <code>Place</code> objects, from which to calculate distance and time.
     * Required.
     */
    origins: (string|google.maps.LatLng|google.maps.LatLngLiteral|
              google.maps.Place)[];
    /**
     * Region code used as a bias for geocoding requests. The region code
     * accepts a <a
     * href="https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains">ccTLD
     * (&quot;top-level domain&quot;)</a> two-character value. Most ccTLD codes
     * are identical to ISO 3166-1 codes, with some notable exceptions. For
     * example, the United Kingdom&#39;s ccTLD is &quot;uk&quot;
     * (<code>.co.uk</code>) while its ISO 3166-1 code is &quot;gb&quot;
     * (technically for the entity of &quot;The United Kingdom of Great Britain
     * and Northern Ireland&quot;).
     */
    region?: null|string;
    /**
     * Settings that apply only to requests where <code>travelMode</code> is
     * TRANSIT. This object will have no effect for other travel modes.
     */
    transitOptions?: google.maps.TransitOptions;
    /**
     * Type of routing requested. Required.
     */
    travelMode: google.maps.TravelMode;
    /**
     * Preferred unit system to use when displaying distance. Optional; defaults
     * to metric.
     */
    unitSystem?: google.maps.UnitSystem;
  }
  /**
   * The response to a <code>DistanceMatrixService</code> request, consisting of
   * the formatted origin and destination addresses, and a sequence of
   * <code>DistanceMatrixResponseRow</code>s, one for each corresponding origin
   * address.
   */
  export interface DistanceMatrixResponse {
    /**
     * The formatted destination addresses.
     */
    destinationAddresses: string[];
    /**
     * The formatted origin addresses.
     */
    originAddresses: string[];
    /**
     * The rows of the matrix, corresponding to the origin addresses.
     */
    rows: google.maps.DistanceMatrixResponseRow[];
  }
  /**
   * A single element of a response to a <code>DistanceMatrixService</code>
   * request, which contains the duration and distance from one origin to one
   * destination.
   */
  export interface DistanceMatrixResponseElement {
    /**
     * The distance for this origin-destination pairing. This property may be
     * undefined as the distance may be unknown.
     */
    distance: google.maps.Distance;
    /**
     * The duration for this origin-destination pairing. This property may be
     * undefined as the duration may be unknown.
     */
    duration: google.maps.Duration;
    /**
     * The duration for this origin-destination pairing, taking into account the
     * traffic conditions indicated by the <code>trafficModel</code> property.
     * This property may be <code>undefined</code> as the duration may be
     * unknown. Only available to Premium Plan customers when
     * <code>drivingOptions</code> is defined when making the request.
     */
    duration_in_traffic: google.maps.Duration;
    /**
     * The total fare for this origin-destination pairing. Only applicable to
     * transit requests.
     */
    fare: google.maps.TransitFare;
    /**
     * The status of this particular origin-destination pairing.
     */
    status: google.maps.DistanceMatrixElementStatus;
  }
  /**
   * A row of the response to a <code>DistanceMatrixService</code> request,
   * consisting of a sequence of <code>DistanceMatrixResponseElement</code>s,
   * one for each corresponding destination address.
   */
  export interface DistanceMatrixResponseRow {
    /**
     * The row&#39;s elements, corresponding to the destination addresses.
     */
    elements: google.maps.DistanceMatrixResponseElement[];
  }
  /**
   * A service for computing distances between multiple origins and
   * destinations.
   *
   * Access by calling `const {DistanceMatrixService} = await
   * google.maps.importLibrary("routes")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class DistanceMatrixService {
    /**
     * Issues a distance matrix request.
     */
    getDistanceMatrix(
        request: google.maps.DistanceMatrixRequest,
        callback?:
            (a: google.maps.DistanceMatrixResponse|null,
             b: google.maps.DistanceMatrixStatus) => void):
        Promise<google.maps.DistanceMatrixResponse>;
  }
  /**
   * The top-level status about the request in general returned by the
   * <code>DistanceMatrixService</code> upon completion of a distance matrix
   * request. Specify these by value, or by using the constant&#39;s name. For
   * example, <code>'OK'</code> or
   * <code>google.maps.DistanceMatrixStatus.OK</code>.
   *
   * Access by calling `const {DistanceMatrixStatus} = await
   * google.maps.importLibrary("routes")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum DistanceMatrixStatus {
    /**
     * The provided request was invalid.
     */
    INVALID_REQUEST = 'INVALID_REQUEST',
    /**
     * The request contains more than 25 origins, or more than 25 destinations.
     */
    MAX_DIMENSIONS_EXCEEDED = 'MAX_DIMENSIONS_EXCEEDED',
    /**
     * The product of origins and destinations exceeds the per-query limit.
     */
    MAX_ELEMENTS_EXCEEDED = 'MAX_ELEMENTS_EXCEEDED',
    /**
     * The response contains a valid result.
     */
    OK = 'OK',
    /**
     * Too many elements have been requested within the allowed time period. The
     * request should succeed if you try again after some time.
     */
    OVER_QUERY_LIMIT = 'OVER_QUERY_LIMIT',
    /**
     * The service denied use of the Distance Matrix service by your web page.
     */
    REQUEST_DENIED = 'REQUEST_DENIED',
    /**
     * A Distance Matrix request could not be processed due to a server error.
     * The request may succeed if you try again.
     */
    UNKNOWN_ERROR = 'UNKNOWN_ERROR',
  }
  export interface DrawingLibrary {
    DrawingManager: typeof google.maps.drawing.DrawingManager;
    OverlayType: typeof google.maps.drawing.OverlayType;
  }
  /**
   * Configures the <code><a
   * href="#DirectionsRequest">DirectionsRequest</a></code> when the travel mode
   * is set to <code>DRIVING</code>.
   */
  export interface DrivingOptions {
    /**
     * The desired departure time for the route, specified as a
     * <code>Date</code> object. The <code>Date</code> object measures time in
     * milliseconds since 1 January 1970. This must be specified for a
     * <code>DrivingOptions</code> to be valid. The departure time must be set
     * to the current time or some time in the future. It cannot be in the past.
     */
    departureTime: Date;
    /**
     * The preferred assumption to use when predicting duration in traffic. The
     * default is <code>BEST_GUESS</code>.
     */
    trafficModel?: google.maps.TrafficModel;
  }
  /**
   * A representation of duration as a numeric value and a display string.
   */
  export interface Duration {
    /**
     * A string representation of the duration value.
     */
    text: string;
    /**
     * The duration in seconds.
     */
    value: number;
  }
  export interface ElevationLibrary {
    ElevationService: typeof google.maps.ElevationService;
    ElevationStatus: typeof google.maps.ElevationStatus;
  }
  /**
   * The result of an <code>ElevationService</code> request, consisting of the
   * set of elevation coordinates and their elevation values. Note that a single
   * request may produce multiple <code>ElevationResult</code>s.
   */
  export interface ElevationResult {
    /**
     * The elevation of this point on Earth, in meters above sea level.
     */
    elevation: number;
    /**
     * The location of this elevation result.
     */
    location: null|google.maps.LatLng;
    /**
     * The distance, in meters, between sample points from which the elevation
     * was interpolated. This property will be missing if the resolution is not
     * known. Note that elevation data becomes more coarse (larger
     * <code>resolution</code> values) when multiple points are passed. To
     * obtain the most accurate elevation value for a point, it should be
     * queried independently.
     */
    resolution: number;
  }
  /**
   * Defines a service class that talks directly to Google servers for
   * requesting elevation data.
   *
   * Access by calling `const {ElevationService} = await
   * google.maps.importLibrary("elevation")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class ElevationService {
    /**
     * Makes an elevation request along a path, where the elevation data are
     * returned as distance-based samples along that path.
     */
    getElevationAlongPath(
        request: google.maps.PathElevationRequest,
        callback?:
            (a: google.maps.ElevationResult[]|null,
             b: google.maps.ElevationStatus) => void):
        Promise<google.maps.PathElevationResponse>;
    /**
     * Makes an elevation request for a list of discrete locations.
     */
    getElevationForLocations(
        request: google.maps.LocationElevationRequest,
        callback?:
            (a: google.maps.ElevationResult[]|null,
             b: google.maps.ElevationStatus) => void):
        Promise<google.maps.LocationElevationResponse>;
  }
  /**
   * The status returned by the <code>ElevationService</code> upon completion of
   * an elevation request. Specify these by value, or by using the
   * constant&#39;s name. For example, <code>'OK'</code> or
   * <code>google.maps.ElevationStatus.OK</code>.
   *
   * Access by calling `const {ElevationStatus} = await
   * google.maps.importLibrary("elevation")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum ElevationStatus {
    /**
     * The request was invalid.
     */
    INVALID_REQUEST = 'INVALID_REQUEST',
    /**
     * The request did not encounter any errors.
     */
    OK = 'OK',
    /**
     * The webpage has gone over the requests limit in too short a period of
     * time.
     */
    OVER_QUERY_LIMIT = 'OVER_QUERY_LIMIT',
    /**
     * The webpage is not allowed to use the elevation service.
     */
    REQUEST_DENIED = 'REQUEST_DENIED',
    /**
     * The elevation request could not be successfully processed, yet the exact
     * reason for the failure is not known.
     */
    UNKNOWN_ERROR = 'UNKNOWN_ERROR',
  }
  /**
   * An event with an associated Error.
   */
  export interface ErrorEvent {
    /**
     * The Error related to the event.
     */
    error: Error;
  }
  /**
   * An interface representing a vector map tile feature. These are inputs to
   * the <code>FeatureStyleFunction</code>. Do not save a reference to a
   * particular <code>Feature</code> object because the reference will not be
   * stable.
   */
  export interface Feature {
    /**
     * <code>FeatureType</code> of this <code>Feature</code>.
     */
    featureType: google.maps.FeatureType;
  }
  /**
   * An interface representing a map layer containing features of a
   * specific {@link google.maps.FeatureType} whose style can be overridden
   * client-side, or have events attached.
   */
  export interface FeatureLayer {
    /**
     * Adds the given listener function to the given event name. Returns an
     * identifier for this listener that can be used with {@link
     * google.maps.event.removeListener}.
     * @param eventName Observed event.
     * @param handler Function to handle events.
     */
    addListener(eventName: string, handler: Function):
        google.maps.MapsEventListener;
    /**
     * Available only in the v=beta channel: https://goo.gle/3oAthT3.
     * The Dataset ID for this <code>FeatureLayer</code>. Only present if the
     * <code>featureType</code> is <code>FeatureType.DATASET</code>.
     */
    datasetId?: string;
    /**
     * The <code>FeatureType</code> associated with this
     * <code>FeatureLayer</code>.
     */
    featureType: google.maps.FeatureType;
    /**
     * Whether this <code>FeatureLayer</code> is available, meaning whether
     * Data-driven styling is available for this map (there is a map ID using
     * vector tiles with this <code>FeatureLayer</code> enabled in the Google
     * Cloud Console map style.) If this is false (or becomes false), styling on
     * this <code>FeatureLayer</code> returns to default and events are not
     * triggered.
     */
    isAvailable: boolean;
    /**
     * The style of <code>Feature</code>s in the <code>FeatureLayer</code>. The
     * style is applied when style is set. If your style function updates, you
     * must set the style property again. A <code>FeatureStyleFunction</code>
     * must return consistent results when it is applied over the map tiles, and
     * should be optimized for performance. Asynchronous functions are not
     * supported. If you use a <code>FeatureStyleOptions</code>, all features of
     * that layer will be styled with the same <code>FeatureStyleOptions</code>.
     * Set the style to <code>null</code> to remove the previously set style. If
     * this <code>FeatureLayer</code> is not available, setting style does
     * nothing and logs an error.
     */
    style?: google.maps.FeatureStyleOptions|null|
        (google.maps.FeatureStyleFunction);
  }
  /**
   * This object is returned from a mouse event on a <code>FeatureLayer</code>.
   */
  export interface FeatureMouseEvent extends google.maps.MapMouseEvent {
    /**
     * The <code>Feature</code>s at this mouse event.
     */
    features: google.maps.Feature[];
  }
  export type FeatureStyleFunction =
      (a: google.maps.FeatureStyleFunctionOptions) =>
          google.maps.FeatureStyleOptions|null|undefined;
  /**
   * Options passed to a <code>FeatureStyleFunction</code>.
   */
  export interface FeatureStyleFunctionOptions {
    /**
     * <code>Feature</code> passed into the <code>FeatureStyleFunction</code>
     * for styling.
     */
    feature: google.maps.Feature;
  }
  /**
   * These options specify the way the style of a <code>Feature</code> should be
   * modified on a map.
   */
  export interface FeatureStyleOptions {
    /**
     * Hex RGB string (like &quot;#00FF00&quot; for green). Only applies to
     * polygon geometries.
     */
    fillColor?: string;
    /**
     * The fill opacity between 0.0 and 1.0. Only applies to polygon geometries.
     */
    fillOpacity?: number;
    /**
     * Hex RGB string (like &quot;#00FF00&quot; for green).
     */
    strokeColor?: string;
    /**
     * The stroke opacity between 0.0 and 1.0. Only applies to line and polygon
     * geometries.
     */
    strokeOpacity?: number;
    /**
     * The stroke width in pixels. Only applies to line and polygon geometries.
     */
    strokeWeight?: number;
  }
  /**
   * Identifiers for feature types.
   *
   * Access by calling `const {FeatureType} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum FeatureType {
    /**
     * Indicates a first-order civil entity below the country level.
     */
    ADMINISTRATIVE_AREA_LEVEL_1 = 'ADMINISTRATIVE_AREA_LEVEL_1',
    /**
     * Indicates a second-order civil entity below the country level.
     */
    ADMINISTRATIVE_AREA_LEVEL_2 = 'ADMINISTRATIVE_AREA_LEVEL_2',
    /**
     * Indicates the national political entity.
     */
    COUNTRY = 'COUNTRY',
    /**
     * Indicates a third-party dataset.
     */
    DATASET = 'DATASET',
    /**
     * Indicates an incorporated city or town political entity.
     */
    LOCALITY = 'LOCALITY',
    /**
     * Indicates a postal code as used to address postal mail within the
     * country.
     */
    POSTAL_CODE = 'POSTAL_CODE',
  }
  /**
   * Options for the rendering of the fullscreen control.
   */
  export interface FullscreenControlOptions {
    /**
     * Position id. Used to specify the position of the control on the map. The
     * default position is <code>RIGHT_TOP</code>.
     */
    position?: google.maps.ControlPosition|null;
  }
  /**
   * A service for converting between an address and a <code>LatLng</code>.
   *
   * Access by calling `const {Geocoder} = await
   * google.maps.importLibrary("geocoding")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Geocoder {
    /**
     * Geocode a request.
     */
    geocode(
        request: google.maps.GeocoderRequest,
        callback?: null|
        ((a: null|google.maps.GeocoderResult[],
          b: google.maps.GeocoderStatus) => void)):
        Promise<google.maps.GeocoderResponse>;
  }
  /**
   * A single address component within a <code>GeocoderResult</code>. A full
   * address may consist of multiple address components.
   */
  export interface GeocoderAddressComponent {
    /**
     * The full text of the address component
     */
    long_name: string;
    /**
     * The abbreviated, short text of the given address component
     */
    short_name: string;
    /**
     * An array of strings denoting the type of this address component. A list
     * of valid types can be found <a
     * href="https://developers.google.com/maps/documentation/javascript/geocoding#GeocodingAddressTypes">here</a>
     */
    types: string[];
  }
  /**
   * <code>GeocoderComponentRestrictions</code> represents a set of filters that
   * resolve to a specific area. For details on how this works, see <a
   * href="https://developers.google.com/maps/documentation/javascript/geocoding#ComponentFiltering">
   * Geocoding Component Filtering</a>.
   */
  export interface GeocoderComponentRestrictions {
    /**
     * Matches all the <code>administrative_area levels</code>. Optional.
     */
    administrativeArea?: string;
    /**
     * Matches a country name or a two letter ISO 3166-1 country code. Optional.
     */
    country?: string;
    /**
     * Matches against both <code>locality</code> and <code>sublocality</code>
     * types. Optional.
     */
    locality?: string;
    /**
     * Matches <code>postal_code</code> and <code>postal_code_prefix</code>.
     * Optional.
     */
    postalCode?: string;
    /**
     * Matches the long or short name of a <code>route</code>. Optional.
     */
    route?: string;
  }
  /**
   * Geometry information about this <code>GeocoderResult</code>
   */
  export interface GeocoderGeometry {
    /**
     * The precise bounds of this <code>GeocoderResult</code>, if applicable
     */
    bounds?: google.maps.LatLngBounds;
    /**
     * The latitude/longitude coordinates of this result
     */
    location: google.maps.LatLng;
    /**
     * The type of location returned in <code>location</code>
     */
    location_type: google.maps.GeocoderLocationType;
    /**
     * The bounds of the recommended viewport for displaying this
     * <code>GeocoderResult</code>
     */
    viewport: google.maps.LatLngBounds;
  }
  /**
   * Describes the type of location returned from a geocode. Specify these by
   * value, or by using the constant&#39;s name. For example,
   * <code>'ROOFTOP'</code> or
   * <code>google.maps.GeocoderLocationType.ROOFTOP</code>.
   *
   * Access by calling `const {GeocoderLocationType} = await
   * google.maps.importLibrary("geocoding")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum GeocoderLocationType {
    /**
     * The returned result is approximate.
     */
    APPROXIMATE = 'APPROXIMATE',
    /**
     * The returned result is the geometric center of a result such a line (e.g.
     * street) or polygon (region).
     */
    GEOMETRIC_CENTER = 'GEOMETRIC_CENTER',
    /**
     * The returned result reflects an approximation (usually on a road)
     * interpolated between two precise points (such as intersections).
     * Interpolated results are generally returned when rooftop geocodes are
     * unavailable for a street address.
     */
    RANGE_INTERPOLATED = 'RANGE_INTERPOLATED',
    /**
     * The returned result reflects a precise geocode.
     */
    ROOFTOP = 'ROOFTOP',
  }
  /**
   * The specification for a geocoding request to be sent to the
   * <code>Geocoder</code>.
   */
  export interface GeocoderRequest {
    /**
     * Address to geocode. One, and only one, of <code>address</code>,
     * <code>location</code> and <code>placeId</code> must be supplied.
     */
    address?: null|string;
    /**
     * <code>LatLngBounds</code> within which to search. Optional.
     */
    bounds?: null|google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral;
    /**
     * Components are used to restrict results to a specific area. A filter
     * consists of one or more of: <code>route</code>, <code>locality</code>,
     * <code>administrativeArea</code>, <code>postalCode</code>,
     * <code>country</code>. Only the results that match all the filters will be
     * returned. Filter values support the same methods of spelling correction
     * and partial matching as other geocoding requests. Optional.
     */
    componentRestrictions?: null|google.maps.GeocoderComponentRestrictions;
    /**
     * A language identifier for the language in which results should be
     * returned, when possible. See the <a
     * href="https://developers.google.com/maps/faq#languagesupport">list of
     * supported languages</a>.
     */
    language?: null|string;
    /**
     * <code>LatLng</code> (or <code>LatLngLiteral</code>) for which to search.
     * The geocoder performs a reverse geocode. See <a
     * href="https://developers.google.com/maps/documentation/javascript/geocoding#ReverseGeocoding">
     * Reverse Geocoding</a> for more information. One, and only one, of
     * <code>address</code>, <code>location</code> and <code>placeId</code> must
     * be supplied.
     */
    location?: null|google.maps.LatLng|google.maps.LatLngLiteral;
    /**
     * The place ID associated with the location. Place IDs uniquely identify a
     * place in the Google Places database and on Google Maps. Learn more about
     * <a
     * href="https://developers.google.com/maps/documentation/places/web-service/place-id">place
     * IDs</a> in the Places API developer guide. The geocoder performs a
     * reverse geocode. See <a
     * href="https://developers.google.com/maps/documentation/javascript/geocoding#ReverseGeocoding">Reverse
     * Geocoding</a> for more information. One, and only one, of
     * <code>address</code>, <code>location</code> and <code>placeId</code> must
     * be supplied.
     */
    placeId?: null|string;
    /**
     * Country code used to bias the search, specified as a two-character
     * (non-numeric) Unicode region subtag / CLDR identifier. Optional. See <a
     * href="http://developers.google.com/maps/coverage">Google Maps Platform
     * Coverage Details</a> for supported regions.
     */
    region?: null|string;
  }
  /**
   * A Geocoder response returned by the {@link google.maps.Geocoder} containing
   * the list of {@link google.maps.GeocoderResult}s.
   */
  export interface GeocoderResponse {
    /**
     * The list of {@link google.maps.GeocoderResult}s.
     */
    results: google.maps.GeocoderResult[];
  }
  /**
   * A single geocoder result retrieved from the geocode server. A geocode
   * request may return multiple result objects. Note that though this result is
   * &quot;JSON-like,&quot; it is not strictly JSON, as it indirectly includes a
   * <code>LatLng</code> object.
   */
  export interface GeocoderResult {
    /**
     * An array of <code>GeocoderAddressComponent</code>s
     */
    address_components: google.maps.GeocoderAddressComponent[];
    /**
     * A string containing the human-readable address of this location.
     */
    formatted_address: string;
    /**
     * A <code>GeocoderGeometry</code> object
     */
    geometry: google.maps.GeocoderGeometry;
    /**
     * Whether the geocoder did not return an exact match for the original
     * request, though it was able to match part of the requested address. If an
     * exact match, the value will be <code>undefined</code>.
     */
    partial_match?: boolean;
    /**
     * The place ID associated with the location. Place IDs uniquely identify a
     * place in the Google Places database and on Google Maps. Learn more about
     * <a
     * href="https://developers.google.com/maps/documentation/places/web-service/place-id">Place
     * IDs</a> in the Places API developer guide.
     */
    place_id: string;
    /**
     * The plus code associated with the location.
     */
    plus_code?: google.maps.places.PlacePlusCode;
    /**
     * An array of strings denoting all the localities contained in a postal
     * code. This is only present when the result is a postal code that contains
     * multiple localities.
     */
    postcode_localities?: string[];
    /**
     * An array of strings denoting the type of the returned geocoded element.
     * For a list of possible strings, refer to the <a href=
     * "https://developers.google.com/maps/documentation/javascript/geocoding#GeocodingAddressTypes">
     * Address Component Types</a> section of the Developer&#39;s Guide.
     */
    types: string[];
  }
  /**
   * The status returned by the <code>Geocoder</code> on the completion of a
   * call to <code>geocode()</code>. Specify these by value, or by using the
   * constant&#39;s name. For example, <code>'OK'</code> or
   * <code>google.maps.GeocoderStatus.OK</code>.
   *
   * Access by calling `const {GeocoderStatus} = await
   * google.maps.importLibrary("geocoding")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum GeocoderStatus {
    /**
     * There was a problem contacting the Google servers.
     */
    ERROR = 'ERROR',
    /**
     * This <code>GeocoderRequest</code> was invalid.
     */
    INVALID_REQUEST = 'INVALID_REQUEST',
    /**
     * The response contains a valid <code>GeocoderResponse</code>.
     */
    OK = 'OK',
    /**
     * The webpage has gone over the requests limit in too short a period of
     * time.
     */
    OVER_QUERY_LIMIT = 'OVER_QUERY_LIMIT',
    /**
     * The webpage is not allowed to use the geocoder.
     */
    REQUEST_DENIED = 'REQUEST_DENIED',
    /**
     * A geocoding request could not be processed due to a server error. The
     * request may succeed if you try again.
     */
    UNKNOWN_ERROR = 'UNKNOWN_ERROR',
    /**
     * No result was found for this <code>GeocoderRequest</code>.
     */
    ZERO_RESULTS = 'ZERO_RESULTS',
  }
  export interface GeocodingLibrary {
    Geocoder: typeof google.maps.Geocoder;
    GeocoderLocationType: typeof google.maps.GeocoderLocationType;
    GeocoderStatus: typeof google.maps.GeocoderStatus;
  }
  export interface GeometryLibrary {
    encoding: typeof google.maps.geometry.encoding;
    poly: typeof google.maps.geometry.poly;
    spherical: typeof google.maps.geometry.spherical;
  }
  /**
   * A rectangular image overlay on the map.
   *
   * Access by calling `const {GroundOverlay} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class GroundOverlay extends google.maps.MVCObject {
    /**
     * A rectangular image overlay on the map.
     *
     * Access by calling `const {GroundOverlay} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(
        url: string,
        bounds: google.maps.LatLngBounds|null|google.maps.LatLngBoundsLiteral,
        opts?: google.maps.GroundOverlayOptions|null);
    /**
     * Gets the <code>LatLngBounds</code> of this overlay.
     */
    getBounds(): google.maps.LatLngBounds|null;
    /**
     * Returns the map on which this ground overlay is displayed.
     */
    getMap(): google.maps.Map|null;
    /**
     * Returns the opacity of this ground overlay.
     */
    getOpacity(): number;
    /**
     * Gets the url of the projected image.
     */
    getUrl(): string;
    /**
     * Renders the ground overlay on the specified map. If map is set to
     * <code>null</code>, the overlay is removed.
     */
    setMap(map: google.maps.Map|null): void;
    /**
     * Sets the opacity of this ground overlay.
     */
    setOpacity(opacity: number): void;
  }
  /**
   * This object defines the properties that can be set on a
   * <code>GroundOverlay</code> object.
   */
  export interface GroundOverlayOptions {
    /**
     * If <code>true</code>, the ground overlay can receive mouse events.
     */
    clickable?: boolean|null;
    /**
     * The map on which to display the overlay.
     */
    map?: google.maps.Map|null;
    /**
     * The opacity of the overlay, expressed as a number between 0 and 1.
     * Optional.
     * @defaultValue <code>1.0</code>
     */
    opacity?: number|null;
  }
  /**
   * A structure representing a Marker icon image.
   */
  export interface Icon {
    /**
     * The position at which to anchor an image in correspondence to the
     * location of the marker on the map. By default, the anchor is located
     * along the center point of the bottom of the image.
     */
    anchor?: null|google.maps.Point;
    /**
     * The origin of the label relative to the top-left corner of the icon
     * image, if a label is supplied by the marker. By default, the origin is
     * located in the center point of the image.
     */
    labelOrigin?: null|google.maps.Point;
    /**
     * The position of the image within a sprite, if any. By default, the origin
     * is located at the top left corner of the image <code>(0, 0)</code>.
     */
    origin?: null|google.maps.Point;
    /**
     * The size of the entire image after scaling, if any. Use this property to
     * stretch/shrink an image or a sprite.
     */
    scaledSize?: null|google.maps.Size;
    /**
     * The display size of the sprite or image. When using sprites, you must
     * specify the sprite size. If the size is not provided, it will be set when
     * the image loads.
     */
    size?: null|google.maps.Size;
    /**
     * The URL of the image or sprite sheet.
     */
    url: string;
  }
  /**
   * This object is sent in an event when a user clicks on an icon on the map.
   * The place ID of this place is stored in the placeId member. To prevent the
   * default info window from showing up, call the stop() method on this event
   * to prevent it being propagated. Learn more about <a
   * href="https://developers.google.com/maps/documentation/places/web-service/place-id">place
   * IDs</a> in the Places API developer guide.
   */
  export interface IconMouseEvent extends google.maps.MapMouseEvent {
    /**
     * The place ID of the place that was clicked. This place ID can be used to
     * query more information about the feature that was clicked. <p> Learn more
     * about <a
     * href="https://developers.google.com/maps/documentation/places/web-service/place-id">place
     * IDs</a> in the Places API developer guide.
     */
    placeId: string|null;
  }
  /**
   * Describes how icons are to be rendered on a line. <br><br> If your polyline
   * is geodesic, then the distances specified for both offset and repeat are
   * calculated in meters by default. Setting either offset or repeat to a pixel
   * value will cause the distances to be calculated in pixels on the screen.
   */
  export interface IconSequence {
    /**
     * If <code>true</code>, each icon in the sequence has the same fixed
     * rotation regardless of the angle of the edge on which it lies. If
     * <code>false</code>, case each icon in the sequence is rotated to align
     * with its edge.
     * @defaultValue <code>false</code>
     */
    fixedRotation?: boolean;
    /**
     * The icon to render on the line.
     */
    icon?: null|google.maps.Symbol;
    /**
     * The distance from the start of the line at which an icon is to be
     * rendered. This distance may be expressed as a percentage of line&#39;s
     * length (e.g.
     * &#39;50%&#39;) or in pixels (e.g. &#39;50px&#39;).
     * @defaultValue <code>&#39;100%&#39;</code>
     */
    offset?: string;
    /**
     * The distance between consecutive icons on the line. This distance may be
     * expressed as a percentage of the line&#39;s length (e.g. &#39;50%&#39;)
     * or in pixels (e.g. &#39;50px&#39;). To disable repeating of the icon,
     * specify
     * &#39;0&#39;.
     * @defaultValue <code>0</code>
     */
    repeat?: string;
  }
  /**
   * This class implements the MapType interface and is provided for rendering
   * image tiles.
   *
   * Access by calling `const {ImageMapType} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class ImageMapType extends google.maps.MVCObject implements
      google.maps.MapType {
    /**
     * This class implements the MapType interface and is provided for rendering
     * image tiles.
     *
     * Access by calling `const {ImageMapType} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(opts: google.maps.ImageMapTypeOptions|null);
    alt: string|null;
    /**
     * Returns the opacity level (<code>0</code> (transparent) to
     * <code>1.0</code>) of the <code>ImageMapType</code> tiles.
     */
    getOpacity(): number;
    getTile(
        tileCoord: google.maps.Point|null, zoom: number,
        ownerDocument: Document|null): Element|null;
    maxZoom: number;
    minZoom: number;
    name: string|null;
    projection: google.maps.Projection|null;
    radius: number;
    releaseTile(tileDiv: Element|null): void;
    /**
     * Sets the opacity level (<code>0</code> (transparent) to <code>1.0</code>)
     * of the <code>ImageMapType</code> tiles.
     * @param opacity The new opacity.
     */
    setOpacity(opacity: number): void;
    tileSize: google.maps.Size|null;
  }
  /**
   * This class is used to create a MapType that renders image tiles.
   */
  export interface ImageMapTypeOptions {
    /**
     * Alt text to display when this MapType&#39;s button is hovered over in the
     * MapTypeControl.
     */
    alt?: string|null;
    /**
     * Returns a string (URL) for given tile coordinate (x, y) and zoom level.
     */
    getTileUrl?: ((a: google.maps.Point, b: number) => string | null)|null;
    /**
     * The maximum zoom level for the map when displaying this MapType.
     */
    maxZoom?: number|null;
    /**
     * The minimum zoom level for the map when displaying this MapType.
     * Optional.
     */
    minZoom?: number|null;
    /**
     * Name to display in the MapTypeControl.
     */
    name?: string|null;
    /**
     * The opacity to apply to the tiles. The opacity should be specified as a
     * float value between 0 and 1.0, where 0 is fully transparent and 1 is
     * fully opaque.
     */
    opacity?: number|null;
    /**
     * The tile size.
     */
    tileSize?: google.maps.Size|null;
  }
  /**
   * An overlay that looks like a bubble and is often connected to a marker.
   *
   * Access by calling `const {InfoWindow} = await
   * google.maps.importLibrary("maps")` or `const {InfoWindow} = await
   * google.maps.importLibrary("streetView")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class InfoWindow extends google.maps.MVCObject {
    /**
     * An overlay that looks like a bubble and is often connected to a marker.
     *
     * Access by calling `const {InfoWindow} = await
     * google.maps.importLibrary("maps")` or `const {InfoWindow} = await
     * google.maps.importLibrary("streetView")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(opts?: google.maps.InfoWindowOptions|null);
    /**
     * Closes this InfoWindow by removing it from the DOM structure.
     */
    close(): void;
    /**
     * Sets focus on this <code>InfoWindow</code>. You may wish to consider
     * using this method along with a <code>visible</code> event to make sure
     * that <code>InfoWindow</code> is visible before setting focus on it. An
     * <code>InfoWindow</code> that is not visible cannot be focused.
     */
    focus(): void;
    getContent(): string|Element|null|Text|undefined;
    getPosition(): google.maps.LatLng|null|undefined;
    getZIndex(): number;
    /**
     * Opens this InfoWindow on the given map. Optionally, an InfoWindow can be
     * associated with an anchor. In the core API, the only anchor is the Marker
     * class. However, an anchor can be any MVCObject that exposes a LatLng
     * <code>position</code> property and optionally a Point
     * <code>anchorPoint</code> property for calculating the
     * <code>pixelOffset</code> (see InfoWindowOptions). The
     * <code>anchorPoint</code> is the offset from the anchor&#39;s position to
     * the tip of the InfoWindow. It is recommended to use the {@link
     * google.maps.InfoWindowOpenOptions} interface as the single argument for
     * this method. To prevent changing browser focus on open, set {@link
     * google.maps.InfoWindowOpenOptions.shouldFocus} to <code>false</code>.
     * @param options Either an InfoWindowOpenOptions object (recommended) or
     *     the map|panorama on which to render this InfoWindow.
     * @param anchor The anchor to which this InfoWindow will be positioned. If
     *     the anchor is non-null, the InfoWindow will be positioned at the
     *     top-center of the anchor. The InfoWindow will be rendered on the same
     *     map or panorama as the anchor <strong>(when available)</strong>.
     */
    open(
        options?: google.maps.InfoWindowOpenOptions|null|google.maps.Map|
        google.maps.StreetViewPanorama,
        anchor?: google.maps.MVCObject|null|
        google.maps.marker.AdvancedMarkerElement): void;
    setContent(content?: string|Element|null|Text): void;
    setOptions(options?: google.maps.InfoWindowOptions|null): void;
    setPosition(position?: google.maps.LatLng|null|
                google.maps.LatLngLiteral): void;
    setZIndex(zIndex: number): void;
  }
  /**
   * Options for opening an InfoWindow
   */
  export interface InfoWindowOpenOptions {
    /**
     * The anchor to which this InfoWindow will be positioned. If the anchor is
     * non-null, the InfoWindow will be positioned at the top-center of the
     * anchor. The InfoWindow will be rendered on the same map or panorama as
     * the anchor <strong>(when available)</strong>.
     */
    anchor?: google.maps.MVCObject|null|
        google.maps.marker.AdvancedMarkerElement;
    /**
     * The map or panorama on which to render this InfoWindow.
     */
    map?: google.maps.Map|null|google.maps.StreetViewPanorama;
    /**
     * Whether or not focus should be moved inside the InfoWindow when it is
     * opened. When this property is unset or when it is set to
     * <code>null</code> or <code>undefined</code>, a heuristic is used to
     * decide whether or not focus should be moved. It is recommended to
     * explicitly set this property to fit your needs as the heuristic is
     * subject to change and may not work well for all use cases.
     */
    shouldFocus?: boolean|null;
  }
  /**
   * InfoWindowOptions object used to define the properties that can be set on a
   * InfoWindow.
   */
  export interface InfoWindowOptions {
    /**
     * AriaLabel to assign to the InfoWindow.
     */
    ariaLabel?: null|string;
    /**
     * Content to display in the InfoWindow. This can be an HTML element, a
     * plain-text string, or a string containing HTML. The InfoWindow will be
     * sized according to the content. To set an explicit size for the content,
     * set content to be a HTML element with that size.
     */
    content?: null|string|Element|Text;
    /**
     * Disable panning the map to make the InfoWindow fully visible when it
     * opens.
     * @defaultValue <code>false</code>
     */
    disableAutoPan?: null|boolean;
    /**
     * Maximum width of the InfoWindow, regardless of content&#39;s width. This
     * value is only considered if it is set before a call to
     * <code>open()</code>. To change the maximum width when changing content,
     * call <code>close()</code>, <code>setOptions()</code>, and then
     * <code>open()</code>.
     */
    maxWidth?: null|number;
    /**
     * Minimum width of the InfoWindow, regardless of the content&#39;s width.
     * When using this property, it is strongly recommended to set the
     * <code>minWidth</code> to a value less than the width of the map (in
     * pixels). This value is only considered if it is set before a call to
     * <code>open()</code>. To change the minimum width when changing content,
     * call <code>close()</code>, <code>setOptions()</code>, and then
     * <code>open()</code>.
     */
    minWidth?: null|number;
    /**
     * The offset, in pixels, of the tip of the info window from the point on
     * the map at whose geographical coordinates the info window is anchored. If
     * an InfoWindow is opened with an anchor, the <code>pixelOffset</code> will
     * be calculated from the anchor&#39;s <code>anchorPoint</code> property.
     */
    pixelOffset?: null|google.maps.Size;
    /**
     * The LatLng at which to display this InfoWindow. If the InfoWindow is
     * opened with an anchor, the anchor&#39;s position will be used instead.
     */
    position?: null|google.maps.LatLng|google.maps.LatLngLiteral;
    /**
     * All InfoWindows are displayed on the map in order of their zIndex, with
     * higher values displaying in front of InfoWindows with lower values. By
     * default, InfoWindows are displayed according to their latitude, with
     * InfoWindows of lower latitudes appearing in front of InfoWindows at
     * higher latitudes. InfoWindows are always displayed in front of markers.
     */
    zIndex?: null|number;
  }
  export interface JourneySharingLibrary {
    AutomaticViewportMode:
        typeof google.maps.journeySharing.AutomaticViewportMode;
    DeliveryVehicleStopState:
        typeof google.maps.journeySharing.DeliveryVehicleStopState;
    FleetEngineServiceType:
        typeof google.maps.journeySharing.FleetEngineServiceType;
    FleetEngineShipmentLocationProvider:
        typeof google.maps.journeySharing.FleetEngineShipmentLocationProvider;
    FleetEngineTripLocationProvider:
        typeof google.maps.journeySharing.FleetEngineTripLocationProvider;
    JourneySharingMapView:
        typeof google.maps.journeySharing.JourneySharingMapView;
  }
  /**
   * Contains details of the author of a KML document or feature.
   */
  export interface KmlAuthor {
    /**
     * The author&#39;s e-mail address, or an empty string if not specified.
     */
    email: string;
    /**
     * The author&#39;s name, or an empty string if not specified.
     */
    name: string;
    /**
     * The author&#39;s home page, or an empty string if not specified.
     */
    uri: string;
  }
  /**
   * Data for a single KML feature in JSON format, returned when a KML feature
   * is clicked. The data contained in this object mirrors that associated with
   * the feature in the KML or GeoRSS markup in which it is declared.
   */
  export interface KmlFeatureData {
    /**
     * The feature&#39;s <code>&lt;atom:author&gt;</code>, extracted from the
     * layer markup (if specified).
     */
    author: google.maps.KmlAuthor|null;
    /**
     * The feature&#39;s <code>&lt;description&gt;</code>, extracted from the
     * layer markup.
     */
    description: string;
    /**
     * The feature&#39;s <code>&lt;id&gt;</code>, extracted from the layer
     * markup. If no <code>&lt;id&gt;</code> has been specified, a unique ID
     * will be generated for this feature.
     */
    id: string;
    /**
     * The feature&#39;s balloon styled text, if set.
     */
    infoWindowHtml: string;
    /**
     * The feature&#39;s <code>&lt;name&gt;</code>, extracted from the layer
     * markup.
     */
    name: string;
    /**
     * The feature&#39;s <code>&lt;Snippet&gt;</code>, extracted from the layer
     * markup.
     */
    snippet: string;
  }
  /**
   * A <code>KmlLayer</code> adds geographic markup to the map from a KML, KMZ
   * or GeoRSS file that is hosted on a publicly accessible web server. A
   * <code>KmlFeatureData</code> object is provided for each feature when
   * clicked.
   *
   * Access by calling `const {KmlLayer} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class KmlLayer extends google.maps.MVCObject {
    /**
     * A <code>KmlLayer</code> adds geographic markup to the map from a KML, KMZ
     * or GeoRSS file that is hosted on a publicly accessible web server. A
     * <code>KmlFeatureData</code> object is provided for each feature when
     * clicked.
     *
     * Access by calling `const {KmlLayer} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     * @param opts Options for this layer.
     */
    constructor(opts?: google.maps.KmlLayerOptions|null);
    /**
     * Get the default viewport for the layer being displayed.
     */
    getDefaultViewport(): google.maps.LatLngBounds|null;
    /**
     * Get the map on which the KML Layer is being rendered.
     */
    getMap(): google.maps.Map|null;
    /**
     * Get the metadata associated with this layer, as specified in the layer
     * markup.
     */
    getMetadata(): google.maps.KmlLayerMetadata|null;
    /**
     * Get the status of the layer, set once the requested document has loaded.
     */
    getStatus(): google.maps.KmlLayerStatus;
    /**
     * Gets the URL of the KML file being displayed.
     */
    getUrl(): string;
    /**
     * Gets the z-index of the KML Layer.
     */
    getZIndex(): number;
    /**
     * Renders the KML Layer on the specified map. If map is set to
     * <code>null</code>, the layer is removed.
     */
    setMap(map: google.maps.Map|null): void;
    setOptions(options: google.maps.KmlLayerOptions|null): void;
    /**
     * Sets the URL of the KML file to display.
     */
    setUrl(url: string): void;
    /**
     * Sets the z-index of the KML Layer.
     * @param zIndex The z-index to set.
     */
    setZIndex(zIndex: number): void;
  }
  /**
   * Metadata for a single KML layer, in JSON format.
   */
  export interface KmlLayerMetadata {
    /**
     * The layer&#39;s <code>&lt;atom:author&gt;</code>, extracted from the
     * layer markup.
     */
    author: google.maps.KmlAuthor|null;
    /**
     * The layer&#39;s <code>&lt;description&gt;</code>, extracted from the
     * layer markup.
     */
    description: string;
    /**
     * Whether the layer has any screen overlays.
     */
    hasScreenOverlays: boolean;
    /**
     * The layer&#39;s <code>&lt;name&gt;</code>, extracted from the layer
     * markup.
     */
    name: string;
    /**
     * The layer&#39;s <code>&lt;Snippet&gt;</code>, extracted from the layer
     * markup
     */
    snippet: string;
  }
  /**
   * This object defines the properties that can be set on a
   * <code>KmlLayer</code> object.
   */
  export interface KmlLayerOptions {
    /**
     * If <code>true</code>, the layer receives mouse events.
     * @defaultValue <code>true</code>
     */
    clickable?: boolean|null;
    /**
     * The map on which to display the layer.
     */
    map?: google.maps.Map|null;
    /**
     * If this option is set to <code>true</code> or if the map&#39;s center and
     * zoom were never set, the input map is centered and zoomed to the bounding
     * box of the contents of the layer.
     * @defaultValue <code>false</code>
     */
    preserveViewport?: boolean|null;
    /**
     * Whether to render the screen overlays.
     * @defaultValue <code>true</code>
     */
    screenOverlays?: boolean|null;
    /**
     * Suppress the rendering of info windows when layer features are clicked.
     */
    suppressInfoWindows?: boolean|null;
    /**
     * The URL of the KML document to display.
     */
    url?: string|null;
    /**
     * The z-index of the layer.
     */
    zIndex?: number|null;
  }
  /**
   * The status returned by <code>KmlLayer</code> on the completion of loading a
   * document. Specify these by value, or by using the constant&#39;s name. For
   * example, <code>'OK'</code> or <code>google.maps.KmlLayerStatus.OK</code>.
   *
   * Access by calling `const {KmlLayerStatus} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum KmlLayerStatus {
    /**
     * The document could not be found. Most likely it is an invalid URL, or the
     * document is not publicly available.
     */
    DOCUMENT_NOT_FOUND = 'DOCUMENT_NOT_FOUND',
    /**
     * The document exceeds the file size limits of KmlLayer.
     */
    DOCUMENT_TOO_LARGE = 'DOCUMENT_TOO_LARGE',
    /**
     * The document could not be fetched.
     */
    FETCH_ERROR = 'FETCH_ERROR',
    /**
     * The document is not a valid KML, KMZ or GeoRSS document.
     */
    INVALID_DOCUMENT = 'INVALID_DOCUMENT',
    /**
     * The <code>KmlLayer</code> is invalid.
     */
    INVALID_REQUEST = 'INVALID_REQUEST',
    /**
     * The document exceeds the feature limits of KmlLayer.
     */
    LIMITS_EXCEEDED = 'LIMITS_EXCEEDED',
    /**
     * The layer loaded successfully.
     */
    OK = 'OK',
    /**
     * The document could not be loaded within a reasonable amount of time.
     */
    TIMED_OUT = 'TIMED_OUT',
    /**
     * The document failed to load for an unknown reason.
     */
    UNKNOWN = 'UNKNOWN',
  }
  /**
   * The properties of a click event on a KML/KMZ or GeoRSS document.
   */
  export interface KmlMouseEvent {
    /**
     * A <code>KmlFeatureData</code> object, containing information about the
     * clicked feature.
     */
    featureData: google.maps.KmlFeatureData|null;
    /**
     * The position at which to anchor an infowindow on the clicked feature.
     */
    latLng: google.maps.LatLng|null;
    /**
     * The offset to apply to an infowindow anchored on the clicked feature.
     */
    pixelOffset: google.maps.Size|null;
  }
  /**
   * A <code>LatLng</code> is a point in geographical coordinates: latitude and
   * longitude.<br> <ul> <li>Latitude ranges between -90 and 90 degrees,
   * inclusive. Values above or below this range will be clamped to the range
   * [-90, 90]. This means that if the value specified is less than -90, it will
   * be set to -90. And if the value is greater than 90, it will be set
   * to 90.</li> <li>Longitude ranges between -180 and 180 degrees, inclusive.
   * Values above or below this range will be wrapped so that they fall within
   * the range. For example, a value of -190 will be converted to 170. A value
   * of 190 will be converted to -170. This reflects the fact that longitudes
   * wrap around the globe.</li> </ul> Although the default map projection
   * associates longitude with the x-coordinate of the map, and latitude with
   * the y-coordinate, the latitude coordinate is always written <em>first</em>,
   * followed by the longitude.<br> Notice that you cannot modify the
   * coordinates of a <code>LatLng</code>. If you want to compute another point,
   * you have to create a new one.<br> <p> Most methods that accept
   * <code>LatLng</code> objects also accept a {@link google.maps.LatLngLiteral}
   * object, so that the following are equivalent: <pre> map.setCenter(new
   * google.maps.LatLng(-34, 151));<br> map.setCenter({lat: -34, lng: 151});
   * </pre> <p> The constructor also accepts {@link google.maps.LatLngLiteral}
   * and <code>LatLng</code> objects. If a <code>LatLng</code> instance is
   * passed to the constructor, a copy is created. <p> The possible calls to the
   * constructor are below: <pre> new google.maps.LatLng(-34, 151);<br> new
   * google.maps.LatLng(-34, 151, true);<br> new google.maps.LatLng({lat: -34,
   * lng: 151});<br> new google.maps.LatLng({lat: -34, lng: 151}, true);<br> new
   * google.maps.LatLng({lat: -34, lng: 151}, null, true);<br> new
   * google.maps.LatLng(new google.maps.LatLng(-34, 151));<br> new
   * google.maps.LatLng(new google.maps.LatLng(-34, 151), true);<br> new
   * google.maps.LatLng(new google.maps.LatLng(-34, 151), null, true); </pre>
   *
   * Access by calling `const {LatLng} = await
   * google.maps.importLibrary("core")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class LatLng {
    /**
     * A <code>LatLng</code> is a point in geographical coordinates: latitude
     * and longitude.<br> <ul> <li>Latitude ranges between -90 and 90 degrees,
     * inclusive. Values above or below this range will be clamped to the range
     * [-90, 90]. This means that if the value specified is less than -90, it
     * will be set to -90. And if the value is greater than 90, it will be set
     * to 90.</li> <li>Longitude ranges between -180 and 180 degrees, inclusive.
     * Values above or below this range will be wrapped so that they fall within
     * the range. For example, a value of -190 will be converted to 170. A value
     * of 190 will be converted to -170. This reflects the fact that longitudes
     * wrap around the globe.</li> </ul> Although the default map projection
     * associates longitude with the x-coordinate of the map, and latitude with
     * the y-coordinate, the latitude coordinate is always written
     * <em>first</em>, followed by the longitude.<br> Notice that you cannot
     * modify the coordinates of a <code>LatLng</code>. If you want to compute
     * another point, you have to create a new one.<br> <p> Most methods that
     * accept <code>LatLng</code> objects also accept a {@link
     * google.maps.LatLngLiteral} object, so that the following are equivalent:
     * <pre> map.setCenter(new google.maps.LatLng(-34, 151));<br>
     * map.setCenter({lat: -34, lng: 151}); </pre> <p> The constructor also
     * accepts {@link google.maps.LatLngLiteral} and <code>LatLng</code>
     * objects. If a <code>LatLng</code> instance is passed to the constructor,
     * a copy is created. <p> The possible calls to the constructor are below:
     * <pre> new google.maps.LatLng(-34, 151);<br> new google.maps.LatLng(-34,
     * 151, true);<br> new google.maps.LatLng({lat: -34, lng: 151});<br> new
     * google.maps.LatLng({lat: -34, lng: 151}, true);<br> new
     * google.maps.LatLng({lat: -34, lng: 151}, null, true);<br> new
     * google.maps.LatLng(new google.maps.LatLng(-34, 151));<br> new
     * google.maps.LatLng(new google.maps.LatLng(-34, 151), true);<br> new
     * google.maps.LatLng(new google.maps.LatLng(-34, 151), null, true); </pre>
     *
     * Access by calling `const {LatLng} = await
     * google.maps.importLibrary("core")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(
        latOrLatLngOrLatLngLiteral: number|google.maps.LatLngLiteral|
        google.maps.LatLng,
        lngOrNoClampNoWrap?: number|boolean|null, noClampNoWrap?: boolean);
    /**
     * Comparison function.
     */
    equals(other: google.maps.LatLng|null): boolean;
    /**
     * Returns the latitude in degrees.
     */
    lat(): number;
    /**
     * Returns the longitude in degrees.
     */
    lng(): number;
    /**
     * Converts to JSON representation. This function is intended to be used via
     * <code>JSON.stringify</code>.
     */
    toJSON(): google.maps.LatLngLiteral;
    /**
     * Converts to string representation.
     */
    toString(): string;
    /**
     * Returns a string of the form &quot;lat,lng&quot; for this LatLng. We
     * round the lat/lng values to 6 decimal places by default.
     */
    toUrlValue(precision?: number): string;
  }
  /**
   * A <code>LatLngAltitude</code> is a 3D point in geographical coordinates:
   * latitude, longitude, and altitude.<br> <ul> <li>Latitude ranges between -90
   * and 90 degrees, inclusive. Values above or below this range will be clamped
   * to the range [-90, 90]. This means that if the value specified is less than
   * -90, it will be set to -90. And if the value is greater than 90, it will be
   * set to 90.</li> <li>Longitude ranges between -180 and 180 degrees,
   * inclusive. Values above or below this range will be wrapped so that they
   * fall within the range. For example, a value of -190 will be converted to
   * 170. A value of 190 will be converted to -170. This reflects the fact that
   * longitudes wrap around the globe.</li> <li>Altitude is measured in meters.
   * Positive values denote heights above ground level, and negative values
   * denote heights underneath the ground surface.</li> </ul>
   *
   * Access by calling `const {LatLngAltitude} = await
   * google.maps.importLibrary("core")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class LatLngAltitude implements google.maps.LatLngAltitudeLiteral,
                                         google.maps.LatLngLiteral {
    /**
     * A <code>LatLngAltitude</code> is a 3D point in geographical coordinates:
     * latitude, longitude, and altitude.<br> <ul> <li>Latitude ranges between
     * -90 and 90 degrees, inclusive. Values above or below this range will be
     * clamped to the range [-90, 90]. This means that if the value specified is
     * less than -90, it will be set to -90. And if the value is greater than
     * 90, it will be set to 90.</li> <li>Longitude ranges between -180 and 180
     * degrees, inclusive. Values above or below this range will be wrapped so
     * that they fall within the range. For example, a value of -190 will be
     * converted to 170. A value of 190 will be converted to -170. This reflects
     * the fact that longitudes wrap around the globe.</li> <li>Altitude is
     * measured in meters. Positive values denote heights above ground level,
     * and negative values denote heights underneath the ground surface.</li>
     * </ul>
     *
     * Access by calling `const {LatLngAltitude} = await
     * google.maps.importLibrary("core")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     * @param value The initializing value.
     * @param noClampNoWrap Whether to preserve the initialization values, even
     *     if they may not necessarily be valid latitude values in the range of
     *     [-90, 90] or valid longitude values in the range of [-180, 180]. The
     *     default is <code>false</code> which enables latitude clamping and
     *     longitude wrapping.
     */
    constructor(
        value: google.maps.LatLngAltitudeLiteral|
        google.maps.LatLngLiteral|google.maps.LatLng,
        noClampNoWrap?: boolean);
    /**
     * Returns the altitude.
     */
    altitude: number;
    /**
     * Comparison function.
     * @param other Another LatLngAltitude object.
     */
    equals(other: null|google.maps.LatLngAltitude): boolean;
    /**
     * Returns the latitude.
     */
    lat: number;
    /**
     * Returns the longitude.
     */
    lng: number;
    toJSON(): google.maps.LatLngAltitudeLiteral;
  }
  /**
   * Object literals are accepted in place of <code>LatLngAltitude</code>
   * objects, as a convenience, in many places. These are converted to
   * <code>LatLngAltitude</code> objects when the Maps API encounters them.
   */
  export interface LatLngAltitudeLiteral extends google.maps.LatLngLiteral {
    /**
     * Distance (in meters) above the ground surface. Negative value means
     * underneath the ground surface.
     * @defaultValue <code>0</code>
     */
    altitude: number;
    /**
     * Latitude in degrees. Values will be clamped to the range [-90, 90]. This
     * means that if the value specified is less than -90, it will be set to
     * -90. And if the value is greater than 90, it will be set to 90.
     */
    lat: number;
    /**
     * Longitude in degrees. Values outside the range [-180, 180] will be
     * wrapped so that they fall within the range. For example, a value of -190
     * will be converted to 170. A value of 190 will be converted to -170. This
     * reflects the fact that longitudes wrap around the globe.
     */
    lng: number;
  }
  /**
   * A <code><a href="#LatLngBounds">LatLngBounds</a></code> instance represents
   * a rectangle in geographical coordinates, including one that crosses the 180
   * degrees longitudinal meridian.
   *
   * Access by calling `const {LatLngBounds} = await
   * google.maps.importLibrary("core")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class LatLngBounds {
    /**
     * A <code><a href="#LatLngBounds">LatLngBounds</a></code> instance
     * represents a rectangle in geographical coordinates, including one that
     * crosses the 180 degrees longitudinal meridian.
     *
     * Access by calling `const {LatLngBounds} = await
     * google.maps.importLibrary("core")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(
        swOrLatLngBounds?: google.maps.LatLng|null|
        google.maps.LatLngLiteral|google.maps.LatLngBounds|
        google.maps.LatLngBoundsLiteral,
        ne?: google.maps.LatLng|null|google.maps.LatLngLiteral);
    /**
     * Returns <code>true</code> if the given lat/lng is in this bounds.
     */
    contains(latLng: google.maps.LatLng|google.maps.LatLngLiteral): boolean;
    /**
     * Returns <code>true</code> if this bounds approximately equals the given
     * bounds.
     */
    equals(other: google.maps.LatLngBounds|null|
           google.maps.LatLngBoundsLiteral): boolean;
    /**
     * Extends this bounds to contain the given point.
     */
    extend(point: google.maps.LatLng|
           google.maps.LatLngLiteral): google.maps.LatLngBounds;
    /**
     * Computes the center of this LatLngBounds
     */
    getCenter(): google.maps.LatLng;
    /**
     * Returns the north-east corner of this bounds.
     */
    getNorthEast(): google.maps.LatLng;
    /**
     * Returns the south-west corner of this bounds.
     */
    getSouthWest(): google.maps.LatLng;
    /**
     * Returns <code>true</code> if this bounds shares any points with the other
     * bounds.
     */
    intersects(other: google.maps.LatLngBounds|
               google.maps.LatLngBoundsLiteral): boolean;
    /**
     * Returns if the bounds are empty.
     */
    isEmpty(): boolean;
    /**
     * Converts to JSON representation. This function is intended to be used via
     * <code>JSON.stringify</code>.
     */
    toJSON(): google.maps.LatLngBoundsLiteral;
    /**
     * Converts the given map bounds to a lat/lng span.
     */
    toSpan(): google.maps.LatLng;
    /**
     * Converts to string.
     */
    toString(): string;
    /**
     * Returns a string of the form &quot;lat_lo,lng_lo,lat_hi,lng_hi&quot; for
     * this bounds, where &quot;lo&quot; corresponds to the southwest corner of
     * the bounding box, while &quot;hi&quot; corresponds to the northeast
     * corner of that box.
     */
    toUrlValue(precision?: number): string;
    /**
     * Extends this bounds to contain the union of this and the given bounds.
     */
    union(other: google.maps.LatLngBounds|
          google.maps.LatLngBoundsLiteral): google.maps.LatLngBounds;
    /**
     * LatLngBounds for the max bounds of the Earth. These bounds will encompass
     * the entire globe.
     */
    static readonly MAX_BOUNDS: google.maps.LatLngBounds;
  }
  /**
   * Object literals are accepted in place of <code>LatLngBounds</code> objects
   * throughout the API. These are automatically converted to
   * <code>LatLngBounds</code> objects. All <code>south</code>,
   * <code>west</code>, <code>north</code> and <code>east</code> must be set,
   * otherwise an exception is thrown.
   */
  export interface LatLngBoundsLiteral {
    /**
     * East longitude in degrees. Values outside the range [-180, 180] will be
     * wrapped to the range [-180, 180). For example, a value of -190 will be
     * converted to 170. A value of 190 will be converted to -170. This reflects
     * the fact that longitudes wrap around the globe.
     */
    east: number;
    /**
     * North latitude in degrees. Values will be clamped to the range [-90, 90].
     * This means that if the value specified is less than -90, it will be set
     * to -90. And if the value is greater than 90, it will be set to 90.
     */
    north: number;
    /**
     * South latitude in degrees. Values will be clamped to the range [-90, 90].
     * This means that if the value specified is less than -90, it will be set
     * to -90. And if the value is greater than 90, it will be set to 90.
     */
    south: number;
    /**
     * West longitude in degrees. Values outside the range [-180, 180] will be
     * wrapped to the range [-180, 180). For example, a value of -190 will be
     * converted to 170. A value of 190 will be converted to -170. This reflects
     * the fact that longitudes wrap around the globe.
     */
    west: number;
  }
  /**
   * Object literals are accepted in place of <code>LatLng</code> objects, as a
   * convenience, in many places. These are converted to <code>LatLng</code>
   * objects when the Maps API encounters them. <p> Examples: <pre>
   * map.setCenter({lat: -34, lng: 151});<br> new
   * google.maps.Marker({position: {lat: -34, lng: 151}, map: map}); </pre> <p
   * class="note">LatLng object literals are not supported in the Geometry
   * library.</p>
   */
  export interface LatLngLiteral {
    /**
     * Latitude in degrees. Values will be clamped to the range [-90, 90]. This
     * means that if the value specified is less than -90, it will be set to
     * -90. And if the value is greater than 90, it will be set to 90.
     */
    lat: number;
    /**
     * Longitude in degrees. Values outside the range [-180, 180] will be
     * wrapped so that they fall within the range. For example, a value of -190
     * will be converted to 170. A value of 190 will be converted to -170. This
     * reflects the fact that longitudes wrap around the globe.
     */
    lng: number;
  }
  /**
   * An elevation request sent by the <code>ElevationService</code> containing
   * the list of discrete coordinates (<code>LatLng</code>s) for which to return
   * elevation data.
   */
  export interface LocationElevationRequest {
    /**
     * The discrete locations for which to retrieve elevations.
     */
    locations?: null|(google.maps.LatLng|google.maps.LatLngLiteral)[];
  }
  /**
   * An elevation response returned by the {@link google.maps.ElevationService}
   * containing the list of {@link google.maps.ElevationResult}s matching the
   * locations of the {@link google.maps.LocationElevationRequest}.
   */
  export interface LocationElevationResponse {
    /**
     * The list of {@link google.maps.ElevationResult}s matching the locations
     * of the {@link google.maps.LocationElevationRequest}.
     */
    results: google.maps.ElevationResult[];
  }
  /**
   * Access by calling `const {MVCArray} = await
   * google.maps.importLibrary("core")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class MVCArray<T = any> extends google.maps.MVCObject {
    /**
     * Access by calling `const {MVCArray} = await
     * google.maps.importLibrary("core")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(array?: T[]|null);
    /**
     * Removes all elements from the array.
     */
    clear(): void;
    /**
     * Iterate over each element, calling the provided callback. The callback is
     * called for each element like: callback(element, index).
     */
    forEach(callback: (a: T, b: number) => void): void;
    /**
     * Returns a reference to the underlying Array. Warning: if the Array is
     * mutated, no events will be fired by this object.
     */
    getArray(): T[];
    /**
     * Returns the element at the specified index.
     */
    getAt(i: number): T;
    /**
     * Returns the number of elements in this array.
     */
    getLength(): number;
    /**
     * Inserts an element at the specified index.
     */
    insertAt(i: number, elem: T): void;
    /**
     * Removes the last element of the array and returns that element.
     */
    pop(): T;
    /**
     * Adds one element to the end of the array and returns the new length of
     * the array.
     */
    push(elem: T): number;
    /**
     * Removes an element from the specified index.
     */
    removeAt(i: number): T;
    /**
     * Sets an element at the specified index.
     */
    setAt(i: number, elem: T): void;
  }
  /**
   * Base class implementing KVO. <br><br>The <code>MVCObject</code> constructor
   * is guaranteed to be an empty function, and so you may inherit from
   * <code>MVCObject</code> by writing <code>MySubclass.prototype = new
   * google.maps.MVCObject();</code>. Unless otherwise noted, this is not true
   * of other classes in the API, and inheriting from other classes in the API
   * is not supported.
   *
   * Access by calling `const {MVCObject} = await
   * google.maps.importLibrary("core")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class MVCObject {
    /**
     * Adds the given listener function to the given event name. Returns an
     * identifier for this listener that can be used with
     * <code>google.maps.event.removeListener</code>.
     */
    addListener(eventName: string, handler: Function):
        google.maps.MapsEventListener;
    /**
     * Binds a View to a Model.
     */
    bindTo(
        key: string, target: google.maps.MVCObject, targetKey?: string|null,
        noNotify?: boolean): void;
    /**
     * Gets a value.
     */
    get(key: string): any;
    /**
     * Notify all observers of a change on this property. This notifies both
     * objects that are bound to the object&#39;s property as well as the object
     * that it is bound to.
     */
    notify(key: string): void;
    /**
     * Sets a value.
     */
    set(key: string, value: any): void;
    /**
     * Sets a collection of key-value pairs.
     */
    setValues(values?: object|null): void;
    /**
     * Removes a binding. Unbinding will set the unbound property to the current
     * value. The object will not be notified, as the value has not changed.
     */
    unbind(key: string): void;
    /**
     * Removes all bindings.
     */
    unbindAll(): void;
  }
  /**
   * Access by calling `const {Map} = await google.maps.importLibrary("maps")`.
   * See https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Map extends google.maps.MVCObject {
    /**
     * Access by calling `const {Map} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     * @param mapDiv The map will render to fill this element.
     * @param opts Options
     */
    constructor(mapDiv: HTMLElement, opts?: google.maps.MapOptions);
    /**
     * Additional controls to attach to the map. To add a control to the map,
     * add the control&#39;s <code>&lt;div&gt;</code> to the
     * <code>MVCArray</code> corresponding to the <code>ControlPosition</code>
     * where it should be rendered.
     */
    controls: google.maps.MVCArray<HTMLElement>[];
    /**
     * An instance of <code>Data</code>, bound to the map. Add features to this
     * <code>Data</code> object to conveniently display them on this map.
     */
    data: google.maps.Data;
    /**
     * Sets the viewport to contain the given bounds.</br>
     * <strong>Note:</strong> When the map is set to <code>display: none</code>,
     * the <code>fitBounds</code> function reads the map&#39;s size as 0x0, and
     * therefore does not do anything. To change the viewport while the map is
     * hidden, set the map to <code>visibility: hidden</code>, thereby ensuring
     * the map div has an actual size. For vector maps, this method sets the
     * map&#39;s tilt and heading to their default zero values. Calling this
     * method may cause a smooth animation as the map pans and zooms to fit the
     * bounds. Whether or not this method animates depends on an internal
     * heuristic.
     * @param bounds Bounds to show.
     * @param padding Padding in pixels. The bounds will be fit in the part of
     *     the map that remains after padding is removed. A number value will
     *     yield the same padding on all 4 sides. Supply 0 here to make a
     *     fitBounds idempotent on the result of getBounds.
     */
    fitBounds(
        bounds: google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral,
        padding?: number|google.maps.Padding): void;
    /**
     * Returns the lat/lng bounds of the current viewport. If more than one copy
     * of the world is visible, the bounds range in longitude from -180 to 180
     * degrees inclusive. If the map is not yet initialized or center and zoom
     * have not been set then the result is <code>undefined</code>. For vector
     * maps with non-zero tilt or heading, the returned lat/lng bounds
     * represents the smallest bounding box that includes the visible region of
     * the map&#39;s viewport. See {@link
     * google.maps.MapCanvasProjection.getVisibleRegion} for getting the exact
     * visible region of the map&#39;s viewport.
     */
    getBounds(): google.maps.LatLngBounds|undefined;
    /**
     * Returns the position displayed at the center of the map. Note that
     * this {@link google.maps.LatLng} object is <em>not</em> wrapped. See
     * <code><a href="#LatLng">LatLng</a></code> for more information. If the
     * center or bounds have not been set then the result is
     * <code>undefined</code>.
     */
    getCenter(): google.maps.LatLng|undefined;
    /**
     * Returns the clickability of the map icons. A map icon represents a point
     * of interest, also known as a POI. If the returned value is
     * <code>true</code>, then the icons are clickable on the map.
     */
    getClickableIcons(): boolean|undefined;
    /**
     * Available only in the v=beta channel: https://goo.gle/3oAthT3.
     * Returns the <code>FeatureLayer</code> for the specified
     * <code>datasetId</code>. Dataset IDs must be configured in the Google
     * Cloud Console. If the dataset ID is not associated with the map&#39;s map
     * style, or if Data-driven styling is not available (no map ID, no vector
     * tiles, no Data-Driven Styling feature layers or Datasets configured in
     * the Map Style), this logs an error, and the resulting
     * <code>FeatureLayer.isAvailable</code> will be false.
     */
    getDatasetFeatureLayer(datasetId: string): google.maps.FeatureLayer;
    getDiv(): HTMLElement;
    /**
     * Returns the <code>FeatureLayer</code> of the specific
     * <code>FeatureType</code>. A <code>FeatureLayer</code> must be enabled in
     * the Google Cloud Console. If a <code>FeatureLayer</code> of the specified
     * <code>FeatureType</code> does not exist on this map, or if Data-driven
     * styling is not available (no map ID, no vector tiles, and no
     * <code>FeatureLayer</code> enabled in the map style), this logs an error,
     * and the resulting <code>FeatureLayer.isAvailable</code> will be false.
     */
    getFeatureLayer(featureType: google.maps.FeatureType):
        google.maps.FeatureLayer;
    /**
     * Returns the compass heading of the map. The heading value is measured in
     * degrees (clockwise) from cardinal direction North. If the map is not yet
     * initialized then the result is <code>undefined</code>.
     */
    getHeading(): number|undefined;
    /**
     * Informs the caller of the current capabilities available to the map based
     * on the Map ID that was provided.
     */
    getMapCapabilities(): google.maps.MapCapabilities;
    getMapTypeId(): string|undefined;
    /**
     * Returns the current <code>Projection</code>. If the map is not yet
     * initialized then the result is <code>undefined</code>. Listen to the
     * <code>projection_changed</code> event and check its value to ensure it is
     * not <code>undefined</code>.
     */
    getProjection(): google.maps.Projection|undefined;
    /**
     * Returns the current RenderingType of the map.
     */
    getRenderingType(): google.maps.RenderingType;
    /**
     * Returns the default <code>StreetViewPanorama</code> bound to the map,
     * which may be a default panorama embedded within the map, or the panorama
     * set using <code>setStreetView()</code>. Changes to the map&#39;s
     * <code>streetViewControl</code> will be reflected in the display of such a
     * bound panorama.
     */
    getStreetView(): google.maps.StreetViewPanorama;
    /**
     * Returns the current angle of incidence of the map, in degrees from the
     * viewport plane to the map plane. For raster maps, the result will be
     * <code>0</code> for imagery taken directly overhead or <code>45</code> for
     * 45&deg; imagery. This method does not return the value set by
     * <code>setTilt</code>. See <code>setTilt</code> for details.
     */
    getTilt(): number|undefined;
    /**
     * Returns the zoom of the map. If the zoom has not been set then the result
     * is <code>undefined</code>.
     */
    getZoom(): number|undefined;
    /**
     * A registry of <code>MapType</code> instances by string ID.
     */
    mapTypes: google.maps.MapTypeRegistry;
    /**
     * Immediately sets the map&#39;s camera to the target camera options,
     * without animation.
     */
    moveCamera(cameraOptions: google.maps.CameraOptions): void;
    /**
     * Additional map types to overlay. Overlay map types will display on top of
     * the base map they are attached to, in the order in which they appear in
     * the <code>overlayMapTypes</code> array (overlays with higher index values
     * are displayed in front of overlays with lower index values).
     */
    overlayMapTypes: google.maps.MVCArray<google.maps.MapType|null>;
    /**
     * Changes the center of the map by the given distance in pixels. If the
     * distance is less than both the width and height of the map, the
     * transition will be smoothly animated. Note that the map coordinate system
     * increases from west to east (for x values) and north to south (for y
     * values).
     * @param x Number of pixels to move the map in the x direction.
     * @param y Number of pixels to move the map in the y direction.
     */
    panBy(x: number, y: number): void;
    /**
     * Changes the center of the map to the given <code>LatLng</code>. If the
     * change is less than both the width and height of the map, the transition
     * will be smoothly animated.
     * @param latLng The new center latitude/longitude of the map.
     */
    panTo(latLng: google.maps.LatLng|google.maps.LatLngLiteral): void;
    /**
     * Pans the map by the minimum amount necessary to contain the given
     * <code>LatLngBounds</code>. It makes no guarantee where on the map the
     * bounds will be, except that the map will be panned to show as much of the
     * bounds as possible inside <code>{currentMapSizeInPx} - {padding}</code>.
     * For both raster and vector maps, the map&#39;s zoom, tilt, and heading
     * will not be changed.
     * @param latLngBounds The bounds to pan the map to.
     * @param padding Padding in pixels. A number value will yield the same
     *     padding on all 4 sides. The default value is 0.
     */
    panToBounds(
        latLngBounds: google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral,
        padding?: number|google.maps.Padding): void;
    setCenter(latlng: google.maps.LatLng|google.maps.LatLngLiteral): void;
    /**
     * Controls whether the map icons are clickable or not. A map icon
     * represents a point of interest, also known as a POI. To disable the
     * clickability of map icons, pass a value of <code>false</code> to this
     * method.
     */
    setClickableIcons(value: boolean): void;
    /**
     * Sets the compass heading for map measured in degrees from cardinal
     * direction North. For raster maps, this method only applies to aerial
     * imagery.
     */
    setHeading(heading: number): void;
    setMapTypeId(mapTypeId: string): void;
    setOptions(options: google.maps.MapOptions|null): void;
    /**
     * Binds a <code>StreetViewPanorama</code> to the map. This panorama
     * overrides the default <code>StreetViewPanorama</code>, allowing the map
     * to bind to an external panorama outside of the map. Setting the panorama
     * to <code>null</code> binds the default embedded panorama back to the map.
     * @param panorama The panorama to bind to the map.
     */
    setStreetView(panorama: google.maps.StreetViewPanorama|null): void;
    /**
     * For vector maps, sets the angle of incidence of the map. The allowed
     * values are restricted depending on the zoom level of the map. For raster
     * maps, controls the automatic switching behavior for the angle of
     * incidence of the map. The only allowed values are <code>0</code> and
     * <code>45</code>. <code>setTilt(0)</code> causes the map to always use a
     * 0&deg; overhead view regardless of the zoom level and viewport.
     * <code>setTilt(45)</code> causes the tilt angle to automatically switch to
     * 45 whenever 45&deg; imagery is available for the current zoom level and
     * viewport, and switch back to 0 whenever 45&deg; imagery is not available
     * (this is the default behavior). 45&deg; imagery is only available for
     * <code>satellite</code> and <code>hybrid</code> map types, within some
     * locations, and at some zoom levels. <b>Note:</b> <code>getTilt</code>
     * returns the current tilt angle, not the value set by
     * <code>setTilt</code>. Because <code>getTilt</code> and
     * <code>setTilt</code> refer to different things, do not
     * <code>bind()</code> the <code>tilt</code> property; doing so may yield
     * unpredictable effects.
     */
    setTilt(tilt: number): void;
    /**
     * Sets the zoom of the map.
     * @param zoom Larger zoom values correspond to a higher resolution.
     */
    setZoom(zoom: number): void;
    /**
     * Map ID which can be used for code samples which require a Map ID. This
     * Map ID is not intended for use in production applications and cannot be
     * used for features which require cloud configuration (such as Cloud
     * Styling).
     */
    static readonly DEMO_MAP_ID: string;
  }
  /**
   * This object is made available to the <code>OverlayView</code> from within
   * the draw method. It is not guaranteed to be initialized until draw is
   * called.
   */
  export interface MapCanvasProjection {
    /**
     * Computes the geographical coordinates from pixel coordinates in the
     * map&#39;s container.
     */
    fromContainerPixelToLatLng(
        pixel: google.maps.Point|null,
        noClampNoWrap?: boolean): google.maps.LatLng|null;
    /**
     * Computes the geographical coordinates from pixel coordinates in the div
     * that holds the draggable map.
     */
    fromDivPixelToLatLng(
        pixel: google.maps.Point|null,
        noClampNoWrap?: boolean): google.maps.LatLng|null;
    /**
     * Computes the pixel coordinates of the given geographical location in the
     * map&#39;s container element.
     */
    fromLatLngToContainerPixel(latLng: google.maps.LatLng|
                               google.maps.LatLngLiteral): google.maps.Point
        |null;
    /**
     * Computes the pixel coordinates of the given geographical location in the
     * DOM element that holds the draggable map.
     */
    fromLatLngToDivPixel(latLng: google.maps.LatLng|null|
                         google.maps.LatLngLiteral): google.maps.Point|null;
    /**
     * The visible region of the map. Returns <code>null</code> if the map has
     * no size. Returns <code>null</code> if the OverlayView is on a
     * StreetViewPanorama.
     */
    getVisibleRegion(): google.maps.VisibleRegion|null;
    /**
     * The width of the world in pixels in the current zoom level. For
     * projections with a heading angle of either 90 or 270 degrees, this
     * corresponds to the pixel span in the Y-axis.
     */
    getWorldWidth(): number;
  }
  /**
   * Object containing a snapshot of what capabilities are currently available
   * for the Map. See the properties for a list of possible capabilities.
   */
  export interface MapCapabilities {
    isAdvancedMarkersAvailable?: boolean;
    isDataDrivenStylingAvailable?: boolean;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * MapElement is an <code>HTMLElement</code> subclass for rendering maps.
   * After loading the <code>maps</code> library, a map can be created in HTML.
   * For example:<br> <code>&lt;gmp-map
   * center=&quot;37.4220656,-122.0840897&quot; zoom=&quot;10&quot;
   * map-id=&quot;DEMO_MAP_ID&quot;&gt;&lt;/gmp-map&gt;</code><br> <br>
   * Internally, it uses {@link google.maps.Map}, which can be accessed with the
   * <code>innerMap</code> property.
   *
   * Access by calling `const {MapElement} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class MapElement extends HTMLElement implements
      google.maps.MapElementOptions {
    /**
     * Available only in the v=beta channel: https://goo.gle/3oAthT3.
     *
     * MapElement is an <code>HTMLElement</code> subclass for rendering maps.
     * After loading the <code>maps</code> library, a map can be created in
     * HTML. For example:<br> <code>&lt;gmp-map
     * center=&quot;37.4220656,-122.0840897&quot; zoom=&quot;10&quot;
     * map-id=&quot;DEMO_MAP_ID&quot;&gt;&lt;/gmp-map&gt;</code><br> <br>
     * Internally, it uses {@link google.maps.Map}, which can be accessed with
     * the <code>innerMap</code> property.
     *
     * Access by calling `const {MapElement} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor();
    center: null|google.maps.LatLng|google.maps.LatLngLiteral;
    /**
     * A reference to the {@link google.maps.Map} that the MapElement uses
     * internally.
     */
    innerMap: google.maps.Map;
    mapId: null|string;
    zoom: null|number;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * MapElementOptions object used to define the properties that can be set on a
   * MapElement.
   */
  export interface MapElementOptions {
    /**
     * The initial Map center.
     */
    center?: null|google.maps.LatLng|google.maps.LatLngLiteral;
    /**
     * The <a
     * href="https://developers.google.com/maps/documentation/get-map-id">Map
     * ID</a> of the map. This parameter cannot be set or changed after a map is
     * instantiated.
     */
    mapId?: null|string;
    /**
     * The initial Map zoom level. Valid zoom values are numbers from zero up to
     * the supported <a
     * href="https://developers.google.com/maps/documentation/javascript/maxzoom">maximum
     * zoom level</a>. Larger zoom values correspond to a higher resolution.
     */
    zoom?: null|number;
  }
  /**
   * This object is returned from various mouse events on the map and overlays,
   * and contains all the fields shown below.
   */
  export interface MapMouseEvent {
    /**
     * The corresponding native DOM event. Developers should not rely on
     * <code>target</code>, <code>currentTarget</code>,
     * <code>relatedTarget</code> and <code>path</code> properties being defined
     * and consistent. Developers should not also rely on the DOM structure of
     * the internal implementation of the Maps API. Due to internal event
     * mapping, the <code>domEvent</code> may have different semantics from
     * the {@link google.maps.MapMouseEvent} (e.g. a {@link
     * google.maps.MapMouseEvent} &quot;click&quot; may have a
     * <code>domEvent</code> of type <code>KeyboardEvent</code>).
     */
    domEvent: MouseEvent|TouchEvent|PointerEvent|KeyboardEvent|Event;
    /**
     * The latitude/longitude that was below the cursor when the event occurred.
     */
    latLng: null|google.maps.LatLng;
    /**
     * Prevents this event from propagating further.
     */
    stop(): void;
  }
  /**
   * MapOptions object used to define the properties that can be set on a Map.
   */
  export interface MapOptions {
    /**
     * Color used for the background of the Map div. This color will be visible
     * when tiles have not yet loaded as the user pans. This option can only be
     * set when the map is initialized.
     */
    backgroundColor?: string|null;
    /**
     * The initial Map center.
     */
    center?: google.maps.LatLng|null|google.maps.LatLngLiteral;
    /**
     * When <code>false</code>, map icons are not clickable. A map icon
     * represents a point of interest, also known as a POI.
     * @defaultValue <code>true</code>
     */
    clickableIcons?: boolean|null;
    /**
     * Size in pixels of the controls appearing on the map. This value must be
     * supplied directly when creating the Map, updating this value later may
     * bring the controls into an <code>undefined</code> state. Only governs the
     * controls made by the Maps API itself. Does not scale developer created
     * custom controls.
     */
    controlSize?: number|null;
    /**
     * Enables/disables all default UI buttons. May be overridden individually.
     * Does not disable the keyboard controls, which are separately controlled
     * by the {@link google.maps.MapOptions.keyboardShortcuts} option. Does not
     * disable gesture controls, which are separately controlled by the {@link
     * google.maps.MapOptions.gestureHandling} option.
     */
    disableDefaultUI?: boolean|null;
    /**
     * Enables/disables zoom and center on double click. Enabled by default.
     * <p><strong>Note</strong>: This property is <strong>not
     * recommended</strong>. To disable zooming on double click, you can use the
     * <code>gestureHandling</code> property, and set it to <code>"none"</code>.
     */
    disableDoubleClickZoom?: boolean|null;
    /**
     * If <code>false</code>, prevents the map from being dragged. Dragging is
     * enabled by default.
     * @deprecated Deprecated in 2017. To disable dragging on the map, you can
     *     use the <code>gestureHandling</code> property, and set it to
     *     <code>"none"</code>.
     */
    draggable?: boolean|null;
    /**
     * The name or url of the cursor to display when mousing over a draggable
     * map. This property uses the css <code>cursor</code> attribute to change
     * the icon. As with the css property, you must specify at least one
     * fallback cursor that is not a URL. For example: <code>draggableCursor:
     * 'url(<a
     * href="http://www.example.com/icon.png">http://www.example.com/icon.png</a>),
     * auto;'</code>.
     */
    draggableCursor?: string|null;
    /**
     * The name or url of the cursor to display when the map is being dragged.
     * This property uses the css <code>cursor</code> attribute to change the
     * icon. As with the css property, you must specify at least one fallback
     * cursor that is not a URL. For example: <code>draggingCursor: 'url(<a
     * href="http://www.example.com/icon.png">http://www.example.com/icon.png</a>),
     * auto;'</code>.
     */
    draggingCursor?: string|null;
    /**
     * The enabled/disabled state of the Fullscreen control.
     */
    fullscreenControl?: boolean|null;
    /**
     * The display options for the Fullscreen control.
     */
    fullscreenControlOptions?: google.maps.FullscreenControlOptions|null;
    /**
     * This setting controls how the API handles gestures on the map. Allowed
     * values: <ul> <li> <code>"cooperative"</code>: Scroll events and
     * one-finger touch gestures scroll the page, and do not zoom or pan the
     * map. Two-finger touch gestures pan and zoom the map. Scroll events with a
     * ctrl key or ⌘ key pressed zoom the map.<br> In this mode the map
     * <em>cooperates</em> with the page. <li> <code>"greedy"</code>: All touch
     * gestures and scroll events pan or zoom the map. <li> <code>"none"</code>:
     * The map cannot be panned or zoomed by user gestures. <li>
     * <code>"auto"</code>: (default) Gesture handling is either cooperative or
     * greedy, depending on whether the page is scrollable or in an iframe.
     * </ul>
     */
    gestureHandling?: string|null;
    /**
     * The heading for aerial imagery in degrees measured clockwise from
     * cardinal direction North. Headings are snapped to the nearest available
     * angle for which imagery is available.
     */
    heading?: number|null;
    /**
     * Whether the map should allow fractional zoom levels. Listen to
     * <code>isfractionalzoomenabled_changed</code> to know when the default has
     * been set.
     * @defaultValue <code>true</code> for vector maps and <code>false</code>
     * for raster maps
     */
    isFractionalZoomEnabled?: boolean|null;
    /**
     * If <code>false</code>, prevents the map from being controlled by the
     * keyboard. Keyboard shortcuts are enabled by default.
     */
    keyboardShortcuts?: boolean|null;
    /**
     * The <a
     * href="https://developers.google.com/maps/documentation/get-map-id">Map
     * ID</a> of the map. This parameter cannot be set or changed after a map is
     * instantiated.
     */
    mapId?: string|null;
    /**
     * The initial enabled/disabled state of the Map type control.
     */
    mapTypeControl?: boolean|null;
    /**
     * The initial display options for the Map type control.
     */
    mapTypeControlOptions?: google.maps.MapTypeControlOptions|null;
    /**
     * The initial Map mapTypeId. Defaults to <code>ROADMAP</code>.
     */
    mapTypeId?: null|string;
    /**
     * The maximum zoom level which will be displayed on the map. If omitted, or
     * set to <code>null</code>, the maximum zoom from the current map type is
     * used instead. Valid zoom values are numbers from zero up to the supported
     * <a
     * href="https://developers.google.com/maps/documentation/javascript/maxzoom">maximum
     * zoom level</a>.
     */
    maxZoom?: number|null;
    /**
     * The minimum zoom level which will be displayed on the map. If omitted, or
     * set to <code>null</code>, the minimum zoom from the current map type is
     * used instead. Valid zoom values are numbers from zero up to the supported
     * <a
     * href="https://developers.google.com/maps/documentation/javascript/maxzoom">maximum
     * zoom level</a>.
     */
    minZoom?: number|null;
    /**
     * If <code>true</code>, do not clear the contents of the Map div.
     */
    noClear?: boolean|null;
    /**
     * The enabled/disabled state of the Pan control. <p> Note: The Pan control
     * is not available in the new set of controls introduced in v3.22 of the
     * Google Maps JavaScript API. While using v3.22 and v3.23, you can choose
     * to use the earlier set of controls rather than the new controls, thus
     * making the Pan control available as part of the old control set. See <a
     * href="https://developers.google.com/maps/articles/v322-controls-diff">What&#39;s
     * New in the v3.22 Map Controls</a>.
     */
    panControl?: boolean|null;
    /**
     * The display options for the Pan control. <p> Note: The Pan control is not
     * available in the new set of controls introduced in v3.22 of the Google
     * Maps JavaScript API. While using v3.22 and v3.23, you can choose to use
     * the earlier set of controls rather than the new controls, thus making the
     * Pan control available as part of the old control set. See <a
     * href="https://developers.google.com/maps/articles/v322-controls-diff">What&#39;s
     * New in the v3.22 Map Controls</a>.
     */
    panControlOptions?: google.maps.PanControlOptions|null;
    /**
     * Defines a boundary that restricts the area of the map accessible to
     * users. When set, a user can only pan and zoom while the camera view stays
     * inside the limits of the boundary.
     */
    restriction?: google.maps.MapRestriction|null;
    /**
     * The enabled/disabled state of the Rotate control.
     */
    rotateControl?: boolean|null;
    /**
     * The display options for the Rotate control.
     */
    rotateControlOptions?: google.maps.RotateControlOptions|null;
    /**
     * The initial enabled/disabled state of the Scale control.
     */
    scaleControl?: boolean|null;
    /**
     * The initial display options for the Scale control.
     */
    scaleControlOptions?: google.maps.ScaleControlOptions|null;
    /**
     * If <code>false</code>, disables zooming on the map using a mouse scroll
     * wheel. The scrollwheel is enabled by default. <p><strong>Note</strong>:
     * This property is <strong>not recommended</strong>. To disable zooming
     * using scrollwheel, you can use the <code>gestureHandling</code> property,
     * and set it to either <code>"cooperative"</code> or <code>"none"</code>.
     */
    scrollwheel?: boolean|null;
    /**
     * A <code>StreetViewPanorama</code> to display when the Street View pegman
     * is dropped on the map. If no panorama is specified, a default
     * <code>StreetViewPanorama</code> will be displayed in the map&#39;s
     * <code>div</code> when the pegman is dropped.
     */
    streetView?: google.maps.StreetViewPanorama|null;
    /**
     * The initial enabled/disabled state of the Street View Pegman control.
     * This control is part of the default UI, and should be set to
     * <code>false</code> when displaying a map type on which the Street View
     * road overlay should not appear (e.g. a non-Earth map type).
     */
    streetViewControl?: boolean|null;
    /**
     * The initial display options for the Street View Pegman control.
     */
    streetViewControlOptions?: google.maps.StreetViewControlOptions|null;
    /**
     * Styles to apply to each of the default map types. Note that for
     * <code>satellite</code>/<code>hybrid</code> and <code>terrain</code>
     * modes, these styles will only apply to labels and geometry.
     */
    styles?: google.maps.MapTypeStyle[]|null;
    /**
     * For vector maps, sets the angle of incidence of the map. The allowed
     * values are restricted depending on the zoom level of the map. For raster
     * maps, controls the automatic switching behavior for the angle of
     * incidence of the map. The only allowed values are <code>0</code> and
     * <code>45</code>. The value <code>0</code> causes the map to always use a
     * 0&deg; overhead view regardless of the zoom level and viewport. The value
     * <code>45</code> causes the tilt angle to automatically switch to 45
     * whenever 45&deg; imagery is available for the current zoom level and
     * viewport, and switch back to 0 whenever 45&deg; imagery is not available
     * (this is the default behavior). 45&deg; imagery is only available for
     * <code>satellite</code> and <code>hybrid</code> map types, within some
     * locations, and at some zoom levels. <b>Note:</b> <code>getTilt</code>
     * returns the current tilt angle, not the value specified by this option.
     * Because <code>getTilt</code> and this option refer to different things,
     * do not <code>bind()</code> the <code>tilt</code> property; doing so may
     * yield unpredictable effects.
     */
    tilt?: number|null;
    /**
     * The initial Map zoom level. Valid zoom values are numbers from zero up to
     * the supported <a
     * href="https://developers.google.com/maps/documentation/javascript/maxzoom">maximum
     * zoom level</a>. Larger zoom values correspond to a higher resolution.
     */
    zoom?: number|null;
    /**
     * The enabled/disabled state of the Zoom control.
     */
    zoomControl?: boolean|null;
    /**
     * The display options for the Zoom control.
     */
    zoomControlOptions?: google.maps.ZoomControlOptions|null;
  }
  export interface MapPanes {
    /**
     * This pane contains the info window. It is above all map overlays. (Pane
     * 4).
     */
    floatPane: Element;
    /**
     * This pane is the lowest pane and is above the tiles. It does not receive
     * DOM events. (Pane 0).
     */
    mapPane: Element;
    /**
     * This pane contains markers. It does not receive DOM events. (Pane 2).
     */
    markerLayer: Element;
    /**
     * This pane contains polylines, polygons, ground overlays and tile layer
     * overlays. It does not receive DOM events. (Pane 1).
     */
    overlayLayer: Element;
    /**
     * This pane contains elements that receive DOM events. (Pane 3).
     */
    overlayMouseTarget: Element;
  }
  /**
   * A restriction that can be applied to the Map. The map&#39;s viewport will
   * not exceed these restrictions.
   */
  export interface MapRestriction {
    /**
     * When set, a user can only pan and zoom inside the given bounds. Bounds
     * can restrict both longitude and latitude, or can restrict latitude only.
     * For latitude-only bounds use west and east longitudes of -180 and 180,
     * respectively, for example, <code>latLngBounds: {north: northLat, south:
     * southLat, west: -180, east: 180}</code>.
     */
    latLngBounds: google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral;
    /**
     * Bounds can be made more restrictive by setting the
     * <code>strictBounds</code> flag to <code>true</code>. This reduces how far
     * a user can zoom out, ensuring that everything outside of the restricted
     * bounds stays hidden. The default is <code>false</code>, meaning that a
     * user can zoom out until the entire bounded area is in view, possibly
     * including areas outside the bounded area.
     */
    strictBounds?: boolean;
  }
  /**
   * This interface defines the map type, and is typically used for custom map
   * types. Immutable.
   */
  export interface MapType {
    /**
     * Alt text to display when this MapType&#39;s button is hovered over in the
     * MapTypeControl. Optional.
     */
    alt: string|null;
    /**
     * Returns a tile for the given tile coordinate (x, y) and zoom level. This
     * tile will be appended to the given ownerDocument. Not available for base
     * map types.
     * @param tileCoord Tile coordinates.
     * @param zoom Tile zoom.
     * @param ownerDocument The document which owns this tile.
     */
    getTile(
        tileCoord: google.maps.Point|null, zoom: number,
        ownerDocument: Document|null): Element|null;
    /**
     * The maximum zoom level for the map when displaying this MapType. Required
     * for base MapTypes, ignored for overlay MapTypes.
     */
    maxZoom: number;
    /**
     * The minimum zoom level for the map when displaying this MapType.
     * Optional; defaults to 0.
     */
    minZoom: number;
    /**
     * Name to display in the MapTypeControl. Optional.
     */
    name: string|null;
    /**
     * The Projection used to render this MapType. Optional; defaults to
     * Mercator.
     */
    projection: google.maps.Projection|null;
    /**
     * Radius of the planet for the map, in meters. Optional; defaults to
     * Earth&#39;s equatorial radius of 6378137 meters.
     */
    radius: number;
    /**
     * Releases the given tile, performing any necessary cleanup. The provided
     * tile will have already been removed from the document. Optional.
     * @param tile Tile to release.
     */
    releaseTile(tile: Element|null): void;
    /**
     * The dimensions of each tile. Required.
     */
    tileSize: google.maps.Size|null;
  }
  /**
   * Options for the rendering of the map type control.
   */
  export interface MapTypeControlOptions {
    /**
     * IDs of map types to show in the control.
     */
    mapTypeIds?: (string)[]|null;
    /**
     * Position id. Used to specify the position of the control on the map.
     * @defaultValue {@link google.maps.ControlPosition.TOP_RIGHT}
     */
    position?: google.maps.ControlPosition|null;
    /**
     * Style id. Used to select what style of map type control to display.
     */
    style?: google.maps.MapTypeControlStyle|null;
  }
  /**
   * Identifiers for common MapTypesControls.
   *
   * Access by calling `const {MapTypeControlStyle} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum MapTypeControlStyle {
    /**
     * Uses the default map type control. When the <code>DEFAULT</code> control
     * is shown, it will vary according to window size and other factors. The
     * <code>DEFAULT</code> control may change in future versions of the API.
     */
    DEFAULT = 0.0,
    /**
     * A dropdown menu for the screen realestate conscious.
     */
    DROPDOWN_MENU = 1.0,
    /**
     * The standard horizontal radio buttons bar.
     */
    HORIZONTAL_BAR = 2.0,
  }
  /**
   * Identifiers for common MapTypes. Specify these by value, or by using the
   * constant&#39;s name. For example, <code>'satellite'</code> or
   * <code>google.maps.MapTypeId.SATELLITE</code>.
   *
   * Access by calling `const {MapTypeId} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum MapTypeId {
    /**
     * This map type displays a transparent layer of major streets on satellite
     * images.
     */
    HYBRID = 'hybrid',
    /**
     * This map type displays a normal street map.
     */
    ROADMAP = 'roadmap',
    /**
     * This map type displays satellite images.
     */
    SATELLITE = 'satellite',
    /**
     * This map type displays maps with physical features such as terrain and
     * vegetation.
     */
    TERRAIN = 'terrain',
  }
  /**
   * A registry for MapType instances, keyed by MapType id.
   *
   * Access by calling `const {MapTypeRegistry} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class MapTypeRegistry extends google.maps.MVCObject {
    /**
     * Sets the registry to associate the passed string identifier with the
     * passed MapType.
     * @param id Identifier of the MapType to add to the registry.
     * @param mapType MapType object to add to the registry.
     */
    set(id: string, mapType: any): void;
  }
  /**
   * The <code>MapTypeStyle</code> is a collection of selectors and stylers that
   * define how the map should be styled. Selectors specify the map features
   * and/or elements that should be affected, and stylers specify how those
   * features and elements should be modified. For details, see the <a
   * href="https://developers.google.com/maps/documentation/javascript/style-reference">style
   * reference</a>.
   */
  export interface MapTypeStyle {
    /**
     * The element to which a styler should be applied. An element is a visual
     * aspect of a feature on the map. Example: a label, an icon, the stroke or
     * fill applied to the geometry, and more. Optional. If
     * <code>elementType</code> is not specified, the value is assumed to be
     * <code>'all'</code>. For details of usage and allowed values, see the <a
     * href="https://developers.google.com/maps/documentation/javascript/style-reference#style-elements">style
     * reference</a>.
     */
    elementType?: string|null;
    /**
     * The feature, or group of features, to which a styler should be applied.
     * Optional. If <code>featureType</code> is not specified, the value is
     * assumed to be <code>'all'</code>. For details of usage and allowed
     * values, see the <a
     * href="https://developers.google.com/maps/documentation/javascript/style-reference#style-features">style
     * reference</a>.
     */
    featureType?: string|null;
    /**
     * The style rules to apply to the selected map features and elements. The
     * rules are applied in the order that you specify in this array. For
     * guidelines on usage and allowed values, see the <a
     * href="https://developers.google.com/maps/documentation/javascript/style-reference#stylers">style
     * reference</a>.
     */
    stylers: object[];
  }
  /**
   * An event listener, created by <code><a
   * href="#event">google.maps.event.addListener</a>()</code> and friends.
   */
  export interface MapsEventListener {
    /**
     * Removes the listener. <p>Calling <code>listener.remove()</code> is
     * equivalent to <code>google.maps.event.removeListener(listener)</code>.
     */
    remove(): void;
  }
  export interface MapsLibrary {
    BicyclingLayer: typeof google.maps.BicyclingLayer;
    Circle: typeof google.maps.Circle;
    Data: typeof google.maps.Data;
    FeatureType: typeof google.maps.FeatureType;
    GroundOverlay: typeof google.maps.GroundOverlay;
    ImageMapType: typeof google.maps.ImageMapType;
    InfoWindow: typeof google.maps.InfoWindow;
    KmlLayer: typeof google.maps.KmlLayer;
    KmlLayerStatus: typeof google.maps.KmlLayerStatus;
    Map: typeof google.maps.Map;
    MapTypeControlStyle: typeof google.maps.MapTypeControlStyle;
    MapTypeId: typeof google.maps.MapTypeId;
    MapTypeRegistry: typeof google.maps.MapTypeRegistry;
    MaxZoomService: typeof google.maps.MaxZoomService;
    MaxZoomStatus: typeof google.maps.MaxZoomStatus;
    OverlayView: typeof google.maps.OverlayView;
    Polygon: typeof google.maps.Polygon;
    Polyline: typeof google.maps.Polyline;
    Rectangle: typeof google.maps.Rectangle;
    RenderingType: typeof google.maps.RenderingType;
    StrokePosition: typeof google.maps.StrokePosition;
    StyledMapType: typeof google.maps.StyledMapType;
    TrafficLayer: typeof google.maps.TrafficLayer;
    TransitLayer: typeof google.maps.TransitLayer;
    WebGLOverlayView: typeof google.maps.WebGLOverlayView;
  }
  /**
   * Base class for managing network errors in Maps.
   *
   * Access by calling `const {MapsNetworkError} = await
   * google.maps.importLibrary("core")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class MapsNetworkError extends Error {
    /**
     * Base class for managing network errors in Maps.
     *
     * Access by calling `const {MapsNetworkError} = await
     * google.maps.importLibrary("core")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor();
    /**
     * Identifies the type of error produced by the API.
     */
    code: google.maps.DirectionsStatus|google.maps.DistanceMatrixStatus|
        google.maps.ElevationStatus|google.maps.GeocoderStatus|
        google.maps.MaxZoomStatus|google.maps.places.PlacesServiceStatus|
        google.maps.StreetViewStatus;
    /**
     * Represents the network service that responded with the error.
     */
    endpoint: google.maps.MapsNetworkErrorEndpoint;
  }
  /**
   * Identifiers for API endpoints used by {@link google.maps.MapsNetworkError}
   * instances.
   *
   * Access by calling `const {MapsNetworkErrorEndpoint} = await
   * google.maps.importLibrary("core")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum MapsNetworkErrorEndpoint {
    /**
     * Identifies the Routes API within the Directions API.
     */
    DIRECTIONS_ROUTE = 'DIRECTIONS_ROUTE',
    /**
     * Identifies the DistanceMatrix API.
     */
    DISTANCE_MATRIX = 'DISTANCE_MATRIX',
    /**
     * Identifies the getElevationsAlongPath API within the Elevation API.
     */
    ELEVATION_ALONG_PATH = 'ELEVATION_ALONG_PATH',
    /**
     * Identifies the getElevationForLocations API within the Elevation API.
     */
    ELEVATION_LOCATIONS = 'ELEVATION_LOCATIONS',
    /**
     * Identifies the Get DeliveryVehicle API within Fleet Engine.
     */
    FLEET_ENGINE_GET_DELIVERY_VEHICLE = 'FLEET_ENGINE_GET_DELIVERY_VEHICLE',
    /**
     * Identifies the Get Trip API within Fleet Engine.
     */
    FLEET_ENGINE_GET_TRIP = 'FLEET_ENGINE_GET_TRIP',
    /**
     * Identifies the Get Vehicle API within Fleet Engine.
     */
    FLEET_ENGINE_GET_VEHICLE = 'FLEET_ENGINE_GET_VEHICLE',
    /**
     * Identifies the List DeliveryVehicles API within Fleet Engine.
     */
    FLEET_ENGINE_LIST_DELIVERY_VEHICLES = 'FLEET_ENGINE_LIST_DELIVERY_VEHICLES',
    /**
     * Identifies the List Tasks API within Fleet Engine.
     */
    FLEET_ENGINE_LIST_TASKS = 'FLEET_ENGINE_LIST_TASKS',
    /**
     * Identifies the List Vehicles API within Fleet Engine.
     */
    FLEET_ENGINE_LIST_VEHICLES = 'FLEET_ENGINE_LIST_VEHICLES',
    /**
     * Identifies the Search Tasks API within Fleet Engine.
     */
    FLEET_ENGINE_SEARCH_TASKS = 'FLEET_ENGINE_SEARCH_TASKS',
    /**
     * Identifies the geocode API within the Geocoder.
     */
    GEOCODER_GEOCODE = 'GEOCODER_GEOCODE',
    /**
     * Identifies the MaximumZoomImageryService API within the Maps API.
     */
    MAPS_MAX_ZOOM = 'MAPS_MAX_ZOOM',
    /**
     * Identifies the Autocomplete API within the Places API.
     */
    PLACES_AUTOCOMPLETE = 'PLACES_AUTOCOMPLETE',
    /**
     * Identifies the Details API within the Places API.
     */
    PLACES_DETAILS = 'PLACES_DETAILS',
    /**
     * Identifies the findPlaceFromPhoneNumber API within the Places API.
     */
    PLACES_FIND_PLACE_FROM_PHONE_NUMBER = 'PLACES_FIND_PLACE_FROM_PHONE_NUMBER',
    /**
     * Identifies the findPlaceFromQuery API within the Places API.
     */
    PLACES_FIND_PLACE_FROM_QUERY = 'PLACES_FIND_PLACE_FROM_QUERY',
    /**
     * Identifies the Gateway API within the Places API.
     */
    PLACES_GATEWAY = 'PLACES_GATEWAY',
    /**
     * Identifies the LocalContextSearch API within the Places API.
     */
    PLACES_LOCAL_CONTEXT_SEARCH = 'PLACES_LOCAL_CONTEXT_SEARCH',
    /**
     * Identifies the NearbySearch API within the Places API.
     */
    PLACES_NEARBY_SEARCH = 'PLACES_NEARBY_SEARCH',
    /**
     * Identifies the getPanorama method within the Streetview service.
     */
    STREETVIEW_GET_PANORAMA = 'STREETVIEW_GET_PANORAMA',
  }
  /**
   * Represents a request error from a web service (i.e. the equivalent of a 4xx
   * code in HTTP).
   *
   * Access by calling `const {MapsRequestError} = await
   * google.maps.importLibrary("core")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class MapsRequestError extends google.maps.MapsNetworkError {
    /**
     * Represents a request error from a web service (i.e. the equivalent of a
     * 4xx code in HTTP).
     *
     * Access by calling `const {MapsRequestError} = await
     * google.maps.importLibrary("core")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor();
  }
  /**
   * Represents a server-side error from a web service (i.e. the equivalent of a
   * 5xx code in HTTP).
   *
   * Access by calling `const {MapsServerError} = await
   * google.maps.importLibrary("core")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class MapsServerError extends google.maps.MapsNetworkError {
    /**
     * Represents a server-side error from a web service (i.e. the equivalent of
     * a 5xx code in HTTP).
     *
     * Access by calling `const {MapsServerError} = await
     * google.maps.importLibrary("core")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor();
  }
  /**
   * Access by calling `const {Marker} = await
   * google.maps.importLibrary("marker")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Marker extends google.maps.MVCObject {
    /**
     * Access by calling `const {Marker} = await
     * google.maps.importLibrary("marker")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     * @param opts Named optional arguments
     */
    constructor(opts?: google.maps.MarkerOptions|null);
    /**
     * Get the currently running animation.
     */
    getAnimation(): google.maps.Animation|null|undefined;
    /**
     * Get the clickable status of the {@link google.maps.Marker}.
     */
    getClickable(): boolean;
    /**
     * Get the mouse cursor type shown on hover.
     */
    getCursor(): string|null|undefined;
    /**
     * Get the draggable status of the {@link google.maps.Marker}.
     */
    getDraggable(): boolean;
    /**
     * Get the icon of the {@link google.maps.Marker}. See {@link
     * google.maps.MarkerOptions.icon}.
     */
    getIcon(): string|google.maps.Icon|null|google.maps.Symbol|undefined;
    /**
     * Get the label of the {@link google.maps.Marker}. See {@link
     * google.maps.MarkerOptions.label}.
     */
    getLabel(): google.maps.MarkerLabel|null|string|undefined;
    /**
     * Get the map or panaroama the {@link google.maps.Marker} is rendered on.
     */
    getMap(): google.maps.Map|null|google.maps.StreetViewPanorama;
    /**
     * Get the opacity of the {@link google.maps.Marker}.
     */
    getOpacity(): number|null|undefined;
    /**
     * Get the position of the {@link google.maps.Marker}.
     */
    getPosition(): google.maps.LatLng|null|undefined;
    /**
     * Get the shape of the {@link google.maps.Marker} used for interaction.
     * See {@link google.maps.MarkerOptions.shape} and {@link
     * google.maps.MarkerShape}.
     */
    getShape(): google.maps.MarkerShape|null|undefined;
    /**
     * Get the title of the {@link google.maps.Marker} tooltip. See {@link
     * google.maps.MarkerOptions.title}.
     */
    getTitle(): string|null|undefined;
    /**
     * Get the visibility of the {@link google.maps.Marker}.
     */
    getVisible(): boolean;
    /**
     * Get the zIndex of the {@link google.maps.Marker}. See {@link
     * google.maps.MarkerOptions.zIndex}.
     */
    getZIndex(): number|null|undefined;
    /**
     * Start an animation. Any ongoing animation will be cancelled. Currently
     * supported animations are: {@link google.maps.Animation.BOUNCE}, {@link
     * google.maps.Animation.DROP}. Passing in <code>null</code> will cause any
     * animation to stop.
     * @param animation The animation to play.
     */
    setAnimation(animation?: google.maps.Animation|null): void;
    /**
     * Set if the {@link google.maps.Marker} is clickable.
     * @param flag If <code>true</code>, the Marker can be clicked.
     */
    setClickable(flag: boolean): void;
    /**
     * Set the mouse cursor type shown on hover.
     * @param cursor Mouse cursor type.
     */
    setCursor(cursor?: string|null): void;
    /**
     * Set if the {@link google.maps.Marker} is draggable.
     * @param flag If <code>true</code>, the Marker can be dragged.
     */
    setDraggable(flag: boolean|null): void;
    /**
     * Set the icon for the {@link google.maps.Marker}. See {@link
     * google.maps.MarkerOptions.icon}.
     */
    setIcon(icon?: string|google.maps.Icon|null|google.maps.Symbol): void;
    /**
     * Set the label for the {@link google.maps.Marker}. See {@link
     * google.maps.MarkerOptions.label}.
     * @param label The label can either be a character string or a {@link
     *     google.maps.MarkerLabel} object.
     */
    setLabel(label?: string|google.maps.MarkerLabel|null): void;
    /**
     * Renders the {@link google.maps.Marker} on the specified map or panorama.
     * If map is set to <code>null</code>, the marker will be removed.
     */
    setMap(map: google.maps.Map|null|google.maps.StreetViewPanorama): void;
    /**
     * Set the opacity of the {@link google.maps.Marker}.
     * @param opacity A number between 0.0, transparent, and 1.0, opaque.
     */
    setOpacity(opacity?: number|null): void;
    /**
     * Set the options for the {@link google.maps.Marker}.
     */
    setOptions(options: google.maps.MarkerOptions|null): void;
    /**
     * Set the postition for the {@link google.maps.Marker}.
     * @param latlng The new position.
     */
    setPosition(latlng?: google.maps.LatLng|null|
                google.maps.LatLngLiteral): void;
    /**
     * Set the shape of the {@link google.maps.Marker} used for interaction.
     * See {@link google.maps.MarkerOptions.shape} and {@link
     * google.maps.MarkerShape}.
     */
    setShape(shape?: google.maps.MarkerShape|null): void;
    /**
     * Set the title of the {@link google.maps.Marker} tooltip. See {@link
     * google.maps.MarkerOptions.title}.
     */
    setTitle(title?: string|null): void;
    /**
     * Set if the {@link google.maps.Marker} is visible.
     * @param visible If <code>true</code>, the Marker is visible
     */
    setVisible(visible: boolean): void;
    /**
     * Set the zIndex of the {@link google.maps.Marker}. See {@link
     * google.maps.MarkerOptions.zIndex}.
     */
    setZIndex(zIndex?: number|null): void;
    /**
     * The maximum default z-index that the API will assign to a marker. You may
     * set a higher z-index to bring a marker to the front.
     */
    static readonly MAX_ZINDEX: number;
  }
  /**
   * These options specify the appearance of a marker label. A marker label is a
   * string (often a single character) which will appear inside the marker. If
   * you are using it with a custom marker, you can reposition it with the
   * <code>labelOrigin</code> property in the <code>Icon</code> class.
   */
  export interface MarkerLabel {
    /**
     * The className property of the label&#39;s element (equivalent to the
     * element&#39;s class attribute). Multiple space-separated CSS classes can
     * be added. The font color, size, weight, and family can only be set via
     * the other properties of <code>MarkerLabel</code>. CSS classes should not
     * be used to change the position nor orientation of the label (e.g. using
     * translations and rotations) if also using <a
     * href="https://developers.google.com/maps/documentation/javascript/examples/marker-collision-management">marker
     * collision management</a>.
     * @defaultValue <code>&#39;&#39;</code> (empty string)
     */
    className?: string;
    /**
     * The color of the label text.
     * @defaultValue <code>&#39;black&#39;</code>
     */
    color?: string;
    /**
     * The font family of the label text (equivalent to the CSS font-family
     * property).
     */
    fontFamily?: string;
    /**
     * The font size of the label text (equivalent to the CSS font-size
     * property).
     * @defaultValue <code>&#39;14px&#39;</code>
     */
    fontSize?: string;
    /**
     * The font weight of the label text (equivalent to the CSS font-weight
     * property).
     */
    fontWeight?: string;
    /**
     * The text to be displayed in the label.
     */
    text: string;
  }
  export interface MarkerLibrary {
    AdvancedMarkerClickEvent:
        typeof google.maps.marker.AdvancedMarkerClickEvent;
    AdvancedMarkerElement: typeof google.maps.marker.AdvancedMarkerElement;
    Animation: typeof google.maps.Animation;
    CollisionBehavior: typeof google.maps.CollisionBehavior;
    Marker: typeof google.maps.Marker;
    PinElement: typeof google.maps.marker.PinElement;
  }
  /**
   * MarkerOptions object used to define the properties that can be set on a
   * Marker.
   */
  export interface MarkerOptions {
    /**
     * The offset from the marker&#39;s position to the tip of an InfoWindow
     * that has been opened with the marker as anchor.
     */
    anchorPoint?: google.maps.Point|null;
    /**
     * Which animation to play when marker is added to a map.
     * @defaultValue <code>null</code>
     */
    animation?: google.maps.Animation|null;
    /**
     * If <code>true</code>, the marker receives mouse and touch events.
     * @defaultValue <code>true</code>
     */
    clickable?: boolean|null;
    /**
     * Available only in the v=beta channel: https://goo.gle/3oAthT3.
     * Set a collision behavior for markers on vector maps.
     * @defaultValue <code>null</code>
     */
    collisionBehavior?: string|null;
    /**
     * If <code>false</code>, disables cross that appears beneath the marker
     * when dragging.
     * @defaultValue <code>true</code>
     */
    crossOnDrag?: boolean|null;
    /**
     * Mouse cursor type to show on hover.
     * @defaultValue <code>pointer</code>
     */
    cursor?: string|null;
    /**
     * If <code>true</code>, the marker can be dragged.
     * @defaultValue <code>false</code>
     */
    draggable?: boolean|null;
    /**
     * Icon for the foreground. If a string is provided, it is treated as though
     * it were an <code>Icon</code> with the string as <code>url</code>.
     */
    icon?: string|null|google.maps.Icon|google.maps.Symbol;
    /**
     * Adds a label to the marker. A marker label is a letter or number that
     * appears inside a marker. The label can either be a string, or a
     * <code>MarkerLabel</code> object. If provided and {@link
     * google.maps.MarkerOptions.title} is not provided, an accessibility text
     * (e.g. for use with screen readers) will be added to the marker with the
     * provided label&#39;s text. Please note that the <code>label</code> is
     * currently only used for accessibility text for non-optimized markers.
     * @defaultValue <code>null</code>
     */
    label?: string|null|google.maps.MarkerLabel;
    /**
     * Map on which to display Marker. The map is required to display the marker
     * and can be provided with {@link google.maps.Marker.setMap} if not
     * provided at marker construction.
     */
    map?: google.maps.Map|null|google.maps.StreetViewPanorama;
    /**
     * A number between 0.0, transparent, and 1.0, opaque.
     * @defaultValue 1.0
     */
    opacity?: number|null;
    /**
     * Optimization enhances performance by rendering many markers as a single
     * static element. This is useful in cases where a large number of markers
     * is required. Read more about <a
     * href="https://developers.google.com/maps/documentation/javascript/markers#optimize">marker
     * optimization</a>.
     */
    optimized?: boolean|null;
    /**
     * Sets the marker position. A marker may be constructed but not displayed
     * until its position is provided - for example, by a user&#39;s actions or
     * choices. A marker position can be provided with {@link
     * google.maps.Marker.setPosition} if not provided at marker construction.
     */
    position?: google.maps.LatLng|null|google.maps.LatLngLiteral;
    /**
     * Image map region definition used for drag/click.
     */
    shape?: google.maps.MarkerShape|null;
    /**
     * Rollover text. If provided, an accessibility text (e.g. for use with
     * screen readers) will be added to the marker with the provided value.
     * Please note that the <code>title</code> is currently only used for
     * accessibility text for non-optimized markers.
     * @defaultValue <code>undefined</code>
     */
    title?: string|null;
    /**
     * If <code>true</code>, the marker is visible.
     * @defaultValue <code>true</code>
     */
    visible?: boolean|null;
    /**
     * All markers are displayed on the map in order of their zIndex, with
     * higher values displaying in front of markers with lower values. By
     * default, markers are displayed according to their vertical position on
     * screen, with lower markers appearing in front of markers further up the
     * screen.
     */
    zIndex?: number|null;
  }
  /**
   * This object defines the clickable region of a marker image. The shape
   * consists of two properties &mdash; <code>type</code> and <code>coord</code>
   * &mdash; which define the non-transparent region of an image.
   */
  export interface MarkerShape {
    /**
     * The format of this attribute depends on the value of the
     * <code>type</code> and follows the w3 AREA <code>coords</code>
     * specification found at <a
     * href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-coords">
     * http://www.w3.org/TR/REC-html40/struct/objects.html#adef-coords</a>.
     * <br>The <code>coords</code> attribute is an array of integers that
     * specify the pixel position of the shape relative to the top-left corner
     * of the target image. The coordinates depend on the value of
     * <code>type</code> as follows: <br>&nbsp;&nbsp;- <code>circle</code>:
     * coords is <code>[x1,y1,r]</code> where x1,y2 are the coordinates of the
     * center of the circle, and r is the radius of the circle.
     * <br>&nbsp;&nbsp;- <code>poly</code>: coords is
     * <code>[x1,y1,x2,y2...xn,yn]</code> where each x,y pair contains the
     * coordinates of one vertex of the polygon. <br>&nbsp;&nbsp;-
     * <code>rect</code>: coords is <code>[x1,y1,x2,y2]</code> where x1,y1 are
     * the coordinates of the upper-left corner of the rectangle and x2,y2 are
     * the coordinates of the lower-right coordinates of the rectangle.
     */
    coords: number[]|null;
    /**
     * Describes the shape&#39;s type and can be <code>circle</code>,
     * <code>poly</code> or <code>rect</code>.
     */
    type: string;
  }
  /**
   * A MaxZoom result in JSON format retrieved from the MaxZoomService.
   */
  export interface MaxZoomResult {
    /**
     * Status of the request. This property is only defined when using callbacks
     * with {@link google.maps.MaxZoomService.getMaxZoomAtLatLng} (it is not
     * defined when using Promises).
     */
    status: null|google.maps.MaxZoomStatus;
    /**
     * The maximum zoom level found at the given <code>LatLng</code>.
     */
    zoom: number;
  }
  /**
   * A service for obtaining the highest zoom level at which satellite imagery
   * is available for a given location.
   *
   * Access by calling `const {MaxZoomService} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class MaxZoomService {
    /**
     * Returns the maximum zoom level for which detailed imagery is available at
     * a particular <code>LatLng</code> for the <code>satellite</code> map type.
     * As this request is asynchronous, you must pass a <code>callback</code>
     * function which will be executed upon completion of the request, being
     * passed a <code>MaxZoomResult</code>.
     */
    getMaxZoomAtLatLng(
        latlng: google.maps.LatLng|google.maps.LatLngLiteral,
        callback?: (a: google.maps.MaxZoomResult) => void):
        Promise<google.maps.MaxZoomResult>;
  }
  /**
   * The status returned by the <code>MaxZoomService</code> on the completion of
   * a call to <code>getMaxZoomAtLatLng()</code>. Specify these by value, or by
   * using the constant&#39;s name. For example, <code>'OK'</code> or
   * <code>google.maps.MaxZoomStatus.OK</code>.
   *
   * Access by calling `const {MaxZoomStatus} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum MaxZoomStatus {
    /**
     * An unknown error occurred.
     */
    ERROR = 'ERROR',
    /**
     * The response contains a valid <code>MaxZoomResult</code>.
     */
    OK = 'OK',
  }
  /**
   * Options for the rendering of the motion tracking control.
   */
  export interface MotionTrackingControlOptions {
    /**
     * Position id. This is used to specify the position of this control on the
     * panorama. The default position is <code>RIGHT_BOTTOM</code>.
     */
    position?: null|google.maps.ControlPosition;
  }
  /**
   * You can implement this class if you want to display custom types of overlay
   * objects on the map. <br><br>Inherit from this class by setting your
   * overlay&#39;s prototype: <code>MyOverlay.prototype = new
   * google.maps.OverlayView();</code>. The <code>OverlayView</code> constructor
   * is guaranteed to be an empty function. <br><br>You must implement three
   * methods: <code>onAdd()</code>, <code>draw()</code>, and
   * <code>onRemove()</code>. <ul> <li>In the <code>onAdd()</code> method, you
   * should create DOM objects and append them as children of the panes.</li>
   * <li>In the <code>draw()</code> method, you should position these
   * elements.</li> <li>In the <code>onRemove()</code> method, you should remove
   * the objects from the DOM.</li> </ul> You must call <code>setMap()</code>
   * with a valid <code>Map</code> object to trigger the call to the
   * <code>onAdd()</code> method and <code>setMap(null)</code> in order to
   * trigger the <code>onRemove()</code> method. The <code>setMap()</code>
   * method can be called at the time of construction or at any point afterward
   * when the overlay should be re-shown after removing. The <code>draw()</code>
   * method will then be called whenever a map property changes that could
   * change the position of the element, such as zoom, center, or map type.
   *
   * Access by calling `const {OverlayView} = await
   * google.maps.importLibrary("maps")` or `const {OverlayView} = await
   * google.maps.importLibrary("streetView")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class OverlayView extends google.maps.MVCObject {
    /**
     * Implement this method to draw or update the overlay. Use the position
     * from projection.fromLatLngToDivPixel() to correctly position the overlay
     * relative to the MapPanes. This method is called after onAdd(), and is
     * called on change of zoom or center. It is not recommended to do
     * computationally expensive work in this method.
     */
    draw(): void;
    getMap(): google.maps.Map|null|google.maps.StreetViewPanorama;
    /**
     * Returns the panes in which this OverlayView can be rendered. The panes
     * are not initialized until <code>onAdd</code> is called by the API.
     */
    getPanes(): google.maps.MapPanes|null;
    /**
     * Returns the <code>MapCanvasProjection</code> object associated with this
     * <code>OverlayView</code>. The projection is not initialized until
     * <code>onAdd</code> is called by the API.
     */
    getProjection(): google.maps.MapCanvasProjection;
    /**
     * Implement this method to initialize the overlay DOM elements. This method
     * is called once after setMap() is called with a valid map. At this point,
     * panes and projection will have been initialized.
     */
    onAdd(): void;
    /**
     * Implement this method to remove your elements from the DOM. This method
     * is called once following a call to setMap(null).
     */
    onRemove(): void;
    /**
     * Adds the overlay to the map or panorama.
     * @param map The map or panorama. If <code>null</code>, the layer will be
     *     removed.
     */
    setMap(map: google.maps.Map|null|google.maps.StreetViewPanorama): void;
    /**
     * Stops click, tap, drag, and wheel events on the element from bubbling up
     * to the map. Use this to prevent map dragging and zooming, as well as map
     * &quot;click&quot; events.
     */
    static preventMapHitsAndGesturesFrom(this: any, element: Element): void;
    /**
     * Stops click or tap on the element from bubbling up to the map. Use this
     * to prevent the map from triggering &quot;click&quot; events.
     */
    static preventMapHitsFrom(this: any, element: Element): void;
  }
  export interface Padding {
    /**
     * Padding for the bottom, in pixels.
     */
    bottom?: number;
    /**
     * Padding for the left, in pixels.
     */
    left?: number;
    /**
     * Padding for the right, in pixels.
     */
    right?: number;
    /**
     * Padding for the top, in pixels.
     */
    top?: number;
  }
  /**
   * Options for the rendering of the pan control.
   */
  export interface PanControlOptions {
    /**
     * Position id. Used to specify the position of the control on the map.
     * @defaultValue {@link google.maps.ControlPosition.TOP_LEFT}
     */
    position?: google.maps.ControlPosition|null;
  }
  /**
   * Options for the Custom Pano Provider.
   */
  export interface PanoProviderOptions {
    /**
     * If set, the renderer will use technologies (like webgl) that only work
     * when cors headers are appropriately set on the provided images. It is the
     * developer&#39;s task to serve the images correctly in combination with
     * this flag, which might otherwise lead to SecurityErrors.
     */
    cors?: boolean;
  }
  /**
   * An elevation query sent by the <code>ElevationService</code> containing the
   * path along which to return sampled data. This request defines a continuous
   * path along the earth along which elevation samples should be taken at
   * evenly-spaced distances. All paths from vertex to vertex use segments of
   * the great circle between those two points.
   */
  export interface PathElevationRequest {
    /**
     * The path along which to collect elevation values.
     */
    path?: null|(google.maps.LatLng|google.maps.LatLngLiteral)[];
    /**
     * Required. The number of equidistant points along the given path for which
     * to retrieve elevation data, including the endpoints. The number of
     * samples must be a value between 2 and 512 inclusive.
     */
    samples: number;
  }
  /**
   * An elevation response returned by the {@link google.maps.ElevationService}
   * containing the list of {@link google.maps.ElevationResult}s evenly-spaced
   * along the path of the {@link google.maps.PathElevationRequest}.
   */
  export interface PathElevationResponse {
    /**
     * The list of {@link google.maps.ElevationResult}s matching the samples of
     * the {@link google.maps.PathElevationRequest}.
     */
    results: google.maps.ElevationResult[];
  }
  /**
   * Contains information needed to locate, identify, or describe a place for
   * a {@link google.maps.DirectionsRequest} or {@link
   * google.maps.DistanceMatrixRequest}. In this context, &quot;place&quot;
   * means a business, point of interest, or geographic location. For fetching
   * information about a place, see {@link google.maps.places.PlacesService}.
   */
  export interface Place {
    /**
     * The <code>LatLng</code> of the entity described by this place.
     */
    location?: google.maps.LatLng|null|google.maps.LatLngLiteral;
    /**
     * The place ID of the place (such as a business or point of interest). The
     * place ID is a unique identifier of a place in the Google Maps database.
     * Note that the <code>placeId</code> is the most accurate way of
     * identifying a place. If possible, you should specify the
     * <code>placeId</code> rather than a <code>query</code>. A place ID can be
     * retrieved from any request to the Places API, such as a <a
     * href="https://developers.google.com/maps/documentation/places/web-service/search">TextSearch</a>.
     * Place IDs can also be retrieved from requests to the Geocoding API. For
     * more information, see the <a
     * href="https://developers.google.com/maps/documentation/places/web-service/place-id">overview
     * of place IDs</a>.
     */
    placeId?: string;
    /**
     * A search query describing the place (such as a business or point of
     * interest). An example query is &quot;Quay, Upper Level, Overseas
     * Passenger Terminal 5 Hickson Road, The Rocks NSW&quot;. If possible, you
     * should specify the <code>placeId</code> rather than a <code>query</code>.
     * The API does not guarantee the accuracy of resolving the query string to
     * a place. If both the <code>placeId</code> and <code>query</code> are
     * provided, an error occurs.
     */
    query?: string;
  }
  /**
   * An interface representing a feature with a place ID which includes features
   * of type {@link google.maps.FeatureType.ADMINISTRATIVE_AREA_LEVEL_1}, {@link
   * google.maps.FeatureType.ADMINISTRATIVE_AREA_LEVEL_2}, {@link
   * google.maps.FeatureType.COUNTRY}, {@link google.maps.FeatureType.LOCALITY},
   * and {@link google.maps.FeatureType.POSTAL_CODE}.
   */
  export interface PlaceFeature extends google.maps.Feature {
    /**
     * Fetches a <code>Place</code> for this <code>PlaceFeature</code>. In the
     * resulting <code>Place</code> object, the <code>id</code> and the
     * <code>displayName</code> properties will be populated. The display name
     * will be in the language the end user sees on the map. (Additional fields
     * can be subsequently requested via <code>Place.fetchFields()</code>
     * subject to normal Places API enablement and billing.) Do not call this
     * from a <code>FeatureStyleFunction</code> since only synchronous
     * FeatureStyleFunctions are supported. The promise is rejected if there was
     * an error fetching the <code>Place</code>.
     */
    fetchPlace(): Promise<google.maps.places.Place>;
    /**
     * The {@link google.maps.places.PlaceResult.place_id}.
     */
    placeId: string;
  }
  export interface PlacesLibrary {
    AddressComponent: typeof google.maps.places.AddressComponent;
    Attribution: typeof google.maps.places.Attribution;
    Autocomplete: typeof google.maps.places.Autocomplete;
    AutocompleteService: typeof google.maps.places.AutocompleteService;
    AutocompleteSessionToken:
        typeof google.maps.places.AutocompleteSessionToken;
    BusinessStatus: typeof google.maps.places.BusinessStatus;
    OpeningHours: typeof google.maps.places.OpeningHours;
    OpeningHoursPeriod: typeof google.maps.places.OpeningHoursPeriod;
    OpeningHoursPoint: typeof google.maps.places.OpeningHoursPoint;
    Photo: typeof google.maps.places.Photo;
    PhotoAttribution: typeof google.maps.places.PhotoAttribution;
    Place: typeof google.maps.places.Place;
    PlacesService: typeof google.maps.places.PlacesService;
    PlacesServiceStatus: typeof google.maps.places.PlacesServiceStatus;
    PlusCode: typeof google.maps.places.PlusCode;
    PriceLevel: typeof google.maps.places.PriceLevel;
    RankBy: typeof google.maps.places.RankBy;
    Review: typeof google.maps.places.Review;
    SearchBox: typeof google.maps.places.SearchBox;
  }
  /**
   * Access by calling `const {Point} = await
   * google.maps.importLibrary("core")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Point {
    /**
     * Access by calling `const {Point} = await
     * google.maps.importLibrary("core")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(x: number, y: number);
    /**
     * Compares two Points
     */
    equals(other: google.maps.Point|null): boolean;
    /**
     * Returns a string representation of this Point.
     */
    toString(): string;
    /**
     * The X coordinate
     */
    x: number;
    /**
     * The Y coordinate
     */
    y: number;
  }
  /**
   * This object is returned from mouse events on polylines and polygons.
   */
  export interface PolyMouseEvent extends google.maps.MapMouseEvent {
    /**
     * The index of the edge within the path beneath the cursor when the event
     * occurred, if the event occurred on a mid-point on an editable polygon.
     */
    edge?: number;
    /**
     * The index of the path beneath the cursor when the event occurred, if the
     * event occurred on a vertex and the polygon is editable. Otherwise
     * <code>undefined</code>.
     */
    path?: number;
    /**
     * The index of the vertex beneath the cursor when the event occurred, if
     * the event occurred on a vertex and the polyline or polygon is editable.
     * If the event does not occur on a vertex, the value is
     * <code>undefined</code>.
     */
    vertex?: number;
  }
  /**
   * A polygon (like a polyline) defines a series of connected coordinates in an
   * ordered sequence. Additionally, polygons form a closed loop and define a
   * filled region. See the samples in the developer&#39;s guide, starting with
   * a <a
   * href="https://developers.google.com/maps/documentation/javascript/examples/polygon-simple">simple
   * polygon</a>, a <a
   * href="https://developers.google.com/maps/documentation/javascript/examples/polygon-hole">polygon
   * with a hole</a>, and more. Note that you can also use the <a
   * href="#Data.Polygon">Data layer</a> to create a polygon. The Data layer
   * offers a simpler way of creating holes because it handles the order of the
   * inner and outer paths for you.
   *
   * Access by calling `const {Polygon} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Polygon extends google.maps.MVCObject {
    /**
     * A polygon (like a polyline) defines a series of connected coordinates in
     * an ordered sequence. Additionally, polygons form a closed loop and define
     * a filled region. See the samples in the developer&#39;s guide, starting
     * with a <a
     * href="https://developers.google.com/maps/documentation/javascript/examples/polygon-simple">simple
     * polygon</a>, a <a
     * href="https://developers.google.com/maps/documentation/javascript/examples/polygon-hole">polygon
     * with a hole</a>, and more. Note that you can also use the <a
     * href="#Data.Polygon">Data layer</a> to create a polygon. The Data layer
     * offers a simpler way of creating holes because it handles the order of
     * the inner and outer paths for you.
     *
     * Access by calling `const {Polygon} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(opts?: google.maps.PolygonOptions|null);
    /**
     * Returns whether this shape can be dragged by the user.
     */
    getDraggable(): boolean;
    /**
     * Returns whether this shape can be edited by the user.
     */
    getEditable(): boolean;
    /**
     * Returns the map on which this shape is attached.
     */
    getMap(): google.maps.Map|null;
    /**
     * Retrieves the first path.
     */
    getPath(): google.maps.MVCArray<google.maps.LatLng>;
    /**
     * Retrieves the paths for this polygon.
     */
    getPaths(): google.maps.MVCArray<google.maps.MVCArray<google.maps.LatLng>>;
    /**
     * Returns whether this poly is visible on the map.
     */
    getVisible(): boolean;
    /**
     * If set to <code>true</code>, the user can drag this shape over the map.
     * The <code>geodesic</code> property defines the mode of dragging.
     */
    setDraggable(draggable: boolean): void;
    /**
     * If set to <code>true</code>, the user can edit this shape by dragging the
     * control points shown at the vertices and on each segment.
     */
    setEditable(editable: boolean): void;
    /**
     * Renders this shape on the specified map. If map is set to
     * <code>null</code>, the shape will be removed.
     */
    setMap(map: google.maps.Map|null): void;
    setOptions(options: google.maps.PolygonOptions|null): void;
    /**
     * Sets the first path. See <em><code><a
     * href="#PolygonOptions">PolygonOptions</a></code></em> for more details.
     */
    setPath(path: google.maps.MVCArray<google.maps.LatLng>|
            (google.maps.LatLng|google.maps.LatLngLiteral)[]): void;
    /**
     * Sets the path for this polygon.
     */
    setPaths(paths: google.maps.MVCArray<any>|any[]): void;
    /**
     * Hides this poly if set to <code>false</code>.
     */
    setVisible(visible: boolean): void;
  }
  /**
   * PolygonOptions object used to define the properties that can be set on a
   * Polygon.
   */
  export interface PolygonOptions {
    /**
     * Indicates whether this <code>Polygon</code> handles mouse events.
     * @defaultValue <code>true</code>
     */
    clickable?: null|boolean;
    /**
     * If set to <code>true</code>, the user can drag this shape over the map.
     * The <code>geodesic</code> property defines the mode of dragging.
     * @defaultValue <code>false</code>
     */
    draggable?: null|boolean;
    /**
     * If set to <code>true</code>, the user can edit this shape by dragging the
     * control points shown at the vertices and on each segment.
     * @defaultValue <code>false</code>
     */
    editable?: null|boolean;
    /**
     * The fill color. All CSS3 colors are supported except for extended named
     * colors.
     */
    fillColor?: null|string;
    /**
     * The fill opacity between 0.0 and 1.0
     */
    fillOpacity?: null|number;
    /**
     * When <code>true</code>, edges of the polygon are interpreted as geodesic
     * and will follow the curvature of the Earth. When <code>false</code>,
     * edges of the polygon are rendered as straight lines in screen space. Note
     * that the shape of a geodesic polygon may appear to change when dragged,
     * as the dimensions are maintained relative to the surface of the earth.
     * @defaultValue <code>false</code>
     */
    geodesic?: null|boolean;
    /**
     * Map on which to display Polygon.
     */
    map?: null|google.maps.Map;
    /**
     * The ordered sequence of coordinates that designates a closed loop. Unlike
     * polylines, a polygon may consist of one or more paths. As a result, the
     * paths property may specify one or more arrays of <code>LatLng</code>
     * coordinates. Paths are closed automatically; do not repeat the first
     * vertex of the path as the last vertex. Simple polygons may be defined
     * using a single array of <code>LatLng</code>s. More complex polygons may
     * specify an array of arrays. Any simple arrays are converted into <code><a
     * href="#MVCArray">MVCArray</a></code>s. Inserting or removing
     * <code>LatLng</code>s from the <code>MVCArray</code> will automatically
     * update the polygon on the map.
     */
    paths?: null|google.maps.MVCArray<any>|any[];
    /**
     * The stroke color. All CSS3 colors are supported except for extended named
     * colors.
     */
    strokeColor?: null|string;
    /**
     * The stroke opacity between 0.0 and 1.0
     */
    strokeOpacity?: null|number;
    /**
     * The stroke position.
     * @defaultValue {@link google.maps.StrokePosition.CENTER}
     */
    strokePosition?: null|google.maps.StrokePosition;
    /**
     * The stroke width in pixels.
     */
    strokeWeight?: null|number;
    /**
     * Whether this polygon is visible on the map.
     * @defaultValue <code>true</code>
     */
    visible?: null|boolean;
    /**
     * The zIndex compared to other polys.
     */
    zIndex?: null|number;
  }
  /**
   * A polyline is a linear overlay of connected line segments on the map.
   *
   * Access by calling `const {Polyline} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Polyline extends google.maps.MVCObject {
    /**
     * A polyline is a linear overlay of connected line segments on the map.
     *
     * Access by calling `const {Polyline} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(opts?: google.maps.PolylineOptions|null);
    /**
     * Returns whether this shape can be dragged by the user.
     */
    getDraggable(): boolean;
    /**
     * Returns whether this shape can be edited by the user.
     */
    getEditable(): boolean;
    /**
     * Returns the map on which this shape is attached.
     */
    getMap(): google.maps.Map|null;
    /**
     * Retrieves the path.
     */
    getPath(): google.maps.MVCArray<google.maps.LatLng>;
    /**
     * Returns whether this poly is visible on the map.
     */
    getVisible(): boolean;
    /**
     * If set to <code>true</code>, the user can drag this shape over the map.
     * The <code>geodesic</code> property defines the mode of dragging.
     */
    setDraggable(draggable: boolean): void;
    /**
     * If set to <code>true</code>, the user can edit this shape by dragging the
     * control points shown at the vertices and on each segment.
     */
    setEditable(editable: boolean): void;
    /**
     * Renders this shape on the specified map. If map is set to
     * <code>null</code>, the shape will be removed.
     */
    setMap(map: google.maps.Map|null): void;
    setOptions(options: google.maps.PolylineOptions|null): void;
    /**
     * Sets the path. See <em><code><a
     * href="#PolylineOptions">PolylineOptions</a></code></em> for more details.
     */
    setPath(path: google.maps.MVCArray<google.maps.LatLng>|
            (google.maps.LatLng|google.maps.LatLngLiteral)[]): void;
    /**
     * Hides this poly if set to <code>false</code>.
     */
    setVisible(visible: boolean): void;
  }
  /**
   * PolylineOptions object used to define the properties that can be set on a
   * Polyline.
   */
  export interface PolylineOptions {
    /**
     * Indicates whether this <code>Polyline</code> handles mouse events.
     * @defaultValue <code>true</code>
     */
    clickable?: null|boolean;
    /**
     * If set to <code>true</code>, the user can drag this shape over the map.
     * The <code>geodesic</code> property defines the mode of dragging.
     * @defaultValue <code>false</code>
     */
    draggable?: null|boolean;
    /**
     * If set to <code>true</code>, the user can edit this shape by dragging the
     * control points shown at the vertices and on each segment.
     * @defaultValue <code>false</code>
     */
    editable?: null|boolean;
    /**
     * When <code>true</code>, edges of the polygon are interpreted as geodesic
     * and will follow the curvature of the Earth. When <code>false</code>,
     * edges of the polygon are rendered as straight lines in screen space. Note
     * that the shape of a geodesic polygon may appear to change when dragged,
     * as the dimensions are maintained relative to the surface of the earth.
     * @defaultValue <code>false</code>
     */
    geodesic?: null|boolean;
    /**
     * The icons to be rendered along the polyline.
     */
    icons?: null|google.maps.IconSequence[];
    /**
     * Map on which to display Polyline.
     */
    map?: null|google.maps.Map;
    /**
     * The ordered sequence of coordinates of the Polyline. This path may be
     * specified using either a simple array of <code>LatLng</code>s, or an
     * <code>MVCArray</code> of <code>LatLng</code>s. Note that if you pass a
     * simple array, it will be converted to an <code>MVCArray</code> Inserting
     * or removing LatLngs in the <code>MVCArray</code> will automatically
     * update the polyline on the map.
     */
    path?: null|google.maps.MVCArray<google.maps.LatLng>|
        (google.maps.LatLng|google.maps.LatLngLiteral)[];
    /**
     * The stroke color. All CSS3 colors are supported except for extended named
     * colors.
     */
    strokeColor?: null|string;
    /**
     * The stroke opacity between 0.0 and 1.0.
     */
    strokeOpacity?: null|number;
    /**
     * The stroke width in pixels.
     */
    strokeWeight?: null|number;
    /**
     * Whether this polyline is visible on the map.
     * @defaultValue <code>true</code>
     */
    visible?: null|boolean;
    /**
     * The zIndex compared to other polys.
     */
    zIndex?: null|number;
  }
  export interface Projection {
    /**
     * Translates from the LatLng cylinder to the Point plane. This interface
     * specifies a function which implements translation from given
     * <code>LatLng</code> values to world coordinates on the map projection.
     * The Maps API calls this method when it needs to plot locations on screen.
     * <code>Projection</code> objects must implement this method, but may
     * return <code>null</code> if the projection cannot calculate the
     * <code>Point</code>.
     */
    fromLatLngToPoint(
        latLng: google.maps.LatLng|google.maps.LatLngLiteral,
        point?: google.maps.Point): google.maps.Point|null;
    /**
     * This interface specifies a function which implements translation from
     * world coordinates on a map projection to <code>LatLng</code> values. The
     * Maps API calls this method when it needs to translate actions on screen
     * to positions on the map. <code>Projection</code> objects must implement
     * this method, but may return <code>null</code> if the projection cannot
     * calculate the <code>LatLng</code>.
     */
    fromPointToLatLng(pixel: google.maps.Point, noClampNoWrap?: boolean):
        google.maps.LatLng|null;
  }
  /**
   * A rectangle overlay.
   *
   * Access by calling `const {Rectangle} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Rectangle extends google.maps.MVCObject {
    /**
     * A rectangle overlay.
     *
     * Access by calling `const {Rectangle} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(opts?: google.maps.RectangleOptions|null);
    /**
     * Returns the bounds of this rectangle.
     */
    getBounds(): google.maps.LatLngBounds|null;
    /**
     * Returns whether this rectangle can be dragged by the user.
     */
    getDraggable(): boolean;
    /**
     * Returns whether this rectangle can be edited by the user.
     */
    getEditable(): boolean;
    /**
     * Returns the map on which this rectangle is displayed.
     */
    getMap(): google.maps.Map|null;
    /**
     * Returns whether this rectangle is visible on the map.
     */
    getVisible(): boolean;
    /**
     * Sets the bounds of this rectangle.
     */
    setBounds(bounds: google.maps.LatLngBounds|null|
              google.maps.LatLngBoundsLiteral): void;
    /**
     * If set to <code>true</code>, the user can drag this rectangle over the
     * map.
     */
    setDraggable(draggable: boolean): void;
    /**
     * If set to <code>true</code>, the user can edit this rectangle by dragging
     * the control points shown at the corners and on each edge.
     */
    setEditable(editable: boolean): void;
    /**
     * Renders the rectangle on the specified map. If map is set to
     * <code>null</code>, the rectangle will be removed.
     */
    setMap(map: google.maps.Map|null): void;
    setOptions(options: google.maps.RectangleOptions|null): void;
    /**
     * Hides this rectangle if set to <code>false</code>.
     */
    setVisible(visible: boolean): void;
  }
  /**
   * RectangleOptions object used to define the properties that can be set on a
   * Rectangle.
   */
  export interface RectangleOptions {
    /**
     * The bounds.
     */
    bounds?: null|google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral;
    /**
     * Indicates whether this <code>Rectangle</code> handles mouse events.
     * @defaultValue <code>true</code>
     */
    clickable?: null|boolean;
    /**
     * If set to <code>true</code>, the user can drag this rectangle over the
     * map.
     * @defaultValue <code>false</code>
     */
    draggable?: null|boolean;
    /**
     * If set to <code>true</code>, the user can edit this rectangle by dragging
     * the control points shown at the corners and on each edge.
     * @defaultValue <code>false</code>
     */
    editable?: null|boolean;
    /**
     * The fill color. All CSS3 colors are supported except for extended named
     * colors.
     */
    fillColor?: null|string;
    /**
     * The fill opacity between 0.0 and 1.0
     */
    fillOpacity?: null|number;
    /**
     * Map on which to display Rectangle.
     */
    map?: null|google.maps.Map;
    /**
     * The stroke color. All CSS3 colors are supported except for extended named
     * colors.
     */
    strokeColor?: null|string;
    /**
     * The stroke opacity between 0.0 and 1.0
     */
    strokeOpacity?: null|number;
    /**
     * The stroke position.
     * @defaultValue {@link google.maps.StrokePosition.CENTER}
     */
    strokePosition?: null|google.maps.StrokePosition;
    /**
     * The stroke width in pixels.
     */
    strokeWeight?: null|number;
    /**
     * Whether this rectangle is visible on the map.
     * @defaultValue <code>true</code>
     */
    visible?: null|boolean;
    /**
     * The zIndex compared to other polys.
     */
    zIndex?: null|number;
  }
  /**
   * Access by calling `const {RenderingType} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum RenderingType {
    /**
     * Indicates that the map is a raster map.
     */
    RASTER = 'RASTER',
    /**
     * Indicates that it is unknown yet whether the map is vector or raster,
     * because the map has not finished initializing yet.
     */
    UNINITIALIZED = 'UNINITIALIZED',
    /**
     * Indicates that the map is a vector map.
     */
    VECTOR = 'VECTOR',
  }
  /**
   * Options for the rendering of the rotate control.
   */
  export interface RotateControlOptions {
    /**
     * Position id. Used to specify the position of the control on the map. The
     * default position is <code>TOP_LEFT</code>.
     */
    position?: google.maps.ControlPosition|null;
  }
  export interface RoutesLibrary {
    DirectionsRenderer: typeof google.maps.DirectionsRenderer;
    DirectionsService: typeof google.maps.DirectionsService;
    DirectionsStatus: typeof google.maps.DirectionsStatus;
    DistanceMatrixElementStatus: typeof google.maps.DistanceMatrixElementStatus;
    DistanceMatrixService: typeof google.maps.DistanceMatrixService;
    DistanceMatrixStatus: typeof google.maps.DistanceMatrixStatus;
    TrafficModel: typeof google.maps.TrafficModel;
    TransitMode: typeof google.maps.TransitMode;
    TransitRoutePreference: typeof google.maps.TransitRoutePreference;
    TravelMode: typeof google.maps.TravelMode;
    VehicleType: typeof google.maps.VehicleType;
  }
  /**
   * Options for the rendering of the scale control.
   */
  export interface ScaleControlOptions {
    /**
     * Style id. Used to select what style of scale control to display.
     */
    style?: google.maps.ScaleControlStyle|null;
  }
  /**
   * Identifiers for scale control ids.
   */
  export enum ScaleControlStyle {
    /**
     * The standard scale control.
     */
    DEFAULT = 0.0,
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * Settings which control the behavior of the Maps JavaScript API as a whole.
   *
   * Access by calling `const {Settings} = await
   * google.maps.importLibrary("core")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Settings {
    /**
     * Available only in the v=beta channel: https://goo.gle/3oAthT3.
     * A collection of unique experience IDs to which to attribute Maps JS API
     * calls. The returned value is a copy of the internal value that is stored
     * in the <code>Settings</code> class singleton instance. Operations on
     * <code>google.maps.Settings.getInstance().experienceIds</code> will
     * therefore only modify the copy and not the internal value.<br/><br/>To
     * update the internal value, set the property equal to the new value on the
     * singleton instance (ex:
     * <code>google.maps.Settings.getInstance().experienceIds =
     * [experienceId];</code>).
     */
    experienceIds: Iterable<string>;
    /**
     * Available only in the v=beta channel: https://goo.gle/3oAthT3.
     * Returns the singleton instance of <code>google.maps.Settings</code>.
     */
    static getInstance(this: any): google.maps.Settings;
  }
  /**
   * Access by calling `const {Size} = await google.maps.importLibrary("core")`.
   * See https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Size {
    /**
     * Access by calling `const {Size} = await
     * google.maps.importLibrary("core")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(
        width: number, height: number, widthUnit?: string, heightUnit?: string);
    /**
     * Compares two Sizes.
     */
    equals(other: google.maps.Size|null): boolean;
    /**
     * The height along the y-axis, in pixels.
     */
    height: number;
    /**
     * Returns a string representation of this Size.
     */
    toString(): string;
    /**
     * The width along the x-axis, in pixels.
     */
    width: number;
  }
  /**
   * Options for the rendering of the Street View address control.
   */
  export interface StreetViewAddressControlOptions {
    /**
     * Position id. This id is used to specify the position of the control on
     * the map. The default position is <code>TOP_LEFT</code>.
     */
    position?: null|google.maps.ControlPosition;
  }
  /**
   * Options for the rendering of the Street View pegman control on the map.
   */
  export interface StreetViewControlOptions {
    /**
     * Position id. Used to specify the position of the control on the map. The
     * default position is embedded within the navigation (zoom and pan)
     * controls. If this position is empty or the same as that specified in the
     * <code>zoomControlOptions</code> or <code>panControlOptions</code>, the
     * Street View control will be displayed as part of the navigation controls.
     * Otherwise, it will be displayed separately.
     */
    position?: google.maps.ControlPosition|null;
  }
  /**
   * A layer that illustrates the locations where Street View is available.
   *
   * Access by calling `const {StreetViewCoverageLayer} = await
   * google.maps.importLibrary("streetView")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class StreetViewCoverageLayer extends google.maps.MVCObject {
    /**
     * Returns the map on which this layer is displayed.
     */
    getMap(): google.maps.Map|null;
    /**
     * Renders the layer on the specified map. If the map is set to null, the
     * layer will be removed.
     */
    setMap(map: google.maps.Map|null): void;
  }
  export interface StreetViewLibrary {
    InfoWindow: typeof google.maps.InfoWindow;
    OverlayView: typeof google.maps.OverlayView;
    StreetViewCoverageLayer: typeof google.maps.StreetViewCoverageLayer;
    StreetViewPanorama: typeof google.maps.StreetViewPanorama;
    StreetViewPreference: typeof google.maps.StreetViewPreference;
    StreetViewService: typeof google.maps.StreetViewService;
    StreetViewSource: typeof google.maps.StreetViewSource;
    StreetViewStatus: typeof google.maps.StreetViewStatus;
  }
  /**
   * A collection of references to adjacent Street View panos.
   */
  export interface StreetViewLink {
    /**
     * A localized string describing the link.
     */
    description: null|string;
    /**
     * The heading of the link.
     */
    heading: null|number;
    /**
     * A unique identifier for the panorama. This id is stable within a session
     * but unstable across sessions.
     */
    pano: null|string;
  }
  /**
   * A representation of a location in the Street View panorama.
   */
  export interface StreetViewLocation {
    /**
     * A localized string describing the location.
     */
    description?: null|string;
    /**
     * The latlng of the panorama.
     */
    latLng?: null|google.maps.LatLng;
    /**
     * A unique identifier for the panorama. This is stable within a session but
     * unstable across sessions.
     */
    pano: string;
    /**
     * Short description of the location.
     */
    shortDescription?: null|string;
  }
  /**
   * A Street View request to be sent with <code>getPanorama</code>.
   * <code>StreetViewLocationRequest</code> lets you search for a Street View
   * panoroma at a specified location.
   */
  export interface StreetViewLocationRequest {
    /**
     * Specifies the location where to search for a Street View panorama.
     */
    location?: null|google.maps.LatLng|google.maps.LatLngLiteral;
    /**
     * Sets a preference for which panorama should be found within the radius:
     * the one nearest to the provided location, or the best one within the
     * radius.
     */
    preference?: null|google.maps.StreetViewPreference;
    /**
     * Sets a radius in meters in which to search for a panorama.
     * @defaultValue <code>50</code>
     */
    radius?: null|number;
    /**
     * Specifies the source of panoramas to search. This allows a restriction to
     * search for just outdoor panoramas for example.
     * @defaultValue {@link google.maps.StreetViewSource.DEFAULT}
     */
    source?: null|google.maps.StreetViewSource;
  }
  /**
   * A <code>StreetViewPanoRequest</code> is used with the
   * <code>getPanorama</code> to find a panorama with a specified ID.
   */
  export interface StreetViewPanoRequest {
    /**
     * Specifies the pano ID to search for.
     */
    pano?: null|string;
  }
  /**
   * Displays the panorama for a given <code>LatLng</code> or panorama ID. A
   * <code>StreetViewPanorama</code> object provides a Street View
   * &quot;viewer&quot; which can be stand-alone within a separate
   * <code>&lt;div&gt;</code> or bound to a <code>Map</code>.
   *
   * Access by calling `const {StreetViewPanorama} = await
   * google.maps.importLibrary("streetView")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class StreetViewPanorama extends google.maps.MVCObject {
    /**
     * Displays the panorama for a given <code>LatLng</code> or panorama ID. A
     * <code>StreetViewPanorama</code> object provides a Street View
     * &quot;viewer&quot; which can be stand-alone within a separate
     * <code>&lt;div&gt;</code> or bound to a <code>Map</code>.
     *
     * Access by calling `const {StreetViewPanorama} = await
     * google.maps.importLibrary("streetView")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(
        container: HTMLElement,
        opts?: google.maps.StreetViewPanoramaOptions|null);
    /**
     * Additional controls to attach to the panorama. To add a control to the
     * panorama, add the control&#39;s <code>&lt;div&gt;</code> to the
     * <code>MVCArray</code> corresponding to the {@link
     * google.maps.ControlPosition} where it should be rendered.
     */
    controls: google.maps.MVCArray<HTMLElement>[];
    /**
     * Sets focus on this <code>StreetViewPanorama</code>. You may wish to
     * consider using this method along with a <code>visible_changed</code>
     * event to make sure that <code>StreetViewPanorama</code> is visible before
     * setting focus on it. A <code>StreetViewPanorama</code> that is not
     * visible cannot be focused.
     */
    focus(): void;
    /**
     * Returns the set of navigation links for the Street View panorama.
     */
    getLinks(): (google.maps.StreetViewLink|null)[]|null;
    /**
     * Returns the StreetViewLocation of the current panorama.
     */
    getLocation(): google.maps.StreetViewLocation;
    /**
     * Returns the state of motion tracker. If <code>true</code> when the user
     * physically moves the device and the browser supports it, the Street View
     * Panorama tracks the physical movements.
     */
    getMotionTracking(): boolean;
    /**
     * Returns the current panorama ID for the Street View panorama. This id is
     * stable within the browser&#39;s current session only.
     */
    getPano(): string;
    /**
     * Returns the heading and pitch of the photographer when this panorama was
     * taken. For Street View panoramas on the road, this also reveals in which
     * direction the car was travelling. This data is available after the
     * <code>pano_changed</code> event.
     */
    getPhotographerPov(): google.maps.StreetViewPov;
    /**
     * Returns the current <code>LatLng</code> position for the Street View
     * panorama.
     */
    getPosition(): google.maps.LatLng|null;
    /**
     * Returns the current point of view for the Street View panorama.
     */
    getPov(): google.maps.StreetViewPov;
    /**
     * Returns the status of the panorama on completion of the
     * <code>setPosition()</code> or <code>setPano()</code> request.
     */
    getStatus(): google.maps.StreetViewStatus;
    /**
     * Returns <code>true</code> if the panorama is visible. It does not specify
     * whether Street View imagery is available at the specified position.
     */
    getVisible(): boolean;
    /**
     * Returns the zoom level of the panorama. Fully zoomed-out is level 0,
     * where the field of view is 180 degrees. Zooming in increases the zoom
     * level.
     */
    getZoom(): number;
    /**
     * Set the custom panorama provider called on pano change to load custom
     * panoramas.
     */
    registerPanoProvider(
        provider: (a: string) => google.maps.StreetViewPanoramaData | null,
        opt_options?: google.maps.PanoProviderOptions): void;
    /**
     * Sets the set of navigation links for the Street View panorama.
     */
    setLinks(links: (google.maps.StreetViewLink|null)[]|null): void;
    /**
     * Sets the state of motion tracker. If <code>true</code> when the user
     * physically moves the device and the browser supports it, the Street View
     * Panorama tracks the physical movements.
     */
    setMotionTracking(motionTracking: boolean): void;
    /**
     * Sets a collection of key-value pairs.
     */
    setOptions(options: google.maps.StreetViewPanoramaOptions|null): void;
    /**
     * Sets the current panorama ID for the Street View panorama.
     */
    setPano(pano: string): void;
    /**
     * Sets the current <code>LatLng</code> position for the Street View
     * panorama.
     */
    setPosition(latLng: google.maps.LatLng|null|
                google.maps.LatLngLiteral): void;
    /**
     * Sets the point of view for the Street View panorama.
     */
    setPov(pov: google.maps.StreetViewPov): void;
    /**
     * Sets to <code>true</code> to make the panorama visible. If set to
     * <code>false</code>, the panorama will be hidden whether it is embedded in
     * the map or in its own <code>&lt;div&gt;</code>.
     */
    setVisible(flag: boolean): void;
    /**
     * Sets the zoom level of the panorama. Fully zoomed-out is level 0, where
     * the field of view is 180 degrees. Zooming in increases the zoom level.
     */
    setZoom(zoom: number): void;
  }
  /**
   * The representation of a panorama returned from the provider defined using
   * <code>registerPanoProvider</code>.
   */
  export interface StreetViewPanoramaData {
    /**
     * Specifies the copyright text for this panorama.
     */
    copyright?: string;
    /**
     * Specifies the year and month in which the imagery in this panorama was
     * acquired. The date string is in the form YYYY-MM.
     */
    imageDate?: string;
    /**
     * Specifies the navigational links to adjacent panoramas.
     */
    links?: google.maps.StreetViewLink[];
    /**
     * Specifies the location meta-data for this panorama.
     */
    location?: google.maps.StreetViewLocation;
    /**
     * Specifies the custom tiles for this panorama.
     */
    tiles: google.maps.StreetViewTileData;
  }
  /**
   * Options defining the properties of a <code>StreetViewPanorama</code>
   * object.
   */
  export interface StreetViewPanoramaOptions {
    /**
     * The enabled/disabled state of the address control.
     */
    addressControl?: boolean|null;
    /**
     * The display options for the address control.
     */
    addressControlOptions?: google.maps.StreetViewAddressControlOptions|null;
    /**
     * The enabled/disabled state of click-to-go. Not applicable to custom
     * panoramas.
     * @defaultValue <code>true</code>
     */
    clickToGo?: boolean|null;
    /**
     * Size in pixels of the controls appearing on the panorama. This value must
     * be supplied directly when creating the Panorama, updating this value
     * later may bring the controls into an undefined state. Only governs the
     * controls made by the Maps API itself. Does not scale developer created
     * custom controls.
     */
    controlSize?: number|null;
    /**
     * Enables/disables all default UI. May be overridden individually.
     */
    disableDefaultUI?: boolean|null;
    /**
     * Enables/disables zoom on double click.
     * @defaultValue <code>true</code>
     */
    disableDoubleClickZoom?: boolean|null;
    /**
     * If <code>true</code>, the close button is displayed.
     * @defaultValue <code>false</code>
     */
    enableCloseButton?: boolean|null;
    /**
     * The enabled/disabled state of the fullscreen control.
     */
    fullscreenControl?: boolean|null;
    /**
     * The display options for the fullscreen control.
     */
    fullscreenControlOptions?: google.maps.FullscreenControlOptions|null;
    /**
     * The enabled/disabled state of the imagery acquisition date control.
     * Disabled by default.
     */
    imageDateControl?: boolean|null;
    /**
     * The enabled/disabled state of the links control.
     */
    linksControl?: boolean|null;
    /**
     * Whether motion tracking is on or off. Enabled by default when the motion
     * tracking control is present and permission is granted by a user or not
     * required, so that the POV (point of view) follows the orientation of the
     * device. This is primarily applicable to mobile devices. If
     * <code>motionTracking</code> is set to <code>false</code> while
     * <code>motionTrackingControl</code> is enabled, the motion tracking
     * control appears but tracking is off. The user can tap the motion tracking
     * control to toggle this option. If <code>motionTracking</code> is set to
     * <code>true</code> while permission is required but not yet requested, the
     * motion tracking control appears but tracking is off. The user can tap the
     * motion tracking control to request permission. If
     * <code>motionTracking</code> is set to <code>true</code> while permission
     * is denied by a user, the motion tracking control appears disabled with
     * tracking turned off.
     */
    motionTracking?: boolean|null;
    /**
     * The enabled/disabled state of the motion tracking control. Enabled by
     * default when the device has motion data, so that the control appears on
     * the map. This is primarily applicable to mobile devices.
     */
    motionTrackingControl?: boolean|null;
    /**
     * The display options for the motion tracking control.
     */
    motionTrackingControlOptions?: google.maps.MotionTrackingControlOptions|
        null;
    /**
     * The enabled/disabled state of the pan control.
     */
    panControl?: boolean|null;
    /**
     * The display options for the pan control.
     */
    panControlOptions?: google.maps.PanControlOptions|null;
    /**
     * The panorama ID, which should be set when specifying a custom panorama.
     */
    pano?: string|null;
    /**
     * The <code>LatLng</code> position of the Street View panorama.
     */
    position?: google.maps.LatLng|null|google.maps.LatLngLiteral;
    /**
     * The camera orientation, specified as heading and pitch, for the panorama.
     */
    pov?: google.maps.StreetViewPov|null;
    /**
     * If <code>false</code>, disables scrollwheel zooming in Street View.
     * @defaultValue <code>true</code>
     */
    scrollwheel?: boolean|null;
    /**
     * The display of street names on the panorama. If this value is not
     * specified, or is set to <code>true</code>, street names are displayed on
     * the panorama. If set to <code>false</code>, street names are not
     * displayed.
     * @defaultValue <code>true</code>
     */
    showRoadLabels?: boolean|null;
    /**
     * If <code>true</code>, the Street View panorama is visible on load.
     */
    visible?: boolean|null;
    /**
     * The zoom of the panorama, specified as a number. A zoom of 0 gives a 180
     * degrees Field of View.
     */
    zoom?: number|null;
    /**
     * The enabled/disabled state of the zoom control.
     */
    zoomControl?: boolean|null;
    /**
     * The display options for the zoom control.
     */
    zoomControlOptions?: google.maps.ZoomControlOptions|null;
  }
  /**
   * A point of view object which specifies the camera&#39;s orientation at the
   * Street View panorama&#39;s position. The point of view is defined as
   * heading and pitch.
   */
  export interface StreetViewPov {
    /**
     * The camera heading in degrees relative to <code>true</code> north. True
     * north is 0&deg;, east is 90&deg;, south is 180&deg;, west is 270&deg;.
     */
    heading: number;
    /**
     * The camera pitch in degrees, relative to the street view vehicle. Ranges
     * from 90&deg; (directly upwards) to -90&deg; (directly downwards).
     */
    pitch: number;
  }
  /**
   * Options that bias a search result towards returning a Street View panorama
   * that is nearest to the request location, or a panorama that is considered
   * most likely to be what the user wants to see. Specify these by value, or by
   * using the constant&#39;s name. For example, <code>'best'</code> or
   * <code>google.maps.StreetViewPreference.BEST</code>.
   *
   * Access by calling `const {StreetViewPreference} = await
   * google.maps.importLibrary("streetView")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum StreetViewPreference {
    /**
     * Return the Street View panorama that is considered most likely to be what
     * the user wants to see. The best result is determined by algorithms based
     * on user research and parameters such as recognised points of interest,
     * image quality, and distance from the given location.
     */
    BEST = 'best',
    /**
     * Return the Street View panorama that is the shortest distance from the
     * provided location. This works well only within a limited radius. The
     * recommended radius is 1km or less.
     */
    NEAREST = 'nearest',
  }
  /**
   * The response resolved for a Promise from {@link
   * google.maps.StreetViewService.getPanorama}.
   */
  export interface StreetViewResponse {
    /**
     * The representation of a panorama.
     */
    data: google.maps.StreetViewPanoramaData;
  }
  /**
   * A <code>StreetViewService</code> object performs searches for Street View
   * data.
   *
   * Access by calling `const {StreetViewService} = await
   * google.maps.importLibrary("streetView")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class StreetViewService {
    /**
     * Retrieves the <code>StreetViewPanoramaData</code> for a panorama that
     * matches the supplied Street View query request. The
     * <code>StreetViewPanoramaData</code> is passed to the provided callback.
     */
    getPanorama(
        request: google.maps.StreetViewLocationRequest|
        google.maps.StreetViewPanoRequest,
        callback?:
            (a: google.maps.StreetViewPanoramaData|null,
             b: google.maps.StreetViewStatus) => void):
        Promise<google.maps.StreetViewResponse>;
  }
  /**
   * Identifiers to limit Street View searches to selected sources. These values
   * are specified as strings. For example, <code>'outdoor'</code>.
   *
   * Access by calling `const {StreetViewSource} = await
   * google.maps.importLibrary("streetView")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum StreetViewSource {
    /**
     * Uses the default sources of Street View, searches will not be limited to
     * specific sources.
     */
    DEFAULT = 'default',
    /**
     * Limits Street View searches to outdoor collections. Indoor collections
     * are not included in search results. Note also that the search only
     * returns panoramas where it&#39;s possible to determine whether
     * they&#39;re indoors or outdoors. For example, PhotoSpheres are not
     * returned because it&#39;s unknown whether they are indoors or outdoors.
     */
    OUTDOOR = 'outdoor',
  }
  /**
   * The status returned by the <code>StreetViewService</code> on completion of
   * a Street View request. These can be specified by value, or by using the
   * constant&#39;s name. For example, <code>'OK'</code> or
   * <code>google.maps.StreetViewStatus.OK</code>.
   *
   * Access by calling `const {StreetViewStatus} = await
   * google.maps.importLibrary("streetView")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum StreetViewStatus {
    /**
     * The request was successful.
     */
    OK = 'OK',
    /**
     * The request could not be successfully processed, yet the exact reason for
     * failure is unknown.
     */
    UNKNOWN_ERROR = 'UNKNOWN_ERROR',
    /**
     * There are no panoramas found that match the search criteria.
     */
    ZERO_RESULTS = 'ZERO_RESULTS',
  }
  /**
   * The properties of the tile set used in a Street View panorama.
   */
  export interface StreetViewTileData {
    /**
     * The heading (in degrees) at the center of the panoramic tiles.
     */
    centerHeading: number;
    /**
     * Gets the tile image URL for the specified tile.<br/> This is a custom
     * method which you must implement, to supply your custom tiles. The API
     * calls this method, supplying the following parameters:</br>
     * <code>pano</code> is the panorama ID of the Street View tile.<br/>
     * <code>tileZoom</code> is the zoom level of the tile.<br/>
     * <code>tileX</code> is the x-coordinate of the tile.<br/>
     * <code>tileY</code> is the y-coordinate of the tile.<br/> Your custom
     * method must return the URL for the tile image.<br/>
     */
    getTileUrl(pano: string, tileZoom: number, tileX: number, tileY: number):
        string;
    /**
     * The size (in pixels) at which tiles will be rendered.
     */
    tileSize: google.maps.Size;
    /**
     * The size (in pixels) of the whole panorama&#39;s &quot;world&quot;.
     */
    worldSize: google.maps.Size;
  }
  /**
   * The possible positions of the stroke on a polygon.
   *
   * Access by calling `const {StrokePosition} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum StrokePosition {
    /**
     * The stroke is centered on the polygon&#39;s path, with half the stroke
     * inside the polygon and half the stroke outside the polygon.
     */
    CENTER = 0.0,
    /**
     * The stroke lies inside the polygon.
     */
    INSIDE = 1.0,
    /**
     * The stroke lies outside the polygon.
     */
    OUTSIDE = 2.0,
  }
  /**
   * Creates a <code>MapType</code> with a custom style.
   *
   * Access by calling `const {StyledMapType} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class StyledMapType extends google.maps.MVCObject implements
      google.maps.MapType {
    /**
     * Creates a <code>MapType</code> with a custom style.
     *
     * Access by calling `const {StyledMapType} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(
        styles: (google.maps.MapTypeStyle|null)[]|null,
        options?: google.maps.StyledMapTypeOptions|null);
    alt: string;
    getTile(
        tileCoord: google.maps.Point|null, zoom: number,
        ownerDocument: Document|null): Element|null;
    maxZoom: number;
    minZoom: number;
    name: string;
    projection: google.maps.Projection|null;
    radius: number;
    releaseTile(tile: Element|null): void;
    tileSize: google.maps.Size|null;
  }
  /**
   * This class is used to specify options when creating a
   * <code>StyledMapType</code>. These options cannot be changed after the
   * <code>StyledMapType</code> is instantiated.
   */
  export interface StyledMapTypeOptions {
    /**
     * Text to display when this <code>MapType</code>&#39;s button is hovered
     * over in the map type control.
     */
    alt?: string|null;
    /**
     * The maximum zoom level for the map when displaying this
     * <code>MapType</code>. Optional.
     */
    maxZoom?: number|null;
    /**
     * The minimum zoom level for the map when displaying this
     * <code>MapType</code>. Optional.
     */
    minZoom?: number|null;
    /**
     * The name to display in the map type control.
     */
    name?: string|null;
  }
  /**
   * Describes a symbol, which consists of a vector path with styling. A symbol
   * can be used as the icon of a marker, or placed on a polyline.
   */
  export interface Symbol {
    /**
     * The position of the symbol relative to the marker or polyline. The
     * coordinates of the symbol&#39;s path are translated left and up by the
     * anchor&#39;s x and y coordinates respectively. The position is expressed
     * in the same coordinate system as the symbol&#39;s path.
     * @defaultValue <code>google.maps.Point(0,0)</code>
     */
    anchor?: google.maps.Point|null;
    /**
     * The symbol&#39;s fill color. All CSS3 colors are supported except for
     * extended named colors. For symbol markers, this defaults to
     * &#39;black&#39;. For symbols on polylines, this defaults to the stroke
     * color of the corresponding polyline.
     */
    fillColor?: string|null;
    /**
     * The symbol&#39;s fill opacity.
     * @defaultValue <code>0</code>
     */
    fillOpacity?: number|null;
    /**
     * The origin of the label relative to the origin of the path, if label is
     * supplied by the marker. The origin is expressed in the same coordinate
     * system as the symbol&#39;s path. This property is unused for symbols on
     * polylines.
     * @defaultValue <code>google.maps.Point(0,0)</code>
     */
    labelOrigin?: google.maps.Point|null;
    /**
     * The symbol&#39;s path, which is a built-in symbol path, or a custom path
     * expressed using <a
     * href="http://www.w3.org/TR/SVG/paths.html#PathData">SVG path
     * notation</a>. Required.
     */
    path: google.maps.SymbolPath|string;
    /**
     * The angle by which to rotate the symbol, expressed clockwise in degrees.
     * A symbol in an <code>IconSequence</code> where <code>fixedRotation</code>
     * is <code>false</code> is rotated relative to the angle of the edge on
     * which it lies.
     * @defaultValue <code>0</code>
     */
    rotation?: number|null;
    /**
     * The amount by which the symbol is scaled in size. For symbol markers,
     * this defaults to 1; after scaling, the symbol may be of any size. For
     * symbols on a polyline, this defaults to the stroke weight of the
     * polyline; after scaling, the symbol must lie inside a square 22 pixels in
     * size centered at the symbol&#39;s anchor.
     */
    scale?: number|null;
    /**
     * The symbol&#39;s stroke color. All CSS3 colors are supported except for
     * extended named colors. For symbol markers, this defaults to
     * &#39;black&#39;. For symbols on a polyline, this defaults to the stroke
     * color of the polyline.
     */
    strokeColor?: string|null;
    /**
     * The symbol&#39;s stroke opacity. For symbol markers, this defaults to 1.
     * For symbols on a polyline, this defaults to the stroke opacity of the
     * polyline.
     */
    strokeOpacity?: number|null;
    /**
     * The symbol&#39;s stroke weight.
     * @defaultValue The {@link google.maps.Symbol.scale} of the symbol.
     */
    strokeWeight?: number|null;
  }
  /**
   * Built-in symbol paths.
   *
   * Access by calling `const {SymbolPath} = await
   * google.maps.importLibrary("core")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum SymbolPath {
    /**
     * A backward-pointing closed arrow.
     */
    BACKWARD_CLOSED_ARROW = 0.0,
    /**
     * A backward-pointing open arrow.
     */
    BACKWARD_OPEN_ARROW = 1.0,
    /**
     * A circle.
     */
    CIRCLE = 2.0,
    /**
     * A forward-pointing closed arrow.
     */
    FORWARD_CLOSED_ARROW = 3.0,
    /**
     * A forward-pointing open arrow.
     */
    FORWARD_OPEN_ARROW = 4.0,
  }
  /**
   * A representation of time as a Date object, a localized string, and a time
   * zone.
   */
  export interface Time {
    /**
     * A string representing the time&#39;s value. The time is displayed in the
     * time zone of the transit stop.
     */
    text: string;
    /**
     * The time zone in which this stop lies. The value is the name of the time
     * zone as defined in the IANA Time Zone Database, e.g.
     * &quot;America/New_York&quot;.
     */
    time_zone: string;
    /**
     * The time of this departure or arrival, specified as a JavaScript Date
     * object.
     */
    value: Date;
  }
  /**
   * A traffic layer.
   *
   * Access by calling `const {TrafficLayer} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class TrafficLayer extends google.maps.MVCObject {
    /**
     * A traffic layer.
     *
     * Access by calling `const {TrafficLayer} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(opts?: google.maps.TrafficLayerOptions|null);
    /**
     * Returns the map on which this layer is displayed.
     */
    getMap(): google.maps.Map|null;
    /**
     * Renders the layer on the specified map. If map is set to
     * <code>null</code>, the layer will be removed.
     */
    setMap(map: google.maps.Map|null): void;
    setOptions(options: google.maps.TrafficLayerOptions|null): void;
  }
  /**
   * TrafficLayerOptions object used to define the properties that can be set on
   * a TrafficLayer.
   */
  export interface TrafficLayerOptions {
    /**
     * Whether the traffic layer refreshes with updated information
     * automatically.
     * @defaultValue <code>true</code>
     */
    autoRefresh?: boolean|null;
    /**
     * Map on which to display the traffic layer.
     */
    map?: google.maps.Map|null;
  }
  /**
   * The assumptions to use when predicting duration in traffic. Specified as
   * part of a <code><a href="#DirectionsRequest">DirectionsRequest</a></code>
   * or <code><a href="#DistanceMatrixRequest">DistanceMatrixRequest</a></code>.
   * Specify these by value, or by using the constant&#39;s name. For example,
   * <code>'bestguess'</code> or
   * <code>google.maps.TrafficModel.BEST_GUESS</code>.
   *
   * Access by calling `const {TrafficModel} = await
   * google.maps.importLibrary("routes")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum TrafficModel {
    /**
     * Use historical traffic data to best estimate the time spent in traffic.
     */
    BEST_GUESS = 'bestguess',
    /**
     * Use historical traffic data to make an optimistic estimate of what the
     * duration in traffic will be.
     */
    OPTIMISTIC = 'optimistic',
    /**
     * Use historical traffic data to make a pessimistic estimate of what the
     * duration in traffic will be.
     */
    PESSIMISTIC = 'pessimistic',
  }
  /**
   * Information about an agency that operates a transit line.
   */
  export interface TransitAgency {
    /**
     * The name of this transit agency.
     */
    name: string;
    /**
     * The transit agency&#39;s phone number.
     */
    phone: string;
    /**
     * The transit agency&#39;s URL.
     */
    url: string;
  }
  /**
   * Details about the departure, arrival, and mode of transit used in this
   * step.
   */
  export interface TransitDetails {
    /**
     * The arrival stop of this transit step.
     */
    arrival_stop: google.maps.TransitStop;
    /**
     * The arrival time of this step, specified as a Time object.
     */
    arrival_time: google.maps.Time;
    /**
     * The departure stop of this transit step.
     */
    departure_stop: google.maps.TransitStop;
    /**
     * The departure time of this step, specified as a Time object.
     */
    departure_time: google.maps.Time;
    /**
     * The direction in which to travel on this line, as it is marked on the
     * vehicle or at the departure stop.
     */
    headsign: string;
    /**
     * The expected number of seconds between equivalent vehicles at this stop.
     */
    headway: number;
    /**
     * Details about the transit line used in this step.
     */
    line: google.maps.TransitLine;
    /**
     * The number of stops on this step. Includes the arrival stop, but not the
     * departure stop.
     */
    num_stops: number;
    /**
     * The text that appears in schedules and sign boards to identify a transit
     * trip to passengers, for example, to identify train numbers for commuter
     * rail trips. The text uniquely identifies a trip within a service day.
     */
    trip_short_name: string;
  }
  /**
   * A fare of a <code><a href="#DirectionsResult">DirectionsRoute</a> </code>
   * consisting of value and currency.
   */
  export interface TransitFare {
    /**
     * An <a href="http://en.wikipedia.org/wiki/ISO_4217">ISO 4217 currency
     * code</a> indicating the currency in which the fare is expressed.
     */
    currency: string;
    /**
     * The numerical value of the fare, expressed in the given
     * <code>currency</code>.
     */
    value: number;
  }
  /**
   * A transit layer.
   *
   * Access by calling `const {TransitLayer} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class TransitLayer extends google.maps.MVCObject {
    /**
     * Returns the map on which this layer is displayed.
     */
    getMap(): google.maps.Map|null;
    /**
     * Renders the layer on the specified map. If map is set to
     * <code>null</code>, the layer will be removed.
     */
    setMap(map: google.maps.Map|null): void;
  }
  /**
   * Information about the transit line that operates this transit step.
   */
  export interface TransitLine {
    /**
     * The transit agency that operates this transit line.
     */
    agencies: (google.maps.TransitAgency|null)[]|null;
    /**
     * The color commonly used in signage for this transit line, represented as
     * a hex string.
     */
    color: string;
    /**
     * The URL for an icon associated with this line.
     */
    icon: string;
    /**
     * The full name of this transit line, e.g. &quot;8 Avenue Local&quot;.
     */
    name: string;
    /**
     * The short name of this transit line, e.g. &quot;E&quot;.
     */
    short_name: string;
    /**
     * The text color commonly used in signage for this transit line,
     * represented as a hex string.
     */
    text_color: string;
    /**
     * The agency&#39;s URL which is specific to this transit line.
     */
    url: string;
    /**
     * The type of vehicle used, e.g. train or bus.
     */
    vehicle: google.maps.TransitVehicle;
  }
  /**
   * The valid transit mode e.g. bus that can be specified in a <i><code><a
   * href="#TransitOptions">TransitOptions</a></code></i>. Specify these by
   * value, or by using the constant&#39;s name. For example, <code>'BUS'</code>
   * or <code>google.maps.TransitMode.BUS</code>.
   *
   * Access by calling `const {TransitMode} = await
   * google.maps.importLibrary("routes")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum TransitMode {
    /**
     * Specifies bus as a preferred mode of transit.
     */
    BUS = 'BUS',
    /**
     * Specifies rail as a preferred mode of transit.
     */
    RAIL = 'RAIL',
    /**
     * Specifies subway as a preferred mode of transit.
     */
    SUBWAY = 'SUBWAY',
    /**
     * Specifies train as a preferred mode of transit.
     */
    TRAIN = 'TRAIN',
    /**
     * Specifies tram as a preferred mode of transit.
     */
    TRAM = 'TRAM',
  }
  /**
   * The TransitOptions object to be included in a <code><a
   * href="#DirectionsRequest">DirectionsRequest</a></code> when the travel mode
   * is set to TRANSIT.
   */
  export interface TransitOptions {
    /**
     * The desired arrival time for the route, specified as a Date object. The
     * Date object measures time in milliseconds since 1 January 1970. If
     * arrival time is specified, departure time is ignored.
     */
    arrivalTime?: Date|null;
    /**
     * The desired departure time for the route, specified as a Date object. The
     * Date object measures time in milliseconds since 1 January 1970. If
     * neither departure time nor arrival time is specified, the time is assumed
     * to be &quot;now&quot;.
     */
    departureTime?: Date|null;
    /**
     * One or more preferred modes of transit, such as bus or train. If no
     * preference is given, the API returns the default best route.
     */
    modes?: google.maps.TransitMode[]|null;
    /**
     * A preference that can bias the choice of transit route, such as less
     * walking. If no preference is given, the API returns the default best
     * route.
     */
    routingPreference?: google.maps.TransitRoutePreference|null;
  }
  /**
   * The valid transit route type that can be specified in a <i><code><a
   * href="#TransitOptions">TransitOptions</a></code></i>. Specify these by
   * value, or by using the constant&#39;s name. For example,
   * <code>'LESS_WALKING'</code> or
   * <code>google.maps.TransitRoutePreference.LESS_WALKING</code>.
   *
   * Access by calling `const {TransitRoutePreference} = await
   * google.maps.importLibrary("routes")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum TransitRoutePreference {
    /**
     * Specifies that the calculated route should prefer a limited number of
     * transfers.
     */
    FEWER_TRANSFERS = 'FEWER_TRANSFERS',
    /**
     * Specifies that the calculated route should prefer limited amounts of
     * walking.
     */
    LESS_WALKING = 'LESS_WALKING',
  }
  /**
   * Details about a transit stop or station.
   */
  export interface TransitStop {
    /**
     * The location of this stop.
     */
    location: google.maps.LatLng;
    /**
     * The name of this transit stop.
     */
    name: string;
  }
  /**
   * Information about the vehicle that operates on a transit line.
   */
  export interface TransitVehicle {
    /**
     * A URL for an icon that corresponds to the type of vehicle used on this
     * line.
     */
    icon: string;
    /**
     * A URL for an icon that corresponds to the type of vehicle used in this
     * region instead of the more general icon.
     */
    local_icon: string;
    /**
     * A name for this type of TransitVehicle, e.g. &quot;Train&quot; or
     * &quot;Bus&quot;.
     */
    name: string;
    /**
     * The type of vehicle used, e.g. train, bus, or ferry.
     */
    type: google.maps.VehicleType;
  }
  /**
   * The valid travel modes that can be specified in a
   * <code>DirectionsRequest</code> as well as the travel modes returned in a
   * <code>DirectionsStep</code>. Specify these by value, or by using the
   * constant&#39;s name. For example, <code>'BICYCLING'</code> or
   * <code>google.maps.TravelMode.BICYCLING</code>.
   *
   * Access by calling `const {TravelMode} = await
   * google.maps.importLibrary("routes")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum TravelMode {
    /**
     * Specifies a bicycling directions request.
     */
    BICYCLING = 'BICYCLING',
    /**
     * Specifies a driving directions request.
     */
    DRIVING = 'DRIVING',
    /**
     * Specifies a transit directions request.
     */
    TRANSIT = 'TRANSIT',
    /**
     * Specifies a walking directions request.
     */
    WALKING = 'WALKING',
  }
  /**
   * The valid unit systems that can be specified in a <i><code><a
   * href="#DirectionsRequest">DirectionsRequest</a></code></i>.
   *
   * Access by calling `const {UnitSystem} = await
   * google.maps.importLibrary("core")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum UnitSystem {
    /**
     * Specifies that distances in the <code>DirectionsResult</code> should be
     * expressed in imperial units.
     */
    IMPERIAL = 0.0,
    /**
     * Specifies that distances in the <code>DirectionsResult</code> should be
     * expressed in metric units.
     */
    METRIC = 1.0,
  }
  /**
   * Possible values for vehicle types.
   *
   * Access by calling `const {VehicleType} = await
   * google.maps.importLibrary("routes")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum VehicleType {
    /**
     * Bus.
     */
    BUS = 'BUS',
    /**
     * A vehicle that operates on a cable, usually on the ground. Aerial cable
     * cars may be of the type <code>GONDOLA_LIFT</code>.
     */
    CABLE_CAR = 'CABLE_CAR',
    /**
     * Commuter rail.
     */
    COMMUTER_TRAIN = 'COMMUTER_TRAIN',
    /**
     * Ferry.
     */
    FERRY = 'FERRY',
    /**
     * A vehicle that is pulled up a steep incline by a cable.
     */
    FUNICULAR = 'FUNICULAR',
    /**
     * An aerial cable car.
     */
    GONDOLA_LIFT = 'GONDOLA_LIFT',
    /**
     * Heavy rail.
     */
    HEAVY_RAIL = 'HEAVY_RAIL',
    /**
     * High speed train.
     */
    HIGH_SPEED_TRAIN = 'HIGH_SPEED_TRAIN',
    /**
     * Intercity bus.
     */
    INTERCITY_BUS = 'INTERCITY_BUS',
    /**
     * Light rail.
     */
    METRO_RAIL = 'METRO_RAIL',
    /**
     * Monorail.
     */
    MONORAIL = 'MONORAIL',
    /**
     * Other vehicles.
     */
    OTHER = 'OTHER',
    /**
     * Rail.
     */
    RAIL = 'RAIL',
    /**
     * Share taxi is a sort of bus transport with ability to drop off and pick
     * up passengers anywhere on its route. Generally share taxi uses minibus
     * vehicles.
     */
    SHARE_TAXI = 'SHARE_TAXI',
    /**
     * Underground light rail.
     */
    SUBWAY = 'SUBWAY',
    /**
     * Above ground light rail.
     */
    TRAM = 'TRAM',
    /**
     * Trolleybus.
     */
    TROLLEYBUS = 'TROLLEYBUS',
  }
  /**
   * Contains the four points defining the four-sided polygon that is the
   * visible region of the map. On a vector map this polygon can be a trapezoid
   * instead of a rectangle, when a vector map has tilt.
   */
  export interface VisibleRegion {
    farLeft: google.maps.LatLng;
    farRight: google.maps.LatLng;
    /**
     * The smallest bounding box that includes the visible region.
     */
    latLngBounds: google.maps.LatLngBounds;
    nearLeft: google.maps.LatLng;
    nearRight: google.maps.LatLng;
  }
  export interface VisualizationLibrary {
    HeatmapLayer: typeof google.maps.visualization.HeatmapLayer;
  }
  /**
   * Drawing options.
   */
  export interface WebGLDrawOptions {
    /**
     * The WebGLRenderingContext on which to render this WebGLOverlayView.
     */
    gl: WebGLRenderingContext;
    /**
     * The matrix transformation from camera space to latitude/longitude
     * coordinates.
     */
    transformer: google.maps.CoordinateTransformer;
  }
  /**
   * The WebGL Overlay View provides direct access to the same WebGL rendering
   * context Google Maps Platform uses to render the vector basemap. This use of
   * a shared rendering context provides benefits such as depth occlusion with
   * 3D building geometry, and the ability to sync 2D/3D content with basemap
   * rendering. <br><br>With WebGL Overlay View you can add content to your maps
   * using WebGL directly, or popular Graphics libraries like Three.js or
   * deck.gl. To use the overlay, you can extend
   * <code>google.maps.WebGLOverlayView</code> and provide an implementation for
   * each of the following lifecycle hooks: {@link
   * google.maps.WebGLOverlayView.onAdd}, {@link
   * google.maps.WebGLOverlayView.onContextRestored}, {@link
   * google.maps.WebGLOverlayView.onDraw}, {@link
   * google.maps.WebGLOverlayView.onContextLost} and {@link
   * google.maps.WebGLOverlayView.onRemove}. <br><br>You must call {@link
   * google.maps.WebGLOverlayView.setMap} with a valid {@link google.maps.Map}
   * object to trigger the call to the <code>onAdd()</code> method and
   * <code>setMap(null)</code> in order to trigger the <code>onRemove()</code>
   * method. The <code>setMap()</code> method can be called at the time of
   * construction or at any point afterward when the overlay should be re-shown
   * after removing. The <code>onDraw()</code> method will then be called
   * whenever a map property changes that could change the position of the
   * element, such as zoom, center, or map type. WebGLOverlayView may only be
   * added to a vector map having a {@link google.maps.MapOptions.mapId}.
   *
   * Access by calling `const {WebGLOverlayView} = await
   * google.maps.importLibrary("maps")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class WebGLOverlayView extends google.maps.MVCObject {
    getMap(): google.maps.Map|null|undefined;
    /**
     * Implement this method to fetch or create intermediate data structures
     * before the overlay is drawn that don’t require immediate access to the
     * WebGL rendering context. This method must be implemented to render.
     */
    onAdd(): void;
    /**
     * This method is called when the rendering context is lost for any reason,
     * and is where you should clean up any pre-existing GL state, since it is
     * no longer needed.
     */
    onContextLost(): void;
    /**
     * This method is called once the rendering context is available. Use it to
     * initialize or bind any WebGL state such as shaders or buffer objects.
     * @param options that allow developers to restore the GL context.
     */
    onContextRestored(options: google.maps.WebGLStateOptions): void;
    /**
     * Implement this method to draw WebGL content directly on the map. Note
     * that if the overlay needs a new frame drawn then call {@link
     * google.maps.WebGLOverlayView.requestRedraw}.
     * @param options that allow developers to render content to an associated
     *     Google basemap.
     */
    onDraw(options: google.maps.WebGLDrawOptions): void;
    /**
     * This method is called when the overlay is removed from the map with
     * <code>WebGLOverlayView.setMap(null)</code>, and is where you should
     * remove all intermediate objects. This method must be implemented to
     * render.
     */
    onRemove(): void;
    /**
     * Implement this method to handle any GL state updates outside of the
     * render animation frame.
     * @param options that allow developerse to restore the GL context.
     */
    onStateUpdate(options: google.maps.WebGLStateOptions): void;
    /**
     * Triggers the map to redraw a frame.
     */
    requestRedraw(): void;
    /**
     * Triggers the map to update GL state.
     */
    requestStateUpdate(): void;
    /**
     * Adds the overlay to the map.
     * @param map The map to access the div, model and view state.
     */
    setMap(map?: google.maps.Map|null): void;
  }
  /**
   * GL state options.
   */
  export interface WebGLStateOptions {
    /**
     * The WebGLRenderingContext on which to render this WebGLOverlayView.
     */
    gl: WebGLRenderingContext;
  }
  /**
   * Options for the rendering of the zoom control.
   */
  export interface ZoomControlOptions {
    /**
     * Position id. Used to specify the position of the control on the map. The
     * default position is <code>TOP_LEFT</code>.
     */
    position?: google.maps.ControlPosition|null;
  }
  /**
   * Namespace for all public event functions
   *
   * Access by calling `const {event} = await
   * google.maps.importLibrary("core")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class event {
    /**
     * Cross browser event handler registration. This listener is removed by
     * calling removeListener(handle) for the handle that is returned by this
     * function.
     * @deprecated <code>google.maps.event.addDomListener()</code> is
     *     deprecated, use the standard <a
     *     href="https://developer.mozilla.org/docs/Web/API/EventTarget/addEventListener">addEventListener()</a>
     *     method instead. The feature will continue to work and there is no
     *     plan to decommission it.
     */
    static addDomListener(
        this: any, instance: object, eventName: string, handler: Function,
        capture?: boolean): google.maps.MapsEventListener;
    /**
     * Wrapper around addDomListener that removes the listener after the first
     * event.
     * @deprecated <code>google.maps.event.addDomListenerOnce()</code> is
     *     deprecated, use the standard <a
     *     href="https://developer.mozilla.org/docs/Web/API/EventTarget/addEventListener">addEventListener()</a>
     *     method instead. The feature will continue to work and there is no
     *     plan to decommission it.
     */
    static addDomListenerOnce(
        this: any, instance: object, eventName: string, handler: Function,
        capture?: boolean): google.maps.MapsEventListener;
    /**
     * Adds the given listener function to the given event name for the given
     * object instance. Returns an identifier for this listener that can be used
     * with removeListener().
     */
    static addListener(
        this: any, instance: object, eventName: string,
        handler: Function): google.maps.MapsEventListener;
    /**
     * Like addListener, but the handler removes itself after handling the first
     * event.
     */
    static addListenerOnce(
        this: any, instance: object, eventName: string,
        handler: Function): google.maps.MapsEventListener;
    /**
     * Removes all listeners for all events for the given instance.
     */
    static clearInstanceListeners(this: any, instance: object): void;
    /**
     * Removes all listeners for the given event for the given instance.
     */
    static clearListeners(this: any, instance: object, eventName: string): void;
    /**
     * Returns if there are listeners for the given event on the given instance.
     * Can be used to to save the computation of expensive event details.
     */
    static hasListeners(this: any, instance: object, eventName: string):
        boolean;
    /**
     * Removes the given listener, which should have been returned by
     * addListener above. Equivalent to calling <code>listener.remove()</code>.
     */
    static removeListener(this: any, listener: google.maps.MapsEventListener):
        void;
    /**
     * Triggers the given event. All arguments after eventName are passed as
     * arguments to the listeners.
     */
    static trigger(
        this: any, instance: object, eventName: string,
        ...eventArgs: any[]): void;
  }
  /**
   * Loads a <a
   * href="https://developers.google.com/maps/documentation/javascript/libraries">library</a>
   * of the Maps JavaScript API, resolving with the direct members of that API
   * (without namespacing). (When loaded, libraries also add themselves to the
   * global <code>google.maps</code> namespace, though using the global
   * namespace is not generally recommended.)
   */
  export function importLibrary(libraryName: string):
      Promise<google.maps.CoreLibrary|google.maps.MapsLibrary|
              google.maps.PlacesLibrary|google.maps.GeocodingLibrary|
              google.maps.RoutesLibrary|google.maps.MarkerLibrary|
              google.maps.GeometryLibrary|google.maps.ElevationLibrary|
              google.maps.StreetViewLibrary|
              google.maps.JourneySharingLibrary|
              google.maps.DrawingLibrary|google.maps.VisualizationLibrary>;
  /**
   * Google Maps JavaScript API version loaded by the browser. See <a
   * href="https://developers.google.com/maps/documentation/javascript/versions">https://developers.google.com/maps/documentation/javascript/versions</a>
   */
  export let version: string;
}
declare namespace google.maps.Data {
  /**
   * The properties of a <code>addfeature</code> event.
   */
  export interface AddFeatureEvent {
    /**
     * The feature that was added to the <code>FeatureCollection</code>.
     */
    feature: google.maps.Data.Feature;
  }
  /**
   * DataOptions object used to define the properties that a developer can set
   * on a <code>Data</code> object.
   */
  export interface DataOptions {
    /**
     * The position of the drawing controls on the map.
     * @defaultValue {@link google.maps.ControlPosition.TOP_LEFT}
     */
    controlPosition?: google.maps.ControlPosition;
    /**
     * Describes which drawing modes are available for the user to select, in
     * the order they are displayed. This should not include the
     * <code>null</code> drawing mode, which is added by default. If
     * <code>null</code>, drawing controls are disabled and not displayed.
     * Possible drawing modes are <code>"Point"</code>,
     * <code>"LineString"</code> or <code>"Polygon"</code>.
     * @defaultValue <code>null</code>
     */
    controls?: string[]|null;
    /**
     * The current drawing mode of the given Data layer. A drawing mode of
     * <code>null</code> means that the user can interact with the map as
     * normal, and clicks do not draw anything. Possible drawing modes are
     * <code>null</code>, <code>"Point"</code>, <code>"LineString"</code> or
     * <code>"Polygon"</code>.
     * @defaultValue <code>null</code>
     */
    drawingMode?: string|null;
    /**
     * When drawing is enabled and a user draws a Geometry (a Point, Line String
     * or Polygon), this function is called with that Geometry and should return
     * a Feature that is to be added to the Data layer. If a featureFactory is
     * not supplied, a Feature with no id and no properties will be created from
     * that Geometry instead. Defaults to <code>null</code>.
     */
    featureFactory?:
        ((a: google.maps.Data.Geometry) => google.maps.Data.Feature)|null;
    /**
     * Map on which to display the features in the collection.
     */
    map: google.maps.Map;
    /**
     * Style for all features in the collection. For more details, see the
     * <code><a href='#Data'>setStyle()</a></code> method above.
     */
    style?: (google.maps.Data.StylingFunction)|google.maps.Data.StyleOptions;
  }
  /**
   * A feature has a geometry, an id, and a set of properties.
   *
   * Access by calling `const {Data} = await google.maps.importLibrary("maps")`.
   * See https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Feature {
    /**
     * A feature has a geometry, an id, and a set of properties.
     *
     * Access by calling `const {Data} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(options?: google.maps.Data.FeatureOptions|null);
    /**
     * Repeatedly invokes the given function, passing a property value and name
     * on each invocation. The order of iteration through the properties is
     * undefined.
     */
    forEachProperty(callback: (a: any, b: string) => void): void;
    /**
     * Returns the feature&#39;s geometry.
     */
    getGeometry(): google.maps.Data.Geometry|null;
    /**
     * Returns the feature ID.
     */
    getId(): number|string|undefined;
    /**
     * Returns the value of the requested property, or <code>undefined</code> if
     * the property does not exist.
     */
    getProperty(name: string): any;
    /**
     * Removes the property with the given name.
     */
    removeProperty(name: string): void;
    /**
     * Sets the feature&#39;s geometry.
     */
    setGeometry(newGeometry: google.maps.Data.Geometry|null|
                google.maps.LatLng|google.maps.LatLngLiteral): void;
    /**
     * Sets the value of the specified property. If <code>newValue</code> is
     * <code>undefined</code> this is equivalent to calling
     * <code>removeProperty</code>.
     */
    setProperty(name: string, newValue: any): void;
    /**
     * Exports the feature to a GeoJSON object.
     */
    toGeoJson(callback: (a: object) => void): void;
  }
  /**
   * Optional parameters for creating <code>Data.Feature</code> objects.
   */
  export interface FeatureOptions {
    /**
     * The feature geometry. If none is specified when a feature is constructed,
     * the feature&#39;s geometry will be <code>null</code>. If a
     * <code>LatLng</code> object or <code>LatLngLiteral</code> is given, this
     * will be converted to a <code>Data.Point</code> geometry.
     */
    geometry?: google.maps.Data.Geometry|null|google.maps.LatLng|
        google.maps.LatLngLiteral;
    /**
     * Feature ID is optional. If provided, it can be used to look up the
     * feature in a <code>Data</code> object using the
     * <code>getFeatureById()</code> method. Note that a feature&#39;s ID cannot
     * be subsequently changed.
     */
    id?: number|string;
    /**
     * The feature properties. This is an arbitrary mapping of property names to
     * values.
     */
    properties?: object|null;
  }
  /**
   * Optional parameters for importing GeoJSON.
   */
  export interface GeoJsonOptions {
    /**
     * The name of the Feature property to use as the feature ID. If not
     * specified, the GeoJSON Feature id will be used.
     */
    idPropertyName?: string|null;
  }
  /**
   * A superclass for the various geometry objects.
   */
  export interface Geometry {
    /**
     * Repeatedly invokes the given function, passing a point from the geometry
     * to the function on each invocation.
     */
    forEachLatLng(callback: (a: google.maps.LatLng) => void): void;
    /**
     * Returns the type of the geometry object. Possibilities are
     * <code>"Point"</code>, <code>"MultiPoint"</code>,
     * <code>"LineString"</code>, <code>"MultiLineString"</code>,
     * <code>"LinearRing"</code>, <code>"Polygon"</code>,
     * <code>"MultiPolygon"</code>, or <code>"GeometryCollection"</code>.
     */
    getType(): string;
  }
  /**
   * A GeometryCollection contains a number of geometry objects. Any
   * <code>LatLng</code> or <code>LatLngLiteral</code> objects are automatically
   * converted to <code>Data.Point</code> geometry objects.
   *
   * Access by calling `const {Data} = await google.maps.importLibrary("maps")`.
   * See https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class GeometryCollection implements google.maps.Data.Geometry {
    /**
     * A GeometryCollection contains a number of geometry objects. Any
     * <code>LatLng</code> or <code>LatLngLiteral</code> objects are
     * automatically converted to <code>Data.Point</code> geometry objects.
     *
     * Access by calling `const {Data} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(elements: (google.maps.Data.Geometry|google.maps.LatLng|
                           google.maps.LatLngLiteral)[]);
    forEachLatLng(callback: (a: google.maps.LatLng) => void): void;
    /**
     * Returns an array of the contained geometry objects. A new array is
     * returned each time <code>getArray()</code> is called.
     */
    getArray(): google.maps.Data.Geometry[];
    /**
     * Returns the <code>n</code>-th contained geometry object.
     */
    getAt(n: number): google.maps.Data.Geometry;
    /**
     * Returns the number of contained geometry objects.
     */
    getLength(): number;
    /**
     * Returns the string <code>"GeometryCollection"</code>.
     */
    getType(): string;
  }
  /**
   * A LineString geometry contains a number of <code>LatLng</code>s.
   *
   * Access by calling `const {Data} = await google.maps.importLibrary("maps")`.
   * See https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class LineString implements google.maps.Data.Geometry {
    /**
     * A LineString geometry contains a number of <code>LatLng</code>s.
     *
     * Access by calling `const {Data} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(elements: (google.maps.LatLng|google.maps.LatLngLiteral)[]);
    forEachLatLng(callback: (a: google.maps.LatLng) => void): void;
    /**
     * Returns an array of the contained <code>LatLngs</code>. A new array is
     * returned each time <code>getArray()</code> is called.
     */
    getArray(): google.maps.LatLng[];
    /**
     * Returns the <code>n</code>-th contained <code>LatLng</code>.
     */
    getAt(n: number): google.maps.LatLng;
    /**
     * Returns the number of contained <code>LatLng</code>s.
     */
    getLength(): number;
    /**
     * Returns the string <code>"LineString"</code>.
     */
    getType(): string;
  }
  /**
   * A LinearRing geometry contains a number of <code>LatLng</code>s,
   * representing a closed LineString. There is no need to make the first
   * <code>LatLng</code> equal to the last <code>LatLng</code>. The LinearRing
   * is closed implicitly.
   *
   * Access by calling `const {Data} = await google.maps.importLibrary("maps")`.
   * See https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class LinearRing implements google.maps.Data.Geometry {
    /**
     * A LinearRing geometry contains a number of <code>LatLng</code>s,
     * representing a closed LineString. There is no need to make the first
     * <code>LatLng</code> equal to the last <code>LatLng</code>. The LinearRing
     * is closed implicitly.
     *
     * Access by calling `const {Data} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(elements: (google.maps.LatLng|google.maps.LatLngLiteral)[]);
    forEachLatLng(callback: (a: google.maps.LatLng) => void): void;
    /**
     * Returns an array of the contained <code>LatLng</code>s. A new array is
     * returned each time <code>getArray()</code> is called.
     */
    getArray(): google.maps.LatLng[];
    /**
     * Returns the <code>n</code>-th contained <code>LatLng</code>.
     */
    getAt(n: number): google.maps.LatLng;
    /**
     * Returns the number of contained <code>LatLng</code>s.
     */
    getLength(): number;
    /**
     * Returns the string <code>"LinearRing"</code>.
     */
    getType(): string;
  }
  /**
   * This object is passed to mouse event handlers on a <code>Data</code>
   * object.
   */
  export interface MouseEvent extends google.maps.MapMouseEvent {
    /**
     * The feature which generated the mouse event.
     */
    feature: google.maps.Data.Feature;
  }
  /**
   * A MultiLineString geometry contains a number of <code>LineString</code>s.
   *
   * Access by calling `const {Data} = await google.maps.importLibrary("maps")`.
   * See https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class MultiLineString implements google.maps.Data.Geometry {
    /**
     * A MultiLineString geometry contains a number of <code>LineString</code>s.
     *
     * Access by calling `const {Data} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(elements: (google.maps.Data.LineString|
                           (google.maps.LatLng|google.maps.LatLngLiteral)[])[]);
    forEachLatLng(callback: (a: google.maps.LatLng) => void): void;
    /**
     * Returns an array of the contained <code>Data.LineString</code>s. A new
     * array is returned each time <code>getArray()</code> is called.
     */
    getArray(): google.maps.Data.LineString[];
    /**
     * Returns the <code>n</code>-th contained <code>Data.LineString</code>.
     */
    getAt(n: number): google.maps.Data.LineString;
    /**
     * Returns the number of contained <code>Data.LineString</code>s.
     */
    getLength(): number;
    /**
     * Returns the string <code>"MultiLineString"</code>.
     */
    getType(): string;
  }
  /**
   * A MultiPoint geometry contains a number of <code>LatLng</code>s.
   *
   * Access by calling `const {Data} = await google.maps.importLibrary("maps")`.
   * See https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class MultiPoint implements google.maps.Data.Geometry {
    /**
     * A MultiPoint geometry contains a number of <code>LatLng</code>s.
     *
     * Access by calling `const {Data} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(elements: (google.maps.LatLng|google.maps.LatLngLiteral)[]);
    forEachLatLng(callback: (a: google.maps.LatLng) => void): void;
    /**
     * Returns an array of the contained <code>LatLng</code>s. A new array is
     * returned each time <code>getArray()</code> is called.
     */
    getArray(): google.maps.LatLng[];
    /**
     * Returns the <code>n</code>-th contained <code>LatLng</code>.
     */
    getAt(n: number): google.maps.LatLng;
    /**
     * Returns the number of contained <code>LatLng</code>s.
     */
    getLength(): number;
    /**
     * Returns the string <code>"MultiPoint"</code>.
     */
    getType(): string;
  }
  /**
   * A MultiPolygon geometry contains a number of <code>Data.Polygon</code>s.
   *
   * Access by calling `const {Data} = await google.maps.importLibrary("maps")`.
   * See https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class MultiPolygon implements google.maps.Data.Geometry {
    /**
     * A MultiPolygon geometry contains a number of <code>Data.Polygon</code>s.
     *
     * Access by calling `const {Data} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(elements:
                    (google.maps.Data.Polygon|
                     (google.maps.Data.LinearRing|
                      (google.maps.LatLng|google.maps.LatLngLiteral)[])[])[]);
    forEachLatLng(callback: (a: google.maps.LatLng) => void): void;
    /**
     * Returns an array of the contained <code>Data.Polygon</code>s. A new array
     * is returned each time <code>getArray()</code> is called.
     */
    getArray(): google.maps.Data.Polygon[];
    /**
     * Returns the <code>n</code>-th contained <code>Data.Polygon</code>.
     */
    getAt(n: number): google.maps.Data.Polygon;
    /**
     * Returns the number of contained <code>Data.Polygon</code>s.
     */
    getLength(): number;
    /**
     * Returns the string <code>"MultiPolygon"</code>.
     */
    getType(): string;
  }
  /**
   * A Point geometry contains a single <code>LatLng</code>.
   *
   * Access by calling `const {Data} = await google.maps.importLibrary("maps")`.
   * See https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Point implements google.maps.Data.Geometry {
    /**
     * A Point geometry contains a single <code>LatLng</code>.
     *
     * Access by calling `const {Data} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(latLng: google.maps.LatLng|google.maps.LatLngLiteral);
    forEachLatLng(callback: (a: google.maps.LatLng) => void): void;
    /**
     * Returns the contained <code>LatLng</code>.
     */
    get(): google.maps.LatLng;
    /**
     * Returns the string <code>"Point"</code>.
     */
    getType(): string;
  }
  /**
   * A Polygon geometry contains a number of <code>Data.LinearRing</code>s. The
   * first linear-ring must be the polygon exterior boundary and subsequent
   * linear-rings must be interior boundaries, also known as holes. See the <a
   * href="https://developers.google.com/maps/documentation/javascript/examples/layer-data-polygon">sample
   * polygon with a hole</a>.
   *
   * Access by calling `const {Data} = await google.maps.importLibrary("maps")`.
   * See https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Polygon implements google.maps.Data.Geometry {
    /**
     * A Polygon geometry contains a number of <code>Data.LinearRing</code>s.
     * The first linear-ring must be the polygon exterior boundary and
     * subsequent linear-rings must be interior boundaries, also known as holes.
     * See the <a
     * href="https://developers.google.com/maps/documentation/javascript/examples/layer-data-polygon">sample
     * polygon with a hole</a>.
     *
     * Access by calling `const {Data} = await
     * google.maps.importLibrary("maps")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(elements: (google.maps.Data.LinearRing|
                           (google.maps.LatLng|google.maps.LatLngLiteral)[])[]);
    forEachLatLng(callback: (a: google.maps.LatLng) => void): void;
    /**
     * Returns an array of the contained <code>Data.LinearRing</code>s. A new
     * array is returned each time <code>getArray()</code> is called.
     */
    getArray(): google.maps.Data.LinearRing[];
    /**
     * Returns the <code>n</code>-th contained <code>Data.LinearRing</code>.
     */
    getAt(n: number): google.maps.Data.LinearRing;
    /**
     * Returns the number of contained <code>Data.LinearRing</code>s.
     */
    getLength(): number;
    /**
     * Returns the string <code>"Polygon"</code>.
     */
    getType(): string;
  }
  /**
   * The properties of a <code>removefeature</code> event.
   */
  export interface RemoveFeatureEvent {
    /**
     * The feature that was removed from the <code>FeatureCollection</code>.
     */
    feature: google.maps.Data.Feature;
  }
  /**
   * The properties of a <code>removeproperty</code> event.
   */
  export interface RemovePropertyEvent {
    /**
     * The feature whose property was removed.
     */
    feature: google.maps.Data.Feature;
    /**
     * The property name.
     */
    name: string;
    /**
     * The previous value.
     */
    oldValue: any;
  }
  /**
   * The properties of a <code>setgeometry</code> event.
   */
  export interface SetGeometryEvent {
    /**
     * The feature whose geometry was set.
     */
    feature: google.maps.Data.Feature;
    /**
     * The new feature geometry.
     */
    newGeometry?: google.maps.Data.Geometry;
    /**
     * The previous feature geometry.
     */
    oldGeometry?: google.maps.Data.Geometry;
  }
  /**
   * The properties of a <code>setproperty</code> event.
   */
  export interface SetPropertyEvent {
    /**
     * The feature whose property was set.
     */
    feature: google.maps.Data.Feature;
    /**
     * The property name.
     */
    name: string;
    /**
     * The new value.
     */
    newValue: any;
    /**
     * The previous value. Will be <code>undefined</code> if the property was
     * added.
     */
    oldValue: any;
  }
  /**
   * These options specify the way a Feature should appear when displayed on a
   * map.
   */
  export interface StyleOptions {
    /**
     * The animation to play when marker is added to a map. Only applies to
     * point geometries.
     */
    animation?: google.maps.Animation;
    /**
     * If <code>true</code>, the marker receives mouse and touch events.
     * @defaultValue <code>true</code>
     */
    clickable?: boolean;
    /**
     * Mouse cursor to show on hover. Only applies to point geometries.
     */
    cursor?: string;
    /**
     * If <code>true</code>, the object can be dragged across the map and the
     * underlying feature will have its geometry updated.
     * @defaultValue <code>false</code>
     */
    draggable?: boolean;
    /**
     * If <code>true</code>, the object can be edited by dragging control points
     * and the underlying feature will have its geometry updated. Only applies
     * to LineString and Polygon geometries.
     * @defaultValue <code>false</code>
     */
    editable?: boolean;
    /**
     * The fill color. All CSS3 colors are supported except for extended named
     * colors. Only applies to polygon geometries.
     */
    fillColor?: string;
    /**
     * The fill opacity between 0.0 and 1.0. Only applies to polygon geometries.
     */
    fillOpacity?: number;
    /**
     * Icon for the foreground. If a string is provided, it is treated as though
     * it were an <code>Icon</code> with the string as <code>url</code>. Only
     * applies to point geometries.
     */
    icon?: string|google.maps.Icon|google.maps.Symbol;
    /**
     * The icons to be rendered along a polyline. Only applies to line
     * geometries.
     */
    icons?: google.maps.IconSequence[];
    /**
     * Adds a label to the marker. The label can either be a string, or a
     * <code>MarkerLabel</code> object. Only applies to point geometries.
     */
    label?: string|google.maps.MarkerLabel;
    /**
     * The marker&#39;s opacity between 0.0 and 1.0. Only applies to point
     * geometries.
     */
    opacity?: number;
    /**
     * Defines the image map used for hit detection. Only applies to point
     * geometries.
     */
    shape?: google.maps.MarkerShape;
    /**
     * The stroke color. All CSS3 colors are supported except for extended named
     * colors. Only applies to line and polygon geometries.
     */
    strokeColor?: string;
    /**
     * The stroke opacity between 0.0 and 1.0. Only applies to line and polygon
     * geometries.
     */
    strokeOpacity?: number;
    /**
     * The stroke width in pixels. Only applies to line and polygon geometries.
     */
    strokeWeight?: number;
    /**
     * Rollover text. Only applies to point geometries.
     */
    title?: string;
    /**
     * Whether the feature is visible.
     * @defaultValue <code>true</code>
     */
    visible?: boolean;
    /**
     * All features are displayed on the map in order of their zIndex, with
     * higher values displaying in front of features with lower values. Markers
     * are always displayed in front of line-strings and polygons.
     */
    zIndex?: number;
  }
  export type StylingFunction = (a: google.maps.Data.Feature) =>
      google.maps.Data.StyleOptions;
}
declare namespace google.maps.drawing {
  /**
   * Options for the rendering of the drawing control.
   */
  export interface DrawingControlOptions {
    /**
     * The drawing modes to display in the drawing control, in the order in
     * which they are to be displayed. The hand icon (which corresponds to the
     * <code>null</code> drawing mode) is always available and is not to be
     * specified in this array.
     * @defaultValue <code>[{@link
     * google.maps.drawing.OverlayType.MARKER}, {@link
     * google.maps.drawing.OverlayType.POLYLINE}, {@link
     * google.maps.drawing.OverlayType.RECTANGLE}, {@link
     * google.maps.drawing.OverlayType.CIRCLE}, {@link
     * google.maps.drawing.OverlayType.POLYGON}]</code>
     */
    drawingModes?: google.maps.drawing.OverlayType[]|null;
    /**
     * Position id. Used to specify the position of the control on the map.
     * @defaultValue {@link google.maps.ControlPosition.TOP_LEFT}
     */
    position?: google.maps.ControlPosition|null;
  }
  /**
   * Allows users to draw markers, polygons, polylines, rectangles, and circles
   * on the map. The <code>DrawingManager</code>&#39;s drawing mode defines the
   * type of overlay that will be created by the user. Adds a control to the
   * map, allowing the user to switch drawing mode.
   *
   * Access by calling `const {DrawingManager} = await
   * google.maps.importLibrary("drawing")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class DrawingManager extends google.maps.MVCObject {
    /**
     * Allows users to draw markers, polygons, polylines, rectangles, and
     * circles on the map. The <code>DrawingManager</code>&#39;s drawing mode
     * defines the type of overlay that will be created by the user. Adds a
     * control to the map, allowing the user to switch drawing mode.
     *
     * Access by calling `const {DrawingManager} = await
     * google.maps.importLibrary("drawing")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(options?: google.maps.drawing.DrawingManagerOptions|null);
    /**
     * Returns the <code>DrawingManager</code>&#39;s drawing mode.
     */
    getDrawingMode(): google.maps.drawing.OverlayType|null;
    /**
     * Returns the <code>Map</code> to which the <code>DrawingManager</code> is
     * attached, which is the <code>Map</code> on which the overlays created
     * will be placed.
     */
    getMap(): google.maps.Map|null;
    /**
     * Changes the <code>DrawingManager</code>&#39;s drawing mode, which defines
     * the type of overlay to be added on the map. Accepted values are
     * <code>'marker'</code>, <code>'polygon'</code>, <code>'polyline'</code>,
     * <code>'rectangle'</code>, <code>'circle'</code>, or <code>null</code>. A
     * drawing mode of <code>null</code> means that the user can interact with
     * the map as normal, and clicks do not draw anything.
     */
    setDrawingMode(drawingMode: google.maps.drawing.OverlayType|null): void;
    /**
     * Attaches the <code>DrawingManager</code> object to the specified
     * <code>Map</code>.
     */
    setMap(map: google.maps.Map|null): void;
    /**
     * Sets the <code>DrawingManager</code>&#39;s options.
     */
    setOptions(options: google.maps.drawing.DrawingManagerOptions|null): void;
  }
  /**
   * Options for the drawing manager.
   */
  export interface DrawingManagerOptions {
    /**
     * Options to apply to any new circles created with this
     * <code>DrawingManager</code>. The <code>center</code> and
     * <code>radius</code> properties are ignored, and the <code>map</code>
     * property of a new circle is always set to the
     * <code>DrawingManager</code>&#39;s map.
     */
    circleOptions?: google.maps.CircleOptions|null;
    /**
     * The enabled/disabled state of the drawing control.
     * @defaultValue <code>true</code>
     */
    drawingControl?: boolean|null;
    /**
     * The display options for the drawing control.
     */
    drawingControlOptions?: google.maps.drawing.DrawingControlOptions|null;
    /**
     * The <code>DrawingManager</code>&#39;s drawing mode, which defines the
     * type of overlay to be added on the map. Accepted values are
     * <code>'marker'</code>, <code>'polygon'</code>, <code>'polyline'</code>,
     * <code>'rectangle'</code>, <code>'circle'</code>, or <code>null</code>. A
     * drawing mode of <code>null</code> means that the user can interact with
     * the map as normal, and clicks do not draw anything.
     */
    drawingMode?: google.maps.drawing.OverlayType|null;
    /**
     * The <code>Map</code> to which the <code>DrawingManager</code> is
     * attached, which is the <code>Map</code> on which the overlays created
     * will be placed.
     */
    map?: google.maps.Map|null;
    /**
     * Options to apply to any new markers created with this
     * <code>DrawingManager</code>. The <code>position</code> property is
     * ignored, and the <code>map</code> property of a new marker is always set
     * to the <code>DrawingManager</code>&#39;s map.
     */
    markerOptions?: google.maps.MarkerOptions|null;
    /**
     * Options to apply to any new polygons created with this
     * <code>DrawingManager</code>. The <code>paths</code> property is ignored,
     * and the <code>map</code> property of a new polygon is always set to the
     * <code>DrawingManager</code>&#39;s map.
     */
    polygonOptions?: google.maps.PolygonOptions|null;
    /**
     * Options to apply to any new polylines created with this
     * <code>DrawingManager</code>. The <code>path</code> property is ignored,
     * and the <code>map</code> property of a new polyline is always set to the
     * <code>DrawingManager</code>&#39;s map.
     */
    polylineOptions?: google.maps.PolylineOptions|null;
    /**
     * Options to apply to any new rectangles created with this
     * <code>DrawingManager</code>. The <code>bounds</code> property is ignored,
     * and the <code>map</code> property of a new rectangle is always set to the
     * <code>DrawingManager</code>&#39;s map.
     */
    rectangleOptions?: google.maps.RectangleOptions|null;
  }
  /**
   * The properties of an overlaycomplete event on a
   * <code>DrawingManager</code>.
   */
  export interface OverlayCompleteEvent {
    /**
     * The completed overlay.
     */
    overlay: google.maps.Marker|null|google.maps.Polygon|
        google.maps.Polyline|google.maps.Rectangle|google.maps.Circle;
    /**
     * The completed overlay&#39;s type.
     */
    type: google.maps.drawing.OverlayType;
  }
  /**
   * The types of overlay that may be created by the
   * <code>DrawingManager</code>. Specify these by value, or by using the
   * constant&#39;s name. For example, <code>'polygon'</code> or
   * <code>google.maps.drawing.OverlayType.POLYGON</code>.
   *
   * Access by calling `const {OverlayType} = await
   * google.maps.importLibrary("drawing")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum OverlayType {
    /**
     * Specifies that the <code>DrawingManager</code> creates circles, and that
     * the overlay given in the <code>overlaycomplete</code> event is a circle.
     */
    CIRCLE = 'circle',
    /**
     * Specifies that the <code>DrawingManager</code> creates markers, and that
     * the overlay given in the <code>overlaycomplete</code> event is a marker.
     */
    MARKER = 'marker',
    /**
     * Specifies that the <code>DrawingManager</code> creates polygons, and that
     * the overlay given in the <code>overlaycomplete</code> event is a polygon.
     */
    POLYGON = 'polygon',
    /**
     * Specifies that the <code>DrawingManager</code> creates polylines, and
     * that the overlay given in the <code>overlaycomplete</code> event is a
     * polyline.
     */
    POLYLINE = 'polyline',
    /**
     * Specifies that the <code>DrawingManager</code> creates rectangles, and
     * that the overlay given in the <code>overlaycomplete</code> event is a
     * rectangle.
     */
    RECTANGLE = 'rectangle',
  }
}
declare namespace google.maps.geometry.encoding {
  /**
   * Decodes an encoded path string into a sequence of LatLngs.
   */
  export function decodePath(encodedPath: string): google.maps.LatLng[];
  /**
   * Encodes a sequence of LatLngs into an encoded path string.
   */
  export function encodePath(
      path: (google.maps.LatLng|google.maps.LatLngLiteral)[]|
      google.maps.MVCArray<google.maps.LatLng|google.maps.LatLngLiteral>):
      string;
}
declare namespace google.maps.geometry.poly {
  /**
   * Computes whether the given point lies inside the specified polygon.
   */
  export function containsLocation(
      point: google.maps.LatLng|google.maps.LatLngLiteral,
      polygon: google.maps.Polygon): boolean;
  /**
   * Computes whether the given point lies on or near to a polyline, or the edge
   * of a polygon, within a specified tolerance. Returns <code>true</code> when
   * the difference between the latitude and longitude of the supplied point,
   * and the closest point on the edge, is less than the tolerance. The
   * tolerance defaults to 10<sup>-9</sup> degrees.
   */
  export function isLocationOnEdge(
      point: google.maps.LatLng|google.maps.LatLngLiteral,
      poly: google.maps.Polygon|google.maps.Polyline,
      tolerance?: number): boolean;
}
declare namespace google.maps.geometry.spherical {
  /**
   * Returns the unsigned area of a closed path, in the range [0, 2×pi×radius²].
   * The computed area uses the same units as the radius. The
   * <code>radiusOfSphere</code> defaults to the Earth&#39;s radius in meters,
   * in which case the area is in square meters. Passing a <code>Circle</code>
   * requires the <code>radius</code> to be set to a non-negative value.
   * Additionally, the Circle must not cover more than 100% of the sphere. And
   * when passing a <code>LatLngBounds</code>, the southern LatLng cannot be
   * more north than the northern LatLng.
   */
  export function computeArea(
      path: (google.maps.LatLng|google.maps.LatLngLiteral)[]|
      google.maps.MVCArray<google.maps.LatLng|google.maps.LatLngLiteral>|
      google.maps.Circle|google.maps.CircleLiteral|
      google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral,
      radiusOfSphere?: number): number;
  /**
   * Returns the distance, in meters, between two LatLngs. You can optionally
   * specify a custom radius. The radius defaults to the radius of the Earth.
   */
  export function computeDistanceBetween(
      from: google.maps.LatLng|google.maps.LatLngLiteral,
      to: google.maps.LatLng|google.maps.LatLngLiteral,
      radius?: number): number;
  /**
   * Returns the heading from one LatLng to another LatLng. Headings are
   * expressed in degrees clockwise from North within the range [-180,180).
   */
  export function computeHeading(
      from: google.maps.LatLng|google.maps.LatLngLiteral,
      to: google.maps.LatLng|google.maps.LatLngLiteral): number;
  /**
   * Returns the length of the given path.
   */
  export function computeLength(
      path: (google.maps.LatLng|google.maps.LatLngLiteral)[]|
      google.maps.MVCArray<google.maps.LatLng|google.maps.LatLngLiteral>,
      radius?: number): number;
  /**
   * Returns the LatLng resulting from moving a distance from an origin in the
   * specified heading (expressed in degrees clockwise from north).
   */
  export function computeOffset(
      from: google.maps.LatLng|google.maps.LatLngLiteral, distance: number,
      heading: number, radius?: number): google.maps.LatLng;
  /**
   * Returns the location of origin when provided with a LatLng destination,
   * meters travelled and original heading. Headings are expressed in degrees
   * clockwise from North. This function returns <code>null</code> when no
   * solution is available.
   */
  export function computeOffsetOrigin(
      to: google.maps.LatLng|google.maps.LatLngLiteral, distance: number,
      heading: number, radius?: number): google.maps.LatLng|null;
  /**
   * Returns the signed area of a closed path, where counterclockwise is
   * positive, in the range [-2×pi×radius², 2×pi×radius²]. The computed area
   * uses the same units as the radius. The radius defaults to the Earth&#39;s
   * radius in meters, in which case the area is in square meters. <br><br> The
   * area is computed using the <a
   * href="https://wikipedia.org/wiki/Parallel_transport">parallel transport</a>
   * method; the parallel transport around a closed path on the unit sphere
   * twists by an angle that is equal to the area enclosed by the path. This is
   * simpler and more accurate and robust than triangulation using Girard,
   * l&#39;Huilier, or Eriksson on each triangle. In particular, since it
   * doesn&#39;t triangulate, it suffers no instability except in the
   * unavoidable case when an <em>edge</em> (not a diagonal) of the polygon
   * spans 180 degrees.
   */
  export function computeSignedArea(
      loop: (google.maps.LatLng|google.maps.LatLngLiteral)[]|
      google.maps.MVCArray<google.maps.LatLng|google.maps.LatLngLiteral>,
      radius?: number): number;
  /**
   * Returns the LatLng which lies the given fraction of the way between the
   * origin LatLng and the destination LatLng.
   */
  export function interpolate(
      from: google.maps.LatLng|google.maps.LatLngLiteral,
      to: google.maps.LatLng|google.maps.LatLngLiteral,
      fraction: number): google.maps.LatLng;
}
declare namespace google.maps.journeySharing {
  /**
   * The auth token returned by the token fetcher.
   */
  export interface AuthToken {
    /**
     * The expiration time in seconds. A token expires in this amount of time
     * after fetching.
     */
    expiresInSeconds: number;
    /**
     * The token.
     */
    token: string;
  }
  /**
   * Contains additional information needed to mint JSON Web Tokens.
   */
  export interface AuthTokenContext {
    /**
     * When provided, the minted token should have a private
     * <code>DeliveryVehicleId</code> claim for the provided deliveryVehicleId.
     */
    deliveryVehicleId?: string|null;
    /**
     * When provided, the minted token should have a private <code>TaskId</code>
     * claim for the provided taskId.
     */
    taskId?: string|null;
    /**
     * When provided, the minted token should have a private
     * <code>TrackingId</code> claim for the provided trackingId.
     */
    trackingId?: string|null;
    /**
     * When provided, the minted token should have a private <code>TripId</code>
     * claim for the provided tripId.
     */
    tripId?: string|null;
    /**
     * When provided, the minted token should have a private
     * <code>VehicleId</code> claim for the provided vehicleId.
     */
    vehicleId?: string|null;
  }
  export type AuthTokenFetcher =
      (a: google.maps.journeySharing.AuthTokenFetcherOptions) =>
          Promise<google.maps.journeySharing.AuthToken>;
  /**
   * Options for the auth token fetcher.
   */
  export interface AuthTokenFetcherOptions {
    /**
     * The auth token context. IDs specified in the context should be added to
     * the request sent to the JSON Web Token minting endpoint.
     */
    context: google.maps.journeySharing.AuthTokenContext;
    /**
     * The Fleet Engine service type.
     */
    serviceType: google.maps.journeySharing.FleetEngineServiceType;
  }
  /**
   * Automatic viewport mode.
   *
   * Access by calling `const {AutomaticViewportMode} = await
   * google.maps.importLibrary("journeySharing")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum AutomaticViewportMode {
    /**
     * Automatically adjust the viewport to fit markers and any visible
     * anticipated route polylines. This is the default.
     */
    FIT_ANTICIPATED_ROUTE = 'FIT_ANTICIPATED_ROUTE',
    /**
     * Do not automatically adjust the viewport.
     */
    NONE = 'NONE',
  }
  /**
   * MarkerSetup default options.
   * @deprecated Marker setup is deprecated. Use the
   *     <code>MarkerCustomizationFunction</code> methods for your location
   *     provider instead.
   */
  export interface DefaultMarkerSetupOptions {
    /**
     * Default marker options.
     */
    defaultMarkerOptions: google.maps.MarkerOptions;
  }
  /**
   * PolylineSetup default options.
   */
  export interface DefaultPolylineSetupOptions {
    /**
     * Default polyline options.
     */
    defaultPolylineOptions: google.maps.PolylineOptions;
    /**
     * Default polyline visibility.
     */
    defaultVisible: boolean;
  }
  /**
   * The details for a delivery vehicle returned by Fleet Engine.
   */
  export interface DeliveryVehicle {
    /**
     * Custom delivery vehicle attributes.
     */
    attributes: {[key: string]: string|null};
    /**
     * The location where the current route segment ends.
     */
    currentRouteSegmentEndPoint: google.maps.LatLngLiteral|null;
    /**
     * The last reported location of the delivery vehicle.
     */
    latestVehicleLocationUpdate:
        google.maps.journeySharing.VehicleLocationUpdate|null;
    /**
     * In the format
     * &quot;providers/{provider_id}/deliveryVehicles/{delivery_vehicle_id}&quot;.
     * The delivery_vehicle_id must be a unique identifier.
     */
    name: string;
    /**
     * The current navigation status of the vehicle.
     */
    navigationStatus: string;
    /**
     * The remaining driving distance in the current route segment, in meters.
     */
    remainingDistanceMeters: number;
    /**
     * The remaining driving duration in the current route segment, in
     * milliseconds.
     */
    remainingDurationMillis: number|null;
    /**
     * The journey segments assigned to this delivery vehicle, starting from the
     * vehicle&#39;s most recently reported location. This is only populated
     * when the {@link google.maps.journeySharing.DeliveryVehicle} data object
     * is provided through {@link
     * google.maps.journeySharing.FleetEngineDeliveryVehicleLocationProvider}.
     */
    remainingVehicleJourneySegments:
        google.maps.journeySharing.VehicleJourneySegment[];
  }
  /**
   * Parameters specific to marker customization functions that apply options to
   * delivery vehicle markers. Used by {@link
   * google.maps.journeySharing.FleetEngineDeliveryVehicleLocationProviderOptions.deliveryVehicleMarkerCustomization}
   * and {@link
   * google.maps.journeySharing.FleetEngineDeliveryFleetLocationProviderOptions.deliveryVehicleMarkerCustomization}.
   */
  export interface DeliveryVehicleMarkerCustomizationFunctionParams extends
      google.maps.journeySharing.MarkerCustomizationFunctionParams {
    /**
     * The delivery vehicle represented by this marker.
     */
    vehicle: google.maps.journeySharing.DeliveryVehicle;
  }
  /**
   * DeliveryVehicleStop type
   */
  export interface DeliveryVehicleStop {
    /**
     * The location of the stop.
     */
    plannedLocation: google.maps.LatLngLiteral|null;
    /**
     * The state of the stop.
     */
    state: google.maps.journeySharing.DeliveryVehicleStopState|null;
    /**
     * The list of Tasks to be performed at this stop. <ul> <li><code>id</code>:
     * the ID of the task. <li><code>extraDurationMillis</code>: the extra time
     * it takes to perform the task, in milliseconds. </ul>
     */
    tasks: google.maps.journeySharing.TaskInfo[];
  }
  /**
   * The current state of a {@link
   * google.maps.journeySharing.DeliveryVehicleStop}.
   *
   * Access by calling `const {DeliveryVehicleStopState} = await
   * google.maps.importLibrary("journeySharing")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum DeliveryVehicleStopState {
    /**
     * Arrived at stop. Assumes that when the vehicle is routing to the next
     * stop, that all previous stops have been completed.
     */
    ARRIVED = 'ARRIVED',
    /**
     * Assigned and actively routing.
     */
    ENROUTE = 'ENROUTE',
    /**
     * Created, but not actively routing.
     */
    NEW = 'NEW',
    /**
     * Unknown.
     */
    UNSPECIFIED = 'UNSPECIFIED',
  }
  /**
   * Delivery Fleet Location Provider.
   *
   * Access by calling `const {FleetEngineDeliveryFleetLocationProvider} = await
   * google.maps.importLibrary("journeySharing")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class FleetEngineDeliveryFleetLocationProvider extends
      google.maps.journeySharing.PollingLocationProvider {
    /**
     * Delivery Fleet Location Provider.
     *
     * Access by calling `const {FleetEngineDeliveryFleetLocationProvider} =
     * await google.maps.importLibrary("journeySharing")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     * @param options Options to pass to the location provider.
     */
    constructor(options: google.maps.journeySharing
                    .FleetEngineDeliveryFleetLocationProviderOptions);
    /**
     * The filter applied when fetching the delivery vehicles.
     */
    deliveryVehicleFilter?: string|null;
    /**
     * The bounds within which to track delivery vehicles. If no bounds are set,
     * no delivery vehicles will be tracked. To track all delivery vehicles
     * regardless of location, set bounds equivalent to the entire earth.
     */
    locationRestriction?: google.maps.LatLngBounds|null|
        google.maps.LatLngBoundsLiteral;
    /**
     * This Field is read-only. Threshold for stale vehicle location. If the
     * last updated location for the vehicle is older than this threshold, the
     * vehicle will not be displayed.
     */
    staleLocationThresholdMillis: number;
  }
  /**
   * Options for delivery fleet location provider.
   */
  export interface FleetEngineDeliveryFleetLocationProviderOptions {
    /**
     * Provides JSON Web Tokens for authenticating the client to Fleet Engine.
     */
    authTokenFetcher(
        this: any, a: google.maps.journeySharing.AuthTokenFetcherOptions):
        Promise<google.maps.journeySharing.AuthToken>;
    /**
     * A filter query to apply when fetching delivery vehicles. This filter is
     * passed directly to Fleet Engine. <br><br>See <a
     * href="https://goo.gle/3wT0Dlt">ListDeliveryVehiclesRequest.filter</a> for
     * supported formats.<br><br>Note that valid filters for attributes must
     * have the &quot;attributes&quot; prefix. For example, <code>attributes.x =
     * &quot;y&quot;</code> or <code>attributes.&quot;x y&quot; =
     * &quot;z&quot;</code>.
     */
    deliveryVehicleFilter: string|null;
    /**
     * Customization applied to a delivery vehicle marker. <br><br>Use this
     * field to specify custom styling (such as marker icon) and interactivity
     * (such as click handling).<ul><li>If a {@link google.maps.MarkerOptions}
     * object is specified, the changes specified in it are applied to the
     * marker after the marker has been created, overwriting its default options
     * if they exist.</li><li> If a function is specified, it is invoked once
     * when the marker is created, before it is added to the map view. (On this
     * invocation, the <code>isNew</code> parameter in the function parameters
     * object is set to <code>true</code>.) Additionally, this function is
     * invoked when the location provider receives data from Fleet Engine,
     * regardless of whether the data corresponding to this marker have
     * changed.<br><br>See {@link
     * google.maps.journeySharing.DeliveryVehicleMarkerCustomizationFunctionParams}
     * for a list of supplied parameters and their uses.</li></ul>
     */
    deliveryVehicleMarkerCustomization?:
        ((a: google.maps.journeySharing
              .DeliveryVehicleMarkerCustomizationFunctionParams) => void)|null;
    /**
     * The latitude/longitude bounds within which to track vehicles immediately
     * after the location provider is instantiated. If not set, the location
     * provider does not start tracking any vehicles; use {@link
     * google.maps.journeySharing.FleetEngineDeliveryFleetLocationProvider.locationRestriction}
     * to set the bounds and begin tracking. To track all delivery vehicles
     * regardless of location, set bounds equivalent to the entire earth.
     */
    locationRestriction: google.maps.LatLngBounds|null|
        google.maps.LatLngBoundsLiteral;
    /**
     * The consumer&#39;s project ID from Google Cloud Console.
     */
    projectId: string;
    /**
     * Threshold for stale vehicle location. If the last updated location for
     * the vehicle is older this threshold, the vehicle will not be displayed.
     * Defaults to 24 hours in milliseconds. If the threshold is less than zero,
     * or <i>Infinity</i>, the threshold will be ignored and the vehicle
     * location will not be considered stale.
     */
    staleLocationThresholdMillis: number|null;
  }
  /**
   * The event object passed to the event handler when the {@link
   * google.maps.journeySharing.FleetEngineDeliveryFleetLocationProvider.update}
   * event is triggered.
   */
  export interface FleetEngineDeliveryFleetLocationProviderUpdateEvent {
    /**
     * The list of delivery vehicles returned by the query. Unmodifiable.
     */
    deliveryVehicles: google.maps.journeySharing.DeliveryVehicle[]|null;
  }
  /**
   * Delivery Vehicle Location Provider.
   *
   * Access by calling `const {FleetEngineDeliveryVehicleLocationProvider} =
   * await google.maps.importLibrary("journeySharing")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class FleetEngineDeliveryVehicleLocationProvider extends
      google.maps.journeySharing.PollingLocationProvider {
    /**
     * Delivery Vehicle Location Provider.
     *
     * Access by calling `const {FleetEngineDeliveryVehicleLocationProvider} =
     * await google.maps.importLibrary("journeySharing")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     * @param options Options to pass to the location provider.
     */
    constructor(options: google.maps.journeySharing
                    .FleetEngineDeliveryVehicleLocationProviderOptions);
    /**
     * ID for the vehicle that this location provider observes. Set this field
     * to track a vehicle.
     */
    deliveryVehicleId: string;
    /**
     * Optionally allow users to display the task&#39;s outcome location.
     */
    shouldShowOutcomeLocations: boolean|null;
    /**
     * Optionally allow users to display fetched tasks.
     */
    shouldShowTasks: boolean|null;
    /**
     * This Field is read-only. Threshold for stale vehicle location. If the
     * last updated location for the vehicle is older than this threshold, the
     * vehicle will not be displayed.
     */
    staleLocationThresholdMillis: number;
    /**
     * Returns the filter options to apply when fetching tasks.
     */
    taskFilterOptions: google.maps.journeySharing.FleetEngineTaskFilterOptions;
  }
  /**
   * Options for delivery vehicle location provider.
   */
  export interface FleetEngineDeliveryVehicleLocationProviderOptions {
    /**
     * Provides JSON Web Tokens for authenticating the client to Fleet Engine.
     */
    authTokenFetcher(
        this: any, a: google.maps.journeySharing.AuthTokenFetcherOptions):
        Promise<google.maps.journeySharing.AuthToken>;
    /**
     * The delivery vehicle ID to track immediately after the location provider
     * is instantiated. If not specified, the location provider does not start
     * tracking any vehicle; use {@link
     * google.maps.journeySharing.FleetEngineDeliveryVehicleLocationProvider.deliveryVehicleId}
     * to set the ID and begin tracking.
     */
    deliveryVehicleId: string|null;
    /**
     * Customization applied to the delivery vehicle marker. <br><br>Use this
     * field to specify custom styling (such as marker icon) and interactivity
     * (such as click handling).<ul><li>If a {@link google.maps.MarkerOptions}
     * object is specified, the changes specified in it are applied to the
     * marker after the marker has been created, overwriting its default options
     * if they exist.</li><li>If a function is specified, it is invoked once
     * when the marker is created, before it is added to the map view. (On this
     * invocation, the <code>isNew</code> parameter in the function parameters
     * object is set to <code>true</code>.) Additionally, this function is
     * invoked when the location provider receives data from Fleet Engine,
     * regardless of whether the data corresponding to this marker have
     * changed.<br><br>See {@link
     * google.maps.journeySharing.DeliveryVehicleMarkerCustomizationFunctionParams}
     * for a list of supplied parameters and their uses.</li></ul>
     */
    deliveryVehicleMarkerCustomization?:
        ((a: google.maps.journeySharing
              .DeliveryVehicleMarkerCustomizationFunctionParams) => void)|null
        |google.maps.MarkerOptions;
    /**
     * Customization applied to a planned stop marker. <br><br>Use this field to
     * specify custom styling (such as marker icon) and interactivity (such as
     * click handling).<ul><li>If a {@link google.maps.MarkerOptions} object is
     * specified, the changes specified in it are applied to the marker after
     * the marker has been created, overwriting its default options if they
     * exist.</li><li>If a function is specified, it is invoked once when the
     * marker is created, before it is added to the map view. (On this
     * invocation, the <code>isNew</code> parameter in the function parameters
     * object is set to <code>true</code>.) Additionally, this function is
     * invoked when the location provider receives data from Fleet Engine,
     * regardless of whether the data corresponding to this marker have
     * changed.<br><br>See {@link
     * google.maps.journeySharing.PlannedStopMarkerCustomizationFunctionParams}
     * for a list of supplied parameters and their uses.</li></ul>
     */
    plannedStopMarkerCustomization?:
        ((a: google.maps.journeySharing
              .PlannedStopMarkerCustomizationFunctionParams) => void)|null
        |google.maps.MarkerOptions;
    /**
     * Minimum time between fetching location updates in milliseconds. If it
     * takes longer than <code>pollingIntervalMillis</code> to fetch a location
     * update, the next location update is not started until the current one
     * finishes. <br><br>Setting this value to 0 disables recurring location
     * updates. A new location update is fetched if any of the parameters
     * observed by the location provider changes. <br><br>The default polling
     * interval is 5000 milliseconds, the minimum interval. If you set the
     * polling interval to a lower non-zero value, 5000 is used.
     */
    pollingIntervalMillis: number|null;
    /**
     * The consumer&#39;s project ID from Google Cloud Console.
     */
    projectId: string;
    /**
     * Boolean to show or hide outcome locations for the fetched tasks.
     */
    shouldShowOutcomeLocations: boolean|null;
    /**
     * Boolean to show or hide tasks. Setting this to false will prevent the
     * ListTasks endpoint from being called to fetch the tasks. Only the
     * upcoming vehicle stops will be displayed.
     */
    shouldShowTasks: boolean|null;
    /**
     * Threshold for stale vehicle location. If the last updated location for
     * the vehicle is older this threshold, the vehicle will not be displayed.
     * Defaults to 24 hours in milliseconds. If the threshold is less than 0, or
     * <i>Infinity</i>, the threshold will be ignored and the vehicle location
     * will not be considered stale.
     */
    staleLocationThresholdMillis: number|null;
    /**
     * Filter options to apply when fetching tasks. The options can include
     * specific vehicle, time, and task status.
     */
    taskFilterOptions: google.maps.journeySharing.FleetEngineTaskFilterOptions|
        null;
    /**
     * Customization applied to a task marker. A task marker is rendered at the
     * planned location of each task assigned to the delivery vehicle.
     * <br><br>Use this field to specify custom styling (such as marker icon)
     * and interactivity (such as click handling).<ul><li>If a {@link
     * google.maps.MarkerOptions} object is specified, the changes specified in
     * it are applied to the marker after the marker has been created,
     * overwriting its default options if they exist.</li><li>If a function is
     * specified, it is invoked once when the marker is created, before it is
     * added to the map view. (On this invocation, the <code>isNew</code>
     * parameter in the function parameters object is set to <code>true</code>.)
     * Additionally, this function is invoked when the location provider
     * receives data from Fleet Engine, regardless of whether the data
     * corresponding to this marker have changed.<br><br>See {@link
     * google.maps.journeySharing.TaskMarkerCustomizationFunctionParams} for a
     * list of supplied parameters and their uses.</li></ul>
     */
    taskMarkerCustomization?: (
        (a: google.maps.journeySharing.TaskMarkerCustomizationFunctionParams) =>
            void)|null|google.maps.MarkerOptions;
    /**
     * Customization applied to a task outcome marker. A task outcome marker is
     * rendered at the actual outcome location of each task assigned to the
     * delivery vehicle. <br><br>Use this field to specify custom styling (such
     * as marker icon) and interactivity (such as click handling).<ul><li>If
     * a {@link google.maps.MarkerOptions} object is specified, the changes
     * specified in it are applied to the marker after the marker has been
     * created, overwriting its default options if they exist.</li><li>If a
     * function is specified, it is invoked once when the marker is created,
     * before it is added to the map view. (On this invocation, the
     * <code>isNew</code> parameter in the function parameters object is set to
     * <code>true</code>.) Additionally, this function is invoked when the
     * location provider receives data from Fleet Engine, regardless of whether
     * the data corresponding to this marker have changed.<br><br>See {@link
     * google.maps.journeySharing.TaskMarkerCustomizationFunctionParams} for a
     * list of supplied parameters and their uses.</li></ul>
     */
    taskOutcomeMarkerCustomization?:
        ((a: google.maps.journeySharing
              .TaskMarkerCustomizationFunctionParams) => void)|null;
  }
  /**
   * The event object passed to the event handler when the {@link
   * google.maps.journeySharing.FleetEngineDeliveryVehicleLocationProvider.update}
   * event is triggered.
   */
  export interface FleetEngineDeliveryVehicleLocationProviderUpdateEvent {
    /**
     * The journey segments that have been completed by this vehicle.
     * Unmodifiable.
     */
    completedVehicleJourneySegments:
        google.maps.journeySharing.VehicleJourneySegment[]|null;
    /**
     * The delivery vehicle data structure returned by the update. Unmodifiable.
     */
    deliveryVehicle: google.maps.journeySharing.DeliveryVehicle|null;
    /**
     * The list of tasks served by this delivery vehicle. Unmodifiable.
     */
    tasks: google.maps.journeySharing.Task[]|null;
  }
  /**
   * Types of Fleet Engine services.
   *
   * Access by calling `const {FleetEngineServiceType} = await
   * google.maps.importLibrary("journeySharing")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum FleetEngineServiceType {
    /**
     * Fleet Engine service used to access delivery vehicles.
     */
    DELIVERY_VEHICLE_SERVICE = 'DELIVERY_VEHICLE_SERVICE',
    /**
     * Fleet Engine service used to access task information.
     */
    TASK_SERVICE = 'TASK_SERVICE',
    /**
     * Fleet Engine service used to access trip information.
     */
    TRIP_SERVICE = 'TRIP_SERVICE',
    /**
     * Unknown Fleet Engine service.
     */
    UNKNOWN_SERVICE = 'UNKNOWN_SERVICE',
  }
  /**
   * Shipment location provider.
   *
   * Access by calling `const {FleetEngineShipmentLocationProvider} = await
   * google.maps.importLibrary("journeySharing")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class FleetEngineShipmentLocationProvider extends
      google.maps.journeySharing.PollingLocationProvider {
    /**
     * Shipment location provider.
     *
     * Access by calling `const {FleetEngineShipmentLocationProvider} = await
     * google.maps.importLibrary("journeySharing")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     * @param options Options for the location provider.
     */
    constructor(options: google.maps.journeySharing
                    .FleetEngineShipmentLocationProviderOptions);
    /**
     * Explicitly refreshes the tracked location.
     */
    refresh(): void;
    /**
     * The tracking ID for the task that this location provider observes. Set
     * this field to begin tracking.
     */
    trackingId: string;
  }
  /**
   * Options for shipment location provider.
   */
  export interface FleetEngineShipmentLocationProviderOptions {
    /**
     * Provides JSON Web Tokens for authenticating the client to Fleet Engine.
     */
    authTokenFetcher(
        this: any, a: google.maps.journeySharing.AuthTokenFetcherOptions):
        Promise<google.maps.journeySharing.AuthToken>;
    /**
     * Customization applied to the delivery vehicle marker. <br><br>Use this
     * field to specify custom styling (such as marker icon) and interactivity
     * (such as click handling).<ul><li> If a {@link google.maps.MarkerOptions}
     * object is specified, the changes specified in it are applied to the
     * marker after the marker has been created, overwriting its default options
     * if they exist.</li><li>If a function is specified, it is invoked once
     * when the marker is created, before it is added to the map view. (On this
     * invocation, the <code>isNew</code> parameter in the function parameters
     * object is set to <code>true</code>.) Additionally, this function is
     * invoked when the location provider receives data from Fleet Engine,
     * regardless of whether the data corresponding to this marker have
     * changed.<br><br>See {@link
     * google.maps.journeySharing.ShipmentMarkerCustomizationFunctionParams} for
     * a list of supplied parameters and their uses.</li></ul>
     */
    deliveryVehicleMarkerCustomization?:
        ((a: google.maps.journeySharing
              .ShipmentMarkerCustomizationFunctionParams) => void)|null
        |google.maps.MarkerOptions;
    /**
     * Customization applied to the destination marker. <br><br>Use this field
     * to specify custom styling (such as marker icon) and interactivity (such
     * as click handling).<ul><li> If a {@link google.maps.MarkerOptions} object
     * is specified, the changes specified in it are applied to the marker after
     * the marker has been created, overwriting its default options if they
     * exist.</li><li>If a function is specified, it is invoked once when the
     * marker is created, before it is added to the map view. (On this
     * invocation, the <code>isNew</code> parameter in the function parameters
     * object is set to <code>true</code>.) Additionally, this function is
     * invoked when the location provider receives data from Fleet Engine,
     * regardless of whether the data corresponding to this marker have
     * changed.<br><br>See {@link
     * google.maps.journeySharing.ShipmentMarkerCustomizationFunctionParams} for
     * a list of supplied parameters and their uses.</li></ul>
     */
    destinationMarkerCustomization?:
        ((a: google.maps.journeySharing
              .ShipmentMarkerCustomizationFunctionParams) => void)|null
        |google.maps.MarkerOptions;
    /**
     * Minimum time between fetching location updates in milliseconds. If it
     * takes longer than <code>pollingIntervalMillis</code> to fetch a location
     * update, the next location update is not started until the current one
     * finishes. <br><br>Setting this value to 0, Infinity, or a negative value
     * disables automatic location updates. A new location update is fetched
     * once if the tracking ID parameter (for example, the shipment tracking ID
     * of the shipment location provider), or a filtering option (for example,
     * viewport bounds or attribute filters for fleet location providers)
     * changes. <br><br>The default, and minimum, polling interval is 5000
     * milliseconds. If you set the polling interval to a lower positive value,
     * 5000 is stored and used.
     */
    pollingIntervalMillis: number|null;
    /**
     * The consumer&#39;s project ID from Google Cloud Console.
     */
    projectId: string;
    /**
     * The tracking ID of the task to track immediately after the location
     * provider is instantiated. If not specified, the location provider does
     * not start tracking any task; use {@link
     * google.maps.journeySharing.FleetEngineShipmentLocationProvider.trackingId}
     * to set the tracking ID and begin tracking.
     */
    trackingId: string|null;
  }
  /**
   * The event object passed to the event handler when the {@link
   * google.maps.journeySharing.FleetEngineShipmentLocationProvider.update}
   * event is triggered.
   */
  export interface FleetEngineShipmentLocationProviderUpdateEvent {
    /**
     * The task tracking info structure returned by the update. Unmodifiable.
     */
    taskTrackingInfo: google.maps.journeySharing.TaskTrackingInfo|null;
  }
  /**
   * Filtering options for tasks in the Delivery Vehicle Location Provider.
   */
  export interface FleetEngineTaskFilterOptions {
    /**
     * Exclusive lower bound for the completion time of the task. Used to filter
     * for tasks that were completed after the specified time.
     */
    completionTimeFrom: Date|null;
    /**
     * Exclusive upper bound for the completion time of the task. Used to filter
     * for tasks that were completed before the specified time.
     */
    completionTimeTo: Date|null;
    /**
     * The state of the task. Valid values are OPEN or CLOSED.
     */
    state: string|null;
  }
  /**
   * Trip location provider.
   *
   * Access by calling `const {FleetEngineTripLocationProvider} = await
   * google.maps.importLibrary("journeySharing")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class FleetEngineTripLocationProvider extends
      google.maps.journeySharing.PollingLocationProvider {
    /**
     * Trip location provider.
     *
     * Access by calling `const {FleetEngineTripLocationProvider} = await
     * google.maps.importLibrary("journeySharing")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     * @param options Options for the location provider.
     */
    constructor(options: google.maps.journeySharing
                    .FleetEngineTripLocationProviderOptions);
    /**
     * Explicitly refreshes the tracked location.
     */
    refresh(): void;
    /**
     * The ID for the trip that this location provider observes. Set this field
     * to begin tracking.
     */
    tripId: string;
  }
  /**
   * Options for trip location provider.
   */
  export interface FleetEngineTripLocationProviderOptions {
    /**
     * Provides JSON Web Tokens for authenticating the client to Fleet Engine.
     */
    authTokenFetcher(
        this: any, a: google.maps.journeySharing.AuthTokenFetcherOptions):
        Promise<google.maps.journeySharing.AuthToken>;
    /**
     * Customization applied to the destination marker. <br><br>Use this field
     * to specify custom styling (such as marker icon) and interactivity (such
     * as click handling).<ul><li>If a {@link google.maps.MarkerOptions} object
     * is specified, the changes specified in it are applied to the marker after
     * the marker has been created, overwriting its default options if they
     * exist.</li><li>If a function is specified, it is invoked once when the
     * marker is created, before it is added to the map view. (On this
     * invocation, the <code>isNew</code> parameter in the function parameters
     * object is set to <code>true</code>.) Additionally, this function is
     * invoked when the location provider receives data from Fleet Engine,
     * regardless of whether the data corresponding to this marker have
     * changed.<br><br>See {@link
     * google.maps.journeySharing.TripMarkerCustomizationFunctionParams} for a
     * list of supplied parameters and their uses.</li></ul>
     */
    destinationMarkerCustomization?: (
        (a: google.maps.journeySharing.TripMarkerCustomizationFunctionParams) =>
            void)|null|google.maps.MarkerOptions;
    /**
     * Customization applied to the origin marker. <br><br>Use this field to
     * specify custom styling (such as marker icon) and interactivity (such as
     * click handling).<ul><li>If a {@link google.maps.MarkerOptions} object is
     * specified, the changes specified in it are applied to the marker after
     * the marker has been created, overwriting its default options if they
     * exist.</li><li>If a function is specified, it is invoked once when the
     * marker is created, before it is added to the map view. (On this
     * invocation, the <code>isNew</code> parameter in the function parameters
     * object is set to <code>true</code>.) Additionally, this function is
     * invoked when the location provider receives data from Fleet Engine,
     * regardless of whether the data corresponding to this marker have
     * changed.<br><br>See {@link
     * google.maps.journeySharing.TripMarkerCustomizationFunctionParams} for a
     * list of supplied parameters and their uses.</li></ul>
     */
    originMarkerCustomization?: (
        (a: google.maps.journeySharing.TripMarkerCustomizationFunctionParams) =>
            void)|null|google.maps.MarkerOptions;
    /**
     * Minimum time between fetching location updates in milliseconds. If it
     * takes longer than <code>pollingIntervalMillis</code> to fetch a location
     * update, the next location update is not started until the current one
     * finishes. <br><br>Setting this value to 0 disables recurring location
     * updates. A new location update is fetched if any of the parameters
     * observed by the location provider changes. <br><br>The default polling
     * interval is 5000 milliseconds, the minimum interval. If you set the
     * polling interval to a lower non-zero value, 5000 is used.
     */
    pollingIntervalMillis: number|null;
    /**
     * The consumer&#39;s project ID from Google Cloud Console.
     */
    projectId: string;
    /**
     * The trip ID to track immediately after the location provider is
     * instantiated. If not specified, the location provider does not start
     * tracking any trip; use {@link
     * google.maps.journeySharing.FleetEngineTripLocationProvider.tripId} to set
     * the ID and begin tracking.
     */
    tripId: string|null;
    /**
     * Customization applied to the vehicle marker. <br><br>Use this field to
     * specify custom styling (such as marker icon) and interactivity (such as
     * click handling).<ul><li>If a {@link google.maps.MarkerOptions} object is
     * specified, the changes specified in it are applied to the marker after
     * the marker has been created, overwriting its default options if they
     * exist.</li><li>If a function is specified, it is invoked once when the
     * marker is created, before it is added to the map view. (On this
     * invocation, the <code>isNew</code> parameter in the function parameters
     * object is set to <code>true</code>.) Additionally, this function is
     * invoked when the location provider receives data from Fleet Engine,
     * regardless of whether the data corresponding to this marker have
     * changed.<br><br>See {@link
     * google.maps.journeySharing.TripMarkerCustomizationFunctionParams} for a
     * list of supplied parameters and their uses.</li></ul>
     */
    vehicleMarkerCustomization?: (
        (a: google.maps.journeySharing.TripMarkerCustomizationFunctionParams) =>
            void)|null|google.maps.MarkerOptions;
    /**
     * Customization applied to a waypoint marker. <br><br>Use this field to
     * specify custom styling (such as marker icon) and interactivity (such as
     * click handling).<ul><li>If a {@link google.maps.MarkerOptions} object is
     * specified, the changes specified in it are applied to the marker after
     * the marker has been created, overwriting its default options if they
     * exist.</li><li>If a function is specified, it is invoked once when the
     * marker is created, before it is added to the map view. (On this
     * invocation, the <code>isNew</code> parameter in the function parameters
     * object is set to <code>true</code>.) Additionally, this function is
     * invoked when the location provider receives data from Fleet Engine,
     * regardless of whether the data corresponding to this marker have
     * changed.<br><br>See {@link
     * google.maps.journeySharing.TripWaypointMarkerCustomizationFunctionParams}
     * for a list of supplied parameters and their uses.</li></ul>
     */
    waypointMarkerCustomization?:
        ((a: google.maps.journeySharing
              .TripWaypointMarkerCustomizationFunctionParams) => void)|null
        |google.maps.MarkerOptions;
  }
  /**
   * The event object passed to the event handler when the {@link
   * google.maps.journeySharing.FleetEngineTripLocationProvider.update} event is
   * triggered.
   */
  export interface FleetEngineTripLocationProviderUpdateEvent {
    /**
     * The trip structure returned by the update. Unmodifiable.
     */
    trip: google.maps.journeySharing.Trip|null;
  }
  /**
   * The map view.
   *
   * Access by calling `const {JourneySharingMapView} = await
   * google.maps.importLibrary("journeySharing")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class JourneySharingMapView {
    /**
     * The map view.
     *
     * Access by calling `const {JourneySharingMapView} = await
     * google.maps.importLibrary("journeySharing")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     * @param options Options for the map view.
     */
    constructor(options:
                    google.maps.journeySharing.JourneySharingMapViewOptions);
    /**
     * Configures options for an anticipated route polyline. Invoked whenever a
     * new anticipated route polyline is rendered. <br><br>If specifying a
     * function, the function can and should modify the input&#39;s
     * defaultPolylineOptions field containing a google.maps.PolylineOptions
     * object, and return it as polylineOptions in the output
     * PolylineSetupOptions object. <br><br>Specifying a PolylineSetupOptions
     * object has the same effect as specifying a function that returns that
     * static object. <br><br>Do not reuse the same PolylineSetupOptions object
     * in different PolylineSetup functions or static values, and do not reuse
     * the same google.maps.PolylineOptions object for the polylineOptions key
     * in different PolylineSetupOptions objects. If polylineOptions or visible
     * is unset or null, it will be overwritten with the default. Any values set
     * for polylineOptions.map or polylineOptions.path will be ignored.
     */
    anticipatedRoutePolylineSetup:
        google.maps.journeySharing.PolylineSetupOptions|
        ((a: google.maps.journeySharing.DefaultPolylineSetupOptions) =>
             google.maps.journeySharing.PolylineSetupOptions);
    /**
     * Returns the anticipated route polylines, if any.
     */
    anticipatedRoutePolylines: google.maps.Polyline[];
    /**
     * This Field is read-only. Automatic viewport mode.
     */
    automaticViewportMode: google.maps.journeySharing.AutomaticViewportMode;
    /**
     * Configures options for a destination location marker. Invoked whenever a
     * new destination marker is rendered. <br><br>If specifying a function, the
     * function can and should modify the input&#39;s defaultMarkerOptions field
     * containing a google.maps.MarkerOptions object, and return it as
     * markerOptions in the output MarkerSetupOptions object. <br><br>Specifying
     * a MarkerSetupOptions object has the same effect as specifying a function
     * that returns that static object. <br><br>Do not reuse the same
     * MarkerSetupOptions object in different MarkerSetup functions or static
     * values, and do not reuse the same google.maps.MarkerOptions object for
     * the markerOptions key in different MarkerSetupOptions objects. If
     * markerOptions is unset or null, it will be overwritten with the default.
     * Any value set for markerOptions.map or markerOptions.position will be
     * ignored.
     * @deprecated Marker setup is deprecated. Use the
     *     <code>MarkerCustomizationFunction</code> methods for your location
     *     provider instead. This field will be removed in the future.
     */
    destinationMarkerSetup: google.maps.journeySharing.MarkerSetupOptions|
        ((a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
             google.maps.journeySharing.MarkerSetupOptions);
    /**
     * Returns the destination markers, if any.
     * @deprecated getting a list of markers via the <code>MapView</code> is
     *     deprecated. Use the <code>MarkerCustomizationFunction</code>s for
     *     your location provider to receive callbacks when a marker is added to
     *     the map or updated.
     */
    destinationMarkers: google.maps.Marker[];
    /**
     * This Field is read-only. The DOM element backing the view.
     */
    element: Element;
    /**
     * Enables or disables the traffic layer.
     */
    enableTraffic: boolean;
    /**
     * This Field is read-only. A source of tracked locations to be shown in the
     * tracking map view.
     */
    locationProvider: google.maps.journeySharing.LocationProvider;
    /**
     * This Field is read-only. The map object contained in the map view.
     */
    map: google.maps.Map;
    /**
     * This Field is read-only. The map options passed into the map via the map
     * view.
     */
    mapOptions: google.maps.MapOptions;
    /**
     * Configures options for an origin location marker. Invoked whenever a new
     * origin marker is rendered. <br><br>If specifying a function, the function
     * can and should modify the input&#39;s defaultMarkerOptions field
     * containing a google.maps.MarkerOptions object, and return it as
     * markerOptions in the output MarkerSetupOptions object. <br><br>Specifying
     * a MarkerSetupOptions object has the same effect as specifying a function
     * that returns that static object. <br><br>Do not reuse the same
     * MarkerSetupOptions object in different MarkerSetup functions or static
     * values, and do not reuse the same google.maps.MarkerOptions object for
     * the markerOptions key in different MarkerSetupOptions objects. If
     * markerOptions is unset or null, it will be overwritten with the default.
     * Any value set for markerOptions.map or markerOptions.position will be
     * ignored.
     * @deprecated Marker setup is deprecated. Use the
     *     <code>MarkerCustomizationFunction</code> methods for your location
     *     provider instead. This field will be removed in the future.
     */
    originMarkerSetup: google.maps.journeySharing.MarkerSetupOptions|
        ((a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
             google.maps.journeySharing.MarkerSetupOptions);
    /**
     * Returns the origin markers, if any.
     * @deprecated getting a list of markers via the <code>MapView</code> is
     *     deprecated. Use the <code>MarkerCustomizationFunction</code>s for
     *     your location provider to receive callbacks when a marker is added to
     *     the map or updated.
     */
    originMarkers: google.maps.Marker[];
    /**
     * Configures options for a ping location marker. Invoked whenever a new
     * ping marker is rendered. <br><br>If specifying a function, the function
     * can and should modify the input&#39;s defaultMarkerOptions field
     * containing a google.maps.MarkerOptions object, and return it as
     * markerOptions in the output MarkerSetupOptions object. <br><br>Specifying
     * a MarkerSetupOptions object has the same effect as specifying a function
     * that returns that static object. <br><br>Do not reuse the same
     * MarkerSetupOptions object in different MarkerSetup functions or static
     * values, and do not reuse the same google.maps.MarkerOptions object for
     * the markerOptions key in different MarkerSetupOptions objects. If
     * markerOptions is unset or null, it will be overwritten with the default.
     * Any value set for markerOptions.map or markerOptions.position will be
     * ignored.
     * @deprecated Marker setup is deprecated. Use the
     *     <code>MarkerCustomizationFunction</code> methods for your location
     *     provider instead. This field will be removed in the future.
     */
    pingMarkerSetup: google.maps.journeySharing.MarkerSetupOptions|
        ((a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
             google.maps.journeySharing.MarkerSetupOptions);
    /**
     * Configures options for a successful task location marker. Invoked
     * whenever a new successful task marker is rendered. <br><br>If specifying
     * a function, the function can and should modify the input&#39;s
     * defaultMarkerOptions field containing a google.maps.MarkerOptions object,
     * and return it as markerOptions in the output MarkerSetupOptions object.
     * <br><br>Specifying a MarkerSetupOptions object has the same effect as
     * specifying a function that returns that static object. <br><br>Do not
     * reuse the same MarkerSetupOptions object in different MarkerSetup
     * functions or static values, and do not reuse the same
     * google.maps.MarkerOptions object for the markerOptions key in different
     * MarkerSetupOptions objects. If markerOptions is unset or null, it will be
     * overwritten with the default. Any value set for markerOptions.map or
     * markerOptions.position will be ignored.
     * @deprecated Marker setup is deprecated. Use the
     *     <code>MarkerCustomizationFunction</code> methods for your location
     *     provider instead. This field will be removed in the future.
     */
    successfulTaskMarkerSetup: google.maps.journeySharing.MarkerSetupOptions|
        ((a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
             google.maps.journeySharing.MarkerSetupOptions);
    /**
     * Returns the successful task markers, if any.
     * @deprecated getting a list of markers via the <code>MapView</code> is
     *     deprecated. Use the <code>MarkerCustomizationFunction</code>s for
     *     your location provider to receive callbacks when a marker is added to
     *     the map or updated.
     */
    successfulTaskMarkers: google.maps.Marker[];
    /**
     * Configures options for a taken route polyline. Invoked whenever a new
     * taken route polyline is rendered. <br><br>If specifying a function, the
     * function can and should modify the input&#39;s defaultPolylineOptions
     * field containing a google.maps.PolylineOptions object, and return it as
     * polylineOptions in the output PolylineSetupOptions object.
     * <br><br>Specifying a PolylineSetupOptions object has the same effect as
     * specifying a function that returns that static object. <br><br>Do not
     * reuse the same PolylineSetupOptions object in different PolylineSetup
     * functions or static values, and do not reuse the same
     * google.maps.PolylineOptions object for the polylineOptions key in
     * different PolylineSetupOptions objects. <br><br>Any values set for
     * polylineOptions.map or polylineOptions.path will be ignored. Any unset or
     * null value will be overwritten with the default.
     */
    takenRoutePolylineSetup: google.maps.journeySharing.PolylineSetupOptions|
        ((a: google.maps.journeySharing.DefaultPolylineSetupOptions) =>
             google.maps.journeySharing.PolylineSetupOptions);
    /**
     * Returns the taken route polylines, if any.
     */
    takenRoutePolylines: google.maps.Polyline[];
    /**
     * Configures options for a task outcome location marker. Invoked whenever a
     * new task outcome location marker is rendered. <br><br>If specifying a
     * function, the function can and should modify the input&#39;s
     * defaultMarkerOptions field containing a google.maps.MarkerOptions object,
     * and return it as markerOptions in the output MarkerSetupOptions object.
     * <br><br>Specifying a MarkerSetupOptions object has the same effect as
     * specifying a function that returns that static object. <br><br>Do not
     * reuse the same MarkerSetupOptions object in different MarkerSetup
     * functions or static values, and do not reuse the same
     * google.maps.MarkerOptions object for the markerOptions key in different
     * MarkerSetupOptions objects. If markerOptions is unset or null, it will be
     * overwritten with the default. Any value set for markerOptions.map or
     * markerOptions.position will be ignored.
     * @deprecated Marker setup is deprecated. Use the
     *     <code>MarkerCustomizationFunction</code> methods for your location
     *     provider instead. This field will be removed in the future.
     */
    taskOutcomeMarkerSetup: google.maps.journeySharing.MarkerSetupOptions|
        ((a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
             google.maps.journeySharing.MarkerSetupOptions);
    /**
     * Returns the task outcome markers, if any.
     * @deprecated getting a list of markers via the <code>MapView</code> is
     *     deprecated. Use the <code>MarkerCustomizationFunction</code>s for
     *     your location provider to receive callbacks when a marker is added to
     *     the map or updated.
     */
    taskOutcomeMarkers: google.maps.Marker[];
    /**
     * Configures options for an unsuccessful task location marker. Invoked
     * whenever a new unsuccessful task marker is rendered. <br><br>If
     * specifying a function, the function can and should modify the input&#39;s
     * defaultMarkerOptions field containing a google.maps.MarkerOptions object,
     * and return it as markerOptions in the output MarkerSetupOptions object.
     * <br><br>Specifying a MarkerSetupOptions object has the same effect as
     * specifying a function that returns that static object. <br><br>Do not
     * reuse the same MarkerSetupOptions object in different MarkerSetup
     * functions or static values, and do not reuse the same
     * google.maps.MarkerOptions object for the markerOptions key in different
     * MarkerSetupOptions objects. If markerOptions is unset or null, it will be
     * overwritten with the default. Any value set for markerOptions.map or
     * markerOptions.position will be ignored.
     * @deprecated Marker setup is deprecated. Use the
     *     <code>MarkerCustomizationFunction</code> methods for your location
     *     provider instead. This field will be removed in the future.
     */
    unsuccessfulTaskMarkerSetup: google.maps.journeySharing.MarkerSetupOptions|
        ((a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
             google.maps.journeySharing.MarkerSetupOptions);
    /**
     * Returns the unsuccessful task markers, if any.
     * @deprecated getting a list of markers via the <code>MapView</code> is
     *     deprecated. Use the <code>MarkerCustomizationFunction</code>s for
     *     your location provider to receive callbacks when a marker is added to
     *     the map or updated.
     */
    unsuccessfulTaskMarkers: google.maps.Marker[];
    /**
     * Configures options for a vehicle location marker. Invoked whenever a new
     * vehicle marker is rendered. <br><br>If specifying a function, the
     * function can and should modify the input&#39;s defaultMarkerOptions field
     * containing a google.maps.MarkerOptions object, and return it as
     * markerOptions in the output MarkerSetupOptions object. <br><br>Specifying
     * a MarkerSetupOptions object has the same effect as specifying a function
     * that returns that static object. <br><br>Do not reuse the same
     * MarkerSetupOptions object in different MarkerSetup functions or static
     * values, and do not reuse the same google.maps.MarkerOptions object for
     * the markerOptions key in different MarkerSetupOptions objects. If
     * markerOptions is unset or null, it will be overwritten with the default.
     * Any value set for markerOptions.map or markerOptions.position will be
     * ignored.
     * @deprecated Marker setup is deprecated. Use the
     *     <code>MarkerCustomizationFunction</code> methods for your location
     *     provider instead. This field will be removed in the future.
     */
    vehicleMarkerSetup: google.maps.journeySharing.MarkerSetupOptions|
        ((a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
             google.maps.journeySharing.MarkerSetupOptions);
    /**
     * Returns the vehicle markers, if any.
     * @deprecated getting a list of markers via the <code>MapView</code> is
     *     deprecated. Use the <code>MarkerCustomizationFunction</code>s for
     *     your location provider to receive callbacks when a marker is added to
     *     the map or updated.
     */
    vehicleMarkers: google.maps.Marker[];
    /**
     * Configures options for a waypoint location marker. Invoked whenever a new
     * waypoint marker is rendered. <br><br>If specifying a function, the
     * function can and should modify the input&#39;s defaultMarkerOptions field
     * containing a google.maps.MarkerOptions object, and return it as
     * markerOptions in the output MarkerSetupOptions object. <br><br>Specifying
     * a MarkerSetupOptions object has the same effect as specifying a function
     * that returns that static object. <br><br>Do not reuse the same
     * MarkerSetupOptions object in different MarkerSetup functions or static
     * values, and do not reuse the same google.maps.MarkerOptions object for
     * the markerOptions key in different MarkerSetupOptions objects. If
     * markerOptions is unset or null, it will be overwritten with the default.
     * Any value set for markerOptions.map or markerOptions.position will be
     * ignored.
     * @deprecated Marker setup is deprecated. Use the
     *     <code>MarkerCustomizationFunction</code> methods for your location
     *     provider instead. This field will be removed in the future.
     */
    waypointMarkerSetup: google.maps.journeySharing.MarkerSetupOptions|
        ((a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
             google.maps.journeySharing.MarkerSetupOptions);
    /**
     * Returns the waypoint markers, if any.
     * @deprecated getting a list of markers via the <code>MapView</code> is
     *     deprecated. Use the <code>MarkerCustomizationFunction</code>s for
     *     your location provider to receive callbacks when a marker is added to
     *     the map or updated.
     */
    waypointMarkers: google.maps.Marker[];
  }
  /**
   * Options for the map view.
   */
  export interface JourneySharingMapViewOptions {
    /**
     * Configures options for an anticipated route polyline. Invoked whenever a
     * new anticipated route polyline is rendered. <br><br>If specifying a
     * function, the function can and should modify the input&#39;s
     * defaultPolylineOptions field containing a google.maps.PolylineOptions
     * object, and return it as polylineOptions in the output
     * PolylineSetupOptions object. <br><br>Specifying a PolylineSetupOptions
     * object has the same effect as specifying a function that returns that
     * static object. <br><br>Do not reuse the same PolylineSetupOptions object
     * in different PolylineSetup functions or static values, and do not reuse
     * the same google.maps.PolylineOptions object for the polylineOptions key
     * in different PolylineSetupOptions objects. If polylineOptions or visible
     * is unset or null, it will be overwritten with the default. Any values set
     * for polylineOptions.map or polylineOptions.path will be ignored.
     */
    anticipatedRoutePolylineSetup?:
        google.maps.journeySharing.PolylineSetupOptions|
        ((a: google.maps.journeySharing.DefaultPolylineSetupOptions) =>
             google.maps.journeySharing.PolylineSetupOptions)|null;
    /**
     * Automatic viewport mode. Default value is FIT_ANTICIPATED_ROUTE, which
     * enables the map view to automatically adjust the viewport to fit vehicle
     * markers, location markers, and any visible anticipated route polylines.
     * Set this to NONE to turn off automatic fitting.
     */
    automaticViewportMode?: google.maps.journeySharing.AutomaticViewportMode|
        null;
    /**
     * Configures options for a destination location marker. Invoked whenever a
     * new destination marker is rendered. <br><br>If specifying a function, the
     * function can and should modify the input&#39;s defaultMarkerOptions field
     * containing a google.maps.MarkerOptions object, and return it as
     * markerOptions in the output MarkerSetupOptions object. <br><br>Specifying
     * a MarkerSetupOptions object has the same effect as specifying a function
     * that returns that static object. <br><br>Do not reuse the same
     * MarkerSetupOptions object in different MarkerSetup functions or static
     * values, and do not reuse the same google.maps.MarkerOptions object for
     * the markerOptions key in different MarkerSetupOptions objects. If
     * markerOptions is unset or null, it will be overwritten with the default.
     * Any value set for markerOptions.map or markerOptions.position will be
     * ignored.
     * @deprecated Marker setup is deprecated. Use the
     *     <code>MarkerCustomizationFunction</code> methods for your location
     *     provider instead. This field will be removed in the future.
     */
    destinationMarkerSetup?: google.maps.journeySharing.MarkerSetupOptions|
        ((a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
             google.maps.journeySharing.MarkerSetupOptions)|null;
    /**
     * The DOM element backing the view. Required.
     */
    element: Element;
    /**
     * A source of tracked locations to be shown in the tracking map view.
     * Required.
     */
    locationProvider: google.maps.journeySharing.LocationProvider;
    /**
     * Map options passed into the google.maps.Map constructor.
     */
    mapOptions?: google.maps.MapOptions|null;
    /**
     * Configures options for an origin location marker. Invoked whenever a new
     * origin marker is rendered. <br><br>If specifying a function, the function
     * can and should modify the input&#39;s defaultMarkerOptions field
     * containing a google.maps.MarkerOptions object, and return it as
     * markerOptions in the output MarkerSetupOptions object. <br><br>Specifying
     * a MarkerSetupOptions object has the same effect as specifying a function
     * that returns that static object. <br><br>Do not reuse the same
     * MarkerSetupOptions object in different MarkerSetup functions or static
     * values, and do not reuse the same google.maps.MarkerOptions object for
     * the markerOptions key in different MarkerSetupOptions objects. If
     * markerOptions is unset or null, it will be overwritten with the default.
     * Any value set for markerOptions.map or markerOptions.position will be
     * ignored.
     * @deprecated Marker setup is deprecated. Use the
     *     <code>MarkerCustomizationFunction</code> methods for your location
     *     provider instead. This field will be removed in the future.
     */
    originMarkerSetup?: google.maps.journeySharing.MarkerSetupOptions|
        ((a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
             google.maps.journeySharing.MarkerSetupOptions)|null;
    /**
     * Configures options for a ping location marker. Invoked whenever a new
     * ping marker is rendered. <br><br>If specifying a function, the function
     * can and should modify the input&#39;s defaultMarkerOptions field
     * containing a google.maps.MarkerOptions object, and return it as
     * markerOptions in the output MarkerSetupOptions object. <br><br>Specifying
     * a MarkerSetupOptions object has the same effect as specifying a function
     * that returns that static object. <br><br>Do not reuse the same
     * MarkerSetupOptions object in different MarkerSetup functions or static
     * values, and do not reuse the same google.maps.MarkerOptions object for
     * the markerOptions key in different MarkerSetupOptions objects. If
     * markerOptions is unset or null, it will be overwritten with the default.
     * Any value set for markerOptions.map or markerOptions.position will be
     * ignored.
     * @deprecated Marker setup is deprecated. Use the
     *     <code>MarkerCustomizationFunction</code> methods for your location
     *     provider instead. This field will be removed in the future.
     */
    pingMarkerSetup?: google.maps.journeySharing.MarkerSetupOptions|
        ((a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
             google.maps.journeySharing.MarkerSetupOptions)|null;
    /**
     * Configures options for a successful task location marker. Invoked
     * whenever a new successful task marker is rendered. <br><br>If specifying
     * a function, the function can and should modify the input&#39;s
     * defaultMarkerOptions field containing a google.maps.MarkerOptions object,
     * and return it as markerOptions in the output MarkerSetupOptions object.
     * <br><br>Specifying a MarkerSetupOptions object has the same effect as
     * specifying a function that returns that static object. <br><br>Do not
     * reuse the same MarkerSetupOptions object in different MarkerSetup
     * functions or static values, and do not reuse the same
     * google.maps.MarkerOptions object for the markerOptions key in different
     * MarkerSetupOptions objects. If markerOptions is unset or null, it will be
     * overwritten with the default. Any value set for markerOptions.map or
     * markerOptions.position will be ignored.
     * @deprecated Marker setup is deprecated. Use the
     *     <code>MarkerCustomizationFunction</code> methods for your location
     *     provider instead. This field will be removed in the future.
     */
    successfulTaskMarkerSetup?: google.maps.journeySharing.MarkerSetupOptions|
        ((a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
             google.maps.journeySharing.MarkerSetupOptions)|null;
    /**
     * Configures options for a taken route polyline. Invoked whenever a new
     * taken route polyline is rendered. <br><br>If specifying a function, the
     * function can and should modify the input&#39;s defaultPolylineOptions
     * field containing a google.maps.PolylineOptions object, and return it as
     * polylineOptions in the output PolylineSetupOptions object.
     * <br><br>Specifying a PolylineSetupOptions object has the same effect as
     * specifying a function that returns that static object. <br><br>Do not
     * reuse the same PolylineSetupOptions object in different PolylineSetup
     * functions or static values, and do not reuse the same
     * google.maps.PolylineOptions object for the polylineOptions key in
     * different PolylineSetupOptions objects. <br><br>Any values set for
     * polylineOptions.map or polylineOptions.path will be ignored. Any unset or
     * null value will be overwritten with the default.
     */
    takenRoutePolylineSetup?: google.maps.journeySharing.PolylineSetupOptions|
        ((a: google.maps.journeySharing.DefaultPolylineSetupOptions) =>
             google.maps.journeySharing.PolylineSetupOptions)|null;
    /**
     * Configures options for a task outcome location marker. Invoked whenever a
     * new task outcome location marker is rendered. <br><br>If specifying a
     * function, the function can and should modify the input&#39;s
     * defaultMarkerOptions field containing a google.maps.MarkerOptions object,
     * and return it as markerOptions in the output MarkerSetupOptions object.
     * <br><br>Specifying a MarkerSetupOptions object has the same effect as
     * specifying a function that returns that static object. <br><br>Do not
     * reuse the same MarkerSetupOptions object in different MarkerSetup
     * functions or static values, and do not reuse the same
     * google.maps.MarkerOptions object for the markerOptions key in different
     * MarkerSetupOptions objects. If markerOptions is unset or null, it will be
     * overwritten with the default. Any value set for markerOptions.map or
     * markerOptions.position will be ignored.
     * @deprecated Marker setup is deprecated. Use the
     *     <code>MarkerCustomizationFunction</code> methods for your location
     *     provider instead. This field will be removed in the future.
     */
    taskOutcomeMarkerSetup?: google.maps.journeySharing.MarkerSetupOptions|
        ((a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
             google.maps.journeySharing.MarkerSetupOptions)|null;
    /**
     * Configures options for an unsuccessful task location marker. Invoked
     * whenever a new unsuccessful task marker is rendered. <br><br>If
     * specifying a function, the function can and should modify the input&#39;s
     * defaultMarkerOptions field containing a google.maps.MarkerOptions object,
     * and return it as markerOptions in the output MarkerSetupOptions object.
     * <br><br>Specifying a MarkerSetupOptions object has the same effect as
     * specifying a function that returns that static object. <br><br>Do not
     * reuse the same MarkerSetupOptions object in different MarkerSetup
     * functions or static values, and do not reuse the same
     * google.maps.MarkerOptions object for the markerOptions key in different
     * MarkerSetupOptions objects. If markerOptions is unset or null, it will be
     * overwritten with the default. Any value set for markerOptions.map or
     * markerOptions.position will be ignored.
     * @deprecated Marker setup is deprecated. Use the
     *     <code>MarkerCustomizationFunction</code> methods for your location
     *     provider instead. This field will be removed in the future.
     */
    unsuccessfulTaskMarkerSetup?: google.maps.journeySharing.MarkerSetupOptions|
        ((a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
             google.maps.journeySharing.MarkerSetupOptions)|null;
    /**
     * Configures options for a vehicle location marker. Invoked whenever a new
     * vehicle marker is rendered. <br><br>If specifying a function, the
     * function can and should modify the input&#39;s defaultMarkerOptions field
     * containing a google.maps.MarkerOptions object, and return it as
     * markerOptions in the output MarkerSetupOptions object. <br><br>Specifying
     * a MarkerSetupOptions object has the same effect as specifying a function
     * that returns that static object. <br><br>Do not reuse the same
     * MarkerSetupOptions object in different MarkerSetup functions or static
     * values, and do not reuse the same google.maps.MarkerOptions object for
     * the markerOptions key in different MarkerSetupOptions objects. If
     * markerOptions is unset or null, it will be overwritten with the default.
     * Any value set for markerOptions.map or markerOptions.position will be
     * ignored.
     * @deprecated Marker setup is deprecated. Use the
     *     <code>MarkerCustomizationFunction</code> methods for your location
     *     provider instead. This field will be removed in the future.
     */
    vehicleMarkerSetup?: google.maps.journeySharing.MarkerSetupOptions|
        ((a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
             google.maps.journeySharing.MarkerSetupOptions)|null;
    /**
     * Configures options for a waypoint location marker. Invoked whenever a new
     * waypoint marker is rendered. <br><br>If specifying a function, the
     * function can and should modify the input&#39;s defaultMarkerOptions field
     * containing a google.maps.MarkerOptions object, and return it as
     * markerOptions in the output MarkerSetupOptions object. <br><br>Specifying
     * a MarkerSetupOptions object has the same effect as specifying a function
     * that returns that static object. <br><br>Do not reuse the same
     * MarkerSetupOptions object in different MarkerSetup functions or static
     * values, and do not reuse the same google.maps.MarkerOptions object for
     * the markerOptions key in different MarkerSetupOptions objects. If
     * markerOptions is unset or null, it will be overwritten with the default.
     * Any value set for markerOptions.map or markerOptions.position will be
     * ignored.
     * @deprecated Marker setup is deprecated. Use the
     *     <code>MarkerCustomizationFunction</code> methods for your location
     *     provider instead. This field will be removed in the future.
     */
    waypointMarkerSetup?: google.maps.journeySharing.MarkerSetupOptions|
        ((a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
             google.maps.journeySharing.MarkerSetupOptions)|null;
  }
  /**
   * Parent class of all location providers.
   */
  export abstract class LocationProvider {
    /**
     * Adds a {@link google.maps.MapsEventListener} for an event fired by this
     * location provider. Returns an identifier for this listener that can be
     * used with {@link google.maps.event.removeListener}.
     * @param eventName The name of the event to listen for.
     * @param handler The event handler.
     */
    addListener(eventName: string, handler: Function):
        google.maps.MapsEventListener;
  }
  /**
   * Parameters that are common to all marker customization functions. No object
   * of this class is provided directly to any marker customization function; an
   * object of one of its descendent classes is provided instead.
   */
  export interface MarkerCustomizationFunctionParams {
    /**
     * The default options used to create this marker.
     */
    defaultOptions: google.maps.MarkerOptions;
    /**
     * If true, the marker was newly created, and the marker customization
     * function is being called for the first time, before the marker has been
     * added to the map view. False otherwise.
     */
    isNew: boolean;
    /**
     * The marker. Any customizations should be made to this object directly.
     */
    marker: google.maps.Marker;
  }
  export type MarkerSetup = google.maps.journeySharing.MarkerSetupOptions|(
      (a: google.maps.journeySharing.DefaultMarkerSetupOptions) =>
          google.maps.journeySharing.MarkerSetupOptions);
  /**
   * MarkerSetup options.
   * @deprecated Marker setup is deprecated. Use the
   *     <code>MarkerCustomizationFunction</code> methods for your location
   *     provider instead.
   */
  export interface MarkerSetupOptions {
    /**
     * Marker options.
     */
    markerOptions?: google.maps.MarkerOptions|null;
  }
  /**
   * Parameters specific to marker customization functions that apply options to
   * markers representing planned stops. Used by {@link
   * google.maps.journeySharing.FleetEngineDeliveryVehicleLocationProviderOptions.plannedStopMarkerCustomization}.
   */
  export interface PlannedStopMarkerCustomizationFunctionParams extends
      google.maps.journeySharing
          .DeliveryVehicleMarkerCustomizationFunctionParams {
    /**
     * The 0-based index of this stop in the list of remaining stops.
     */
    stopIndex: number;
  }
  /**
   * Parent class of polling location providers.
   */
  export abstract class PollingLocationProvider extends
      google.maps.journeySharing.LocationProvider {
    /**
     * True if this location provider is polling. Read only.
     */
    isPolling: boolean;
    /**
     * Minimum time between fetching location updates in milliseconds. If it
     * takes longer than <code>pollingIntervalMillis</code> to fetch a location
     * update, the next location update is not started until the current one
     * finishes. <br><br>Setting this value to 0, Infinity, or a negative value
     * disables automatic location updates. A new location update is fetched
     * once if the tracking ID parameter (for example, the shipment tracking ID
     * of the shipment location provider), or a filtering option (for example,
     * viewport bounds or attribute filters for fleet location providers)
     * changes. <br><br>The default, and minimum, polling interval is 5000
     * milliseconds. If you set the polling interval to a lower positive value,
     * 5000 is stored and used.
     */
    pollingIntervalMillis: number;
  }
  /**
   * The event object passed to the event handler when the {@link
   * google.maps.journeySharing.PollingLocationProvider.ispollingchange} event
   * is triggered.
   */
  export interface PollingLocationProviderIsPollingChangeEvent {
    /**
     * The error that caused the polling state to change, if the state change
     * was caused by an error. Undefined if the state change was due to normal
     * operations.
     */
    error: Error|null;
  }
  export type PolylineSetup = google.maps.journeySharing.PolylineSetupOptions|(
      (a: google.maps.journeySharing.DefaultPolylineSetupOptions) =>
          google.maps.journeySharing.PolylineSetupOptions);
  /**
   * PolylineSetup options.
   */
  export interface PolylineSetupOptions {
    /**
     * Polyline options.
     */
    polylineOptions?: google.maps.PolylineOptions|null;
    /**
     * Polyline visibility.
     */
    visible?: boolean|null;
  }
  /**
   * Parameters specific to marker customization functions that apply options to
   * markers representing shipment delivery vehicle and destination locations.
   * Used by {@link
   * google.maps.journeySharing.FleetEngineShipmentLocationProviderOptions.deliveryVehicleMarkerCustomization}
   * and {@link
   * google.maps.journeySharing.FleetEngineShipmentLocationProviderOptions.destinationMarkerCustomization}.
   */
  export interface ShipmentMarkerCustomizationFunctionParams extends
      google.maps.journeySharing.MarkerCustomizationFunctionParams {
    /**
     * Information for the task associated with this marker.
     */
    taskTrackingInfo: google.maps.journeySharing.TaskTrackingInfo;
  }
  /**
   * The details for a task returned by Fleet Engine.
   */
  export interface Task {
    /**
     * Attributes assigned to the task.
     */
    attributes: {[key: string]: any};
    /**
     * The timestamp of the estimated completion time of the task.
     */
    estimatedCompletionTime: Date|null;
    /**
     * Information specific to the last location update.
     */
    latestVehicleLocationUpdate:
        google.maps.journeySharing.VehicleLocationUpdate|null;
    /**
     * The task name in the format
     * &quot;providers/{provider_id}/tasks/{task_id}&quot;. The task_id must be
     * a unique identifier and not a tracking ID. To store a tracking ID of a
     * shipment, use the tracking_id field. Multiple tasks can have the same
     * tracking_id.
     */
    name: string;
    /**
     * The outcome of the task.
     */
    outcome: string|null;
    /**
     * The location where the task was completed (from provider).
     */
    outcomeLocation: google.maps.LatLngLiteral|null;
    /**
     * The setter of the task outcome location (&#39;PROVIDER&#39; or
     * &#39;LAST_VEHICLE_LOCATION&#39;).
     */
    outcomeLocationSource: string|null;
    /**
     * The timestamp of when the task&#39;s outcome was set (from provider).
     */
    outcomeTime: Date|null;
    /**
     * The location where the task is to be completed.
     */
    plannedLocation: google.maps.LatLngLiteral|null;
    /**
     * Information about the segments left to be completed for this task.
     */
    remainingVehicleJourneySegments:
        google.maps.journeySharing.VehicleJourneySegment[];
    /**
     * The current execution state of the task.
     */
    status: string;
    /**
     * The time window during which the task should be completed.
     */
    targetTimeWindow: google.maps.journeySharing.TimeWindow|null;
    /**
     * The tracking ID of the shipment.
     */
    trackingId: string|null;
    /**
     * The task type; for example, a break or shipment.
     */
    type: string;
    /**
     * The ID of the vehicle performing this task.
     */
    vehicleId: string|null;
  }
  /**
   * TaskInfo type, used by {@link
   * google.maps.journeySharing.DeliveryVehicleStop}.
   */
  export interface TaskInfo {
    /**
     * The extra time it takes to perform the task, in milliseconds.
     */
    extraDurationMillis: number|null;
    /**
     * The ID of the task.
     */
    id: string|null;
    /**
     * The time window during which the task should be completed.
     */
    targetTimeWindow: google.maps.journeySharing.TimeWindow|null;
  }
  /**
   * Parameters specific to marker customization functions that apply options to
   * markers representing planned or actual task locations. Used by {@link
   * google.maps.journeySharing.FleetEngineDeliveryVehicleLocationProviderOptions.taskMarkerCustomization}
   * and {@link
   * google.maps.journeySharing.FleetEngineDeliveryVehicleLocationProviderOptions.taskOutcomeMarkerCustomization}.
   */
  export interface TaskMarkerCustomizationFunctionParams extends
      google.maps.journeySharing
          .DeliveryVehicleMarkerCustomizationFunctionParams {
    /**
     * The task location represented by this marker.
     */
    task: google.maps.journeySharing.Task;
  }
  /**
   * The details for a task tracking info object returned by Fleet Engine.
   */
  export interface TaskTrackingInfo {
    /**
     * Attributes assigned to the task.
     */
    attributes: {[key: string]: any};
    /**
     * The estimated arrival time to the stop location.
     */
    estimatedArrivalTime: Date|null;
    /**
     * The estimated completion time of a Task.
     */
    estimatedTaskCompletionTime: Date|null;
    /**
     * Information specific to the last location update.
     */
    latestVehicleLocationUpdate:
        google.maps.journeySharing.VehicleLocationUpdate|null;
    /**
     * The name in the format
     * &quot;providers/{provider_id}/taskTrackingInfo/{tracking_id}&quot;, where
     * <code>tracking_id</code> represents the tracking ID.
     */
    name: string;
    /**
     * The location where the Task will be completed.
     */
    plannedLocation: google.maps.LatLng|null;
    /**
     * The total remaining distance in meters to the <code>VehicleStop</code> of
     * interest.
     */
    remainingDrivingDistanceMeters: number|null;
    /**
     * Indicates the number of stops the vehicle remaining until the task stop
     * is reached, including the task stop. For example, if the vehicle&#39;s
     * next stop is the task stop, the value will be 1.
     */
    remainingStopCount: number|null;
    /**
     * A list of points which when connected forms a polyline of the
     * vehicle&#39;s expected route to the location of this task.
     */
    routePolylinePoints: google.maps.LatLng[]|null;
    /**
     * The current execution state of the Task.
     */
    state: string|null;
    /**
     * The time window during which the task should be completed.
     */
    targetTimeWindow: google.maps.journeySharing.TimeWindow|null;
    /**
     * The outcome of attempting to execute a Task.
     */
    taskOutcome: string|null;
    /**
     * The time when the Task&#39;s outcome was set by the provider.
     */
    taskOutcomeTime: Date|null;
    /**
     * The tracking ID of a Task.<br> <ul> <li>Must be a valid Unicode
     * string.</li> <li>Limited to a maximum length of 64 characters.</li>
     * <li>Normalized according to <a
     * href="http://www.unicode.org/reports/tr15/">Unicode Normalization Form
     * C</a>.</li> <li>May not contain any of the following ASCII characters:
     * &#39;/&#39;, &#39;:&#39;, &#39;?&#39;, &#39;,&#39;, or
     * &#39;#&#39;.</li> </ul>
     */
    trackingId: string;
  }
  /**
   * A time range.
   */
  export interface TimeWindow {
    /**
     * The end time of the time window (inclusive).
     */
    endTime: Date;
    /**
     * The start time of the time window (inclusive).
     */
    startTime: Date;
  }
  /**
   * The details for a trip returned by Fleet Engine.
   */
  export interface Trip {
    /**
     * Location where the customer was dropped off.
     */
    actualDropOffLocation: google.maps.LatLngLiteral|null;
    /**
     * Location where the customer was picked up.
     */
    actualPickupLocation: google.maps.LatLngLiteral|null;
    /**
     * The estimated future time when the passengers will be dropped off, or the
     * actual time when they were dropped off.
     */
    dropOffTime: Date|null;
    /**
     * Information specific to the last location update.
     */
    latestVehicleLocationUpdate:
        google.maps.journeySharing.VehicleLocationUpdate|null;
    /**
     * In the format &quot;providers/{provider_id}/trips/{trip_id}&quot;. The
     * trip_id must be a unique identifier.
     */
    name: string;
    /**
     * Number of passengers on this trip; does not include the driver.
     */
    passengerCount: number;
    /**
     * The estimated future time when the passengers will be picked up, or the
     * actual time when they were picked up.
     */
    pickupTime: Date|null;
    /**
     * Location where the customer indicates they will be dropped off.
     */
    plannedDropOffLocation: google.maps.LatLngLiteral|null;
    /**
     * Location where customer indicates they will be picked up.
     */
    plannedPickupLocation: google.maps.LatLngLiteral|null;
    /**
     * An array of waypoints indicating the path from the current location to
     * the drop-off point.
     */
    remainingWaypoints: google.maps.journeySharing.VehicleWaypoint[];
    /**
     * Current status of the trip. Possible values are UNKNOWN_TRIP_STATUS, NEW,
     * ENROUTE_TO_PICKUP, ARRIVED_AT_PICKUP,
     * ARRIVED_AT_INTERMEDIATE_DESTINATION, ENROUTE_TO_INTERMEDIATE_DESTINATION,
     * ENROUTE_TO_DROPOFF, COMPLETE, or CANCELED.
     */
    status: string;
    /**
     * The type of the trip. Possible values are UNKNOWN_TRIP_TYPE, SHARED or
     * EXCLUSIVE.
     */
    type: string;
    /**
     * ID of the vehicle making this trip.
     */
    vehicleId: string;
  }
  /**
   * Parameters specific to marker customization functions that apply options to
   * markers representing trip vehicle, origin and destination locations. Used
   * by {@link
   * google.maps.journeySharing.FleetEngineTripLocationProviderOptions.vehicleMarkerCustomization}, {@link
   * google.maps.journeySharing.FleetEngineTripLocationProviderOptions.originMarkerCustomization},
   * and {@link
   * google.maps.journeySharing.FleetEngineTripLocationProviderOptions.destinationMarkerCustomization}.
   */
  export interface TripMarkerCustomizationFunctionParams extends
      google.maps.journeySharing.MarkerCustomizationFunctionParams {
    /**
     * The trip associated with this marker. <br><br>For information about the
     * vehicle servicing this trip, use {@link
     * google.maps.journeySharing.Trip.latestVehicleLocationUpdate} and {@link
     * google.maps.journeySharing.Trip.remainingWaypoints}.
     */
    trip: google.maps.journeySharing.Trip;
  }
  /**
   * Parameters specific to marker customization functions that apply options to
   * markers representing trip waypoint locations. Used by {@link
   * google.maps.journeySharing.FleetEngineTripLocationProviderOptions.waypointMarkerCustomization}.
   */
  export interface TripWaypointMarkerCustomizationFunctionParams extends
      google.maps.journeySharing.TripMarkerCustomizationFunctionParams {
    /**
     * The 0-based waypoint index associated with this marker. Use this index
     * on {@link google.maps.journeySharing.Trip.remainingWaypoints} to retrieve
     * information about the waypoint.
     */
    waypointIndex: number;
  }
  /**
   * VehicleJourneySegment type
   */
  export interface VehicleJourneySegment {
    /**
     * The travel distance from the previous stop to this stop, in meters.
     */
    drivingDistanceMeters: number|null;
    /**
     * The travel time from the previous stop this stop, in milliseconds.
     */
    drivingDurationMillis: number|null;
    /**
     * The path from the previous stop (or the vehicle&#39;s current location,
     * if this stop is the first in the list of stops) to this stop.
     */
    path: google.maps.LatLngLiteral[]|null;
    /**
     * Information about the stop.
     */
    stop: google.maps.journeySharing.DeliveryVehicleStop|null;
  }
  /**
   * VehicleLocationUpdate type
   */
  export interface VehicleLocationUpdate {
    /**
     * The heading of the update. 0 corresponds to north, 180 to south.
     */
    heading: number|null;
    /**
     * The location of the update.
     */
    location: google.maps.LatLngLiteral|null|google.maps.LatLng;
    /**
     * The speed in kilometers per hour.
     */
    speedKilometersPerHour: number|null;
    /**
     * The time this update was received from the vehicle.
     */
    time: Date|null;
  }
  /**
   * VehicleWaypoint type.
   */
  export interface VehicleWaypoint {
    /**
     * The path distance between the previous waypoint (or the vehicle&#39;s
     * current location, if this waypoint is the first in the list of waypoints)
     * to this waypoint in meters.
     */
    distanceMeters: number|null;
    /**
     * Travel time between the previous waypoint (or the vehicle&#39;s current
     * location, if this waypoint is the first in the list of waypoints) to this
     * waypoint in milliseconds.
     */
    durationMillis: number|null;
    /**
     * The location of the waypoint.
     */
    location: google.maps.LatLngLiteral|null;
    /**
     * The path from the previous waypoint (or the vehicle&#39;s current
     * location, if this waypoint is the first in the list of waypoints) to this
     * waypoint.
     */
    path: google.maps.LatLngLiteral[]|null;
  }
}
declare namespace google.maps.localContext {
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * Shows a Local Context experience with a {@link google.maps.Map}.
   *
   * Access by calling `const {LocalContextMapView} = await
   * google.maps.importLibrary("localContext")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   * @deprecated Local Context is deprecated, and no longer recommended for new
   *     websites. The feature will continue to work, and 12 months notice will
   *     be given before support is discontinued. If you are interested in
   *     building a Local Context-like experience yourself, we suggest that you
   *     check out the &quot;Neighborhood Discovery&quot; solution in <a
   *     href="https://mapsplatform.google.com/resources/quick-builder/">Quick
   *     Builder</a> or use the <a
   *     href="https://developers.google.com/maps/documentation/javascript/places">Places
   *     Library</a>, Maps JavaScript API. <a
   *     href="https://developers.google.com/maps/documentation/javascript/examples#places">Code
   *     samples</a> and <a
   *     href="https://codelabs.developers.google.com/?product=googlemapsplatform&text=places">codelabs</a>
   *     for the Places Library can help you.
   */
  export class LocalContextMapView implements
      google.maps.localContext.LocalContextMapViewOptions {
    /**
     * Available only in the v=beta channel: https://goo.gle/3oAthT3.
     *
     * Shows a Local Context experience with a {@link google.maps.Map}.
     *
     * Access by calling `const {LocalContextMapView} = await
     * google.maps.importLibrary("localContext")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     * @deprecated Local Context is deprecated, and no longer recommended for
     *     new websites. The feature will continue to work, and 12 months notice
     *     will be given before support is discontinued. If you are interested
     *     in building a Local Context-like experience yourself, we suggest that
     *     you check out the &quot;Neighborhood Discovery&quot; solution in <a
     *     href="https://mapsplatform.google.com/resources/quick-builder/">Quick
     *     Builder</a> or use the <a
     *     href="https://developers.google.com/maps/documentation/javascript/places">Places
     *     Library</a>, Maps JavaScript API. <a
     *     href="https://developers.google.com/maps/documentation/javascript/examples#places">Code
     *     samples</a> and <a
     *     href="https://codelabs.developers.google.com/?product=googlemapsplatform&text=places">codelabs</a>
     *     for the Places Library can help you.
     */
    constructor(options: google.maps.localContext.LocalContextMapViewOptions);
    /**
     * Adds the given listener function to the given event name.
     */
    addListener(eventName: string, handler: Function):
        google.maps.MapsEventListener;
    /**
     * See {@link
     * google.maps.localContext.LocalContextMapViewOptions.directionsOptions}.
     */
    directionsOptions?: null|
        google.maps.localContext.MapDirectionsOptionsLiteral;
    /**
     * This Field is read-only. The DOM Element backing the view.
     */
    element?: null|HTMLElement|SVGElement;
    /**
     * Hides the place details.
     */
    hidePlaceDetailsView(): void;
    /**
     * Is set to <code>true</code> before {@link
     * google.maps.localContext.LocalContextMapView} begins changing the bounds
     * of the inner {@link google.maps.Map}, and set to <code>false</code>
     * after {@link google.maps.localContext.LocalContextMapView} finishes
     * changing the bounds of the inner {@link google.maps.Map}. (Not set when
     * layout mode changes happen due to responsive resizing.)
     */
    isTransitioningMapBounds: boolean;
    /**
     * See {@link
     * google.maps.localContext.LocalContextMapViewOptions.locationBias}.
     * Changing this property on the <code>LocalContextMapView</code> may
     * trigger a new search.
     */
    locationBias?: google.maps.LatLng|google.maps.LatLngLiteral|
        google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral|
        google.maps.Circle|google.maps.CircleLiteral|string|null;
    /**
     * See {@link
     * google.maps.localContext.LocalContextMapViewOptions.locationRestriction}.
     * Changing this property on the <code>LocalContextMapView</code> may
     * trigger a new search.
     */
    locationRestriction?: google.maps.LatLngBounds|
        google.maps.LatLngBoundsLiteral|null;
    map?: google.maps.Map|null;
    /**
     * See {@link
     * google.maps.localContext.LocalContextMapViewOptions.maxPlaceCount}.
     * Changing this property on the <code>LocalContextMapView</code> may
     * trigger a new search.
     */
    maxPlaceCount: number;
    pinOptionsSetup?:
        ((a: {isHighlighted: boolean, isSelected: boolean}) =>
             google.maps.localContext.PinOptions | null |
             undefined)|google.maps.localContext.PinOptions|null;
    placeChooserViewSetup?:
        ((a: {
           defaultLayoutMode: google.maps.localContext.PlaceChooserLayoutMode,
           defaultPosition: google.maps.localContext.PlaceChooserPosition|null
         }) => google.maps.localContext.PlaceChooserViewSetupOptions | null |
             undefined)|google.maps.localContext.PlaceChooserViewSetupOptions
        |null;
    placeDetailsViewSetup?:
        ((a: {
           defaultLayoutMode: google.maps.localContext.PlaceDetailsLayoutMode,
           defaultPosition: google.maps.localContext.PlaceDetailsPosition|null
         }) => google.maps.localContext.PlaceDetailsViewSetupOptions | null |
             undefined)|google.maps.localContext.PlaceDetailsViewSetupOptions
        |null;
    /**
     * See {@link
     * google.maps.localContext.LocalContextMapViewOptions.placeTypePreferences}.
     * Changing this property on the <code>LocalContextMapView</code> may
     * trigger a new search.
     * <code>Iterable&lt;string|PlaceTypePreference&gt;</code> is also accepted.
     */
    placeTypePreferences: google.maps.localContext.PlaceTypePreference[];
    /**
     * Searches for places to show the user based on the current
     * <code>maxPlaceCount</code>, <code>placeTypePreferences</code>,
     * <code>locationRestriction</code>, and <code>locationBias</code>.
     */
    search(): void;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * Options for constructing a {@link
   * google.maps.localContext.LocalContextMapView}, or accessing an
   * existing {@link google.maps.localContext.LocalContextMapView}.
   */
  export interface LocalContextMapViewOptions {
    /**
     * Options for customizing directions. If not set, directions and distance
     * will be disabled.
     */
    directionsOptions?: null|
        google.maps.localContext.MapDirectionsOptionsLiteral;
    /**
     * This Field is read-only. The DOM Element backing the view.
     */
    element?: null|HTMLElement|SVGElement;
    /**
     * A soft boundary or hint to use when searching for places.
     * @defaultValue <code>null</code>
     */
    locationBias?: google.maps.LatLng|google.maps.LatLngLiteral|
        google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral|
        google.maps.Circle|google.maps.CircleLiteral|string|null;
    /**
     * Bounds to constrain search results. If not specified, results will be
     * constrained to the map viewport.
     */
    locationRestriction?: google.maps.LatLngBounds|
        google.maps.LatLngBoundsLiteral|null;
    /**
     * An already instantiated {@link google.maps.Map} instance. If passed in,
     * the map will be moved into the LocalContextMapView&#39;s DOM, and will
     * <strong>not</strong> be re-styled. The element associated with the Map
     * may also have styles and classes applied to it by the
     * <code>LocalContextMapView</code>.
     */
    map?: google.maps.Map|null;
    /**
     * The maximum number of places to show. When this parameter is 0, the Local
     * Context Library does not load places. [0,24]
     */
    maxPlaceCount: number;
    /**
     * Configure the place marker icon based on the icon state. Invoked whenever
     * the input to the callback changes. Pass a function to dynamically
     * override the default setup when the LocalContextMapView draws the place
     * marker. Errors and invalid configurations may be determined
     * asynchronously, and will be ignored (defaults will be used, and errors
     * will be logged to the console).
     */
    pinOptionsSetup?:
        ((a: {isHighlighted: boolean, isSelected: boolean}) =>
             google.maps.localContext.PinOptions | null |
             undefined)|google.maps.localContext.PinOptions|null;
    /**
     * Overrides the setup of the place chooser view. Pass a function to
     * dynamically override the default setup when the LocalContextMapView might
     * change its layout due to resizing. Errors and invalid configurations may
     * be determined asynchronously, and will be ignored (defaults will be used
     * instead, and errors will be logged to the console). Errors detected at
     * construction will cause errors to be thrown synchronously.
     */
    placeChooserViewSetup?:
        ((a: {
           defaultLayoutMode: google.maps.localContext.PlaceChooserLayoutMode,
           defaultPosition: google.maps.localContext.PlaceChooserPosition|null
         }) => google.maps.localContext.PlaceChooserViewSetupOptions | null |
             undefined)|google.maps.localContext.PlaceChooserViewSetupOptions
        |null;
    /**
     * Overrides the setup of the place details view. Pass a function to
     * dynamically override the default setup when the LocalContextMapView might
     * change its layout due to resizing. Errors and invalid configurations may
     * be determined asynchronously, and will be ignored (defaults will be used,
     * and errors will be logged to the console). Errors detected at
     * construction will cause errors to be thrown synchronously.
     */
    placeDetailsViewSetup?:
        ((a: {
           defaultLayoutMode: google.maps.localContext.PlaceDetailsLayoutMode,
           defaultPosition: google.maps.localContext.PlaceDetailsPosition|null
         }) => google.maps.localContext.PlaceDetailsViewSetupOptions | null |
             undefined)|google.maps.localContext.PlaceDetailsViewSetupOptions
        |null;
    /**
     * The types of places to search for (up to 10). The type
     * <code>Iterable&lt;string|PlaceTypePreference&gt;</code> is also accepted,
     * but is only supported in browsers which natively support JavaScript
     * Symbols.
     */
    placeTypePreferences: google.maps.localContext.PlaceTypePreference[];
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * Provides settings for directions with a {@link
   * google.maps.localContext.LocalContextMapView}.
   *
   * Access by calling `const {MapDirectionsOptions} = await
   * google.maps.importLibrary("localContext")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class MapDirectionsOptions implements
      google.maps.localContext.MapDirectionsOptionsLiteral {
    /**
     * Adds the given listener function to the given event name.
     */
    addListener(eventName: string, handler: Function):
        google.maps.MapsEventListener;
    origin: google.maps.LatLng|google.maps.LatLngLiteral;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * Object literals are accepted in place of {@link
   * google.maps.localContext.MapDirectionsOptions} objects, as a convenience,
   * in many places. These are converted to {@link
   * google.maps.localContext.MapDirectionsOptions} objects when the Maps API
   * encounters them.
   */
  export interface MapDirectionsOptionsLiteral {
    /**
     * Origin for directions and distance.
     */
    origin: google.maps.LatLng|google.maps.LatLngLiteral;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * Options for customizing a pin marker.
   */
  export interface PinOptions {
    /**
     * The color of the icon&#39;s shape, can be any valid CSS color.
     */
    background?: string|null;
    /**
     * The color of the icon&#39;s glyph, can be any valid CSS color.
     */
    glyphColor?: string|null;
    /**
     * The scale of the icon. The value is absolute, not relative to the default
     * sizes in each state.
     */
    scale?: number|null;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * Layout modes for the place chooser.
   *
   * Access by calling `const {PlaceChooserLayoutMode} = await
   * google.maps.importLibrary("localContext")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum PlaceChooserLayoutMode {
    /**
     * Place chooser is hidden.
     */
    HIDDEN = 'HIDDEN',
    /**
     * Place chooser is shown as a sheet.
     */
    SHEET = 'SHEET',
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * Display positions for the place chooser.
   *
   * Access by calling `const {PlaceChooserPosition} = await
   * google.maps.importLibrary("localContext")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum PlaceChooserPosition {
    /**
     * Place chooser is displayed on a line below the map extending to the end
     * of the container.
     */
    BLOCK_END = 'BLOCK_END',
    /**
     * Place chooser is displayed inline with the map at the end of the line.
     * (In a left-to-right language this means that the place chooser is to the
     * right of the map.)
     */
    INLINE_END = 'INLINE_END',
    /**
     * Place chooser is displayed inline with the map at the start of the line.
     * (In a left-to-right language this means that the place chooser is to the
     * left of the map.)
     */
    INLINE_START = 'INLINE_START',
  }
  /**
   * Setup options for the place chooser. Read more about <a
   * href="https://developers.google.com/maps/documentation/javascript/local-context/set-options#setting_layout_and_visibility">setting
   * layout and visibility</a>.
   */
  export interface PlaceChooserViewSetupOptions {
    layoutMode?: google.maps.localContext.PlaceChooserLayoutMode|null;
    /**
     * Ignored when <code>layoutMode:HIDDEN</code>. If not passed, a position
     * will be determined automatically based on the <code>layoutMode</code>.
     */
    position?: google.maps.localContext.PlaceChooserPosition|null;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * Layout modes for the place details.
   *
   * Access by calling `const {PlaceDetailsLayoutMode} = await
   * google.maps.importLibrary("localContext")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum PlaceDetailsLayoutMode {
    /**
     * Place details is displayed in an {@link google.maps.InfoWindow}.
     */
    INFO_WINDOW = 'INFO_WINDOW',
    /**
     * Place details is displayed in a sheet.
     */
    SHEET = 'SHEET',
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * Display positions for the place details.
   *
   * Access by calling `const {PlaceDetailsPosition} = await
   * google.maps.importLibrary("localContext")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum PlaceDetailsPosition {
    /**
     * Place details is displayed inline with the map at the end of the line.
     * (In a left-to-right language this means that the place details is to the
     * right of the map.)
     */
    INLINE_END = 'INLINE_END',
    /**
     * Place details is displayed inline with the map at the start of the line.
     * (In a left-to-right language this means that the place details is to the
     * left of the map.)
     */
    INLINE_START = 'INLINE_START',
  }
  /**
   * Setup options for the place details. Read more about <a
   * href="https://developers.google.com/maps/documentation/javascript/local-context/set-options#setting_layout_and_visibility">setting
   * layout and visibility</a>.
   */
  export interface PlaceDetailsViewSetupOptions {
    hidesOnMapClick?: boolean;
    layoutMode?: google.maps.localContext.PlaceDetailsLayoutMode|null;
    /**
     * Ignored when <code>layoutMode:INFO_WINDOW</code>. If not passed, a
     * position will be determined automatically based on the
     * <code>layoutMode</code>.
     */
    position?: google.maps.localContext.PlaceDetailsPosition|null;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   */
  export type PlaceTypePreference = {type: string, weight?: number};
}
declare namespace google.maps.marker {
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * This event is created from clicking an Advanced Marker. Access the
   * marker&#39;s position with <code>event.target.position</code>.
   *
   * Access by calling `const {AdvancedMarkerClickEvent} = await
   * google.maps.importLibrary("marker")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class AdvancedMarkerClickEvent extends Event {
    /**
     * Available only in the v=beta channel: https://goo.gle/3oAthT3.
     *
     * This event is created from clicking an Advanced Marker. Access the
     * marker&#39;s position with <code>event.target.position</code>.
     *
     * Access by calling `const {AdvancedMarkerClickEvent} = await
     * google.maps.importLibrary("marker")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor();
  }
  /**
   * Shows a position on a map. Note that the <code>position</code> must be set
   * for the <code>AdvancedMarkerElement</code> to display.<br> <br>
   * <strong>Note:</strong> Usage as a Web Component (e.g. using the custom
   * <code>&lt;gmp-advanced-marker&gt;</code> HTML element, is only available in
   * the <code>v=beta</code> channel).
   *
   * Access by calling `const {AdvancedMarkerElement} = await
   * google.maps.importLibrary("marker")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class AdvancedMarkerElement extends HTMLElement implements
      google.maps.marker.AdvancedMarkerElementOptions {
    /**
     * Shows a position on a map. Note that the <code>position</code> must be
     * set for the <code>AdvancedMarkerElement</code> to display.<br> <br>
     * <strong>Note:</strong> Usage as a Web Component (e.g. using the custom
     * <code>&lt;gmp-advanced-marker&gt;</code> HTML element, is only available
     * in the <code>v=beta</code> channel).
     *
     * Access by calling `const {AdvancedMarkerElement} = await
     * google.maps.importLibrary("marker")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(options?: google.maps.marker.AdvancedMarkerElementOptions);
    /**
     * Adds the given listener function to the given event name in the Maps
     * Eventing system.
     * @param eventName Observed event.
     * @param handler Function to handle events.
     */
    addListener(eventName: string, handler: Function):
        google.maps.MapsEventListener;
    /**
     * See {@link
     * google.maps.marker.AdvancedMarkerElementOptions.collisionBehavior}.
     */
    collisionBehavior?: null|google.maps.CollisionBehavior;
    /**
     * See {@link google.maps.marker.AdvancedMarkerElementOptions.content}.
     */
    content?: null|Node;
    /**
     * This field is read-only. The DOM Element backing the view.
     */
    element: HTMLElement;
    /**
     * See {@link google.maps.marker.AdvancedMarkerElementOptions.gmpDraggable}.
     */
    gmpDraggable?: null|boolean;
    /**
     * See {@link google.maps.marker.AdvancedMarkerElementOptions.map}.
     */
    map?: null|google.maps.Map;
    /**
     * See {@link google.maps.marker.AdvancedMarkerElementOptions.position}.
     */
    position?: null|google.maps.LatLng|google.maps.LatLngLiteral|
        google.maps.LatLngAltitudeLiteral;
    /**
     * See {@link google.maps.marker.AdvancedMarkerElementOptions.title}.
     */
    title: string;
    /**
     * See {@link google.maps.marker.AdvancedMarkerElementOptions.zIndex}.
     */
    zIndex?: null|number;
  }
  /**
   * Options for constructing an {@link
   * google.maps.marker.AdvancedMarkerElement}.
   */
  export interface AdvancedMarkerElementOptions {
    /**
     * An enumeration specifying how an <code>AdvancedMarkerElement</code>
     * should behave when it collides with another
     * <code>AdvancedMarkerElement</code> or with the basemap labels on a vector
     * map. <p><strong>Note</strong>: <code>AdvancedMarkerElement</code> to
     * <code>AdvancedMarkerElement</code> collision works on both raster and
     * vector maps, however, <code>AdvancedMarkerElement</code> to base
     * map&#39;s label collision only works on vector maps.
     */
    collisionBehavior?: null|google.maps.CollisionBehavior;
    /**
     * The DOM Element backing the visual of an
     * <code>AdvancedMarkerElement</code>. <p><strong>Note</strong>:
     * <code>AdvancedMarkerElement</code> does not clone the passed-in DOM
     * element. Once the DOM element is passed to an
     * <code>AdvancedMarkerElement</code>, passing the same DOM element to
     * another <code>AdvancedMarkerElement</code> will move the DOM element and
     * cause the previous <code>AdvancedMarkerElement</code> to look empty.
     * @defaultValue {@link google.maps.marker.PinElement.element}
     */
    content?: null|Node;
    /**
     * If <code>true</code>, the <code>AdvancedMarkerElement</code> can be
     * dragged. <p><strong>Note</strong>: <code>AdvancedMarkerElement</code>
     * with altitude is not draggable.
     * @defaultValue <code>false</code>
     */
    gmpDraggable?: null|boolean;
    /**
     * Map on which to display the <code>AdvancedMarkerElement</code>. The map
     * is required to display the <code>AdvancedMarkerElement</code> and can be
     * provided by setting {@link google.maps.marker.AdvancedMarkerElement.map}
     * if not provided at the construction.
     */
    map?: null|google.maps.Map;
    /**
     * Sets the <code>AdvancedMarkerElement</code>&#39;s position. An
     * <code>AdvancedMarkerElement</code> may be constructed without a position,
     * but will not be displayed until its position is provided - for example,
     * by a user&#39;s actions or choices. An
     * <code>AdvancedMarkerElement</code>&#39;s position can be provided by
     * setting {@link google.maps.marker.AdvancedMarkerElement.position} if not
     * provided at the construction. <p><strong>Note</strong>:
     * <code>AdvancedMarkerElement</code> with altitude is only supported on
     * vector maps.
     */
    position?: null|google.maps.LatLng|google.maps.LatLngLiteral;
    /**
     * Rollover text. If provided, an accessibility text (e.g. for use with
     * screen readers) will be added to the <code>AdvancedMarkerElement</code>
     * with the provided value.
     */
    title?: null|string;
    /**
     * All <code>AdvancedMarkerElement</code>s are displayed on the map in order
     * of their zIndex, with higher values displaying in front of
     * <code>AdvancedMarkerElement</code>s with lower values. By default,
     * <code>AdvancedMarkerElement</code>s are displayed according to their
     * vertical position on screen, with lower
     * <code>AdvancedMarkerElement</code>s appearing in front of
     * <code>AdvancedMarkerElement</code>s farther up the screen. Note that
     * <code>zIndex</code> is also used to help determine relative priority
     * between {@link
     * google.maps.CollisionBehavior.OPTIONAL_AND_HIDES_LOWER_PRIORITY} Advanced
     * Markers. A higher <code>zIndex</code> value indicates higher priority.
     */
    zIndex?: null|number;
  }
  /**
   * A <code>PinElement</code> represents a DOM element that consists of a shape
   * and a glyph. The shape has the same balloon style as seen in the
   * default {@link google.maps.marker.AdvancedMarkerElement}. The glyph is an
   * optional DOM element displayed in the balloon shape. A
   * <code>PinElement</code> may have a different aspect ratio depending on
   * its {@link google.maps.marker.PinElement.scale}.<br> <br>
   * <strong>Note:</strong> Usage as a Web Component (e.g. usage as an
   * HTMLElement subclass, or via HTML) is not yet supported.
   *
   * Access by calling `const {PinElement} = await
   * google.maps.importLibrary("marker")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class PinElement extends HTMLElement implements
      google.maps.marker.PinElementOptions {
    /**
     * A <code>PinElement</code> represents a DOM element that consists of a
     * shape and a glyph. The shape has the same balloon style as seen in the
     * default {@link google.maps.marker.AdvancedMarkerElement}. The glyph is an
     * optional DOM element displayed in the balloon shape. A
     * <code>PinElement</code> may have a different aspect ratio depending on
     * its {@link google.maps.marker.PinElement.scale}.<br> <br>
     * <strong>Note:</strong> Usage as a Web Component (e.g. usage as an
     * HTMLElement subclass, or via HTML) is not yet supported.
     *
     * Access by calling `const {PinElement} = await
     * google.maps.importLibrary("marker")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(options?: google.maps.marker.PinElementOptions);
    /**
     * See {@link google.maps.marker.PinElementOptions.background}.
     */
    background?: null|string;
    /**
     * See {@link google.maps.marker.PinElementOptions.borderColor}.
     */
    borderColor?: null|string;
    /**
     * This field is read-only. The DOM Element backing the view.
     */
    element: HTMLElement;
    /**
     * See {@link google.maps.marker.PinElementOptions.glyph}.
     */
    glyph?: null|string|Element|URL;
    /**
     * See {@link google.maps.marker.PinElementOptions.glyphColor}.
     */
    glyphColor?: null|string;
    /**
     * See {@link google.maps.marker.PinElementOptions.scale}.
     */
    scale?: null|number;
  }
  /**
   * Options for creating a {@link google.maps.marker.PinElement}.
   */
  export interface PinElementOptions {
    /**
     * The background color of the pin shape. Supports any CSS <a
     * href="https://developer.mozilla.org/en-US/docs/Web/CSS/color_value">color
     * value</a>.
     */
    background?: null|string;
    /**
     * The border color of the pin shape. Supports any CSS <a
     * href="https://developer.mozilla.org/en-US/docs/Web/CSS/color_value">color
     * value</a>.
     */
    borderColor?: null|string;
    /**
     * The DOM element displayed in the pin.
     */
    glyph?: null|string|Element|URL;
    /**
     * The color of the glyph. Supports any CSS <a
     * href="https://developer.mozilla.org/en-US/docs/Web/CSS/color_value">color
     * value</a>.
     */
    glyphColor?: null|string;
    /**
     * The scale of the pin.
     * @defaultValue <code>1</code>
     */
    scale?: null|number;
  }
}
declare namespace google.maps.places {
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   *
   * Access by calling `const {AddressComponent} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class AddressComponent {
    /**
     * The full text of the address component.
     */
    longText: string|null;
    /**
     * The abbreviated, short text of the given address component.
     */
    shortText: string|null;
    /**
     * An array of strings denoting the type of this address component. A list
     * of valid types can be found <a
     * href="https://developers.google.com/maps/documentation/javascript/geocoding#GeocodingAddressTypes">here</a>.
     */
    types: string[];
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   *
   * Access by calling `const {Attribution} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Attribution {
    /**
     * Attribution text to be displayed for this Place result.
     */
    provider: string|null;
    providerURI: string|null;
  }
  /**
   * A widget that provides Place predictions based on a user&#39;s text input.
   * It attaches to an input element of type <code>text</code>, and listens for
   * text entry in that field. The list of predictions is presented as a
   * drop-down list, and is updated as text is entered.
   *
   * Access by calling `const {Autocomplete} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Autocomplete extends google.maps.MVCObject {
    /**
     * A widget that provides Place predictions based on a user&#39;s text
     * input. It attaches to an input element of type <code>text</code>, and
     * listens for text entry in that field. The list of predictions is
     * presented as a drop-down list, and is updated as text is entered.
     *
     * Access by calling `const {Autocomplete} = await
     * google.maps.importLibrary("places")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     * @param inputField The <code>&lt;input&gt;</code> text field to which the
     *     <code>Autocomplete</code> should be attached.
     * @param opts Options.
     */
    constructor(
        inputField: HTMLInputElement,
        opts?: google.maps.places.AutocompleteOptions|null);
    /**
     * Returns the bounds to which predictions are biased.
     */
    getBounds(): google.maps.LatLngBounds|undefined;
    /**
     * Returns the fields to be included for the Place in the details response
     * when the details are successfully retrieved. For a list of fields
     * see {@link google.maps.places.PlaceResult}.
     */
    getFields(): string[]|undefined;
    /**
     * Returns the details of the Place selected by user if the details were
     * successfully retrieved. Otherwise returns a stub Place object, with the
     * <code>name</code> property set to the current value of the input field.
     */
    getPlace(): google.maps.places.PlaceResult;
    /**
     * Sets the preferred area within which to return Place results. Results are
     * biased towards, but not restricted to, this area.
     * @param bounds The biasing bounds.
     */
    setBounds(bounds: google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral|
              undefined): void;
    /**
     * Sets the component restrictions. Component restrictions are used to
     * restrict predictions to only those within the parent component. For
     * example, the country.
     * @param restrictions The restrictions to use.
     */
    setComponentRestrictions(restrictions:
                                 google.maps.places.ComponentRestrictions|
                             null): void;
    /**
     * Sets the fields to be included for the Place in the details response when
     * the details are successfully retrieved. For a list of fields see {@link
     * google.maps.places.PlaceResult}.
     */
    setFields(fields: string[]|undefined): void;
    setOptions(options: google.maps.places.AutocompleteOptions|null): void;
    /**
     * Sets the types of predictions to be returned. For supported types, see
     * the <a
     * href="https://developers.google.com/maps/documentation/javascript/places-autocomplete#constrain-place-types">
     * developer&#39;s guide</a>. If no types are specified, all types will be
     * returned.
     * @param types The types of predictions to be included.
     */
    setTypes(types: string[]|null): void;
  }
  /**
   * The options that can be set on an <code>Autocomplete</code> object.
   */
  export interface AutocompleteOptions {
    /**
     * The area in which to search for places.
     */
    bounds?: google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral;
    /**
     * The component restrictions. Component restrictions are used to restrict
     * predictions to only those within the parent component. For example, the
     * country.
     */
    componentRestrictions?: google.maps.places.ComponentRestrictions;
    /**
     * Fields to be included for the Place in the details response when the
     * details are successfully retrieved, <a
     * href="https://developers.google.com/maps/billing/understanding-cost-of-use#places-product">which
     * will be billed for</a>. If <code>[&#39;ALL&#39;]</code> is passed in, all
     * available fields will be returned and billed for (this is not recommended
     * for production deployments). For a list of fields see {@link
     * google.maps.places.PlaceResult}. Nested fields can be specified with
     * dot-paths (for example, <code>"geometry.location"</code>). The default is
     * <code>[&#39;ALL&#39;]</code>.
     */
    fields?: string[];
    /**
     * Whether to retrieve only Place IDs. The PlaceResult made available when
     * the place_changed event is fired will only have the place_id, types and
     * name fields, with the place_id, types and description returned by the
     * Autocomplete service. Disabled by default.
     * @deprecated <code>placeIdOnly</code> is deprecated as of January 15,
     *     2019, and will be turned off on January 15, 2020. Use {@link
     *     google.maps.places.AutocompleteOptions.fields} instead: <code>fields:
     *     [&#39;place_id&#39;, &#39;name&#39;, &#39;types&#39;]</code>.
     */
    placeIdOnly?: boolean;
    /**
     * A boolean value, indicating that the Autocomplete widget should only
     * return those places that are inside the bounds of the Autocomplete widget
     * at the time the query is sent. Setting strictBounds to <code>false</code>
     * (which is the default) will make the results biased towards, but not
     * restricted to, places contained within the bounds.
     */
    strictBounds?: boolean;
    /**
     * The types of predictions to be returned. For supported types, see the <a
     * href="https://developers.google.com/maps/documentation/javascript/places-autocomplete#constrain-place-types">
     * developer&#39;s guide</a>. If no types are specified, all types will be
     * returned.
     */
    types?: string[];
  }
  /**
   * Represents a single autocomplete prediction.
   */
  export interface AutocompletePrediction {
    /**
     * This is the unformatted version of the query suggested by the Places
     * service.
     */
    description: string;
    /**
     * The distance in meters of the place from the {@link
     * google.maps.places.AutocompletionRequest.origin}.
     */
    distance_meters?: number;
    /**
     * A set of substrings in the place&#39;s description that match elements in
     * the user&#39;s input, suitable for use in highlighting those substrings.
     * Each substring is identified by an offset and a length, expressed in
     * unicode characters.
     */
    matched_substrings: google.maps.places.PredictionSubstring[];
    /**
     * A place ID that can be used to retrieve details about this place using
     * the place details service (see {@link
     * google.maps.places.PlacesService.getDetails}).
     */
    place_id: string;
    /**
     * Structured information about the place&#39;s description, divided into a
     * main text and a secondary text, including an array of matched substrings
     * from the autocomplete input, identified by an offset and a length,
     * expressed in unicode characters.
     */
    structured_formatting: google.maps.places.StructuredFormatting;
    /**
     * Information about individual terms in the above description, from most to
     * least specific. For example, &quot;Taco Bell&quot;, &quot;Willitis&quot;,
     * and &quot;CA&quot;.
     */
    terms: google.maps.places.PredictionTerm[];
    /**
     * An array of types that the prediction belongs to, for example
     * <code>'establishment'</code> or <code>'geocode'</code>.
     */
    types: string[];
  }
  /**
   * An Autocomplete response returned by the call to {@link
   * google.maps.places.AutocompleteService.getPlacePredictions} containing a
   * list of {@link google.maps.places.AutocompletePrediction}s.
   */
  export interface AutocompleteResponse {
    /**
     * The list of {@link google.maps.places.AutocompletePrediction}s.
     */
    predictions: google.maps.places.AutocompletePrediction[];
  }
  /**
   * Contains methods related to retrieving Autocomplete predictions.
   *
   * Access by calling `const {AutocompleteService} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class AutocompleteService {
    /**
     * Retrieves place autocomplete predictions based on the supplied
     * autocomplete request.
     * @param request The autocompletion request.
     * @param callback A callback accepting an array of AutocompletePrediction
     *     objects and a PlacesServiceStatus value as argument.
     */
    getPlacePredictions(
        request: google.maps.places.AutocompletionRequest,
        callback?:
            (a: google.maps.places.AutocompletePrediction[]|null,
             b: google.maps.places.PlacesServiceStatus) => void):
        Promise<google.maps.places.AutocompleteResponse>;
    /**
     * Retrieves query autocomplete predictions based on the supplied query
     * autocomplete request.
     * @param request The query autocompletion request.
     * @param callback A callback accepting an array of
     *     QueryAutocompletePrediction objects and a PlacesServiceStatus value
     *     as argument.
     */
    getQueryPredictions(
        request: google.maps.places.QueryAutocompletionRequest,
        callback:
            (a: google.maps.places.QueryAutocompletePrediction[]|null,
             b: google.maps.places.PlacesServiceStatus) => void): void;
  }
  /**
   * Represents a session token used for tracking an autocomplete session, which
   * can be a series of {@link
   * google.maps.places.AutocompleteService.getPlacePredictions} calls followed
   * by a single {@link google.maps.places.PlacesService.getDetails} call.
   *
   * Access by calling `const {AutocompleteSessionToken} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class AutocompleteSessionToken {}
  /**
   * An Autocompletion request to be sent to {@link
   * google.maps.places.AutocompleteService.getPlacePredictions}.
   */
  export interface AutocompletionRequest {
    /**
     * Bounds for prediction biasing. Predictions will be biased towards, but
     * not restricted to, the given <code>bounds</code>. Both
     * <code>location</code> and <code>radius</code> will be ignored if
     * <code>bounds</code> is set.
     * @deprecated <code>bounds</code> is deprecated as of May 2023. Use {@link
     *     google.maps.places.AutocompletionRequest.locationBias} and {@link
     *     google.maps.places.AutocompletionRequest.locationRestriction}
     *     instead.
     */
    bounds?: google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral;
    /**
     * The component restrictions. Component restrictions are used to restrict
     * predictions to only those within the parent component. For example, the
     * country.
     */
    componentRestrictions?: google.maps.places.ComponentRestrictions;
    /**
     * The user entered input string.
     */
    input: string;
    /**
     * A language identifier for the language in which the results should be
     * returned, if possible. Results in the selected language may be given a
     * higher ranking, but suggestions are not restricted to this language. See
     * the <a href="https://developers.google.com/maps/faq#languagesupport">list
     * of supported languages</a>.
     */
    language?: string|null;
    /**
     * Location for prediction biasing. Predictions will be biased towards the
     * given <code>location</code> and <code>radius</code>. Alternatively,
     * <code>bounds</code> can be used.
     * @deprecated <code>location</code> is deprecated as of May 2023.
     *     Use {@link google.maps.places.AutocompletionRequest.locationBias}
     *     and {@link
     *     google.maps.places.AutocompletionRequest.locationRestriction}
     *     instead.
     */
    location?: google.maps.LatLng;
    /**
     * A soft boundary or hint to use when searching for places.
     */
    locationBias?: google.maps.LatLng|google.maps.LatLngLiteral|
        google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral|
        google.maps.Circle|google.maps.CircleLiteral|string|null;
    /**
     * Bounds to constrain search results.
     */
    locationRestriction?: google.maps.LatLngBounds|
        google.maps.LatLngBoundsLiteral|null;
    /**
     * The character position in the input term at which the service uses text
     * for predictions (the position of the cursor in the input field).
     */
    offset?: number;
    /**
     * The location where {@link
     * google.maps.places.AutocompletePrediction.distance_meters} is calculated
     * from.
     */
    origin?: google.maps.LatLng|google.maps.LatLngLiteral;
    /**
     * The radius of the area used for prediction biasing. The
     * <code>radius</code> is specified in meters, and must always be
     * accompanied by a <code>location</code> property. Alternatively,
     * <code>bounds</code> can be used.
     * @deprecated <code>radius</code> is deprecated as of May 2023. Use {@link
     *     google.maps.places.AutocompletionRequest.locationBias} and {@link
     *     google.maps.places.AutocompletionRequest.locationRestriction}
     *     instead.
     */
    radius?: number;
    /**
     * A region code which is used for result formatting and for result
     * filtering. It does not restrict the suggestions to this country. The
     * region code accepts a <a
     * href="https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains">ccTLD
     * (&quot;top-level domain&quot;)</a> two-character value. Most ccTLD codes
     * are identical to ISO 3166-1 codes, with some notable exceptions. For
     * example, the United Kingdom&#39;s ccTLD is &quot;uk&quot;
     * (<code>.co.uk</code>) while its ISO 3166-1 code is &quot;gb&quot;
     * (technically for the entity of &quot;The United Kingdom of Great Britain
     * and Northern Ireland&quot;).
     */
    region?: string|null;
    /**
     * Unique reference used to bundle individual requests into sessions.
     */
    sessionToken?: google.maps.places.AutocompleteSessionToken;
    /**
     * The types of predictions to be returned. For supported types, see the <a
     * href="https://developers.google.com/maps/documentation/javascript/places-autocomplete#constrain-place-types">
     * developer&#39;s guide</a>. If no types are specified, all types will be
     * returned.
     */
    types?: string[];
  }
  /**
   * The operational status of the Place, if it is a business, returned in a
   * PlaceResult (indicates whether the place is operational, or closed either
   * temporarily or permanently). Specify these by value, or the constant&#39;s
   * name (example: <code>&#39;OPERATIONAL&#39;</code> or
   * <code>google.maps.places.BusinessStatus.OPERATIONAL</code>).
   *
   * Access by calling `const {BusinessStatus} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum BusinessStatus {
    /**
     * The business is closed permanently.
     */
    CLOSED_PERMANENTLY = 'CLOSED_PERMANENTLY',
    /**
     * The business is closed temporarily.
     */
    CLOSED_TEMPORARILY = 'CLOSED_TEMPORARILY',
    /**
     * The business is operating normally.
     */
    OPERATIONAL = 'OPERATIONAL',
  }
  /**
   * Defines the component restrictions that can be used with the autocomplete
   * service.
   */
  export interface ComponentRestrictions {
    /**
     * Restricts predictions to the specified country (ISO 3166-1 Alpha-2
     * country code, case insensitive). For example, <code>'us'</code>,
     * <code>'br'</code>, or <code>'au'</code>. You can provide a single one, or
     * an array of up to five country code strings.
     */
    country: string|string[]|null;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * Options for fetching Place fields.
   */
  export interface FetchFieldsRequest {
    /**
     * List of fields to be fetched.
     */
    fields: string[];
    /**
     * Unique reference used to bundle the details request with an autocomplete
     * session.
     */
    sessionToken?: google.maps.places.AutocompleteSessionToken|null;
  }
  /**
   * A find place from text search request to be sent to {@link
   * google.maps.places.PlacesService.findPlaceFromPhoneNumber}.
   */
  export interface FindPlaceFromPhoneNumberRequest {
    /**
     * Fields to be included in the response, <a
     * href="https://developers.google.com/maps/billing/understanding-cost-of-use#places-product">which
     * will be billed for</a>. If <code>[&#39;ALL&#39;]</code> is passed in, all
     * available fields will be returned and billed for (this is not recommended
     * for production deployments). For a list of fields see {@link
     * google.maps.places.PlaceResult}. Nested fields can be specified with
     * dot-paths (for example, <code>"geometry.location"</code>).
     */
    fields: string[];
    /**
     * A language identifier for the language in which names and addresses
     * should be returned, when possible. See the <a
     * href="https://developers.google.com/maps/faq#languagesupport">list of
     * supported languages</a>.
     */
    language?: string|null;
    /**
     * The bias used when searching for Place. The result will be biased
     * towards, but not restricted to, the given {@link
     * google.maps.places.LocationBias}.
     */
    locationBias?: google.maps.LatLng|google.maps.LatLngLiteral|
        google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral|
        google.maps.Circle|google.maps.CircleLiteral|string;
    /**
     * The phone number of the place to look up. Format must be <a
     * href="https://en.wikipedia.org/wiki/E.164">E.164</a>.
     */
    phoneNumber: string;
  }
  /**
   * A find place from text search request to be sent to {@link
   * google.maps.places.PlacesService.findPlaceFromQuery}.
   */
  export interface FindPlaceFromQueryRequest {
    /**
     * Fields to be included in the response, <a
     * href="https://developers.google.com/maps/billing/understanding-cost-of-use#places-product">which
     * will be billed for</a>. If <code>[&#39;ALL&#39;]</code> is passed in, all
     * available fields will be returned and billed for (this is not recommended
     * for production deployments). For a list of fields see {@link
     * google.maps.places.PlaceResult}. Nested fields can be specified with
     * dot-paths (for example, <code>"geometry.location"</code>).
     */
    fields: string[];
    /**
     * A language identifier for the language in which names and addresses
     * should be returned, when possible. See the <a
     * href="https://developers.google.com/maps/faq#languagesupport">list of
     * supported languages</a>.
     */
    language?: string|null;
    /**
     * The bias used when searching for Place. The result will be biased
     * towards, but not restricted to, the given {@link
     * google.maps.places.LocationBias}.
     */
    locationBias?: google.maps.LatLng|google.maps.LatLngLiteral|
        google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral|
        google.maps.Circle|google.maps.CircleLiteral|string;
    /**
     * The request&#39;s query. For example, the name or address of a place.
     */
    query: string;
  }
  export type LocationBias =
      google.maps.LatLng|google.maps.LatLngLiteral|
      google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral|
      google.maps.Circle|google.maps.CircleLiteral|string;
  export type LocationRestriction =
      google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral;
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   *
   * Access by calling `const {OpeningHours} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class OpeningHours {
    /**
     * Opening periods covering each day of the week, starting from Sunday, in
     * chronological order. Does not include days where the Place is not open.
     */
    periods: google.maps.places.OpeningHoursPeriod[];
    /**
     * An array of seven strings representing the formatted opening hours for
     * each day of the week. The Places Service will format and localize the
     * opening hours appropriately for the current language. The ordering of the
     * elements in this array depends on the language. Some languages start the
     * week on Monday, while others start on Sunday.
     */
    weekdayDescriptions: string[];
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   *
   * Access by calling `const {OpeningHoursPeriod} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class OpeningHoursPeriod {
    /**
     * The closing time for the Place.
     */
    close: google.maps.places.OpeningHoursPoint|null;
    /**
     * The opening time for the Place.
     */
    open: google.maps.places.OpeningHoursPoint;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   *
   * Access by calling `const {OpeningHoursPoint} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class OpeningHoursPoint {
    /**
     * The day of the week, as a number in the range [0, 6], starting on Sunday.
     * For example, 2 means Tuesday.
     */
    day: number;
    /**
     * The hour of the OpeningHoursPoint.time as a number, in the range [0, 23].
     * This will be reported in the Place’s time zone.
     */
    hour: number;
    /**
     * The minute of the OpeningHoursPoint.time as a number, in the range [0,
     * 59]. This will be reported in the Place’s time zone.
     */
    minute: number;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   *
   * Access by calling `const {Photo} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Photo {
    /**
     * Attribution text to be displayed for this photo.
     */
    attributions: google.maps.places.PhotoAttribution[];
    /**
     * Returns the image URL corresponding to the specified options.
     */
    getURI(options?: google.maps.places.PhotoOptions): string;
    /**
     * The height of the photo in pixels.
     */
    heightPx: number;
    /**
     * The width of the photo in pixels.
     */
    widthPx: number;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   *
   * Access by calling `const {PhotoAttribution} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class PhotoAttribution {
    /**
     * Attribution text to be displayed for this Photo result.
     */
    author: string;
    authorURI: string|null;
  }
  /**
   * Defines photo-requesting options.
   */
  export interface PhotoOptions {
    /**
     * The maximum height in pixels of the returned image.
     */
    maxHeight?: number|null;
    /**
     * The maximum width in pixels of the returned image.
     */
    maxWidth?: number|null;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   *
   * Access by calling `const {Place} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Place {
    /**
     * Available only in the v=beta channel: https://goo.gle/3oAthT3.
     *
     *
     * Access by calling `const {Place} = await
     * google.maps.importLibrary("places")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(options: google.maps.places.PlaceOptions);
    /**
     * The collection of address components for this Place’s location. Empty
     * object if there is no known address data. <code>undefined</code> if the
     * address data has not been called for from the server.
     */
    addressComponents?: google.maps.places.AddressComponent[];
    /**
     * The representation of the Place’s address in the <a
     * href="http://microformats.org/wiki/adr">adr microformat</a>.
     */
    adrFormatAddress?: string|null;
    /**
     * Attribution text to be displayed for this Place result.
     */
    attributions?: google.maps.places.Attribution[];
    /**
     * The location&#39;s operational status. <code>null</code> if there is no
     * known status. <code>undefined</code> if the status data has not been
     * loaded from the server.
     */
    businessStatus?: google.maps.places.BusinessStatus|null;
    /**
     * The location&#39;s display name. <code>null</code> if there is no name.
     * <code>undefined</code> if the name data has not been loaded from the
     * server.
     */
    displayName?: string|null;
    /**
     * Available only in the v=beta channel: https://goo.gle/3oAthT3.
     */
    fetchFields(options: google.maps.places.FetchFieldsRequest):
        Promise<{place: google.maps.places.Place}>;
    /**
     * The locations’s full address.
     */
    formattedAddress?: string|null;
    /**
     * Available only in the v=beta channel: https://goo.gle/3oAthT3.
     * Calculates the Date representing the next OpeningHoursTime. Returns
     * undefined if the data is insufficient to calculate the result, or this
     * place is not operational.
     */
    getNextOpeningTime(date?: Date): Promise<Date|undefined>;
    /**
     * URL of the official Google page for this place. This is the Google-owned
     * page that contains the best available information about the Place.
     */
    googleMapsURI?: string|null;
    /**
     * Whether a place has curbside pickup. Returns &#39;true&#39; or
     * &#39;false&#39; if the value is known. Returns &#39;null&#39; if the
     * value is unknown. Returns &#39;undefined&#39; if this field has not yet
     * been requested.
     */
    hasCurbsidePickup?: boolean|null;
    /**
     * Whether a place has delivery. Returns &#39;true&#39; or &#39;false&#39;
     * if the value is known. Returns &#39;null&#39; if the value is unknown.
     * Returns
     * &#39;undefined&#39; if this field has not yet been requested.
     */
    hasDelivery?: boolean|null;
    /**
     * Whether a place has dine in. Returns &#39;true&#39; or &#39;false&#39; if
     * the value is known. Returns &#39;null&#39; if the value is unknown.
     * Returns
     * &#39;undefined&#39; if this field has not yet been requested.
     */
    hasDineIn?: boolean|null;
    /**
     * Whether a place has takeout. Returns &#39;true&#39; or &#39;false&#39; if
     * the value is known. Returns &#39;null&#39; if the value is unknown.
     * Returns
     * &#39;undefined&#39; if this field has not yet been requested.
     */
    hasTakeout?: boolean|null;
    /**
     * Whether a place has a wheelchair accessible entrance. Returns
     * &#39;true&#39; or &#39;false&#39; if the value is known. Returns
     * &#39;null&#39; if the value is unknown. Returns &#39;undefined&#39; if
     * this field has not yet been requested.
     */
    hasWheelchairAccessibleEntrance?: boolean|null;
    /**
     * The default HEX color code for the place&#39;s category.
     */
    iconBackgroundColor?: string|null;
    /**
     * The unique place id.
     */
    id: string;
    /**
     * The Place’s phone number in international format. International format
     * includes the country code, and is prefixed with the plus (+) sign.
     */
    internationalPhoneNumber?: string|null;
    /**
     * Available only in the v=beta channel: https://goo.gle/3oAthT3.
     * Check if the place is open at the given datetime. Resolves with
     * <code>undefined</code> if the known data for the location is insufficient
     * to calculate this, e.g. if the opening hours are unregistered.
     * @param date Defaults to now.
     */
    isOpen(date?: Date): Promise<boolean|undefined>;
    /**
     * Whether a place is reservable. Returns &#39;true&#39; or &#39;false&#39;
     * if the value is known. Returns &#39;null&#39; if the value is unknown.
     * Returns
     * &#39;undefined&#39; if this field has not yet been requested.
     */
    isReservable?: boolean|null;
    /**
     * The Place’s position.
     */
    location?: google.maps.LatLng|null;
    /**
     * The Place’s phone number, formatted according to the <a
     * href="http://en.wikipedia.org/wiki/Local_conventions_for_writing_telephone_numbers">number&#39;s
     * regional convention</a>.
     */
    nationalPhoneNumber?: string|null;
    openingHours?: google.maps.places.OpeningHours|null;
    /**
     * Photos of this Place. The collection will contain up to ten {@link
     * google.maps.places.Photo} objects.
     */
    photos?: google.maps.places.Photo[];
    plusCode?: google.maps.places.PlusCode|null;
    /**
     * The price level of the Place. This property can return any of the
     * following values <ul style="list-style-type: none;">
     * <li><code>Free</code></li> <li><code>Inexpensive</code></li>
     * <li><code>Moderate</code></li> <li><code>Expensive</code></li>
     * <li><code>Very Expensive</code></li> </ul>
     */
    priceLevel?: google.maps.places.PriceLevel|null;
    /**
     * A rating, between 1.0 to 5.0, based on user reviews of this Place.
     */
    rating?: number|null;
    /**
     * The requested language for this place.
     */
    requestedLanguage?: string|null;
    /**
     * The requested region for this place.
     */
    requestedRegion?: string|null;
    /**
     * A list of reviews for this Place.
     */
    reviews?: google.maps.places.Review[];
    /**
     * Whether a place serves beer. Returns &#39;true&#39; or &#39;false&#39; if
     * the value is known. Returns &#39;null&#39; if the value is unknown.
     * Returns
     * &#39;undefined&#39; if this field has not yet been requested.
     */
    servesBeer?: boolean|null;
    /**
     * Whether a place serves breakfast. Returns &#39;true&#39; or
     * &#39;false&#39; if the value is known. Returns &#39;null&#39; if the
     * value is unknown. Returns &#39;undefined&#39; if this field has not yet
     * been requested.
     */
    servesBreakfast?: boolean|null;
    /**
     * Whether a place serves brunch. Returns &#39;true&#39; or &#39;false&#39;
     * if the value is known. Returns &#39;null&#39; if the value is unknown.
     * Returns
     * &#39;undefined&#39; if this field has not yet been requested.
     */
    servesBrunch?: boolean|null;
    /**
     * Whether a place serves dinner. Returns &#39;true&#39; or &#39;false&#39;
     * if the value is known. Returns &#39;null&#39; if the value is unknown.
     * Returns
     * &#39;undefined&#39; if this field has not yet been requested.
     */
    servesDinner?: boolean|null;
    /**
     * Whether a place serves lunch. Returns &#39;true&#39; or &#39;false&#39;
     * if the value is known. Returns &#39;null&#39; if the value is unknown.
     * Returns
     * &#39;undefined&#39; if this field has not yet been requested.
     */
    servesLunch?: boolean|null;
    /**
     * Whether a place serves vegetarian food. Returns &#39;true&#39; or
     * &#39;false&#39; if the value is known. Returns &#39;null&#39; if the
     * value is unknown. Returns &#39;undefined&#39; if this field has not yet
     * been requested.
     */
    servesVegetarianFood?: boolean|null;
    /**
     * Whether a place serves wine. Returns &#39;true&#39; or &#39;false&#39; if
     * the value is known. Returns &#39;null&#39; if the value is unknown.
     * Returns
     * &#39;undefined&#39; if this field has not yet been requested.
     */
    servesWine?: boolean|null;
    /**
     * URI to the svg image mask resource that can be used to represent a
     * place’s category.
     */
    svgIconMaskURI?: string|null;
    toJSON(): object;
    /**
     * An array of <a
     * href="https://developers.google.com/maps/documentation/places/web-service/supported_types">types
     * for this Place</a> (for example, <code>[&quot;political&quot;,
     * &quot;locality&quot;]</code> or <code>[&quot;restaurant&quot;,
     * &quot;establishment&quot;]</code>).
     */
    types?: string[];
    /**
     * The number of user ratings which contributed to this Place’s {@link
     * google.maps.places.Place.rating}.
     */
    userRatingCount?: number|null;
    /**
     * The offset from UTC of the Place’s current timezone, in minutes. For
     * example, Austrialian Eastern Standard Time (GMT+10) in daylight savings
     * is 11 hours ahead of UTC, so the <code>utc_offset_minutes</code> will be
     * <code>660</code>. For timezones behind UTC, the offset is negative. For
     * example, the <code>utc_offset_minutes</code> is <code>-60</code> for Cape
     * Verde.
     */
    utcOffsetMinutes?: number|null;
    /**
     * The preferred viewport when displaying this Place on a map.
     */
    viewport?: google.maps.LatLngBounds|null;
    /**
     * The authoritative website for this Place, such as a business&#39;
     * homepage.
     */
    websiteURI?: string|null;
    /**
     * Available only in the v=beta channel: https://goo.gle/3oAthT3.
     * Searches for a place based on the given phone number. Returns an array
     * due to rare cases where multiple places may share a phone number.
     * @param request The request containing the phone number and requested
     *     fields.
     */
    static findPlaceFromPhoneNumber(
        this: any, request: google.maps.places.FindPlaceFromPhoneNumberRequest):
        Promise<{places: google.maps.places.Place[]}>;
    /**
     * Available only in the v=beta channel: https://goo.gle/3oAthT3.
     * Searches for a place based on the given text query. Returns an array due
     * to cases where the query is mildly ambiguous, and more than one place
     * gets returned. This method is <em>not</em> intended for searches where
     * multiple results are expected.
     * @param request The request containing the text query and requested
     *     fields.
     */
    static findPlaceFromQuery(
        this: any, request: google.maps.places.FindPlaceFromQueryRequest):
        Promise<{places: google.maps.places.Place[]}>;
  }
  /**
   * Defines information about an aspect of the place that users have reviewed.
   * @deprecated This interface is no longer used.
   */
  export interface PlaceAspectRating {
    /**
     * The rating of this aspect. For individual reviews this is an integer from
     * 0 to 3. For aggregated ratings of a place this is an integer from 0
     * to 30.
     */
    rating: number;
    /**
     * The aspect type. For example, <code>"food"</code>, <code>"decor"</code>,
     * <code>"service"</code>, or <code>"overall"</code>.
     */
    type: string;
  }
  /**
   * Available only in the v=alpha channel: https://goo.gle/js-alpha-channel.
   *
   * Implementation of AutocompleteView for Places API
   *
   * Access by calling `const {PlaceAutocompleteElement} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class PlaceAutocompleteElement implements
      google.maps.places.PlaceAutocompleteElementOptions {
    /**
     * Available only in the v=alpha channel: https://goo.gle/js-alpha-channel.
     *
     * Implementation of AutocompleteView for Places API
     *
     * Access by calling `const {PlaceAutocompleteElement} = await
     * google.maps.importLibrary("places")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(options: google.maps.places.PlaceAutocompleteElementOptions);
    /**
     * Adds the given listener function to the given event name.
     */
    addListener(eventName: string, handler: Function):
        google.maps.MapsEventListener;
    componentRestrictions?: null|google.maps.places.ComponentRestrictions;
    /**
     * This Field is read-only. The DOM Element backing the view.
     */
    element?: null|HTMLElement|SVGElement;
    /**
     * The input element to show autocompletions for.
     */
    inputElement: HTMLInputElement;
    locationBias?: google.maps.LatLng|google.maps.LatLngLiteral|
        google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral|
        google.maps.Circle|google.maps.CircleLiteral|string|null;
    locationRestriction?: google.maps.LatLngBounds|
        google.maps.LatLngBoundsLiteral|null;
    requestedLanguage?: null|string;
    requestedRegion?: null|string;
    types?: null|string[];
  }
  /**
   * Available only in the v=alpha channel: https://goo.gle/js-alpha-channel.
   *
   * Options for constructing a PlaceAutocompleteElement.
   */
  export interface PlaceAutocompleteElementOptions {
    /**
     * The component restrictions. Component restrictions are used to restrict
     * predictions to only those within the parent component. For example, the
     * country.
     */
    componentRestrictions?: null|google.maps.places.ComponentRestrictions;
    /**
     * This Field is read-only. The DOM Element backing the view.
     */
    element?: null|HTMLElement|SVGElement;
    /**
     * The input element to show autocompletions for.
     */
    inputElement: HTMLInputElement;
    /**
     * A soft boundary or hint to use when searching for places.
     */
    locationBias?: google.maps.LatLng|google.maps.LatLngLiteral|
        google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral|
        google.maps.Circle|google.maps.CircleLiteral|string|null;
    /**
     * Bounds to constrain search results.
     */
    locationRestriction?: google.maps.LatLngBounds|
        google.maps.LatLngBoundsLiteral|null;
    /**
     * A language identifier for the language in which the results should be
     * returned, if possible. Results in the selected language may be given a
     * higher ranking, but suggestions are not restricted to this language. See
     * the <a href="https://developers.google.com/maps/faq#languagesupport">list
     * of supported languages</a>.
     */
    requestedLanguage?: null|string;
    /**
     * A region code which is used for result formatting and for result
     * filtering. It does not restrict the suggestions to this country. The
     * region code accepts a <a
     * href="https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains">ccTLD
     * (&quot;top-level domain&quot;)</a> two-character value. Most ccTLD codes
     * are identical to ISO 3166-1 codes, with some notable exceptions. For
     * example, the United Kingdom&#39;s ccTLD is &quot;uk&quot;
     * (<code>.co.uk</code>) while its ISO 3166-1 code is &quot;gb&quot;
     * (technically for the entity of &quot;The United Kingdom of Great Britain
     * and Northern Ireland&quot;).
     */
    requestedRegion?: null|string;
    /**
     * The types of predictions to be returned. For supported types, see the <a
     * href="https://developers.google.com/maps/documentation/javascript/places-autocomplete#constrain-place-types">
     * developer&#39;s guide</a>. If no types are specified, all types will be
     * returned.
     */
    types?: null|string[];
  }
  /**
   * A Place details query to be sent to the <code>PlacesService</code>.
   */
  export interface PlaceDetailsRequest {
    /**
     * Fields to be included in the details response, <a
     * href="https://developers.google.com/maps/billing/understanding-cost-of-use#places-product">which
     * will be billed for</a>. If no fields are specified or
     * <code>[&#39;ALL&#39;]</code> is passed in, all available fields will be
     * returned and billed for (this is not recommended for production
     * deployments). For a list of fields see {@link
     * google.maps.places.PlaceResult}. Nested fields can be specified with
     * dot-paths (for example, <code>"geometry.location"</code>).
     */
    fields?: string[];
    /**
     * A language identifier for the language in which details should be
     * returned. See the <a
     * href="https://developers.google.com/maps/faq#languagesupport">list of
     * supported languages</a>.
     */
    language?: string|null;
    /**
     * The Place ID of the Place for which details are being requested.
     */
    placeId: string;
    /**
     * A region code of the user&#39;s region. This can affect which photos may
     * be returned, and possibly other things. The region code accepts a <a
     * href="https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains">ccTLD
     * (&quot;top-level domain&quot;)</a> two-character value. Most ccTLD codes
     * are identical to ISO 3166-1 codes, with some notable exceptions. For
     * example, the United Kingdom&#39;s ccTLD is &quot;uk&quot;
     * (<code>.co.uk</code>) while its ISO 3166-1 code is &quot;gb&quot;
     * (technically for the entity of &quot;The United Kingdom of Great Britain
     * and Northern Ireland&quot;).
     */
    region?: string|null;
    /**
     * Unique reference used to bundle the details request with an autocomplete
     * session.
     */
    sessionToken?: google.maps.places.AutocompleteSessionToken;
  }
  /**
   * Defines information about the geometry of a Place.
   */
  export interface PlaceGeometry {
    /**
     * The Place’s position.
     */
    location?: google.maps.LatLng;
    /**
     * The preferred viewport when displaying this Place on a map. This property
     * will be <code>null</code> if the preferred viewport for the Place is not
     * known. Only available with {@link
     * google.maps.places.PlacesService.getDetails}.
     */
    viewport?: google.maps.LatLngBounds;
  }
  /**
   * Defines information about the opening hours of a Place.
   */
  export interface PlaceOpeningHours {
    /**
     * Check whether the place is open now (when no date is passed), or at the
     * given date. If this place does not have {@link
     * google.maps.places.PlaceResult.utc_offset_minutes} or {@link
     * google.maps.places.PlaceOpeningHours.periods} then <code>undefined</code>
     * is returned ({@link google.maps.places.PlaceOpeningHours.periods} is only
     * available via {@link google.maps.places.PlacesService.getDetails}). This
     * method does not take exceptional hours, such as holiday hours, into
     * consideration.
     */
    isOpen(date?: Date): boolean|undefined;
    /**
     * Whether the Place is open at the current time.
     * @deprecated <code>open_now</code> is deprecated as of November 2019. Use
     *     the {@link google.maps.places.PlaceOpeningHours.isOpen} method from
     *     a {@link google.maps.places.PlacesService.getDetails} result instead.
     *     See <a
     *     href="https://goo.gle/js-open-now">https://goo.gle/js-open-now</a>
     */
    open_now?: boolean;
    /**
     * Opening periods covering for each day of the week, starting from Sunday,
     * in chronological order. Days in which the Place is not open are not
     * included. Only available with {@link
     * google.maps.places.PlacesService.getDetails}.
     */
    periods?: google.maps.places.PlaceOpeningHoursPeriod[];
    /**
     * An array of seven strings representing the formatted opening hours for
     * each day of the week. The Places Service will format and localize the
     * opening hours appropriately for the current language. The ordering of the
     * elements in this array depends on the language. Some languages start the
     * week on Monday while others start on Sunday. Only available with {@link
     * google.maps.places.PlacesService.getDetails}. Other calls may return an
     * empty array.
     */
    weekday_text?: string[];
  }
  /**
   * Defines structured information about the opening hours of a Place.
   * <strong>Note:</strong> If a Place is <strong>always open</strong>, the
   * <code>close</code> section will be missing from the response. Clients can
   * rely on always-open being represented as an <code>open</code> period
   * containing <code>day</code> with value <code>0</code> and <code>time</code>
   * with value <code>"0000"</code>, and no <code>close</code>.</li>
   */
  export interface PlaceOpeningHoursPeriod {
    /**
     * The closing time for the Place.
     */
    close?: google.maps.places.PlaceOpeningHoursTime;
    /**
     * The opening time for the Place.
     */
    open: google.maps.places.PlaceOpeningHoursTime;
  }
  /**
   * Defines when a Place opens or closes.
   */
  export interface PlaceOpeningHoursTime {
    /**
     * The days of the week, as a number in the range [<code>0</code>,
     * <code>6</code>], starting on Sunday. For example, <code>2</code> means
     * Tuesday.
     */
    day: number;
    /**
     * The hours of the {@link google.maps.places.PlaceOpeningHoursTime.time} as
     * a number, in the range [<code>0</code>, <code>23</code>]. This will be
     * reported in the Place’s time zone.
     */
    hours: number;
    /**
     * The minutes of the {@link google.maps.places.PlaceOpeningHoursTime.time}
     * as a number, in the range [<code>0</code>, <code>59</code>]. This will be
     * reported in the Place’s time zone.
     */
    minutes: number;
    /**
     * The timestamp (as milliseconds since the epoch, suitable for use with
     * <code>new Date()</code>) representing the next occurrence of this
     * PlaceOpeningHoursTime. It is calculated from the {@link
     * google.maps.places.PlaceOpeningHoursTime.day} of week, the {@link
     * google.maps.places.PlaceOpeningHoursTime.time}, and the {@link
     * google.maps.places.PlaceResult.utc_offset_minutes}. If the {@link
     * google.maps.places.PlaceResult.utc_offset_minutes} is
     * <code>undefined</code>, then <code>nextDate</code> will be
     * <code>undefined</code>.
     */
    nextDate?: number;
    /**
     * The time of day in 24-hour &quot;hhmm&quot; format. Values are in the
     * range
     * [<code>"0000"</code>, <code>"2359"</code>]. The time will be reported in
     * the Place’s time zone.
     */
    time: string;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * Options for constructing a Place.
   */
  export interface PlaceOptions {
    /**
     * The unique place id.
     */
    id: string;
    /**
     * A language identifier for the language in which details should be
     * returned. See the <a
     * href="https://developers.google.com/maps/faq#languagesupport">list of
     * supported languages</a>.
     */
    requestedLanguage?: string|null;
    /**
     * A region code of the user&#39;s region. This can affect which photos may
     * be returned, and possibly other things. The region code accepts a <a
     * href="https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains">ccTLD
     * (&quot;top-level domain&quot;)</a> two-character value. Most ccTLD codes
     * are identical to ISO 3166-1 codes, with some notable exceptions. For
     * example, the United Kingdom&#39;s ccTLD is &quot;uk&quot;
     * (<code>.co.uk</code>) while its ISO 3166-1 code is &quot;gb&quot;
     * (technically for the entity of &quot;The United Kingdom of Great Britain
     * and Northern Ireland&quot;).
     */
    requestedRegion?: string|null;
  }
  /**
   * Represents a photo element of a Place.
   */
  export interface PlacePhoto {
    /**
     * Returns the image URL corresponding to the specified options.
     */
    getUrl(opts?: google.maps.places.PhotoOptions): string;
    /**
     * The height of the photo in pixels.
     */
    height: number;
    /**
     * Attribution text to be displayed for this photo.
     */
    html_attributions: string[];
    /**
     * The width of the photo in pixels.
     */
    width: number;
  }
  /**
   * Defines Open Location Codes or &quot;<a href="https://plus.codes/">plus
   * codes</a>&quot; for a Place. Plus codes can be used as a replacement for
   * street addresses in places where they do not exist (where buildings are not
   * numbered or streets are not named).
   */
  export interface PlacePlusCode {
    /**
     * A <a href="https://plus.codes/">plus code</a> with a 1/8000th of a degree
     * by 1/8000th of a degree area where the first four characters (the area
     * code) are dropped and replaced with a locality description. For example,
     * <code>"9G8F+5W Zurich, Switzerland"</code>. If no suitable locality that
     * can be found to shorten the code then this field is omitted.
     */
    compound_code?: string;
    /**
     * A <a href="https://plus.codes/">plus code</a> with a 1/8000th of a degree
     * by 1/8000th of a degree area. For example, <code>"8FVC9G8F+5W"</code>.
     */
    global_code: string;
  }
  /**
   * Defines information about a Place.
   */
  export interface PlaceResult {
    /**
     * The collection of address components for this Place’s location. Only
     * available with {@link google.maps.places.PlacesService.getDetails}.
     */
    address_components?: google.maps.GeocoderAddressComponent[];
    /**
     * The representation of the Place’s address in the <a
     * href="http://microformats.org/wiki/adr">adr microformat</a>. Only
     * available with {@link google.maps.places.PlacesService.getDetails}.
     */
    adr_address?: string;
    /**
     * The rated aspects of this Place, based on Google and Zagat user reviews.
     * The ratings are on a scale of 0 to 30.
     */
    aspects?: google.maps.places.PlaceAspectRating[];
    /**
     * A flag indicating the operational status of the Place, if it is a
     * business (indicates whether the place is operational, or closed either
     * temporarily or permanently). If no data is available, the flag is not
     * present in search or details responses.
     */
    business_status?: google.maps.places.BusinessStatus;
    /**
     * The Place’s full address.
     */
    formatted_address?: string;
    /**
     * The Place’s phone number, formatted according to the <a
     * href="http://en.wikipedia.org/wiki/Local_conventions_for_writing_telephone_numbers">
     * number&#39;s regional convention</a>. Only available with {@link
     * google.maps.places.PlacesService.getDetails}.
     */
    formatted_phone_number?: string;
    /**
     * The Place’s geometry-related information.
     */
    geometry?: google.maps.places.PlaceGeometry;
    /**
     * Attribution text to be displayed for this Place result. Available
     * <code>html_attributions</code> are always returned regardless of what
     * <code>fields</code> have been requested, and must be displayed.
     */
    html_attributions?: string[];
    /**
     * URL to an image resource that can be used to represent this Place’s
     * category.
     */
    icon?: string;
    /**
     * Background color for use with a Place&#39;s icon. See also {@link
     * google.maps.places.PlaceResult.icon_mask_base_uri}.
     */
    icon_background_color?: string;
    /**
     * A truncated URL to an icon mask. Access different icon types by appending
     * a file extension to the end (i.e. <code>.svg</code> or
     * <code>.png</code>).
     */
    icon_mask_base_uri?: string;
    /**
     * The Place’s phone number in international format. International format
     * includes the country code, and is prefixed with the plus (+) sign. Only
     * available with {@link google.maps.places.PlacesService.getDetails}.
     */
    international_phone_number?: string;
    /**
     * The Place’s name. Note: In the case of user entered Places, this is the
     * raw text, as typed by the user. Please exercise caution when using this
     * data, as malicious users may try to use it as a vector for code injection
     * attacks (See <a href="http://en.wikipedia.org/wiki/Code_injection">
     * http://en.wikipedia.org/wiki/Code_injection</a>).
     */
    name?: string;
    /**
     * Defines when the Place opens or closes.
     */
    opening_hours?: google.maps.places.PlaceOpeningHours;
    /**
     * A flag indicating whether the Place is closed, either permanently or
     * temporarily. If the place is operational, or if no data is available, the
     * flag is absent from the response.
     * @deprecated <code>permanently_closed</code> is deprecated as of May 2020
     *     and will be turned off in May 2021. Use {@link
     *     google.maps.places.PlaceResult.business_status} instead as
     *     <code>permanently_closed</code> does not distinguish between
     *     temporary and permanent closures.
     */
    permanently_closed?: boolean;
    /**
     * Photos of this Place. The collection will contain up to ten {@link
     * google.maps.places.PlacePhoto} objects.
     */
    photos?: google.maps.places.PlacePhoto[];
    /**
     * A unique identifier for the Place.
     */
    place_id?: string;
    /**
     * Defines Open Location Codes or &quot;<a href="https://plus.codes/">plus
     * codes</a>&quot; for the Place.
     */
    plus_code?: google.maps.places.PlacePlusCode;
    /**
     * The price level of the Place, on a scale of 0 to 4. Price levels are
     * interpreted as follows: <ul style="list-style-type: none;">
     * <li><code>0</code>: Free <li><code>1</code>: Inexpensive
     * <li><code>2</code>: Moderate <li><code>3</code>: Expensive
     * <li><code>4</code>: Very Expensive
     * </ul>
     */
    price_level?: number;
    /**
     * A rating, between 1.0 to 5.0, based on user reviews of this Place.
     */
    rating?: number;
    /**
     * A list of reviews of this Place. Only available with {@link
     * google.maps.places.PlacesService.getDetails}.
     */
    reviews?: google.maps.places.PlaceReview[];
    /**
     * An array of <a
     * href="https://developers.google.com/maps/documentation/places/web-service/supported_types">
     * types for this Place</a> (for example, <code>["political",
     * "locality"]</code> or <code>["restaurant", "establishment"]</code>).
     */
    types?: string[];
    /**
     * URL of the official Google page for this place. This is the Google-owned
     * page that contains the best available information about the Place. Only
     * available with {@link google.maps.places.PlacesService.getDetails}.
     */
    url?: string;
    /**
     * The number of user ratings which contributed to this Place’s {@link
     * google.maps.places.PlaceResult.rating}.
     */
    user_ratings_total?: number;
    /**
     * The offset from UTC of the Place’s current timezone, in minutes. For
     * example, Sydney, Australia in daylight savings is 11 hours ahead of UTC,
     * so the <code>utc_offset</code> will be <code>660</code>. For timezones
     * behind UTC, the offset is negative. For example, the
     * <code>utc_offset</code> is <code>-60</code> for Cape Verde. Only
     * available with {@link google.maps.places.PlacesService.getDetails}.
     * @deprecated <code>utc_offset</code> is deprecated as of November 2019.
     *     Use {@link google.maps.places.PlaceResult.utc_offset_minutes}
     *     instead. See <a
     *     href="https://goo.gle/js-open-now">https://goo.gle/js-open-now</a>
     */
    utc_offset?: number;
    /**
     * The offset from UTC of the Place’s current timezone, in minutes. For
     * example, Sydney, Australia in daylight savings is 11 hours ahead of UTC,
     * so the <code>utc_offset_minutes</code> will be <code>660</code>. For
     * timezones behind UTC, the offset is negative. For example, the
     * <code>utc_offset_minutes</code> is <code>-60</code> for Cape Verde. Only
     * available with {@link google.maps.places.PlacesService.getDetails}.
     */
    utc_offset_minutes?: number;
    /**
     * The simplified address for the Place, including the street name, street
     * number, and locality, but not the province/state, postal code, or
     * country. For example, Google&#39;s Sydney, Australia office has a
     * vicinity value of <code>"48 Pirrama Road, Pyrmont"</code>. Only available
     * with {@link google.maps.places.PlacesService.getDetails}.
     */
    vicinity?: string;
    /**
     * The authoritative website for this Place, such as a business&#39;
     * homepage. Only available with {@link
     * google.maps.places.PlacesService.getDetails}.
     */
    website?: string;
  }
  /**
   * Represents a single review of a place.
   */
  export interface PlaceReview {
    /**
     * The aspects rated by the review. The ratings on a scale of 0 to 3.
     * @deprecated This field is no longer available.
     */
    aspects?: google.maps.places.PlaceAspectRating[];
    /**
     * The name of the reviewer.
     */
    author_name: string;
    /**
     * A URL to the reviewer&#39;s profile. This will be <code>undefined</code>
     * when the reviewer&#39;s profile is unavailable.
     */
    author_url?: string;
    /**
     * An IETF language code indicating the language in which this review is
     * written. Note that this code includes only the main language tag without
     * any secondary tag indicating country or region. For example, all the
     * English reviews are tagged as <code>'en'</code> rather than
     * &#39;en-AU&#39; or
     * &#39;en-UK&#39;.
     */
    language: string;
    /**
     * A URL to the reviwer&#39;s profile image.
     */
    profile_photo_url: string;
    /**
     * The rating of this review, a number between 1.0 and 5.0 (inclusive).
     */
    rating?: number;
    /**
     * A string of formatted recent time, expressing the review time relative to
     * the current time in a form appropriate for the language and country. For
     * example <code>&quot;a month ago&quot;</code>.
     */
    relative_time_description: string;
    /**
     * The text of a review.
     */
    text: string;
    /**
     * Timestamp for the review, expressed in seconds since epoch.
     */
    time: number;
  }
  /**
   * An object used to fetch additional pages of Places results.
   */
  export interface PlaceSearchPagination {
    /**
     * Indicates if further results are available. <code>true</code> when there
     * is an additional results page.
     */
    hasNextPage: boolean;
    /**
     * Fetches the next page of results. Uses the same callback function that
     * was provided to the first search request.
     */
    nextPage(): void;
  }
  /**
   * A Place search query to be sent to the <code>PlacesService</code>.
   */
  export interface PlaceSearchRequest {
    /**
     * The bounds within which to search for Places. Both <code>location</code>
     * and <code>radius</code> will be ignored if <code>bounds</code> is set.
     */
    bounds?: google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral;
    /**
     * A term to be matched against all available fields, including but not
     * limited to name, type, and address, as well as customer reviews and other
     * third-party content.
     */
    keyword?: string;
    /**
     * A language identifier for the language in which names and addresses
     * should be returned, when possible. See the <a
     * href="https://developers.google.com/maps/faq#languagesupport">list of
     * supported languages</a>.
     */
    language?: string|null;
    /**
     * The location around which to search for Places.
     */
    location?: google.maps.LatLng|google.maps.LatLngLiteral;
    /**
     * Restricts results to only those places at the specified price level or
     * lower. Valid values are in the range from 0 (most affordable) to 4 (most
     * expensive), inclusive. Must be greater than or equal to <code>minPrice
     * </code>, if specified.
     */
    maxPriceLevel?: number;
    /**
     * Restricts results to only those places at the specified price level or
     * higher. Valid values are in the range from 0 (most affordable) to 4 (most
     * expensive), inclusive. Must be less than or equal to
     * <code>maxPrice</code>, if specified.
     */
    minPriceLevel?: number;
    /**
     * Equivalent to <code>keyword</code>. Values in this field are combined
     * with values in the <code>keyword</code> field and passed as part of the
     * same search string.
     * @deprecated Use <code>keyword</code> instead.
     */
    name?: string;
    /**
     * Restricts results to only those places that are open right now.
     */
    openNow?: boolean;
    /**
     * The distance from the given location within which to search for Places,
     * in meters. The maximum allowed value is 50&thinsp;000.
     */
    radius?: number;
    /**
     * Specifies the ranking method to use when returning results. Note that
     * when <code>rankBy</code> is set to <code>DISTANCE</code>, you must
     * specify a <code>location</code> but you cannot specify a
     * <code>radius</code> or <code>bounds</code>.
     * @defaultValue {@link google.maps.places.RankBy.PROMINENCE}
     */
    rankBy?: google.maps.places.RankBy;
    /**
     * Searches for places of the given type. The type is translated to the
     * local language of the request&#39;s target location and used as a query
     * string. If a query is also provided, it is concatenated to the localized
     * type string. Results of a different type are dropped from the response.
     * Use this field to perform language and region independent categorical
     * searches. Valid types are given <a
     * href="https://developers.google.com/maps/documentation/places/web-service/supported_types">here</a>.
     */
    type?: string;
  }
  /**
   * Contains methods related to searching for places and retrieving details
   * about a place.
   *
   * Access by calling `const {PlacesService} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class PlacesService {
    /**
     * Contains methods related to searching for places and retrieving details
     * about a place.
     *
     * Access by calling `const {PlacesService} = await
     * google.maps.importLibrary("places")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(attrContainer: HTMLDivElement|google.maps.Map);
    /**
     * Retrieves a list of places based on a phone number. In most cases there
     * should be just one item in the result list, however if the request is
     * ambiguous more than one result may be returned. The {@link
     * google.maps.places.PlaceResult}s passed to the callback are subsets of a
     * full {@link google.maps.places.PlaceResult}. Your app can get a more
     * detailed {@link google.maps.places.PlaceResult} for each place by
     * calling {@link google.maps.places.PlacesService.getDetails} and passing
     * the {@link google.maps.places.PlaceResult.place_id} for the desired
     * place.
     */
    findPlaceFromPhoneNumber(
        request: google.maps.places.FindPlaceFromPhoneNumberRequest,
        callback:
            (a: google.maps.places.PlaceResult[]|null,
             b: google.maps.places.PlacesServiceStatus) => void): void;
    /**
     * Retrieves a list of places based on a query string. In most cases there
     * should be just one item in the result list, however if the request is
     * ambiguous more than one result may be returned. The {@link
     * google.maps.places.PlaceResult}s passed to the callback are subsets of a
     * full {@link google.maps.places.PlaceResult}. Your app can get a more
     * detailed {@link google.maps.places.PlaceResult} for each place by
     * calling {@link google.maps.places.PlacesService.getDetails} and passing
     * the {@link google.maps.places.PlaceResult.place_id} for the desired
     * place.
     */
    findPlaceFromQuery(
        request: google.maps.places.FindPlaceFromQueryRequest,
        callback:
            (a: google.maps.places.PlaceResult[]|null,
             b: google.maps.places.PlacesServiceStatus) => void): void;
    /**
     * Retrieves details about the place identified by the given
     * <code>placeId</code>.
     */
    getDetails(
        request: google.maps.places.PlaceDetailsRequest,
        callback:
            (a: google.maps.places.PlaceResult|null,
             b: google.maps.places.PlacesServiceStatus) => void): void;
    /**
     * Retrieves a list of places near a particular location, based on keyword
     * or type. Location must always be specified, either by passing a
     * <code>LatLngBounds</code>, or <code>location</code> and
     * <code>radius</code> parameters. The {@link
     * google.maps.places.PlaceResult}s passed to the callback are subsets of
     * the full {@link google.maps.places.PlaceResult}. Your app can get a more
     * detailed {@link google.maps.places.PlaceResult} for each place by sending
     * a <a
     * href="https://developers.google.com/maps/documentation/javascript/places#place_details_requests">Place
     * Details request</a> passing the {@link
     * google.maps.places.PlaceResult.place_id} for the desired place.
     * The {@link google.maps.places.PlaceSearchPagination} object can be used
     * to fetch additional pages of results (null if this is the last page of
     * results or if there is only one page of results).
     */
    nearbySearch(
        request: google.maps.places.PlaceSearchRequest,
        callback:
            (a: google.maps.places.PlaceResult[]|null,
             b: google.maps.places.PlacesServiceStatus,
             c: google.maps.places.PlaceSearchPagination|null) => void): void;
    /**
     * Retrieves a list of places based on a query string (for example,
     * &quot;pizza in New York&quot;, or &quot;shoe stores near Ottawa&quot;).
     * Location parameters are optional; when the location is specified, results
     * are only biased toward nearby results rather than restricted to places
     * inside the area. Use <code>textSearch</code> when you want to search for
     * places using an arbitrary string, and in cases where you may not want to
     * restrict search results to a particular location. The
     * <code>PlaceSearchPagination</code> object can be used to fetch additional
     * pages of results (null if this is the last page of results or if there is
     * only one page of results).
     */
    textSearch(
        request: google.maps.places.TextSearchRequest,
        callback:
            (a: google.maps.places.PlaceResult[]|null,
             b: google.maps.places.PlacesServiceStatus,
             c: google.maps.places.PlaceSearchPagination|null) => void): void;
  }
  /**
   * The status returned by the <code>PlacesService</code> on the completion of
   * its searches. Specify these by value, or by using the constant&#39;s name.
   * For example, <code>'OK'</code> or
   * <code>google.maps.places.PlacesServiceStatus.OK</code>.
   *
   * Access by calling `const {PlacesServiceStatus} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum PlacesServiceStatus {
    /**
     * This request was invalid.
     */
    INVALID_REQUEST = 'INVALID_REQUEST',
    /**
     * The place referenced was not found.
     */
    NOT_FOUND = 'NOT_FOUND',
    /**
     * The response contains a valid result.
     */
    OK = 'OK',
    /**
     * The application has gone over its request quota.
     */
    OVER_QUERY_LIMIT = 'OVER_QUERY_LIMIT',
    /**
     * The application is not allowed to use the <code>PlacesService</code>.
     */
    REQUEST_DENIED = 'REQUEST_DENIED',
    /**
     * The <code>PlacesService</code> request could not be processed due to a
     * server error. The request may succeed if you try again.
     */
    UNKNOWN_ERROR = 'UNKNOWN_ERROR',
    /**
     * No result was found for this request.
     */
    ZERO_RESULTS = 'ZERO_RESULTS',
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   *
   * Access by calling `const {PlusCode} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class PlusCode {
    /**
     * A plus code with a 1/8000th of a degree by 1/8000th of a degree area
     * where the first four characters (the area code) are dropped and replaced
     * with a locality description. For example, &quot;9G8F+5W Zurich,
     * Switzerland&quot;.
     */
    compoundCode: string|null;
    /**
     * A plus code with a 1/8000th of a degree by 1/8000th of a degree area. For
     * example, &quot;8FVC9G8F+5W&quot;.
     */
    globalCode: string|null;
  }
  /**
   * Represents a prediction substring.
   */
  export interface PredictionSubstring {
    /**
     * The length of the substring.
     */
    length: number;
    /**
     * The offset to the substring&#39;s start within the description string.
     */
    offset: number;
  }
  /**
   * Represents a prediction term.
   */
  export interface PredictionTerm {
    /**
     * The offset, in unicode characters, of the start of this term in the
     * description of the place.
     */
    offset: number;
    /**
     * The value of this term, for example, &quot;Taco Bell&quot;.
     */
    value: string;
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   * Price level enum for Place objects.
   *
   * Access by calling `const {PriceLevel} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum PriceLevel {
    EXPENSIVE = 'EXPENSIVE',
    FREE = 'FREE',
    INEXPENSIVE = 'INEXPENSIVE',
    MODERATE = 'MODERATE',
    VERY_EXPENSIVE = 'VERY_EXPENSIVE',
  }
  /**
   * Represents a single Query Autocomplete prediction.
   */
  export interface QueryAutocompletePrediction {
    /**
     * This is the unformatted version of the query suggested by the Places
     * service.
     */
    description: string;
    /**
     * A set of substrings in the place&#39;s description that match elements in
     * the user&#39;s input, suitable for use in highlighting those substrings.
     * Each substring is identified by an offset and a length, expressed in
     * unicode characters.
     */
    matched_substrings: google.maps.places.PredictionSubstring[];
    /**
     * Only available if prediction is a place. A place ID that can be used to
     * retrieve details about this place using the place details service
     * (see {@link google.maps.places.PlacesService.getDetails}).
     */
    place_id?: string;
    /**
     * Information about individual terms in the above description. Categorical
     * terms come first (for example, &quot;restaurant&quot;). Address terms
     * appear from most to least specific. For example, &quot;San
     * Francisco&quot;, and &quot;CA&quot;.
     */
    terms: google.maps.places.PredictionTerm[];
  }
  /**
   * A QueryAutocompletion request to be sent to the
   * <code>QueryAutocompleteService</code>.
   */
  export interface QueryAutocompletionRequest {
    /**
     * Bounds for prediction biasing. Predictions will be biased towards, but
     * not restricted to, the given <code>bounds</code>. Both
     * <code>location</code> and <code>radius</code> will be ignored if
     * <code>bounds</code> is set.
     */
    bounds?: google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral;
    /**
     * The user entered input string.
     */
    input: string;
    /**
     * Location for prediction biasing. Predictions will be biased towards the
     * given <code>location</code> and <code>radius</code>. Alternatively,
     * <code>bounds</code> can be used.
     */
    location?: google.maps.LatLng;
    /**
     * The character position in the input term at which the service uses text
     * for predictions (the position of the cursor in the input field).
     */
    offset?: number;
    /**
     * The radius of the area used for prediction biasing. The
     * <code>radius</code> is specified in meters, and must always be
     * accompanied by a <code>location</code> property. Alternatively,
     * <code>bounds</code> can be used.
     */
    radius?: number;
  }
  /**
   * Ranking options for a PlaceSearchRequest.
   *
   * Access by calling `const {RankBy} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export enum RankBy {
    /**
     * Ranks place results by distance from the location.
     */
    DISTANCE = 0.0,
    /**
     * Ranks place results by their prominence.
     */
    PROMINENCE = 1.0,
  }
  /**
   * Available only in the v=beta channel: https://goo.gle/3oAthT3.
   *
   *
   * Access by calling `const {Review} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class Review {
    /**
     * The name of the reviewer.
     */
    author: string|null;
    /**
     * A URL to the reviwer&#39;s profile image.
     */
    authorPhotoURI: string|null;
    /**
     * A URL to the reviewer&#39;s profile.
     */
    authorURI: string|null;
    publishTime: Date|null;
    /**
     * The rating of this review, a number between 1.0 and 5.0 (inclusive).
     */
    rating: number|null;
    /**
     * A string of formatted recent time, expressing the review time relative to
     * the current time in a form appropriate for the language and country. For
     * example
     * `&quot;a month ago&quot;&#39;.
     */
    relativePublishTimeDescription: string|null;
    /**
     * The text of a review.
     */
    text: string|null;
    /**
     * An IETF language code indicating the language in which this review is
     * written. Note that this code includes only the main language tag without
     * any secondary tag indicating country or region. For example, all the
     * English reviews are tagged as <code>'en'</code> rather than
     * &#39;en-AU&#39; or
     * &#39;en-UK&#39;.
     */
    textLanguageCode: string|null;
  }
  /**
   * A widget that provides query predictions based on a user&#39;s text input.
   * It attaches to an input element of type <code>text</code>, and listens for
   * text entry in that field. The list of predictions is presented as a
   * drop-down list, and is updated as text is entered.
   *
   * Access by calling `const {SearchBox} = await
   * google.maps.importLibrary("places")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class SearchBox extends google.maps.MVCObject {
    /**
     * A widget that provides query predictions based on a user&#39;s text
     * input. It attaches to an input element of type <code>text</code>, and
     * listens for text entry in that field. The list of predictions is
     * presented as a drop-down list, and is updated as text is entered.
     *
     * Access by calling `const {SearchBox} = await
     * google.maps.importLibrary("places")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(
        inputField: HTMLInputElement,
        opts?: google.maps.places.SearchBoxOptions|null);
    /**
     * Returns the bounds to which query predictions are biased.
     */
    getBounds(): google.maps.LatLngBounds|undefined;
    /**
     * Returns the query selected by the user to be used with
     * <code>places_changed</code> event.
     */
    getPlaces(): google.maps.places.PlaceResult[]|undefined;
    /**
     * Sets the region to use for biasing query predictions. Results will only
     * be biased towards this area and not be completely restricted to it.
     */
    setBounds(bounds: google.maps.LatLngBounds|null|
              google.maps.LatLngBoundsLiteral): void;
  }
  /**
   * The options that can be set on a <code>SearchBox</code> object.
   */
  export interface SearchBoxOptions {
    /**
     * The area towards which to bias query predictions. Predictions are biased
     * towards, but not restricted to, queries targeting these bounds.
     */
    bounds?: google.maps.LatLngBounds|null|google.maps.LatLngBoundsLiteral;
  }
  /**
   * Contains structured information about the place&#39;s description, divided
   * into a main text and a secondary text, including an array of matched
   * substrings from the autocomplete input, identified by an offset and a
   * length, expressed in unicode characters.
   */
  export interface StructuredFormatting {
    /**
     * This is the main text part of the unformatted description of the place
     * suggested by the Places service. Usually the name of the place.
     */
    main_text: string;
    /**
     * A set of substrings in the main text that match elements in the
     * user&#39;s input, suitable for use in highlighting those substrings. Each
     * substring is identified by an offset and a length, expressed in unicode
     * characters.
     */
    main_text_matched_substrings: google.maps.places.PredictionSubstring[];
    /**
     * This is the secondary text part of the unformatted description of the
     * place suggested by the Places service. Usually the location of the place.
     */
    secondary_text: string;
  }
  /**
   * A text search request to be sent to the <code>PlacesService</code>.
   */
  export interface TextSearchRequest {
    /**
     * Bounds used to bias results when searching for Places (optional). Both
     * <code>location</code> and <code>radius</code> will be ignored if
     * <code>bounds</code> is set. Results will not be restricted to those
     * inside these bounds; but, results inside it will rank higher.
     */
    bounds?: google.maps.LatLngBounds|google.maps.LatLngBoundsLiteral;
    /**
     * A language identifier for the language in which names and addresses
     * should be returned, when possible. See the <a
     * href="https://developers.google.com/maps/faq#languagesupport">list of
     * supported languages</a>.
     */
    language?: string|null;
    /**
     * The center of the area used to bias results when searching for Places.
     */
    location?: google.maps.LatLng|google.maps.LatLngLiteral;
    /**
     * The request&#39;s query term. For example, the name of a place
     * (&#39;Eiffel Tower&#39;), a category followed by the name of a location
     * (&#39;pizza in New York&#39;), or the name of a place followed by a
     * location disambiguator
     * (&#39;Starbucks in Sydney&#39;).
     */
    query?: string;
    /**
     * The radius of the area used to bias results when searching for Places, in
     * meters.
     */
    radius?: number;
    /**
     * A region code to bias results towards. The region code accepts a <a
     * href="https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains">ccTLD
     * (&quot;top-level domain&quot;)</a> two-character value. Most ccTLD codes
     * are identical to ISO 3166-1 codes, with some notable exceptions. For
     * example, the United Kingdom&#39;s ccTLD is &quot;uk&quot;
     * (<code>.co.uk</code>) while its ISO 3166-1 code is &quot;gb&quot;
     * (technically for the entity of &quot;The United Kingdom of Great Britain
     * and Northern Ireland&quot;).
     */
    region?: string|null;
    /**
     * Searches for places of the given type. The type is translated to the
     * local language of the request&#39;s target location and used as a query
     * string. If a query is also provided, it is concatenated to the localized
     * type string. Results of a different type are dropped from the response.
     * Use this field to perform language and region independent categorical
     * searches. Valid types are given <a
     * href="https://developers.google.com/maps/documentation/places/web-service/supported_types">here</a>.
     */
    type?: string;
  }
}
declare namespace google.maps.visualization {
  /**
   * A layer that provides a client-side rendered heatmap, depicting the
   * intensity of data at geographical points.
   *
   * Access by calling `const {HeatmapLayer} = await
   * google.maps.importLibrary("visualization")`. See
   * https://developers.google.com/maps/documentation/javascript/libraries.
   */
  export class HeatmapLayer extends google.maps.MVCObject {
    /**
     * A layer that provides a client-side rendered heatmap, depicting the
     * intensity of data at geographical points.
     *
     * Access by calling `const {HeatmapLayer} = await
     * google.maps.importLibrary("visualization")`. See
     * https://developers.google.com/maps/documentation/javascript/libraries.
     */
    constructor(opts?: google.maps.visualization.HeatmapLayerOptions|null);
    /**
     * Returns the data points currently displayed by this heatmap.
     */
    getData(): google.maps.MVCArray<google.maps.LatLng|
                                    google.maps.visualization.WeightedLocation>;
    getMap(): google.maps.Map|undefined;
    /**
     * Sets the data points to be displayed by this heatmap.
     */
    setData(data: google.maps.MVCArray<
            google.maps.LatLng|google.maps.visualization.WeightedLocation>|
            (google.maps.LatLng|google.maps.visualization.WeightedLocation)[]):
        void;
    /**
     * Renders the heatmap on the specified map. If map is set to
     * <code>null</code>, the heatmap will be removed.
     */
    setMap(map: google.maps.Map|null): void;
    setOptions(options: google.maps.visualization.HeatmapLayerOptions|
               null): void;
  }
  /**
   * This object defines the properties that can be set on a
   * <code>HeatmapLayer</code> object.
   */
  export interface HeatmapLayerOptions {
    /**
     * The data points to display. Required.
     */
    data?: google.maps.MVCArray<google.maps.LatLng|
                                google.maps.visualization.WeightedLocation>|
        null|(google.maps.LatLng|google.maps.visualization.WeightedLocation)[];
    /**
     * Specifies whether heatmaps dissipate on zoom. By default, the radius of
     * influence of a data point is specified by the radius option only. When
     * dissipating is disabled, the radius option is interpreted as a radius at
     * zoom level 0.
     */
    dissipating?: boolean|null;
    /**
     * The color gradient of the heatmap, specified as an array of CSS color
     * strings. All CSS3 colors are supported except for extended named colors.
     */
    gradient?: string[]|null;
    /**
     * The map on which to display the layer.
     */
    map?: google.maps.Map|null;
    /**
     * The maximum intensity of the heatmap. By default, heatmap colors are
     * dynamically scaled according to the greatest concentration of points at
     * any particular pixel on the map. This property allows you to specify a
     * fixed maximum.
     */
    maxIntensity?: number|null;
    /**
     * The opacity of the heatmap, expressed as a number between 0 and 1.
     * @defaultValue <code>0.6</code>
     */
    opacity?: number|null;
    /**
     * The radius of influence for each data point, in pixels.
     */
    radius?: number|null;
  }
  /**
   * A data point entry for a heatmap. This is a geographical data point with a
   * weight attribute.
   */
  export interface WeightedLocation {
    /**
     * The location of the data point.
     */
    location: google.maps.LatLng|null;
    /**
     * The weighting value of the data point.
     */
    weight: number;
  }
}
