# Installation
> `npm install --save @types/react-signature-canvas`

# Summary
This package contains type definitions for react-signature-canvas (https://github.com/agilgur5/react-signature-canvas).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-signature-canvas.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-signature-canvas/index.d.ts)
````ts
// Type definitions for react-signature-canvas 1.0
// Project: https://github.com/agilgur5/react-signature-canvas
// Definitions by: Kamil Socha <https://github.com/ksocha>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped

import * as React from 'react';
import SignaturePad = require('signature_pad');

export interface ReactSignatureCanvasProps extends SignaturePad.SignaturePadOptions {
    canvasProps?: React.CanvasHTMLAttributes<HTMLCanvasElement> | undefined;
    clearOnResize?: boolean | undefined;
}

declare class ReactSignatureCanvas extends React.Component<ReactSignatureCanvasProps> {
    on: SignaturePad['on'];

    off: SignaturePad['off'];

    clear: SignaturePad['clear'];

    isEmpty: SignaturePad['isEmpty'];

    fromDataURL: SignaturePad['fromDataURL'];

    toDataURL: SignaturePad['toDataURL'];

    fromData: SignaturePad['fromData'];

    toData: SignaturePad['toData'];

    getCanvas(): HTMLCanvasElement;

    getTrimmedCanvas(): HTMLCanvasElement;

    getSignaturePad(): SignaturePad;
}

export default ReactSignatureCanvas;

````

### Additional Details
 * Last updated: Thu, 08 Jul 2021 22:41:32 GMT
 * Dependencies: [@types/react](https://npmjs.com/package/@types/react), [@types/signature_pad](https://npmjs.com/package/@types/signature_pad)
 * Global values: none

# Credits
These definitions were written by [Kamil Socha](https://github.com/ksocha).
