import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Meeting } from '@/types';

export const customerAgencyListing = (type: string): Promise<ApiResponse<Meeting>> => {
  return axios.get(`customer-api/my-agency-send-received-request?request_type=${type}`);
};

type QueryFnType = typeof customerAgencyListing;

type UseMeetingOptions = {
  config?: QueryConfig<QueryFnType>;
  type: string;
};

export const useCustomerAgencyListing = ({ config, type }: UseMeetingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['customer-Agency-Listing'],
    queryFn: () => customerAgencyListing(type),
  });
};
