import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { TableResponse } from '@/types/TableResponse';
import { Inquiry } from '@/types';

export const getAgencyrequest = (): Promise<TableResponse<Inquiry>> => {
  return axios.get('agency-api/agency-property-request');
};

type QueryFnType = typeof getAgencyrequest;

type UseInquiryOptions = {
  config?: QueryConfig<QueryFnType>;
};

export const useAgencyInquiry = ({ config }: UseInquiryOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['agency-req'],
    queryFn: () => getAgencyrequest(),
  });
};
