import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Meeting } from '@/types';

export const getBUyShareDetail = (type: string): Promise<ApiResponse<Meeting>> => {
  return axios.get(`/customer-api/my-share-request?request_type=${type}`);
};

type QueryFnType = typeof getBUyShareDetail;

type UseMeetingOptions = {
  config?: QueryConfig<QueryFnType>;
  type: string;
};

export const useBUyShareDetail = ({ config, type }: UseMeetingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['customer-shares-Listing'],
    queryFn: () => getBUyShareDetail(type),
  });
};
