import { useQuery } from 'react-query';
import { axios } from '@/lib/axiosData';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { Listing } from '@/types';

export const saveSearchListing = (): Promise<Listing[]> => {
  return axios.get('/customer-api/get-save-search-customer');
};

type QueryFnType = typeof saveSearchListing;

type UseListingOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useSaveSearchListing = ({ config }: UseListingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['my-saved-listing'],
    queryFn: () => saveSearchListing(),
  });
};
