import { useQuery } from 'react-query';
import { axios } from '@/lib/axiosData';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';

type SubscriptionData = {
  id: string;
  plan_name: string;
  plan_validity: string;
  price: string;
  plan_description: string;
  package_type: string;
  status: boolean;
  tier_type: number;
  discount: number;
  digital_rental_contract: boolean;
  notifications_stakeholders: boolean;
  visibility_among_ads: boolean;
  visibility_at_top: boolean;
  information_of_local_area: boolean;
  property_count: any;
};

export const getSubList = (pagination: PaginationQuery): Promise<SubscriptionData[]> => {
  return axios.get(url('subscription-api/plan-listing', pagination));
};
type QueryFnType = typeof getSubList;

type UseListingOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useSubscription = ({ config, page_per_data = '10', page }: UseListingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['listing'],
    queryFn: () => getSubList({ page_per_data, page }),
  });
};
