import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, User } from '@/types';

export const getAgencyDetail = (id: string): Promise<ApiResponse<User>> => {
  return axios.get(`/admin-api/agency-details?userid=${id}`);
};

type QueryFnType = typeof getAgencyDetail;

type UseUserOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useAgencyDetail = ({ config, id }: UseUserOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['agency-detail'],
    queryFn: () => getAgencyDetail(id),
  });
};
