import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { User } from '@/types/User';
import { TableResponse } from '@/types/TableResponse';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';

export type UpdateBusinessDTO = {
  name: string;
  inc: string;
  vat: string;
  country: string;
  personal_phone: string;
  business_phone: string;
  insurance: File;
  certification: File;
};

export const getAgencyRequests = (pagination: PaginationQuery): Promise<TableResponse<User>> => {
  return axios.get(url('/agency-api/agency-accepted-request', pagination));
};

type QueryFnType = typeof getAgencyRequests;

type UseUsersOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useAgencyRequests = ({ config, page_per_data = '10', page }: UseUsersOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['get-request'],
    queryFn: () => getAgencyRequests({ page_per_data, page }),
  });
};
