import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { User } from '@/types/User';
import { TableResponse } from '@/types/TableResponse';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';

export const getAgencyUsers = (pagination: PaginationQuery): Promise<TableResponse<User>> => {
  return axios.get(url('admin-api/agency-list', pagination));
};

type QueryFnType = typeof getAgencyUsers;

type UseUsersOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useAgencyUsers = ({ config, page_per_data = '10', page }: UseUsersOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['users'],
    queryFn: () => getAgencyUsers({ page_per_data, page }),
  });
};
