import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { User } from '@/types/User';
import { TableResponse } from '@/types/TableResponse';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';

export type UpdateBusinessDTO = {
  name: string;
  inc: string;
  vat: string;
  country: string;
  personal_phone: string;
  business_phone: string;
  insurance: File;
  certification: File;
};

export const getAgentRequests = (pagination: PaginationQuery): Promise<TableResponse<User>> => {
  return axios.get(url('admin-api/do-by-reeipo-requests', pagination));
};

type QueryFnType = typeof getAgentRequests;

type UseUsersOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useAgentRequests = ({ config, page_per_data = '10', page }: UseUsersOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['get-request'],
    queryFn: () => getAgentRequests({ page_per_data, page }),
  });
};
