import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { TableResponse } from '@/types/TableResponse';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { Business } from '@/types';

export const getBusiness = (pagination: PaginationQuery): Promise<TableResponse<Business>> => {
  return axios.get(url('admin-api/bussiness-sale-listing', pagination));
};

type QueryFnType = typeof getBusiness;

type UseBusinessOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useBusiness = ({ config, page_per_data = '10', page }: UseBusinessOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['business'],
    queryFn: () => getBusiness({ page_per_data, page }),
  });
};
