import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Business } from '@/types';

export const getBusinessDetail = (id: string): Promise<ApiResponse<Business>> => {
  return axios.get(`admin-api/bussiness-sale-detail?bussiness_id=${id}`);
};

type QueryFnType = typeof getBusinessDetail;

type UseBusinessOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useBusinessDetails = ({ config, id }: UseBusinessOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['business-detail'],
    queryFn: () => getBusinessDetail(id),
  });
};
