import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Meeting } from '@/types';

export const meetingListing = (type: string): Promise<ApiResponse<Meeting>> => {
  return axios.get(`customer-api/booking-meeting-list?booking_type=${type}`);
};

type QueryFnType = typeof meetingListing;

type UseMeetingOptions = {
  config?: QueryConfig<QueryFnType>;
  type: string;
};

export const useMeetingDetails = ({ config, type }: UseMeetingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['meeting-listing'],
    queryFn: () => meetingListing(type),
  });
};
