import { useQuery } from 'react-query';
import { axios } from '@/lib/axiosData';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { Business } from '@/types';

export const bussinessForSale = ({
  min_price,
  max_price,
  location,
  bedroom_min,
  type,
  bedroom_max,
  amenities,
  filter_data,
  subscription_tyre,
  sort_price,
}: {
  min_price: any;
  max_price: any;
  location: any;
  bedroom_min: any;
  bedroom_max: any;
  amenities: any;
  filter_data: any;
  subscription_tyre: any;
  sort_price: any;
  type: any;
}): Promise<Business[]> => {
  const filterData = localStorage.getItem('filter_data');
  const companyType = localStorage.getItem('company_type');
  return axios.get(
    `/panel-api/get-bussiness-for-sale?filter_data=${filterData}&company_type=${companyType}&filter_data=${filter_data}&type=${type}&subscription_tyre=${subscription_tyre}&sort_price=${sort_price}&min_price=${min_price}&max_price=${max_price}&location=${location}&bedroom_min=${bedroom_min}&bedroom_max=${bedroom_max}&amenities=${amenities}`
  );
};

type QueryFnType = typeof bussinessForSale;

type UseListingOptions = {
  config?: QueryConfig<QueryFnType>;
  min_price: any;
  max_price: any;
  type: any;
  location: any;
  bedroom_min: any;
  bedroom_max: any;
  amenities: any;
  filter_data: any;
  subscription_tyre: any;
  sort_price: any;
};

export const useLandingListing = ({
  config,
  min_price,
  max_price,
  location,
  type,
  bedroom_min,
  bedroom_max,
  amenities,
  filter_data,
  subscription_tyre,
  sort_price,
}: UseListingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['business-for-sale'],
    queryFn: () =>
      bussinessForSale({
        min_price,
        max_price,
        location,
        bedroom_min,
        bedroom_max,
        amenities,
        filter_data,
        type,
        subscription_tyre,
        sort_price,
      }),
  });
};
