import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Business } from '@/types';

export const getBFS = (id: string): Promise<ApiResponse<Business>> => {
  return axios.get(`customer-api/my-bussiness-for-sale-details?id=${id}`);
};

type QueryFnType = typeof getBFS;

type UseUserOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useBsfDetails = ({ config, id }: UseUserOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['bfs-detail'],
    queryFn: () => getBFS(id),
  });
};
