import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Listing } from '@/types';

export const getBusinessfroSaleDetail = (id: string): Promise<ApiResponse<Listing>> => {
  const searchParams = new URLSearchParams(document.location.search);
  const PageType = searchParams.get('type');
  return axios.get(`panel-api/get-bussiness-for-sale-details?bussiness_id=${id}&type=${PageType}`);
};

type QueryFnType = typeof getBusinessfroSaleDetail;

type UseBusinessOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useBusinessSaleDetails = ({ config, id }: UseBusinessOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['get-business-for-sale-detail'],
    queryFn: () => getBusinessfroSaleDetail(id),
  });
};
