import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Listing } from '@/types';

export const getCommonPannelDetail = (id: string): Promise<ApiResponse<Listing>> => {
  const searchParams = new URLSearchParams(document.location.search);
  const PageType = searchParams.get('type');
  return axios.get(`/panel-api/common-properties-detail?id=${id}&type=${PageType}`);
};

type QueryFnType = typeof getCommonPannelDetail;

type UseBusinessOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useCommonPannelDetails = ({ config, id }: UseBusinessOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['get-business-detail'],
    queryFn: () => getCommonPannelDetail(id),
  });
};
