import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse } from '@/types';
import { Company } from '@/types/Company';

export const getCompany = (): Promise<ApiResponse<Company>> => {
  return axios.get('customer-api/company');
};

type QueryFnType = typeof getCompany;

type UseProfileOptions = {
  config?: QueryConfig<QueryFnType>;
};

export const useCompany = ({ config }: UseProfileOptions = {}) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['company'],
    queryFn: getCompany,
  });
};
