import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, InvestmentCompany } from '@/types';

export const companyInvestmentDetails = (id: string): Promise<ApiResponse<InvestmentCompany>> => {
  return axios.get(`/customer-api/my-investment-my-company-details?id=${id}`);
};
type QueryFnType = typeof companyInvestmentDetails;

type UsePropertyProjectOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useCompanyInvestmentDetails = (
  { config, id }: UsePropertyProjectOptions = { id: '1' }
) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['property-investment-detail'],
    queryFn: () => companyInvestmentDetails(id),
  });
};
