import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, InvestmentCompany } from '@/types';

export const companyInvestmentPannel = (id: string): Promise<ApiResponse<InvestmentCompany>> => {
  return axios.get(`/panel-api/my-investment-my-company-details?id=${id}`);
};
type QueryFnType = typeof companyInvestmentPannel;

type UsePropertyProjectOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useCompanyInvestmentPannel = (
  { config, id }: UsePropertyProjectOptions = { id: '1' }
) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['property-investment-detail'],
    queryFn: () => companyInvestmentPannel(id),
  });
};
