import { useQuery } from 'react-query';
import { axios } from '@/lib/axiosData';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { Listing } from '@/types';

export const getCompanyInvestment = (pagination: PaginationQuery): Promise<Listing[]> => {
  return axios.get(url('/panel-api/get-investment-my-company', pagination));
};
type QueryFnType = typeof getCompanyInvestment;

type UseListingOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useCompanyInvestment = ({ config, page_per_data = '10', page }: UseListingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['company-investment-listing'],
    queryFn: () => getCompanyInvestment({ page_per_data, page }),
  });
};
