import { useQuery } from 'react-query';
import { axios } from '@/lib/axiosData';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { PropertyforRent } from '@/types';

export const propertyForRent = (pagination: PaginationQuery): Promise<PropertyforRent[]> => {
  return axios.get(url(`/panel-api/rent-property-list`, pagination));
};

type QueryFnType = typeof propertyForRent;

type UseListingOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const usePropertyForRent = ({ config, page_per_data = '10', page }: UseListingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['property-for-rent'],
    queryFn: () => propertyForRent({ page_per_data, page }),
  });
};
