import { axios } from '@/lib/axios';
import { ContentManagement } from '@/types';
import data from '@/features/admin/routes/ContentManagement/data.json';

export const createContent = (
  id: string,
  value: string,
  policy: string
): Promise<ContentManagement> => {
  const item = data.find((i) => i.id === id);
  const payload = {
    user: 'customer',
    page: 'terms',
    content: value,
    registration_policy: policy,
  };
  if (item) {
    payload.page = item.page;
  }
  return axios.put(`settings/content`, payload);
};
