import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ContentManagement } from '@/types';
import data from '@/features/admin/routes/ContentManagement/data.json';

export const getContent = (id: string): Promise<ContentManagement> => {
  const item = data.find((i) => i.id === id);
  const payload = {
    user: 'customer',
    page: 'terms',
  };
  if (item) {
    payload.page = item.page;
  }
  return axios.post(`settings/content`, payload);
};

type QueryFnType = typeof getContent;

type UseQuotesOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useContent = ({ config, id }: UseQuotesOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['content'],
    queryFn: () => getContent(id),
  });
};
