import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, PaymentDetail } from '@/types';

export const getPaymentData = (id: string): Promise<ApiResponse<PaymentDetail>> => {
  return axios.get(`/customer-api/get-purchase-detail?id=${id}`);
};

type QueryFnType = typeof getPaymentData;

type UseSigneeOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const usePaymentData = ({ config, id }: UseSigneeOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['signee-detail'],
    queryFn: () => getPaymentData(id),
  });
};
