import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, SigneeDetail } from '@/types';

export const getSigneeData = (id: string): Promise<ApiResponse<SigneeDetail>> => {
  return axios.get(`/customer-api/contract-signee?id=${id}`);
};

type QueryFnType = typeof getSigneeData;

type UseSigneeOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useSigneeDetails = ({ config, id }: UseSigneeOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['signee-detail'],
    queryFn: () => getSigneeData(id),
  });
};
