import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, VerifyPayment } from '@/types';

export const getVerifyPayment = (id: string): Promise<ApiResponse<VerifyPayment>> => {
  return axios.get(`/customer-api/get-recipet-data?contract_id=${id}`);
};

type QueryFnType = typeof getVerifyPayment;

type UseSigneeOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useVerifyPayment = ({ config, id }: UseSigneeOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['signee-detail'],
    queryFn: () => getVerifyPayment(id),
  });
};
