import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, VerifyPayment } from '@/types';

export const getVerifySalePayment = (id: string): Promise<ApiResponse<VerifyPayment>> => {
  return axios.get(`/customer-api/get-meeting-recipet-data?meeting_id=${id}`);
};

type QueryFnType = typeof getVerifySalePayment;

type UseSigneeOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useVerifySalePayment = ({ config, id }: UseSigneeOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['payment-detail'],
    queryFn: () => getVerifySalePayment(id),
  });
};
