import { useQuery } from 'react-query';
import { axios } from '@/lib/axiosData';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { Listing } from '@/types';

export const myDraftListing = (pagination: PaginationQuery): Promise<Listing[]> => {
  return axios.get(url('customer-api/draft-listing', pagination));
};

type QueryFnType = typeof myDraftListing;

type UseListingOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useDraftListing = ({ config, page_per_data = '10', page }: UseListingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['my-draft-listing'],
    queryFn: () => myDraftListing({ page_per_data, page }),
  });
};
