import { useQuery } from 'react-query';
import { axios } from '@/lib/axiosData';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { Listing } from '@/types';

export const favouriteListing = (pagination: PaginationQuery): Promise<Listing[]> => {
  return axios.get(url('/customer-api/my-favourite-listing', pagination));
};

type QueryFnType = typeof favouriteListing;

type UseListingOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useFavouriteListing = ({ config, page_per_data = '10', page }: UseListingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['listing'],
    queryFn: () => favouriteListing({ page_per_data, page }),
  });
};
