import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { Housing } from '@/types';
import { TableResponse } from '@/types/TableResponse';

export const getHousing = (pagination: PaginationQuery): Promise<TableResponse<Housing>> => {
  return axios.get(url('/admin-api/house-wanted-for-rent-list', pagination));
};

type QueryFnType = typeof getHousing;

type UseHousingOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useHousing = ({ config, page_per_data = '10', page }: UseHousingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['housing'],
    queryFn: () => getHousing({ page_per_data, page }),
  });
};
// admin-api/investment-project-list
