import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Housing } from '@/types';

export const getHousingDetail = (id: string): Promise<ApiResponse<Housing>> => {
  return axios.get(`admin-api/house-wanted-for-rent-details?rent_id=${id}`);
};

type QueryFnType = typeof getHousingDetail;

type UseHousingOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useHousingDetails = ({ config, id }: UseHousingOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['housing-detail'],
    queryFn: () => getHousingDetail(id),
  });
};
