import { useQuery } from 'react-query';
import { axios } from '@/lib/axiosData';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { Housing } from '@/types';

export const getHousingList = ({
  min_price,
  max_price,
  location,
  bedroom_min,
  type,
  bedroom_max,
  amenities,
  filter_data,
  subscription_tyre,
  sort_price,
}: {
  min_price: any;
  max_price: any;
  location: any;
  bedroom_min: any;
  bedroom_max: any;
  amenities: any;
  filter_data: any;
  subscription_tyre: any;
  sort_price: any;
  type: any;
}): Promise<Housing[]> => {
  return axios.get(
    `/panel-api/get-housing-for-rent?filter_data=${filter_data}&type=${type}&subscription_tyre=${subscription_tyre}&sort_price=${sort_price}&min_price=${min_price}&max_price=${max_price}&location=${location}&bedroom_min=${bedroom_min}&bedroom_max=${bedroom_max}&amenities=${amenities}`
  );
};

type QueryFnType = typeof getHousingList;

type UseListingOptions = {
  config?: QueryConfig<QueryFnType>;
  min_price: any;
  max_price: any;
  type: any;
  location: any;
  bedroom_min: any;
  bedroom_max: any;
  amenities: any;
  filter_data: any;
  subscription_tyre: any;
  sort_price: any;
};

export const useHousingListing = ({
  config,
  min_price,
  max_price,
  location,
  type,
  bedroom_min,
  bedroom_max,
  amenities,
  filter_data,
  subscription_tyre,
  sort_price,
}: UseListingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['get-housing-list'],
    queryFn: () =>
      getHousingList({
        min_price,
        max_price,
        location,
        bedroom_min,
        bedroom_max,
        amenities,
        filter_data,
        type,
        subscription_tyre,
        sort_price,
      }),
  });
};
