import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Housing } from '@/types';

export const housingGetId = (id: string): Promise<ApiResponse<Housing>> => {
  return axios.get(`/panel-api/get-housing-for-rent-details?rent_id=${id}`);
};

type QueryFnType = typeof housingGetId;

type UseUserOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useHousingIdDetails = ({ config, id }: UseUserOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['housing-id-detail'],
    queryFn: () => housingGetId(id),
  });
};
