import { useQuery } from 'react-query';
import { axios } from '@/lib/axiosData';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { FaqContent } from '@/types';

export const FaqHow = (pagination: PaginationQuery): Promise<FaqContent[]> => {
  return axios.get(url('panel-api/get-faq-content', pagination));
};

type QueryFnType = typeof FaqHow;

type UseListingOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useFaqH = ({ config, page_per_data = '10', page }: UseListingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['get-faq-list'],
    queryFn: () => FaqHow({ page_per_data, page }),
  });
};
