import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { TableResponse } from '@/types/TableResponse';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { Inquiry } from '@/types';

export const getInquiry = (pagination: PaginationQuery): Promise<TableResponse<Inquiry>> => {
  return axios.get(url('admin-api/property-inquire', pagination));
};

type QueryFnType = typeof getInquiry;

type UseInquiryOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useInquiry = ({ config, page_per_data = '10', page }: UseInquiryOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['Inquiry'],
    queryFn: () => getInquiry({ page_per_data, page }),
  });
};
