import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Inquiry } from '@/types';

export const getInquiryDetail = (id: string): Promise<ApiResponse<Inquiry>> => {
  return axios.get(`admin-api/view-inquire?inquire_id=${id}`);
};

type QueryFnType = typeof getInquiryDetail;

type UseInquiryOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useInquiryDetails = ({ config, id }: UseInquiryOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['Inquiry-detail'],
    queryFn: () => getInquiryDetail(id),
  });
};
