import { useQuery } from 'react-query';
import { axios } from '@/lib/axiosData';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { Listing } from '@/types';

export const landingListing = ({
  min_price,
  max_price,
  location,
  latitude,
  longitude,
  bedroom_min,
  type,
  bedroom_max,
  amenities,
  filter_data,
  subscription_tyre,
  sort_price,
  sort_upload_date,
}: {
  min_price: string | null;
  max_price: string | null;
  location: string | null;
  bedroom_min: string | null;
  bedroom_max: string | null;
  amenities: string | null;
  filter_data: boolean;
  latitude: string;
  longitude: string;
  subscription_tyre: string;
  sort_price: string;
  type: any;
  sort_upload_date: string;
}): Promise<Listing[]> => {
  return axios.get(
    `/customer-api/home-page-listing?filter_data=${filter_data}&type=${type}&subscription_tyre=${subscription_tyre}&sort_price=${sort_price}&min_price=${min_price}&max_price=${max_price}&location=${location}&longitude=${longitude}&latitude=${latitude}&bedroom_min=${bedroom_min}&bedroom_max=${bedroom_max}&amenities=${amenities}&sort_upload_date=${sort_upload_date}`
  );
};

type QueryFnType = typeof landingListing;

type UseListingOptions = {
  config?: QueryConfig<QueryFnType>;
  min_price: string | null;
  max_price: string | null;
  type: any;
  location: string | null;
  bedroom_min: string | null;
  bedroom_max: string | null;
  amenities: string | null;
  filter_data: boolean;
  subscription_tyre: string;
  sort_price: string;
  latitude: string;
  longitude: string;
  sort_upload_date: string;
};

export const useLandingListing = ({
  config,
  min_price,
  max_price,
  latitude,
  longitude,
  location,
  type,
  bedroom_min,
  bedroom_max,
  amenities,
  filter_data,
  subscription_tyre,
  sort_price,
  sort_upload_date,
}: UseListingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['listing-landing-page'],
    queryFn: () =>
      landingListing({
        min_price,
        max_price,
        location,
        bedroom_min,
        bedroom_max,
        latitude,
        longitude,
        amenities,
        filter_data,
        type,
        subscription_tyre,
        sort_price,
        sort_upload_date,
      }),
  });
};
