import { useQuery } from 'react-query';
import { axios } from '@/lib/axiosData';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { DealListing } from '@/types/Deals/DealListing';

export const myDeal = (pagination: PaginationQuery): Promise<DealListing[]> => {
  return axios.get(url('/customer-api/get-inquire-list', pagination));
};

type QueryFnType = typeof myDeal;

type UseListingOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useMyDeals = ({ config, page_per_data = '10', page }: UseListingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['DealListing'],
    queryFn: () => myDeal({ page_per_data, page }),
  });
};
