import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Listing } from '@/types';

export const call = (id: string): Promise<ApiResponse<Listing>> => {
  const searchParams = new URLSearchParams(document.location.search);
  const PageType = searchParams.get('type');
  return axios.get(`/customer-api/show-number?id=${id}&type=${PageType}`);
};
type QueryFnType = typeof call;

type UseBusinessOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useCommonDetails = ({ config, id }: UseBusinessOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['get-business-detail'],
    queryFn: () => call(id),
  });
};
