import { useQuery } from 'react-query';
import { axios } from '@/lib/axiosData';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { Listing } from '@/types';

export const getFilterListing = ({
  filter_data,
  property_type,
  sort_price,
  sort_date,
}: {
  filter_data: boolean;
  property_type: string;
  sort_price: string;
  sort_date: string;
}): Promise<Listing[]> => {
  return axios.get(
    `/customer-api/my-listing?filter_data=${filter_data}&type=${property_type}&sort_price=${sort_price}&sort_upload_date=${sort_date}`
  );
};

type QueryFnType = typeof getFilterListing;

type UseListingOptions = {
  config?: QueryConfig<QueryFnType>;
  filter_data: boolean;
  property_type: string;
  sort_price: string;
  sort_date: string;
};

export const useFilterListing = ({
  config,
  filter_data,
  property_type,
  sort_price,
  sort_date,
}: UseListingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['my-listing'],
    queryFn: () =>
      getFilterListing({
        filter_data,
        property_type,
        sort_price,
        sort_date,
      }),
  });
};
