import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { useQuery } from 'react-query';
import { InvestorContent } from '@/types/InvestorContent';
import { ApiResponse } from '@/types';

export const privacyPolicy = (): Promise<ApiResponse<InvestorContent>> => {
  return axios.get('/panel-api/get-content-pages?page_type=Privacy_Policy');
};

type QueryFnType = typeof privacyPolicy;

type investorData = {
  config?: QueryConfig<QueryFnType>;
};

export const usePrivacyPolicy = ({ config }: investorData = {}) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['privacy'],
    queryFn: () => privacyPolicy(),
  });
};
