import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { TableResponse } from '@/types/TableResponse';
import { PaginationQuery } from '@/types/PaginationQuery';
import { formatURL as url } from '@/utils/format';
import { Property } from '@/types';

export const getProperty = (pagination: PaginationQuery): Promise<TableResponse<Property>> => {
  return axios.get(url('admin-api/get-property-request', pagination));
};

type QueryFnType = typeof getProperty;

type UsePropertyOptions = {
  config?: QueryConfig<QueryFnType>;
  page_per_data?: string;
  page: string;
};

export const useProperty = ({ config, page_per_data = '10', page }: UsePropertyOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['Property'],
    queryFn: () => getProperty({ page_per_data, page }),
  });
};
