import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Property } from '@/types';

export const getPropertyDetail = (id: string): Promise<ApiResponse<Property>> => {
  return axios.get(`admin-api/view-property-request?request_property_id=${id}`);
};

type QueryFnType = typeof getPropertyDetail;

type UsePropertyOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const usePropertyDetails = ({ config, id }: UsePropertyOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['property-detail'],
    queryFn: () => getPropertyDetail(id),
  });
};
