import { useQuery } from 'react-query';
import { axios } from '@/lib/axiosData';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { PropertyforRent } from '@/types';

export const propertyForRent = ({
  min_price,
  max_price,
  location,
  bedroom_min,
  bedroom_max,
  amenities,
  filter_data,
  subscription_tyre,
  sort_price,
  latitude,
  longitude,
  countryFilter,
  stateFilter,
  cityFilter,
  category,
}: {
  min_price: string;
  max_price: string;
  location: string;
  bedroom_min: string;
  bedroom_max: string;
  amenities: string;
  filter_data: string;
  subscription_tyre: string;
  sort_price: string;
  latitude: string;
  longitude: string;
  countryFilter: string;
  stateFilter: string;
  cityFilter: string;
  category: string;
}): Promise<PropertyforRent[]> => {
  return axios.get(
    `panel-api/rent-property-list?filter_data=${filter_data}&subscription_tyre=${subscription_tyre}&sort_price=${sort_price}&min_price=${min_price}&max_price=${max_price}&location=${location}&longitude=${longitude}&latitude=${latitude}&bedroom_min=${bedroom_min}&bedroom_max=${bedroom_max}&amenities=${amenities}&countryFilter=${countryFilter}&stateFilter=${stateFilter}&cityFilter=${cityFilter}&category=${category}`
  );
};

type QueryFnType = typeof propertyForRent;

type UseListingOptions = {
  config?: QueryConfig<QueryFnType>;
  min_price: string;
  max_price: string;
  location: string;
  bedroom_min: string;
  bedroom_max: string;
  amenities: string;
  filter_data: string;
  subscription_tyre: string;
  latitude: string;
  longitude: string;
  sort_price: string;
  countryFilter: string;
  stateFilter: string;
  cityFilter: string;
  category: string;
};

export const usePropertyForRent = ({
  config,
  min_price,
  max_price,
  location,
  bedroom_min,
  bedroom_max,
  latitude,
  longitude,
  amenities,
  filter_data,
  subscription_tyre,
  sort_price,
  countryFilter,
  stateFilter,
  cityFilter,
  category,
}: UseListingOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['property-for-rent'],
    queryFn: () =>
      propertyForRent({
        min_price,
        max_price,
        location,
        latitude,
        longitude,
        bedroom_min,
        bedroom_max,
        amenities,
        filter_data,
        subscription_tyre,
        sort_price,
        countryFilter,
        stateFilter,
        cityFilter,
        category,
      }),
  });
};
