import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, Property } from '@/types';

export const getPropertyforSaleDetails = (id: string): Promise<ApiResponse<Property>> => {
  return axios.get(`/panel-api/sale-property-details?id=${id}`);
};
type QueryFnType = typeof getPropertyforSaleDetails;

type UsePropertyProjectOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const usePropertyForSaleDetails = (
  { config, id }: UsePropertyProjectOptions = { id: '1' }
) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['property-for-sale-detail'],
    queryFn: () => getPropertyforSaleDetails(id),
  });
};
